/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import paraprof.BinWindow;
import paraprof.CallPathTextWindow;
import paraprof.ParaProf;
import paraprof.ParaProfImageOutput;
import paraprof.ParaProfManager;
import paraprof.StaticMainWindowData;
import paraprof.StaticMainWindowPanel;
import paraprof.Trial;

public class StaticMainWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener {
    private boolean mShown = false;
    Trial trial = null;
    JFileChooser fileChooser = new JFileChooser();
    private StaticMainWindowPanel sMWPanel = null;
    private StaticMainWindowData sMWData = null;
    private ButtonGroup sortGroup = null;
    private ButtonGroup sortOrderGroup = null;
    private JRadioButtonMenuItem mappingIDButton = null;
    private JRadioButtonMenuItem nameButton = null;
    private JRadioButtonMenuItem millisecondButton = null;
    private JRadioButtonMenuItem ascendingButton = null;
    private JRadioButtonMenuItem descendingButton = null;
    private JRadioButtonMenuItem displaySlidersButton = null;
    private JMenuItem mappingGroupLedgerItem = null;
    private JMenuItem userEventLedgerItem = null;
    private JMenuItem callPathItem = null;
    private JLabel sliderMultipleLabel = new JLabel("Slider Mulitiple");
    private JComboBox sliderMultiple;
    private JLabel barLengthLabel = new JLabel("Bar Mulitiple");
    private JSlider barLengthSlider = new JSlider(0, 40, 1);
    private Container contentPane = null;
    private GridBagLayout gbl = null;
    private GridBagConstraints gbc = null;
    private JScrollPane scrollPane;
    boolean sortByMappingID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean displaySliders = false;
    private Vector currentSMWGeneralData = null;
    private Vector currentSMWMeanData = null;

    public StaticMainWindow(Trial trial) {
        try {
            this.trial = trial;
            this.setTitle("ParaProf: " + this.trial.getProfilePathName());
            int n = 750;
            int n2 = 400;
            this.setSize(new Dimension(n, n2));
            this.sMWData = new StaticMainWindowData(this.trial);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    StaticMainWindow.this.thisWindowClosing(windowEvent);
                }
            });
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            int n3 = dimension.height;
            int n4 = dimension.width;
            int n5 = (n4 - n) / 2;
            int n6 = (n3 - n2) / 2;
            this.setLocation(n5, n6);
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenu jMenu2 = new JMenu("Open ...");
            JMenuItem jMenuItem = new JMenuItem("ParaProf Manager");
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Bin Window");
            jMenuItem2.addActionListener(this);
            jMenu2.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("test");
            jMenuItem3.addActionListener(this);
            jMenu2.add(jMenuItem3);
            jMenu.add(jMenu2);
            JMenu jMenu3 = new JMenu("Save ...");
            JMenuItem jMenuItem4 = new JMenuItem("ParaProf Preferrences");
            jMenuItem4.addActionListener(this);
            jMenu3.add(jMenuItem4);
            jMenu.add(jMenu3);
            JMenuItem jMenuItem5 = new JMenuItem("Edit ParaProf Preferences!");
            jMenuItem5.addActionListener(this);
            jMenu.add(jMenuItem5);
            JMenuItem jMenuItem6 = new JMenuItem("Save Image");
            jMenuItem6.addActionListener(this);
            jMenu.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Exit ParaProf!");
            jMenuItem7.addActionListener(this);
            jMenu.add(jMenuItem7);
            JMenu jMenu4 = new JMenu("Options");
            JMenu jMenu5 = new JMenu("Sort by ...");
            this.sortGroup = new ButtonGroup();
            this.mappingIDButton = new JRadioButtonMenuItem("function ID", false);
            this.mappingIDButton.addActionListener(this);
            this.nameButton = new JRadioButtonMenuItem("name", false);
            this.nameButton.addActionListener(this);
            this.millisecondButton = new JRadioButtonMenuItem("millisecond", true);
            this.millisecondButton.addActionListener(this);
            this.sortGroup.add(this.mappingIDButton);
            this.sortGroup.add(this.nameButton);
            this.sortGroup.add(this.millisecondButton);
            jMenu5.add(this.mappingIDButton);
            jMenu5.add(this.nameButton);
            jMenu5.add(this.millisecondButton);
            jMenu4.add(jMenu5);
            JMenu jMenu6 = new JMenu("Sort Order");
            this.sortOrderGroup = new ButtonGroup();
            this.ascendingButton = new JRadioButtonMenuItem("Ascending", false);
            this.ascendingButton.addActionListener(this);
            this.descendingButton = new JRadioButtonMenuItem("Descending", true);
            this.descendingButton.addActionListener(this);
            this.sortOrderGroup.add(this.ascendingButton);
            this.sortOrderGroup.add(this.descendingButton);
            jMenu6.add(this.ascendingButton);
            jMenu6.add(this.descendingButton);
            jMenu4.add(jMenu6);
            this.displaySlidersButton = new JRadioButtonMenuItem("Display Sliders", false);
            this.displaySlidersButton.addActionListener(this);
            jMenu4.add(this.displaySlidersButton);
            JMenu jMenu7 = new JMenu("Windows");
            jMenu7.addMenuListener(this);
            JMenuItem jMenuItem8 = new JMenuItem("Show Function Ledger");
            jMenuItem8.addActionListener(this);
            jMenu7.add(jMenuItem8);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu7.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu7.add(this.userEventLedgerItem);
            this.callPathItem = new JMenuItem("Show Call Path Relations");
            this.callPathItem.addActionListener(this);
            jMenu7.add(this.callPathItem);
            JMenuItem jMenuItem9 = new JMenuItem("Close All Sub-Windows");
            jMenuItem9.addActionListener(this);
            jMenu7.add(jMenuItem9);
            JMenu jMenu8 = new JMenu("Help");
            JMenuItem jMenuItem10 = new JMenuItem("Show Help Window");
            jMenuItem10.addActionListener(this);
            jMenu8.add(jMenuItem10);
            JMenuItem jMenuItem11 = new JMenuItem("About Racy");
            jMenuItem11.addActionListener(this);
            jMenu8.add(jMenuItem11);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu7);
            jMenuBar.add(jMenu8);
            this.setJMenuBar(jMenuBar);
            this.contentPane = this.getContentPane();
            this.gbl = new GridBagLayout();
            this.contentPane.setLayout(this.gbl);
            this.gbc = new GridBagConstraints();
            this.gbc.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.sMWPanel = new StaticMainWindowPanel(this.trial, this);
            this.sMWPanel.setPreferredSize(new Dimension(600, 300));
            this.scrollPane = new JScrollPane(this.sMWPanel);
            this.scrollPane.setBorder(border);
            this.scrollPane.setPreferredSize(new Dimension(600, 300));
            String[] stringArray = new String[]{"1.00", "0.75", "0.50", "0.25", "0.10"};
            this.sliderMultiple = new JComboBox<String>(stringArray);
            this.sliderMultiple.addActionListener(this);
            this.barLengthSlider.setPaintTicks(true);
            this.barLengthSlider.setMajorTickSpacing(5);
            this.barLengthSlider.setMinorTickSpacing(1);
            this.barLengthSlider.setPaintLabels(true);
            this.barLengthSlider.setSnapToTicks(true);
            this.barLengthSlider.addChangeListener(this);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.scrollPane, this.gbc, 0, 0, 1, 1);
            this.sMWData = new StaticMainWindowData(this.trial);
            this.sMWData.buildStaticMainWindowDataLists();
            this.sortLocalData();
            this.sMWPanel.repaint();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMW01");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block23: {
            try {
                Object object = actionEvent.getSource();
                if (object instanceof JMenuItem) {
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ParaProf Manager")) {
                        ParaProfManager paraProfManager = new ParaProfManager();
                        paraProfManager.show();
                        break block23;
                    }
                    if (string.equals("Bin Window")) {
                        BinWindow binWindow = new BinWindow(this.trial, this.sMWData, true, -1);
                        binWindow.show();
                        break block23;
                    }
                    if (string.equals("test") || string.equals("testImage") || string.equals("ParaProf Preferrences")) break block23;
                    if (string.equals("Edit ParaProf Preferences!")) {
                        this.trial.getPreferences().showPreferencesWindow();
                        break block23;
                    }
                    if (string.equals("Save Image")) {
                        ParaProfImageOutput paraProfImageOutput = new ParaProfImageOutput();
                        paraProfImageOutput.saveImage(this.sMWPanel);
                        break block23;
                    }
                    if (string.equals("Exit ParaProf!")) {
                        this.setVisible(false);
                        this.dispose();
                        System.exit(0);
                        break block23;
                    }
                    if (string.equals("function ID")) {
                        if (!this.mappingIDButton.isSelected()) break block23;
                        this.sortByMappingID = true;
                        this.sortByName = false;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                        break block23;
                    }
                    if (string.equals("name")) {
                        if (!this.nameButton.isSelected()) break block23;
                        this.sortByMappingID = false;
                        this.sortByName = true;
                        this.sortByMillisecond = false;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                        break block23;
                    }
                    if (string.equals("millisecond")) {
                        if (!this.millisecondButton.isSelected()) break block23;
                        this.sortByMappingID = false;
                        this.sortByName = false;
                        this.sortByMillisecond = true;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                        break block23;
                    }
                    if (string.equals("Descending")) {
                        if (!this.descendingButton.isSelected()) break block23;
                        this.descendingOrder = true;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                        break block23;
                    }
                    if (string.equals("Ascending")) {
                        if (!this.ascendingButton.isSelected()) break block23;
                        this.descendingOrder = false;
                        this.sortLocalData();
                        this.sMWPanel.repaint();
                        break block23;
                    }
                    if (string.equals("Display Sliders")) {
                        if (this.displaySlidersButton.isSelected()) {
                            this.displaySiders(true);
                        } else {
                            this.displaySiders(false);
                        }
                        break block23;
                    }
                    if (string.equals("Show Function Ledger")) {
                        this.trial.getGlobalMapping().displayMappingLedger(0);
                        break block23;
                    }
                    if (string.equals("Show Group Ledger")) {
                        this.trial.getGlobalMapping().displayMappingLedger(1);
                        break block23;
                    }
                    if (string.equals("Show User Event Ledger")) {
                        this.trial.getGlobalMapping().displayMappingLedger(2);
                        break block23;
                    }
                    if (string.equals("Show Call Path Relations")) {
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, -1, -1, -1, this.getSMWData(), true);
                        this.trial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                        break block23;
                    }
                    if (string.equals("Close All Sub-Windows")) {
                        this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                        break block23;
                    }
                    if (string.equals("About Racy")) {
                        JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                        break block23;
                    }
                    if (!string.equals("Show Help Window")) break block23;
                    ParaProf.helpWindow.show();
                    break block23;
                }
                if (object == this.sliderMultiple) {
                    this.sMWPanel.changeInMultiples();
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMW02");
            }
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        block7: {
            try {
                if (this.trial.groupNamesPresent()) {
                    this.mappingGroupLedgerItem.setEnabled(true);
                } else {
                    this.mappingGroupLedgerItem.setEnabled(false);
                }
                if (this.trial.userEventsPresent()) {
                    this.userEventLedgerItem.setEnabled(true);
                } else {
                    this.userEventLedgerItem.setEnabled(false);
                }
                if (this.trial.callPathDataPresent()) {
                    this.callPathItem.setEnabled(true);
                    break block7;
                }
                this.callPathItem.setEnabled(false);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMW03");
            }
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.sMWPanel.changeInMultiples();
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.sMWPanel.repaint();
            } else if (string.equals("colorEvent")) {
                this.sMWPanel.repaint();
            } else if (string.equals("dataEvent")) {
                this.sortLocalData();
                this.sMWPanel.repaint();
            } else if (string.equals("dataSetChangeEvent")) {
                this.currentSMWGeneralData = null;
                this.currentSMWMeanData = null;
                this.sortLocalData();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMW04");
        }
    }

    public int getSliderValue() {
        int n = -1;
        try {
            n = this.barLengthSlider.getValue();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMW05");
        }
        return n;
    }

    public double getSliderMultiple() {
        String string = null;
        try {
            string = (String)this.sliderMultiple.getSelectedItem();
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMW06");
            return 0.0;
        }
    }

    private void displaySiders(boolean bl) {
        if (bl) {
            this.contentPane.remove(this.scrollPane);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultipleLabel, this.gbc, 0, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.sliderMultiple, this.gbc, 1, 0, 1, 1);
            this.gbc.fill = 0;
            this.gbc.anchor = 13;
            this.gbc.weightx = 0.1;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthLabel, this.gbc, 2, 0, 1, 1);
            this.gbc.fill = 2;
            this.gbc.anchor = 17;
            this.gbc.weightx = 0.7;
            this.gbc.weighty = 0.01;
            this.addCompItem(this.barLengthSlider, this.gbc, 3, 0, 1, 1);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 0.99;
            this.addCompItem(this.scrollPane, this.gbc, 0, 1, 4, 1);
        } else {
            this.contentPane.remove(this.sliderMultipleLabel);
            this.contentPane.remove(this.sliderMultiple);
            this.contentPane.remove(this.barLengthLabel);
            this.contentPane.remove(this.barLengthSlider);
            this.contentPane.remove(this.scrollPane);
            this.gbc.fill = 1;
            this.gbc.anchor = 10;
            this.gbc.weightx = 1.0;
            this.gbc.weighty = 1.0;
            this.addCompItem(this.scrollPane, this.gbc, 0, 0, 1, 1);
        }
        this.validate();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.contentPane.add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMW07");
        }
    }

    public StaticMainWindowData getSMWData() {
        return this.sMWData;
    }

    private void sortLocalData() {
        block10: {
            try {
                if (this.sortByMappingID) {
                    this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("FIdDE") : this.sMWData.getSMWGeneralData("FIdAE");
                } else if (this.sortByName) {
                    this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("NDE") : this.sMWData.getSMWGeneralData("NAE");
                } else if (this.sortByMillisecond) {
                    this.currentSMWGeneralData = this.descendingOrder ? this.sMWData.getSMWGeneralData("MDE") : this.sMWData.getSMWGeneralData("MAE");
                }
                if (this.sortByMappingID) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("FIdDE") : this.sMWData.getSMWMeanData("FIdAE");
                    break block10;
                }
                if (this.sortByName) {
                    this.currentSMWMeanData = this.descendingOrder ? this.sMWData.getSMWMeanData("NDE") : this.sMWData.getSMWMeanData("NAE");
                    break block10;
                }
                if (!this.sortByMillisecond) break block10;
                if (this.descendingOrder) {
                    this.currentSMWMeanData = this.sMWData.getSMWMeanData("MDE");
                    break block10;
                }
                this.currentSMWMeanData = this.sMWData.getSMWMeanData("MAE");
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMW08");
            }
        }
    }

    public Vector getSMWGeneralData() {
        return this.currentSMWGeneralData;
    }

    public Vector getSMWMeanData() {
        return this.currentSMWMeanData;
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }
}

