/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import paraprof.CallPathTextWindow;
import paraprof.CallPathUtilFuncs;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.MappingDataWindow;
import paraprof.MeanDataWindow;
import paraprof.MeanTotalStatWindow;
import paraprof.ParaProf;
import paraprof.ParaProfImageInterface;
import paraprof.SMWContext;
import paraprof.SMWMeanDataElement;
import paraprof.SMWServer;
import paraprof.SMWThread;
import paraprof.SMWThreadDataElement;
import paraprof.StaticMainWindow;
import paraprof.ThreadDataWindow;
import paraprof.TotalStatUEWindow;
import paraprof.TotalStatWindow;
import paraprof.Trial;

public class StaticMainWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
PopupMenuListener,
ParaProfImageInterface {
    private Trial trial = null;
    StaticMainWindow sMWindow = null;
    int xPanelSize = 600;
    int yPanelSize = 300;
    private JPopupMenu popup = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    JMenuItem tUESWItem = null;
    JMenuItem threadCallpathItem = null;
    Vector contextList = null;
    Vector threadList = null;
    Vector threadDataList = null;
    SMWServer sMWServer = null;
    SMWContext sMWContext = null;
    SMWThread sMWThread = null;
    SMWThreadDataElement sMWThreadDataElement = null;
    SMWMeanDataElement sMWMeanDataElement = null;
    int serverCounter = 0;
    int contextCounter = 0;
    int threadCounter = 0;
    int serverNumber = 0;
    int contextNumber = 0;
    int threadNumber = 0;
    int sMWThreadDataElementCounter = 0;
    int colorCounter = 0;
    int xCoord = -1;
    int yCoord = -1;
    Object clickedOnObject = null;
    String counterName = null;
    private int defaultBarLength = 500;
    String tmpString = null;
    double tmpSum = -1.0;
    double tmpDataValue = -1.0;
    Color tmpColor = null;
    boolean highlighted = false;
    int barXStart = -1;
    int numberOfColors = 0;

    public StaticMainWindowPanel() {
        try {
            this.setToolTipText("Incorrect Constructor!!!");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP01");
        }
    }

    public StaticMainWindowPanel(Trial trial, StaticMainWindow staticMainWindow) {
        try {
            this.setToolTipText("ParaProf bar graph draw window!");
            this.setBackground(Color.white);
            this.addMouseListener(this);
            this.trial = trial;
            this.sMWindow = staticMainWindow;
            this.barXStart = 100;
            JMenuItem jMenuItem = new JMenuItem("Show Function Details");
            jMenuItem.addActionListener(this);
            this.popup.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Change Function Color");
            jMenuItem2.addActionListener(this);
            this.popup.add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem("Reset to Generic Color");
            jMenuItem3.addActionListener(this);
            this.popup.add(jMenuItem3);
            JMenuItem jMenuItem4 = new JMenuItem("Highlight this Function");
            jMenuItem4.addActionListener(this);
            this.popup.add(jMenuItem4);
            JMenuItem jMenuItem5 = new JMenuItem("Un-Highlight this Function");
            jMenuItem5.addActionListener(this);
            this.popup.add(jMenuItem5);
            this.popup2.addPopupMenuListener(this);
            JMenuItem jMenuItem6 = new JMenuItem("Show Total Statistics Windows");
            jMenuItem6.addActionListener(this);
            this.popup2.add(jMenuItem6);
            this.tUESWItem = new JMenuItem("Show Total User Event Statistics Windows");
            this.tUESWItem.addActionListener(this);
            this.popup2.add(this.tUESWItem);
            this.threadCallpathItem = new JMenuItem("Show Call Path Thread Relations");
            this.threadCallpathItem.addActionListener(this);
            this.popup2.add(this.threadCallpathItem);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP02");
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        String string = null;
        try {
            Enumeration enumeration;
            int n = 0;
            int n2 = 0;
            this.xCoord = mouseEvent.getX();
            this.yCoord = mouseEvent.getY();
            if (!this.sMWindow.getSMWMeanData().isEmpty()) {
                this.sMWMeanDataElement = (SMWMeanDataElement)this.sMWindow.getSMWMeanData().elementAt(0);
                if (this.yCoord >= this.sMWMeanDataElement.getYBeg() && this.yCoord <= this.sMWMeanDataElement.getYEnd()) {
                    enumeration = this.sMWindow.getSMWMeanData().elements();
                    while (enumeration.hasMoreElements()) {
                        this.sMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                        if (this.xCoord < this.barXStart) {
                            if (ParaProf.helpWindow.isShowing()) {
                                ParaProf.helpWindow.clearText();
                                ParaProf.helpWindow.writeText("You are to the left of the mean bar.");
                                ParaProf.helpWindow.writeText("");
                                ParaProf.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more detailed data about the mean values for the functions in the system.");
                            }
                            return new String("Left click - detailed display/Right click - Total Statistics.");
                        }
                        if (this.xCoord >= this.sMWMeanDataElement.getXEnd()) continue;
                        if (ParaProf.helpWindow.isShowing()) {
                            ParaProf.helpWindow.clearText();
                            ParaProf.helpWindow.writeText("Your mouse is over the mean draw bar!");
                            ParaProf.helpWindow.writeText("");
                            ParaProf.helpWindow.writeText("Current function name is: " + this.sMWMeanDataElement.getMappingName());
                            ParaProf.helpWindow.writeText("");
                            ParaProf.helpWindow.writeText("The mean draw bars give a visual representation of the mean values for the functions which have run in the system.  The funtions are assigned a color from the current ParaProf color set.  The colors are cycled through when the number of funtions exceeds the number of available colors. In the preferences section, you can add more colors.  Use the right and left mouse buttons to give additional information.");
                        }
                        return this.sMWMeanDataElement.getMappingName();
                    }
                    if (this.xCoord <= this.barXStart + this.defaultBarLength) {
                        if (ParaProf.helpWindow.isShowing()) {
                            ParaProf.helpWindow.clearText();
                            ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!");
                            ParaProf.helpWindow.writeText("");
                            ParaProf.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.");
                            ParaProf.helpWindow.writeText("");
                            ParaProf.helpWindow.writeText("To view these functions, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                        }
                        return "Misc function section ... see help window for details";
                    }
                }
            }
            enumeration = this.sMWindow.getSMWGeneralData().elements();
            while (enumeration.hasMoreElements()) {
                this.sMWServer = (SMWServer)enumeration.nextElement();
                if (this.yCoord > this.sMWServer.getYDrawCoord()) continue;
                this.contextList = this.sMWServer.getContextList();
                Enumeration enumeration2 = this.contextList.elements();
                while (enumeration2.hasMoreElements()) {
                    this.sMWContext = (SMWContext)enumeration2.nextElement();
                    if (this.yCoord > this.sMWContext.getYDrawCoord()) continue;
                    this.threadList = this.sMWContext.getThreadList();
                    Enumeration enumeration3 = this.threadList.elements();
                    while (enumeration3.hasMoreElements()) {
                        this.sMWThread = (SMWThread)enumeration3.nextElement();
                        if (this.yCoord > this.sMWThread.getYDrawCoord()) continue;
                        this.threadDataList = this.sMWThread.getThreadDataList();
                        this.sMWThreadDataElementCounter = 0;
                        Enumeration enumeration4 = this.threadDataList.elements();
                        while (enumeration4.hasMoreElements()) {
                            this.sMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                            n = this.sMWThreadDataElement.getYBeg();
                            n2 = this.sMWThreadDataElement.getYEnd();
                            if (this.xCoord < this.barXStart) {
                                if (this.yCoord >= n && this.yCoord <= n2) {
                                    if (ParaProf.helpWindow.isShowing()) {
                                        ParaProf.helpWindow.clearText();
                                        ParaProf.helpWindow.writeText("n,c,t stands for: Node, Context and Thread.");
                                        ParaProf.helpWindow.writeText("");
                                        ParaProf.helpWindow.writeText("Using either the right or left mouse buttons, click once to display more detailed data about this thread.");
                                    }
                                    return new String("Left click - detailed display/Right click - Total Statistics.");
                                }
                                return string;
                            }
                            if (this.xCoord < this.sMWThreadDataElement.getXEnd()) {
                                if (this.yCoord >= n && this.yCoord <= n2) {
                                    if (ParaProf.helpWindow.isShowing()) {
                                        ParaProf.helpWindow.clearText();
                                        ParaProf.helpWindow.writeText("Your mouse is over one of the thread draw bars!");
                                        ParaProf.helpWindow.writeText("");
                                        ParaProf.helpWindow.writeText("Current function name is: " + this.sMWThreadDataElement.getMappingName());
                                        ParaProf.helpWindow.writeText("");
                                        ParaProf.helpWindow.writeText("The thread draw bars give a visual representation functions which have run on this thread.  The funtions are assigned a color from the current Racy color set.  The colors are cycled through when the number of funtions exceeds the number of available colors.  Use the right and left mouse buttons to give additional information.");
                                    }
                                    return this.sMWThreadDataElement.getMappingName();
                                }
                                return string;
                            }
                            ++this.sMWThreadDataElementCounter;
                        }
                        if (this.yCoord >= n && this.yCoord <= n2 && this.xCoord <= this.barXStart + this.defaultBarLength) {
                            if (ParaProf.helpWindow.isShowing()) {
                                ParaProf.helpWindow.clearText();
                                ParaProf.helpWindow.writeText("Your mouse is over the misc. function section!");
                                ParaProf.helpWindow.writeText("");
                                ParaProf.helpWindow.writeText("These are functions which have a non zero value, but whose screen representation is less than a pixel.");
                                ParaProf.helpWindow.writeText("");
                                ParaProf.helpWindow.writeText("To view these functions, right or left click to the left of this bar to bring up windows which will show more detailed information.");
                            }
                            return "Misc function section ... see help window for details";
                        }
                        return string;
                    }
                }
                return string;
            }
            return string;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP03");
            return string;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block17: {
            try {
                Object object = actionEvent.getSource();
                SMWThreadDataElement sMWThreadDataElement = null;
                SMWMeanDataElement sMWMeanDataElement = null;
                if (!(object instanceof JMenuItem)) break block17;
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Function Details")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorMappingID(sMWThreadDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWThreadDataElement.getMappingID(), this.sMWindow.getSMWData());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    } else {
                        sMWMeanDataElement = (SMWMeanDataElement)this.clickedOnObject;
                        this.trial.getColorChooser().setHighlightColorMappingID(sMWMeanDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, sMWMeanDataElement.getMappingID(), this.sMWindow.getSMWData());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                    }
                    break block17;
                }
                if (string.equals("Change Function Color")) {
                    int n = -1;
                    n = this.clickedOnObject instanceof SMWThreadDataElement ? ((SMWThreadDataElement)this.clickedOnObject).getMappingID() : ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    Color color = globalMappingElement.getMappingColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) == null) break block17;
                    globalMappingElement.setSpecificColor(color);
                    globalMappingElement.setColorFlag(true);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    break block17;
                }
                if (string.equals("Reset to Generic Color")) {
                    int n = -1;
                    n = this.clickedOnObject instanceof SMWThreadDataElement ? ((SMWThreadDataElement)this.clickedOnObject).getMappingID() : ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    GlobalMapping globalMapping = this.trial.getGlobalMapping();
                    GlobalMappingElement globalMappingElement = globalMapping.getGlobalMappingElement(n, 0);
                    globalMappingElement.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                } else if (string.equals("Highlight this Function")) {
                    int n = -1;
                    n = this.clickedOnObject instanceof SMWThreadDataElement ? ((SMWThreadDataElement)this.clickedOnObject).getMappingID() : ((SMWMeanDataElement)this.clickedOnObject).getMappingID();
                    this.trial.getColorChooser().setHighlightColorMappingID(n);
                } else if (string.equals("Un-Highlight this Function")) {
                    this.trial.getColorChooser().setHighlightColorMappingID(-1);
                } else if (string.equals("Show Total Statistics Windows")) {
                    TotalStatWindow totalStatWindow = new TotalStatWindow(this.trial, this.serverNumber, this.contextNumber, this.threadNumber, this.sMWindow.getSMWData());
                    this.trial.getSystemEvents().addObserver(totalStatWindow);
                    totalStatWindow.show();
                } else if (string.equals("Show Total User Event Statistics Windows")) {
                    TotalStatUEWindow totalStatUEWindow = new TotalStatUEWindow(this.trial, this.serverNumber, this.contextNumber, this.threadNumber, this.sMWindow.getSMWData());
                    this.trial.getSystemEvents().addObserver(totalStatUEWindow);
                    totalStatUEWindow.show();
                } else if (string.equals("Show Call Path Thread Relations")) {
                    CallPathUtilFuncs.trimCallPathData(this.trial, this.serverNumber, this.contextNumber, this.threadNumber);
                    CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, this.serverNumber, this.contextNumber, this.threadNumber, this.sMWindow.getSMWData(), false);
                    this.trial.getSystemEvents().addObserver(callPathTextWindow);
                    callPathTextWindow.show();
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMWP04");
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            Enumeration enumeration;
            this.xCoord = mouseEvent.getX();
            this.yCoord = mouseEvent.getY();
            int n = mouseEvent.getClickCount();
            this.sMWThreadDataElementCounter = 0;
            this.threadCounter = 0;
            this.contextCounter = 0;
            this.serverCounter = 0;
            if (!this.sMWindow.getSMWMeanData().isEmpty()) {
                this.sMWMeanDataElement = (SMWMeanDataElement)this.sMWindow.getSMWMeanData().elementAt(0);
                if (this.yCoord >= this.sMWMeanDataElement.getYBeg() && this.yCoord <= this.sMWMeanDataElement.getYEnd()) {
                    enumeration = this.sMWindow.getSMWMeanData().elements();
                    while (enumeration.hasMoreElements()) {
                        this.sMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                        if (this.xCoord < this.barXStart) {
                            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                                MeanDataWindow meanDataWindow = new MeanDataWindow(this.trial, this.sMWindow.getSMWData());
                                this.trial.getSystemEvents().addObserver(meanDataWindow);
                                meanDataWindow.show();
                            } else {
                                MeanTotalStatWindow meanTotalStatWindow = new MeanTotalStatWindow(this.trial, this.sMWindow.getSMWData());
                                this.trial.getSystemEvents().addObserver(meanTotalStatWindow);
                                meanTotalStatWindow.show();
                            }
                            return;
                        }
                        if (this.xCoord >= this.sMWMeanDataElement.getXEnd()) continue;
                        if ((mouseEvent.getModifiers() & 0x10) == 0) {
                            this.clickedOnObject = this.sMWMeanDataElement;
                            this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                            return;
                        }
                        this.trial.getColorChooser().setHighlightColorMappingID(this.sMWMeanDataElement.getMappingID());
                        MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, this.sMWMeanDataElement.getMappingID(), this.sMWindow.getSMWData());
                        this.trial.getSystemEvents().addObserver(mappingDataWindow);
                        mappingDataWindow.show();
                        return;
                    }
                }
            }
            enumeration = this.sMWindow.getSMWGeneralData().elements();
            while (enumeration.hasMoreElements()) {
                this.sMWServer = (SMWServer)enumeration.nextElement();
                if (this.yCoord <= this.sMWServer.getYDrawCoord()) {
                    this.contextList = this.sMWServer.getContextList();
                    Enumeration enumeration2 = this.contextList.elements();
                    while (enumeration2.hasMoreElements()) {
                        this.sMWContext = (SMWContext)enumeration2.nextElement();
                        if (this.yCoord <= this.sMWContext.getYDrawCoord()) {
                            this.threadList = this.sMWContext.getThreadList();
                            Enumeration enumeration3 = this.threadList.elements();
                            while (enumeration3.hasMoreElements()) {
                                this.sMWThread = (SMWThread)enumeration3.nextElement();
                                if (this.yCoord <= this.sMWThread.getYDrawCoord()) {
                                    this.threadDataList = this.sMWThread.getThreadDataList();
                                    this.sMWThreadDataElementCounter = 0;
                                    Enumeration enumeration4 = this.threadDataList.elements();
                                    while (enumeration4.hasMoreElements()) {
                                        this.sMWThreadDataElement = (SMWThreadDataElement)enumeration4.nextElement();
                                        if (this.xCoord < this.barXStart) {
                                            if (this.yCoord >= this.sMWThreadDataElement.getYBeg() && this.yCoord <= this.sMWThreadDataElement.getYEnd()) {
                                                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                                                    ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.trial, this.serverCounter, this.contextCounter, this.threadCounter, this.sMWindow.getSMWData());
                                                    this.trial.getSystemEvents().addObserver(threadDataWindow);
                                                    threadDataWindow.show();
                                                } else {
                                                    this.popup2.show(this, mouseEvent.getX(), mouseEvent.getY());
                                                    this.serverNumber = this.serverCounter;
                                                    this.contextNumber = this.contextCounter;
                                                    this.threadNumber = this.threadCounter;
                                                    return;
                                                }
                                            }
                                            return;
                                        }
                                        if (this.xCoord < this.sMWThreadDataElement.getXEnd()) {
                                            if (this.yCoord < this.sMWThreadDataElement.getYBeg() || this.yCoord > this.sMWThreadDataElement.getYEnd()) continue;
                                            if ((mouseEvent.getModifiers() & 0x10) == 0) {
                                                this.clickedOnObject = this.sMWThreadDataElement;
                                                this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                                                return;
                                            }
                                            this.trial.getColorChooser().setHighlightColorMappingID(this.sMWThreadDataElement.getMappingID());
                                            MappingDataWindow mappingDataWindow = new MappingDataWindow(this.trial, this.sMWThreadDataElement.getMappingID(), this.sMWindow.getSMWData());
                                            this.trial.getSystemEvents().addObserver(mappingDataWindow);
                                            mappingDataWindow.show();
                                            return;
                                        }
                                        ++this.sMWThreadDataElementCounter;
                                    }
                                }
                                ++this.threadCounter;
                            }
                        }
                        ++this.contextCounter;
                    }
                }
                ++this.serverCounter;
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, "display");
        }
        catch (Exception exception) {
            System.out.println(exception);
            ParaProf.systemError(exception, null, "SMWP06");
        }
    }

    public void renderIt(Graphics2D graphics2D, String string) {
        try {
            Object object;
            int n;
            boolean bl = false;
            if (string.equals("display")) {
                bl = true;
            }
            this.numberOfColors = this.trial.getColorChooser().getNumberOfColors();
            GlobalMapping globalMapping = this.trial.getGlobalMapping();
            boolean bl2 = false;
            int n2 = 0;
            if (globalMapping.getIsSelectedGroupOn()) {
                bl2 = true;
                n2 = globalMapping.getSelectedGroupID();
            }
            this.colorCounter = 0;
            this.sMWThreadDataElementCounter = 0;
            this.threadCounter = 0;
            this.contextCounter = 0;
            this.serverCounter = 0;
            this.highlighted = false;
            this.yCoord = 0;
            this.xCoord = 0;
            int n3 = 0;
            int n4 = 0;
            if (!this.trial.getPreferences().areBarDetailsSet()) {
                Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), 12);
                graphics2D.setFont(font);
                FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                int n5 = fontMetrics.getAscent();
                int n6 = fontMetrics.getMaxDescent();
                n = n5 + n6;
                this.trial.getPreferences().setBarDetails(n5, n + 5);
                this.trial.getPreferences().setSliders(n5, n + 5);
            }
            int n7 = this.trial.getPreferences().getBarSpacing();
            int n8 = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), n8);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            n = 3 * n7 + this.trial.getTotalNumberOfThreads() * n7;
            int n9 = this.barXStart + this.defaultBarLength;
            boolean bl3 = false;
            if (n9 > this.xPanelSize) {
                this.xPanelSize = n9 + 10;
                bl3 = true;
            }
            if (n > this.yPanelSize) {
                this.yPanelSize = n + 10;
                bl3 = true;
            }
            if (bl3 && bl) {
                this.revalidate();
            }
            String string2 = new String("n,c,t 99,99,99");
            int n10 = fontMetrics.stringWidth(string2);
            this.barXStart = n10 + 15;
            int n11 = this.barXStart + this.defaultBarLength;
            int n12 = this.barXStart;
            this.yCoord += n7;
            this.counterName = this.trial.getCounterName();
            if (this.counterName != null) {
                graphics2D.drawString("COUNTER NAME: " + this.counterName, 5, this.yCoord);
                this.yCoord += n7;
            }
            if (bl) {
                object = graphics2D.getClipBounds();
                n3 = (int)((Rectangle)object).getY();
                n4 = (int)((double)n3 + ((Rectangle)object).getHeight());
                n4 += n7;
            } else {
                n3 = 0;
                n4 = this.yPanelSize;
            }
            this.yCoord += n7;
            object = "Mean";
            int n13 = fontMetrics.stringWidth((String)object);
            graphics2D.drawString((String)object, this.barXStart - n13 - 5, this.yCoord);
            this.tmpSum = 0.0;
            Enumeration enumeration = this.sMWindow.getSMWMeanData().elements();
            while (enumeration.hasMoreElements()) {
                this.sMWMeanDataElement = (SMWMeanDataElement)enumeration.nextElement();
                this.tmpSum += this.sMWMeanDataElement.getValue();
            }
            this.colorCounter = 0;
            n12 = this.barXStart;
            Enumeration enumeration2 = this.sMWindow.getSMWMeanData().elements();
            while (enumeration2.hasMoreElements()) {
                this.sMWMeanDataElement = (SMWMeanDataElement)enumeration2.nextElement();
                this.tmpDataValue = this.sMWMeanDataElement.getValue();
                if (this.tmpDataValue > 0.0) {
                    double d = this.tmpDataValue / this.tmpSum;
                    int n14 = (int)(d * (double)this.defaultBarLength);
                    if (n14 > 2) {
                        if (n8 > 2) {
                            this.tmpColor = this.sMWMeanDataElement.getMappingColor();
                            graphics2D.setColor(this.tmpColor);
                            graphics2D.fillRect(n12 + 1, this.yCoord - n8 + 1, n14 - 1, n8 - 1);
                            if (this.sMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                this.highlighted = true;
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                graphics2D.drawRect(n12, this.yCoord - n8, n14, n8);
                                graphics2D.drawRect(n12 + 1, this.yCoord - n8 + 1, n14 - 2, n8 - 2);
                            } else if (this.sMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                this.highlighted = true;
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                graphics2D.drawRect(n12, this.yCoord - n8, n14, n8);
                                graphics2D.drawRect(n12 + 1, this.yCoord - n8 + 1, n14 - 2, n8 - 2);
                            } else {
                                graphics2D.setColor(Color.black);
                                if (this.highlighted) {
                                    graphics2D.drawLine(n12 + 1, this.yCoord - n8, n12 + 1 + n14, this.yCoord - n8);
                                    graphics2D.drawLine(n12 + 1, this.yCoord, n12 + 1 + n14, this.yCoord);
                                    graphics2D.drawLine(n12 + 1 + n14, this.yCoord - n8, n12 + 1 + n14, this.yCoord);
                                    this.highlighted = false;
                                } else {
                                    graphics2D.drawRect(n12, this.yCoord - n8, n14, n8);
                                }
                            }
                            if (bl) {
                                this.sMWMeanDataElement.setDrawCoords(n12, n12 + n14, this.yCoord - n8, this.yCoord);
                            }
                            n12 += n14;
                        } else {
                            if (this.sMWMeanDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                            } else if (this.sMWMeanDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                            } else {
                                this.tmpColor = this.sMWMeanDataElement.getMappingColor();
                                graphics2D.setColor(this.tmpColor);
                            }
                            graphics2D.fillRect(n12, this.yCoord - n8, n14, n8);
                            graphics2D.setColor(Color.black);
                            graphics2D.drawRect(n12, this.yCoord - n8, n14, n8);
                            if (bl) {
                                this.sMWMeanDataElement.setDrawCoords(n12, n12 + n14, this.yCoord - n8, this.yCoord);
                            }
                            n12 += n14;
                        }
                    }
                    if (bl) {
                        this.sMWMeanDataElement.setDrawCoords(n12, n12, this.yCoord - n8, this.yCoord);
                    }
                } else if (bl) {
                    this.sMWMeanDataElement.setDrawCoords(n12, n12, this.yCoord - n8, this.yCoord);
                }
                this.colorCounter = (this.colorCounter + 1) % this.numberOfColors;
            }
            if (n12 < this.defaultBarLength + this.barXStart) {
                graphics2D.setColor(this.trial.getColorChooser().getMiscMappingsColor());
                graphics2D.fillRect(n12, this.yCoord - n8, this.defaultBarLength + this.barXStart - n12, n8);
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n12, this.yCoord - n8, this.defaultBarLength + this.barXStart - n12, n8);
            }
            graphics2D.setColor(Color.black);
            this.serverCounter = 0;
            Enumeration enumeration3 = this.sMWindow.getSMWGeneralData().elements();
            while (enumeration3.hasMoreElements()) {
                this.sMWServer = (SMWServer)enumeration3.nextElement();
                this.contextList = this.sMWServer.getContextList();
                this.contextCounter = 0;
                Enumeration enumeration4 = this.contextList.elements();
                while (enumeration4.hasMoreElements()) {
                    this.sMWContext = (SMWContext)enumeration4.nextElement();
                    this.threadList = this.sMWContext.getThreadList();
                    this.threadCounter = 0;
                    Enumeration enumeration5 = this.threadList.elements();
                    while (enumeration5.hasMoreElements()) {
                        this.highlighted = false;
                        this.yCoord += n7;
                        this.sMWThread = (SMWThread)enumeration5.nextElement();
                        if (this.yCoord >= n3 && this.yCoord <= n4) {
                            int n15;
                            double d;
                            Enumeration enumeration6;
                            String string3 = "n,c,t   " + this.serverCounter + "," + this.contextCounter + "," + this.threadCounter;
                            int n16 = fontMetrics.stringWidth(string3);
                            graphics2D.drawString(string3, this.barXStart - n16 - 5, this.yCoord);
                            this.threadDataList = this.sMWThread.getThreadDataList();
                            this.tmpSum = 0.0;
                            if (!bl2) {
                                enumeration6 = this.threadDataList.elements();
                                while (enumeration6.hasMoreElements()) {
                                    this.sMWThreadDataElement = (SMWThreadDataElement)enumeration6.nextElement();
                                    this.tmpSum += this.sMWThreadDataElement.getValue();
                                }
                            } else {
                                enumeration6 = this.threadDataList.elements();
                                while (enumeration6.hasMoreElements()) {
                                    this.sMWThreadDataElement = (SMWThreadDataElement)enumeration6.nextElement();
                                    if (!this.sMWThreadDataElement.isGroupMember(n2)) continue;
                                    this.tmpSum += this.sMWThreadDataElement.getValue();
                                }
                            }
                            this.colorCounter = 0;
                            n12 = this.barXStart;
                            if (!bl2) {
                                enumeration6 = this.threadDataList.elements();
                                while (enumeration6.hasMoreElements()) {
                                    this.sMWThreadDataElement = (SMWThreadDataElement)enumeration6.nextElement();
                                    this.tmpDataValue = this.sMWThreadDataElement.getValue();
                                    if (this.tmpDataValue > 0.0) {
                                        d = this.tmpDataValue / this.tmpSum;
                                        n15 = (int)(d * (double)this.defaultBarLength);
                                        if (n15 > 2) {
                                            if (n8 > 2) {
                                                this.tmpColor = this.sMWThreadDataElement.getMappingColor();
                                                graphics2D.setColor(this.tmpColor);
                                                graphics2D.fillRect(n12 + 1, this.yCoord - n8 + 1, n15 - 1, n8 - 1);
                                                if (this.sMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                                    this.highlighted = true;
                                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                                    graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                    graphics2D.drawRect(n12 + 1, this.yCoord - n8 + 1, n15 - 2, n8 - 2);
                                                } else if (this.sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                                    this.highlighted = true;
                                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                                    graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                    graphics2D.drawRect(n12 + 1, this.yCoord - n8 + 1, n15 - 2, n8 - 2);
                                                } else {
                                                    graphics2D.setColor(Color.black);
                                                    if (this.highlighted) {
                                                        graphics2D.drawLine(n12 + 1, this.yCoord - n8, n12 + 1 + n15, this.yCoord - n8);
                                                        graphics2D.drawLine(n12 + 1, this.yCoord, n12 + 1 + n15, this.yCoord);
                                                        graphics2D.drawLine(n12 + 1 + n15, this.yCoord - n8, n12 + 1 + n15, this.yCoord);
                                                        this.highlighted = false;
                                                    } else {
                                                        graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                    }
                                                }
                                                if (bl) {
                                                    this.sMWThreadDataElement.setDrawCoords(n12, n12 + n15, this.yCoord - n8, this.yCoord);
                                                }
                                                n12 += n15;
                                            } else {
                                                if (this.sMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                                } else if (this.sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                                } else {
                                                    this.tmpColor = this.sMWThreadDataElement.getMappingColor();
                                                    graphics2D.setColor(this.tmpColor);
                                                }
                                                graphics2D.fillRect(n12, this.yCoord - n8, n15, n8);
                                                graphics2D.setColor(Color.black);
                                                graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                if (bl) {
                                                    this.sMWThreadDataElement.setDrawCoords(n12, n12 + n15, this.yCoord - n8, this.yCoord);
                                                }
                                                n12 += n15;
                                            }
                                        }
                                        if (bl) {
                                            this.sMWThreadDataElement.setDrawCoords(n12, n12, this.yCoord - n8, this.yCoord);
                                        }
                                    } else if (bl) {
                                        this.sMWThreadDataElement.setDrawCoords(n12, n12, this.yCoord - n8, this.yCoord);
                                    }
                                    this.colorCounter = (this.colorCounter + 1) % this.numberOfColors;
                                }
                            } else {
                                enumeration6 = this.threadDataList.elements();
                                while (enumeration6.hasMoreElements()) {
                                    this.sMWThreadDataElement = (SMWThreadDataElement)enumeration6.nextElement();
                                    this.tmpDataValue = this.sMWThreadDataElement.getValue();
                                    if (this.tmpDataValue > 0.0 && this.sMWThreadDataElement.isGroupMember(n2)) {
                                        d = this.tmpDataValue / this.tmpSum;
                                        n15 = (int)(d * (double)this.defaultBarLength);
                                        if (n15 > 2) {
                                            if (n8 > 2) {
                                                this.tmpColor = this.sMWThreadDataElement.getMappingColor();
                                                graphics2D.setColor(this.tmpColor);
                                                graphics2D.fillRect(n12 + 1, this.yCoord - n8 + 1, n15 - 1, n8 - 1);
                                                if (this.sMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                                    this.highlighted = true;
                                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                                    graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                    graphics2D.drawRect(n12 + 1, this.yCoord - n8 + 1, n15 - 2, n8 - 2);
                                                } else if (this.sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                                    this.highlighted = true;
                                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                                    graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                    graphics2D.drawRect(n12 + 1, this.yCoord - n8 + 1, n15 - 2, n8 - 2);
                                                } else {
                                                    graphics2D.setColor(Color.black);
                                                    if (this.highlighted) {
                                                        graphics2D.drawLine(n12 + 1, this.yCoord - n8, n12 + 1 + n15, this.yCoord - n8);
                                                        graphics2D.drawLine(n12 + 1, this.yCoord, n12 + 1 + n15, this.yCoord);
                                                        graphics2D.drawLine(n12 + 1 + n15, this.yCoord - n8, n12 + 1 + n15, this.yCoord);
                                                        this.highlighted = false;
                                                    } else {
                                                        graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                    }
                                                }
                                                if (bl) {
                                                    this.sMWThreadDataElement.setDrawCoords(n12, n12 + n15, this.yCoord - n8, this.yCoord);
                                                }
                                                n12 += n15;
                                            } else {
                                                if (this.sMWThreadDataElement.getMappingID() == this.trial.getColorChooser().getHighlightColorMappingID()) {
                                                    graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                                                } else if (this.sMWThreadDataElement.isGroupMember(this.trial.getColorChooser().getGHCMID())) {
                                                    graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                                                } else {
                                                    this.tmpColor = this.sMWThreadDataElement.getMappingColor();
                                                    graphics2D.setColor(this.tmpColor);
                                                }
                                                graphics2D.fillRect(n12, this.yCoord - n8, n15, n8);
                                                graphics2D.setColor(Color.black);
                                                graphics2D.drawRect(n12, this.yCoord - n8, n15, n8);
                                                if (bl) {
                                                    this.sMWThreadDataElement.setDrawCoords(n12, n12 + n15, this.yCoord - n8, this.yCoord);
                                                }
                                                n12 += n15;
                                            }
                                        }
                                        if (bl) {
                                            this.sMWThreadDataElement.setDrawCoords(n12, n12, this.yCoord - n8, this.yCoord);
                                        }
                                    } else if (bl) {
                                        this.sMWThreadDataElement.setDrawCoords(n12, n12, this.yCoord - n8, this.yCoord);
                                    }
                                    this.colorCounter = (this.colorCounter + 1) % this.numberOfColors;
                                }
                            }
                            if (n12 < this.defaultBarLength + this.barXStart) {
                                graphics2D.setColor(this.trial.getColorChooser().getMiscMappingsColor());
                                graphics2D.fillRect(n12, this.yCoord - n8, this.defaultBarLength + this.barXStart - n12, n8);
                                graphics2D.setColor(Color.black);
                                graphics2D.drawRect(n12, this.yCoord - n8, this.defaultBarLength + this.barXStart - n12, n8);
                            }
                            graphics2D.setColor(Color.black);
                        }
                        if (bl) {
                            this.sMWThread.setYDrawCoord(this.yCoord);
                        }
                        ++this.threadCounter;
                    }
                    if (bl) {
                        this.sMWContext.setYDrawCoord(this.yCoord);
                    }
                    ++this.contextCounter;
                }
                if (bl) {
                    this.sMWServer.setYDrawCoord(this.yCoord);
                }
                ++this.serverCounter;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ParaProf.systemError(exception, null, "SMWP07");
        }
    }

    public Dimension getImageSize() {
        return this.getPreferredSize();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        block5: {
            try {
                if (this.trial.userEventsPresent()) {
                    this.tUESWItem.setEnabled(true);
                } else {
                    this.tUESWItem.setEnabled(false);
                }
                if (this.trial.callPathDataPresent()) {
                    this.threadCallpathItem.setEnabled(true);
                    break block5;
                }
                this.threadCallpathItem.setEnabled(true);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMW03");
            }
        }
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void changeInMultiples() {
        this.computeDefaultBarLength();
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }

    public void computeDefaultBarLength() {
        try {
            double d = this.sMWindow.getSliderValue();
            double d2 = this.sMWindow.getSliderMultiple();
            double d3 = 500.0 * d * d2;
            this.defaultBarLength = (int)d3;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SMWP07");
        }
    }
}

