/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import paraprof.ParaProf;
import paraprof.StaticMainWindowData;
import paraprof.TotalStatUEWindowPanel;
import paraprof.Trial;

public class TotalStatUEWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer {
    private Trial trial = null;
    private TotalStatUEWindowPanel totalStatUEWindowPanelRef;
    private StaticMainWindowData sMWData = new StaticMainWindowData(this.trial);
    private JMenuItem mappingGroupLedgerItem;
    private JMenuItem userEventLedgerItem;
    ButtonGroup sortGroup;
    ButtonGroup sortOrderGroup;
    ButtonGroup inclusiveExclusiveGroup;
    JRadioButtonMenuItem mappingIDButton;
    JRadioButtonMenuItem nameButton;
    JRadioButtonMenuItem millisecondButton;
    JRadioButtonMenuItem ascendingButton;
    JRadioButtonMenuItem descendingButton;
    JRadioButtonMenuItem inclusiveRadioButton;
    JRadioButtonMenuItem exclusiveRadioButton;
    boolean sortByMappingID = false;
    boolean sortByName = false;
    boolean sortByMillisecond = true;
    boolean descendingOrder = true;
    boolean inclusive = false;
    int server;
    int context;
    int thread;
    Vector FIdDE;
    Vector FIdAE;
    Vector NDE;
    Vector NAE;
    Vector MDE;
    Vector MAE;
    Vector MDI;
    Vector MAI;

    public TotalStatUEWindow() {
        try {
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(800, 600));
            this.setTitle("Wrong constructor used!");
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "TSUEW01");
        }
    }

    public TotalStatUEWindow(Trial trial, int n, int n2, int n3, StaticMainWindowData staticMainWindowData) {
        try {
            this.trial = trial;
            this.sMWData = staticMainWindowData;
            this.setLocation(new Point(0, 0));
            this.setSize(new Dimension(800, 600));
            this.setTitle("Total n,c,t, " + n + "," + n2 + "," + n3 + " - " + this.trial.getProfilePathName());
            this.server = n;
            this.context = n2;
            this.thread = n3;
            this.FIdDE = null;
            this.FIdAE = null;
            this.NDE = null;
            this.NAE = null;
            this.MDE = null;
            this.MAE = null;
            this.MDI = null;
            this.MAI = null;
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    TotalStatUEWindow.this.thisWindowClosing(windowEvent);
                }
            });
            if (ParaProf.helpWindow.isVisible()) {
                ParaProf.helpWindow.clearText();
                ParaProf.helpWindow.writeText("This is the total user event statistics window.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("This window shows you the total statistics for all user events on this thread.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                ParaProf.helpWindow.writeText("");
                ParaProf.helpWindow.writeText("Right click on any user event within this window to bring up a popup");
                ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                ParaProf.helpWindow.writeText("for the user event, or to show more details about the user event.");
                ParaProf.helpWindow.writeText("You can also left click any user event to hightlight it in the system.");
            }
            JMenuBar jMenuBar = new JMenuBar();
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem("Close This Window");
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
            JMenuItem jMenuItem2 = new JMenuItem("Exit Racy!");
            jMenuItem2.addActionListener(this);
            jMenu.add(jMenuItem2);
            JMenu jMenu2 = new JMenu("Options");
            JMenuItem jMenuItem3 = new JMenuItem("Adjust Racy Colors");
            jMenuItem3.addActionListener(this);
            jMenu2.add(jMenuItem3);
            JMenu jMenu3 = new JMenu("Windows");
            jMenu3.addMenuListener(this);
            JMenuItem jMenuItem4 = new JMenuItem("Show Function Ledger");
            jMenuItem4.addActionListener(this);
            jMenu3.add(jMenuItem4);
            this.mappingGroupLedgerItem = new JMenuItem("Show Group Ledger");
            this.mappingGroupLedgerItem.addActionListener(this);
            jMenu3.add(this.mappingGroupLedgerItem);
            this.userEventLedgerItem = new JMenuItem("Show User Event Ledger");
            this.userEventLedgerItem.addActionListener(this);
            jMenu3.add(this.userEventLedgerItem);
            JMenuItem jMenuItem5 = new JMenuItem("Close All Sub-Windows");
            jMenuItem5.addActionListener(this);
            jMenu3.add(jMenuItem5);
            JMenu jMenu4 = new JMenu("Help");
            JMenuItem jMenuItem6 = new JMenuItem("About Racy");
            jMenuItem6.addActionListener(this);
            jMenu4.add(jMenuItem6);
            JMenuItem jMenuItem7 = new JMenuItem("Show Help Window");
            jMenuItem7.addActionListener(this);
            jMenu4.add(jMenuItem7);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            this.setJMenuBar(jMenuBar);
            Container container = this.getContentPane();
            GridBagLayout gridBagLayout = new GridBagLayout();
            container.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            Border border = BorderFactory.createLoweredBevelBorder();
            Border border2 = BorderFactory.createRaisedBevelBorder();
            Border border3 = BorderFactory.createEmptyBorder();
            this.totalStatUEWindowPanelRef = new TotalStatUEWindowPanel(this.trial, n, n2, n3, this);
            JScrollPane jScrollPane = new JScrollPane(this.totalStatUEWindowPanelRef);
            JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
            jScrollBar.setUnitIncrement(35);
            jScrollPane.setBorder(border);
            jScrollPane.setPreferredSize(new Dimension(500, 450));
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(jScrollPane, gridBagConstraints, 0, 0, 1, 1);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "TSUEW02");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block23: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block23;
                String string = actionEvent.getActionCommand();
                if (string.equals("Close This Window")) {
                    this.closeThisWindow();
                    break block23;
                }
                if (string.equals("Exit Racy!")) {
                    this.setVisible(false);
                    this.dispose();
                    System.exit(0);
                    break block23;
                }
                if (string.equals("Adjust Racy Colors")) {
                    this.trial.getColorChooser().showColorChooser();
                    break block23;
                }
                if (string.equals("function ID")) {
                    if (!this.mappingIDButton.isSelected()) break block23;
                    this.sortByMappingID = true;
                    this.sortByName = false;
                    this.sortByMillisecond = false;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("name")) {
                    if (!this.nameButton.isSelected()) break block23;
                    this.sortByMappingID = false;
                    this.sortByName = true;
                    this.sortByMillisecond = false;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("millisecond")) {
                    if (!this.millisecondButton.isSelected()) break block23;
                    this.sortByMappingID = false;
                    this.sortByName = false;
                    this.sortByMillisecond = true;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("Descending")) {
                    if (!this.descendingButton.isSelected()) break block23;
                    this.descendingOrder = true;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("Ascending")) {
                    if (!this.ascendingButton.isSelected()) break block23;
                    this.descendingOrder = false;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("Inclusive")) {
                    if (!this.inclusiveRadioButton.isSelected()) break block23;
                    this.inclusive = true;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("Exclusive")) {
                    if (!this.exclusiveRadioButton.isSelected()) break block23;
                    this.inclusive = false;
                    this.totalStatUEWindowPanelRef.repaint();
                    break block23;
                }
                if (string.equals("Show Function Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(0);
                } else if (string.equals("Show Group Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(1);
                } else if (string.equals("Show User Event Ledger")) {
                    this.trial.getGlobalMapping().displayMappingLedger(2);
                } else if (string.equals("Close All Sub-Windows")) {
                    this.trial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                } else if (string.equals("About Racy")) {
                    JOptionPane.showMessageDialog(this, ParaProf.getInfoString());
                } else if (string.equals("Show Help Window")) {
                    ParaProf.helpWindow.clearText();
                    ParaProf.helpWindow.show();
                    ParaProf.helpWindow.writeText("This is the total function statistics window.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("This window shows you the total statistics for all functions on this thread.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("Use the options menu to select different ways of displaying the data.");
                    ParaProf.helpWindow.writeText("");
                    ParaProf.helpWindow.writeText("Right click on any function within this window to bring up a popup");
                    ParaProf.helpWindow.writeText("menu. In this menu you can change or reset the default colour");
                    ParaProf.helpWindow.writeText("for the function, or to show more details about the function.");
                    ParaProf.helpWindow.writeText("You can also left click any function to hightlight it in the system.");
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "TSUEW03");
            }
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        block5: {
            try {
                if (this.trial.groupNamesPresent()) {
                    this.mappingGroupLedgerItem.setEnabled(true);
                } else {
                    this.mappingGroupLedgerItem.setEnabled(false);
                }
                if (this.trial.userEventsPresent()) {
                    this.userEventLedgerItem.setEnabled(true);
                    break block5;
                }
                this.userEventLedgerItem.setEnabled(false);
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SMW03");
            }
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void update(Observable observable, Object object) {
        try {
            String string = (String)object;
            if (string.equals("prefEvent")) {
                this.totalStatUEWindowPanelRef.repaint();
            }
            if (string.equals("colorEvent")) {
                this.totalStatUEWindowPanelRef.repaint();
            } else if (string.equals("dataEvent")) {
                this.totalStatUEWindowPanelRef.repaint();
            } else if (string.equals("subWindowCloseEvent")) {
                this.closeThisWindow();
            }
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "TSUEW04");
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        try {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = n3;
            gridBagConstraints.gridheight = n4;
            this.getContentPane().add(component, gridBagConstraints);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "TSUEW05");
        }
    }

    public Vector getStaticMainWindowSystemData() {
        return this.sMWData.getSMWUEThreadData(this.server, this.context, this.thread);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        try {
            if (ParaProf.debugIsOn) {
                System.out.println("------------------------");
                System.out.println("A total stat window for: \"n,c,t, " + this.server + "," + this.context + "," + this.thread + "\" is closing");
                System.out.println("Clearing resourses for this window.");
            }
            this.setVisible(false);
            this.trial.getSystemEvents().deleteObserver(this);
            this.dispose();
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "TSUEW07");
        }
    }
}

