/*
 * Decompiled with CFR 0.152.
 */
package paraprof;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import paraprof.CallPathUtilFuncs;
import paraprof.ColorChooser;
import paraprof.Experiment;
import paraprof.GlobalContext;
import paraprof.GlobalMapping;
import paraprof.GlobalMappingElement;
import paraprof.GlobalServer;
import paraprof.GlobalThread;
import paraprof.GlobalThreadDataElement;
import paraprof.ParaProf;
import paraprof.Preferences;
import paraprof.StaticMainWindow;
import paraprof.SystemEvents;
import paraprof.UnexpectedStateException;
import paraprof.UserEventData;
import paraprof.Value;

public class Trial {
    Experiment parentExperiment = null;
    DefaultMutableTreeNode nodeRef = null;
    private String trialName = null;
    private int trialID = -1;
    private String trialIDString = null;
    private Vector values = new Vector();
    private SystemEvents systemEvents = null;
    private StaticMainWindow sMW = null;
    private ColorChooser clrChooser = new ColorChooser(this, null);
    private Preferences preferences = new Preferences(this, null);
    private File currentFile = null;
    private boolean firstRun = true;
    private String profilePathName = null;
    private String profilePathNameReverse = null;
    private int currentValueLocation = 0;
    private int currentValueWriteLocation = 0;
    private GlobalMapping globalMapping;
    private Vector nodes;
    private String counterName;
    private boolean isUserEventHeadingSet;
    boolean groupNamesCheck = false;
    boolean groupNamesPresent = false;
    boolean userEventsPresent = false;
    boolean callPathDataPresent = false;
    int bSDCounter;
    private int numberOfMappings = -1;
    private int numberOfUserEvents = -1;
    private int totalNumberOfThreads = 0;
    private int[] nct = null;
    private Vector maxMeanInclusiveValueList = new Vector();
    private Vector maxMeanExclusiveValueList = new Vector();
    private Vector maxMeanInclusivePercentValueList = new Vector();
    private Vector maxMeanExclusivePercentValueList = new Vector();
    private double maxMeanNumberOfCalls = 0.0;
    private double maxMeanNumberOfSubRoutines = 0.0;
    private Vector maxMeanUserSecPerCallList = new Vector();
    private Vector totalMeanInclusiveValueList = new Vector();
    private Vector totalMeanExclusiveValueList = new Vector();

    public Trial(Experiment experiment) {
        this.parentExperiment = experiment;
        this.globalMapping = new GlobalMapping(this);
        this.systemEvents = new SystemEvents();
        this.nodes = new Vector();
        this.counterName = null;
        this.isUserEventHeadingSet = false;
    }

    public Experiment getParentExperiment() {
        return this.parentExperiment;
    }

    public void setDMTN(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.nodeRef = defaultMutableTreeNode;
    }

    public DefaultMutableTreeNode getDMTN() {
        return this.nodeRef;
    }

    public void setTrialName(String string) {
        this.trialName = string;
    }

    public String getTrialName() {
        return this.trialName;
    }

    public void setTrialID(int n) {
        this.trialID = n;
        this.trialIDString = this.parentExperiment.getExperimentIDString() + this.trialID;
    }

    public int getTrialID() {
        return this.trialID;
    }

    public String getTrialIDString() {
        return this.trialIDString;
    }

    public Value addValue() {
        Value value = new Value(this);
        value.setValueID(this.values.size());
        this.values.add(value);
        return value;
    }

    public ColorChooser getColorChooser() {
        return this.clrChooser;
    }

    public Preferences getPreferences() {
        return this.preferences;
    }

    public void setProfilePathName(String string) {
        this.profilePathName = string;
    }

    public void setProfilePathNameReverse(String string) {
        this.profilePathNameReverse = string;
    }

    public String getProfilePathName() {
        return this.profilePathName;
    }

    public String getProfilePathNameReverse() {
        return this.profilePathNameReverse;
    }

    public Vector getValues() {
        return this.values;
    }

    public int getValuePosition(String string) {
        int n = 0;
        Enumeration enumeration = this.values.elements();
        while (enumeration.hasMoreElements()) {
            Value value = (Value)enumeration.nextElement();
            if (value.getValueName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String toString() {
        return this.trialName;
    }

    public Vector getNodes() {
        return this.nodes;
    }

    public int[] getMaxNCTNumbers() {
        if (this.nct == null) {
            this.nct = new int[3];
            int n = 0;
            while (n < 3) {
                this.nct[n] = 0;
                ++n;
            }
            GlobalServer globalServer = null;
            GlobalContext globalContext = null;
            Object var4_4 = null;
            Vector vector = null;
            Vector vector2 = null;
            this.nct[0] = this.nodes.size();
            Enumeration enumeration = this.nodes.elements();
            while (enumeration.hasMoreElements()) {
                globalServer = (GlobalServer)enumeration.nextElement();
                vector = globalServer.getContextList();
                if (vector.size() > this.nct[1]) {
                    this.nct[1] = vector.size();
                }
                Enumeration enumeration2 = vector.elements();
                while (enumeration2.hasMoreElements()) {
                    globalContext = (GlobalContext)enumeration2.nextElement();
                    vector2 = globalContext.getThreadList();
                    if (vector2.size() <= this.nct[2]) continue;
                    this.nct[2] = vector2.size();
                }
            }
        }
        return this.nct;
    }

    public StaticMainWindow getStaticMainWindow() {
        return this.sMW;
    }

    public void showMainWindow() {
        if (this.sMW == null) {
            this.sMW = new StaticMainWindow(this);
            this.sMW.setVisible(true);
            this.getSystemEvents().addObserver(this.sMW);
        } else {
            this.getSystemEvents().addObserver(this.sMW);
            this.sMW.show();
        }
    }

    public void closeStaticMainWindow() {
        if (this.sMW != null) {
            this.getSystemEvents().deleteObserver(this.sMW);
            this.sMW.setVisible(false);
        }
    }

    public SystemEvents getSystemEvents() {
        return this.systemEvents;
    }

    public void setCurValLoc(int n) {
        this.currentValueLocation = n;
    }

    public int getCurValLoc() {
        return this.currentValueLocation;
    }

    public void addDefaultToVectors() {
        this.maxMeanInclusiveValueList.add(new Double(0.0));
        this.maxMeanExclusiveValueList.add(new Double(0.0));
        this.maxMeanInclusivePercentValueList.add(new Double(0.0));
        this.maxMeanExclusivePercentValueList.add(new Double(0.0));
        this.maxMeanUserSecPerCallList.add(new Double(0.0));
        this.totalMeanInclusiveValueList.add(new Double(0.0));
        this.totalMeanExclusiveValueList.add(new Double(0.0));
    }

    void initializeGlobalMapping(int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            this.globalMapping.addGlobalMapping(null, n2);
            ++n3;
        }
    }

    GlobalMapping getGlobalMapping() {
        return this.globalMapping;
    }

    public String getCounterName() {
        Value value = (Value)this.values.elementAt(this.currentValueLocation);
        return value.getValueName();
    }

    public boolean isTimeMetric() {
        String string = this.getCounterName();
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public void buildStaticData(File file) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            GlobalContext globalContext;
            Vector vector;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            System.out.println("Processing data file, please wait ......");
            long l = System.currentTimeMillis();
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            int n = -1;
            double d = -1.0;
            double d2 = -1.0;
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            GlobalServer globalServer = null;
            GlobalContext globalContext2 = null;
            GlobalThread globalThread = null;
            Object var26_21 = null;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = 0;
            this.bSDCounter = 0;
            boolean bl = false;
            int n9 = 0;
            string = bufferedReader.readLine();
            if (string == null) {
                return;
            }
            ++this.bSDCounter;
            string = bufferedReader.readLine();
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            String string6 = stringTokenizer.nextToken();
            if (this.firstRun) {
                this.numberOfMappings = Integer.parseInt(string6);
            } else if (this.numberOfMappings != Integer.parseInt(string6)) {
                System.out.println("***********************");
                System.out.println("The number of mappings does not match!!!");
                System.out.println("");
                System.out.println("To add to an existing run, you must be choosing from");
                System.out.println("a list of multiple metrics from that same run!!!");
                System.out.println("***********************");
                return;
            }
            if (this.firstRun) {
                this.initializeGlobalMapping(Integer.parseInt(string6), 0);
            }
            this.counterName = this.getCounterName(string);
            this.addDefaultToVectors();
            if (!this.firstRun) {
                if (ParaProf.debugIsOn) {
                    System.out.println("Increasing the storage for the new counter.");
                }
                object8 = this.globalMapping.getMapping(0).elements();
                while (object8.hasMoreElements()) {
                    object7 = (GlobalMappingElement)object8.nextElement();
                    ((GlobalMappingElement)object7).incrementStorage();
                }
                object7 = this.globalMapping.getMapping(2).elements();
                while (object7.hasMoreElements()) {
                    object6 = (GlobalMappingElement)object7.nextElement();
                    ((GlobalMappingElement)object6).incrementStorage();
                }
                object5 = this.getNodes();
                Enumeration enumeration = ((Vector)object5).elements();
                while (enumeration.hasMoreElements()) {
                    object6 = (GlobalServer)enumeration.nextElement();
                    vector = ((GlobalServer)object6).getContextList();
                    Enumeration enumeration2 = vector.elements();
                    while (enumeration2.hasMoreElements()) {
                        globalContext = (GlobalContext)enumeration2.nextElement();
                        object4 = globalContext.getThreadList();
                        Enumeration enumeration3 = ((Vector)object4).elements();
                        while (enumeration3.hasMoreElements()) {
                            object3 = (GlobalThread)enumeration3.nextElement();
                            ((GlobalThread)object3).incrementStorage();
                            object2 = ((GlobalThread)object3).getThreadDataList();
                            Enumeration enumeration4 = ((Vector)object2).elements();
                            while (enumeration4.hasMoreElements()) {
                                object = (GlobalThreadDataElement)enumeration4.nextElement();
                                if (object == null) continue;
                                ((GlobalThreadDataElement)object).incrementStorage();
                            }
                        }
                    }
                }
                if (ParaProf.debugIsOn) {
                    System.out.println("Done increasing the storage for the new counter.");
                }
            }
            if (this.counterName == null) {
                this.counterName = new String("Wallclock Time");
            }
            System.out.println("Counter name is: " + this.counterName);
            object8 = this.addValue();
            ((Value)object8).setValueName(this.counterName);
            this.setCurValLoc(((Value)object8).getValueID());
            System.out.println("The number of mappings in the system is: " + string6);
            ++this.bSDCounter;
            string = bufferedReader.readLine();
            if (string == null) {
                return;
            }
            ++this.bSDCounter;
            while ((string = bufferedReader.readLine()) != null) {
                GlobalMappingElement globalMappingElement;
                if (this.bSDCounter % 10000 == 0) {
                    Thread.yield();
                }
                stringTokenizer = new StringTokenizer(string, " \t\n\r");
                if (string.charAt(0) == 't') {
                    ++n8;
                    n = this.getMappingID(string);
                    d = this.getValue(string);
                    if (this.checkForExcInc(string, true, false)) {
                        string4 = this.getMappingName(string);
                        n = this.getMappingID(string);
                        if (n > n9) {
                            n9 = n;
                        }
                        if (this.firstRun && (string5 = this.getGroupNames(string)) != null) {
                            object7 = new StringTokenizer(string5, " |");
                            while (((StringTokenizer)object7).hasMoreTokens()) {
                                object6 = ((StringTokenizer)object7).nextToken();
                                if (object6 == null) continue;
                                int n10 = this.globalMapping.addGlobalMapping((String)object6, 1);
                                this.globalMapping.addGroup(n, n10, 0);
                                if (n10 == -1 || !ParaProf.debugIsOn) continue;
                                System.out.println("Adding " + (String)object6 + " group with id: " + n10 + " to mapping: " + string4);
                            }
                        }
                        if (this.firstRun && !this.globalMapping.setMappingNameAt(string4, n, 0)) {
                            System.out.println("There was an error adding mapping to the global mapping");
                        }
                        if (!this.globalMapping.setTotalExclusiveValueAt(this.currentValueLocation, d, n, 0)) {
                            System.out.println("There was an error setting Exc/Inc total time");
                        }
                    } else if (!this.globalMapping.setTotalInclusiveValueAt(this.currentValueLocation, d, n, 0)) {
                        System.out.println("There was an error setting Exc/Inc total time");
                    }
                } else if (string.charAt(0) == 'm') {
                    n = this.getMappingID(string);
                    d = this.getValue(string);
                    d2 = this.getPercentValue(string);
                    globalMappingElement = this.globalMapping.getGlobalMappingElement(n, 0);
                    if (this.checkForExcInc(string, true, false)) {
                        if (this.getMaxMeanExclusiveValue(this.currentValueLocation) < d) {
                            this.setMaxMeanExclusiveValue(this.currentValueLocation, d);
                        }
                        if (this.getMaxMeanExclusivePercentValue(this.currentValueLocation) < d2) {
                            this.setMaxMeanExclusivePercentValue(this.currentValueLocation, d2);
                        }
                        globalMappingElement.setMeanExclusiveValue(this.currentValueLocation, d);
                        globalMappingElement.setMeanExclusivePercentValue(this.currentValueLocation, d2);
                    } else {
                        if (this.getMaxMeanInclusiveValue(this.currentValueLocation) < d) {
                            this.setMaxMeanInclusiveValue(this.currentValueLocation, d);
                        }
                        if (this.getMaxMeanInclusivePercentValue(this.currentValueLocation) < d2) {
                            this.setMaxMeanInclusivePercentValue(this.currentValueLocation, d2);
                        }
                        globalMappingElement.setMeanInclusiveValue(this.currentValueLocation, d);
                        globalMappingElement.setMeanInclusivePercentValue(this.currentValueLocation, d2);
                        string = bufferedReader.readLine();
                        this.setNumberOfCSUMean(string, globalMappingElement);
                        globalMappingElement.setMeanValuesSet(true);
                    }
                } else if (this.checkForExcInc(string, true, true)) {
                    n = this.getMappingID(string);
                    d = this.getValue(string);
                    d2 = this.getPercentValue(string);
                    globalMappingElement = this.globalMapping.getGlobalMappingElement(n, 0);
                    if (globalMappingElement.getMaxExclusiveValue(this.currentValueLocation) < d) {
                        globalMappingElement.setMaxExclusiveValue(this.currentValueLocation, d);
                    }
                    if (globalMappingElement.getMaxExclusivePercentValue(this.currentValueLocation) < d2) {
                        globalMappingElement.setMaxExclusivePercentValue(this.currentValueLocation, d2);
                    }
                    n2 = this.getNCT(0, string, false);
                    n3 = this.getNCT(1, string, false);
                    n4 = this.getNCT(2, string, false);
                    if (this.firstRun) {
                        if (n5 != n2) {
                            n6 = -1;
                            n7 = -1;
                        }
                        if (n6 != n3) {
                            n7 = -1;
                        }
                        if (n7 != n4) {
                            if (n4 == 0) {
                                globalThread = new GlobalThread();
                                ++this.totalNumberOfThreads;
                                globalThread.initializeThreadDataList(this.numberOfMappings);
                                n7 = n4;
                                object7 = globalThread.getThreadDataList();
                                object6 = null;
                                object6 = (GlobalThreadDataElement)((Vector)object7).elementAt(n);
                                if (object6 == null) {
                                    object6 = new GlobalThreadDataElement(this, false);
                                    ((GlobalThreadDataElement)object6).setMappingID(n);
                                    globalThread.addThreadDataElement((GlobalThreadDataElement)object6, n);
                                }
                                ((GlobalThreadDataElement)object6).setMappingExists();
                                ((GlobalThreadDataElement)object6).setExclusiveValue(this.currentValueLocation, d);
                                ((GlobalThreadDataElement)object6).setExclusivePercentValue(this.currentValueLocation, d2);
                                if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d) {
                                    globalThread.setMaxExclusiveValue(this.currentValueLocation, d);
                                }
                                if (globalThread.getMaxExclusivePercentValue(this.currentValueLocation) < d) {
                                    globalThread.setMaxExclusivePercentValue(this.currentValueLocation, d2);
                                }
                                if (n3 == 0) {
                                    globalContext2 = new GlobalContext();
                                    globalContext2.addThread(globalThread);
                                    globalServer = new GlobalServer();
                                    globalServer.addContext(globalContext2);
                                    this.nodes.addElement(globalServer);
                                    n6 = n3;
                                    n5 = n2;
                                } else {
                                    globalContext2 = new GlobalContext();
                                    globalContext2.addThread(globalThread);
                                    globalServer.addContext(globalContext2);
                                    n6 = n3;
                                }
                            } else {
                                globalThread = new GlobalThread();
                                ++this.totalNumberOfThreads;
                                globalThread.initializeThreadDataList(this.numberOfMappings);
                                n7 = n4;
                                object7 = globalThread.getThreadDataList();
                                object6 = null;
                                object6 = (GlobalThreadDataElement)((Vector)object7).elementAt(n);
                                if (object6 == null) {
                                    object6 = new GlobalThreadDataElement(this, false);
                                    ((GlobalThreadDataElement)object6).setMappingID(n);
                                    globalThread.addThreadDataElement((GlobalThreadDataElement)object6, n);
                                }
                                ((GlobalThreadDataElement)object6).setMappingExists();
                                ((GlobalThreadDataElement)object6).setExclusiveValue(this.currentValueLocation, d);
                                ((GlobalThreadDataElement)object6).setExclusivePercentValue(this.currentValueLocation, d2);
                                if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d) {
                                    globalThread.setMaxExclusiveValue(this.currentValueLocation, d);
                                }
                                if (globalThread.getMaxExclusivePercentValue(this.currentValueLocation) < d) {
                                    globalThread.setMaxExclusivePercentValue(this.currentValueLocation, d2);
                                }
                                globalContext2.addThread(globalThread);
                            }
                        } else {
                            object7 = globalThread.getThreadDataList();
                            object6 = null;
                            object6 = (GlobalThreadDataElement)((Vector)object7).elementAt(n);
                            if (object6 == null) {
                                object6 = new GlobalThreadDataElement(this, false);
                                ((GlobalThreadDataElement)object6).setMappingID(n);
                                globalThread.addThreadDataElement((GlobalThreadDataElement)object6, n);
                            }
                            ((GlobalThreadDataElement)object6).setMappingExists();
                            ((GlobalThreadDataElement)object6).setExclusiveValue(this.currentValueLocation, d);
                            ((GlobalThreadDataElement)object6).setExclusivePercentValue(this.currentValueLocation, d2);
                            if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d) {
                                globalThread.setMaxExclusiveValue(this.currentValueLocation, d);
                            }
                            if (globalThread.getMaxExclusivePercentValue(this.currentValueLocation) < d2) {
                                globalThread.setMaxExclusivePercentValue(this.currentValueLocation, d2);
                            }
                        }
                    } else {
                        object7 = (GlobalServer)this.nodes.elementAt(n2);
                        object6 = ((GlobalServer)object7).getContextList();
                        globalContext = (GlobalContext)((Vector)object6).elementAt(n3);
                        object3 = globalContext.getThreadList();
                        object = (GlobalThread)((Vector)object3).elementAt(n4);
                        vector = ((GlobalThread)object).getThreadDataList();
                        object4 = (GlobalThreadDataElement)vector.elementAt(n);
                        ((GlobalThreadDataElement)object4).setExclusiveValue(this.currentValueLocation, d);
                        ((GlobalThreadDataElement)object4).setExclusivePercentValue(this.currentValueLocation, d2);
                        if (((GlobalThread)object).getMaxExclusiveValue(this.currentValueLocation) < d) {
                            ((GlobalThread)object).setMaxExclusiveValue(this.currentValueLocation, d);
                        }
                        if (((GlobalThread)object).getMaxExclusivePercentValue(this.currentValueLocation) < d2) {
                            ((GlobalThread)object).setMaxExclusivePercentValue(this.currentValueLocation, d2);
                        }
                    }
                } else if (this.checkForExcInc(string, false, true)) {
                    n = this.getMappingID(string);
                    d = this.getValue(string);
                    d2 = this.getPercentValue(string);
                    globalMappingElement = this.globalMapping.getGlobalMappingElement(n, 0);
                    if (globalMappingElement.getMaxInclusiveValue(this.currentValueLocation) < d) {
                        globalMappingElement.setMaxInclusiveValue(this.currentValueLocation, d);
                    }
                    if (globalMappingElement.getMaxInclusivePercentValue(this.currentValueLocation) < d2) {
                        globalMappingElement.setMaxInclusivePercentValue(this.currentValueLocation, d2);
                    }
                    n2 = this.getNCT(0, string, false);
                    n3 = this.getNCT(1, string, false);
                    n4 = this.getNCT(2, string, false);
                    object7 = (GlobalServer)this.nodes.elementAt(n2);
                    object6 = ((GlobalServer)object7).getContextList();
                    globalContext = (GlobalContext)((Vector)object6).elementAt(n3);
                    object3 = globalContext.getThreadList();
                    object = (GlobalThread)((Vector)object3).elementAt(n4);
                    vector = ((GlobalThread)object).getThreadDataList();
                    object4 = (GlobalThreadDataElement)vector.elementAt(n);
                    if (object4 == null) {
                        System.out.println("Don't think I ever get here.  Check the logic to make sure.");
                        object4 = new GlobalThreadDataElement(this, false);
                        ((GlobalThreadDataElement)object4).setMappingID(n);
                        globalThread.addThreadDataElement((GlobalThreadDataElement)object4, n);
                    }
                    ((GlobalThreadDataElement)object4).setInclusiveValue(this.currentValueLocation, d);
                    ((GlobalThreadDataElement)object4).setInclusivePercentValue(this.currentValueLocation, d2);
                    if (((GlobalThread)object).getMaxInclusiveValue(this.currentValueLocation) < d) {
                        ((GlobalThread)object).setMaxInclusiveValue(this.currentValueLocation, d);
                    }
                    if (((GlobalThread)object).getMaxInclusivePercentValue(this.currentValueLocation) < d2) {
                        ((GlobalThread)object).setMaxInclusivePercentValue(this.currentValueLocation, d2);
                    }
                    string = bufferedReader.readLine();
                    this.setNumberOfCSU(string, globalMappingElement, (GlobalThread)object, (GlobalThreadDataElement)object4);
                } else if (this.noue(string) && this.firstRun) {
                    if (!this.userEventsPresent()) {
                        this.numberOfUserEvents = this.getNumberOfUserEvents(string);
                        this.initializeGlobalMapping(this.numberOfUserEvents, 2);
                        if (ParaProf.debugIsOn) {
                            System.out.println("The number of user events defined is: " + this.numberOfUserEvents);
                            System.out.println("Initializing mapping selection 2 (The loaction of the user event mapping) for " + this.numberOfUserEvents + " mappings.");
                        }
                    }
                    string = bufferedReader.readLine();
                    object7 = null;
                    object6 = null;
                    globalContext = null;
                    object3 = null;
                    object = null;
                    vector = null;
                    int n11 = 0;
                    while (n11 < this.numberOfUserEvents) {
                        string2 = bufferedReader.readLine();
                        string3 = bufferedReader.readLine();
                        object2 = this.getData(string2, string3, this.userEventsPresent);
                        if (n11 == 0) {
                            object7 = (GlobalServer)this.nodes.elementAt(((UserEventData)object2).node);
                            object6 = ((GlobalServer)object7).getContextList();
                            globalContext = (GlobalContext)((Vector)object6).elementAt(((UserEventData)object2).context);
                            object3 = globalContext.getThreadList();
                            object = (GlobalThread)((Vector)object3).elementAt(((UserEventData)object2).thread);
                            if (this.firstRun) {
                                ((GlobalThread)object).initializeUserThreadDataList(this.numberOfUserEvents);
                            }
                            vector = ((GlobalThread)object).getUserThreadDataList();
                        }
                        if (!this.userEventsPresent() && !this.globalMapping.setMappingNameAt(((UserEventData)object2).name, ((UserEventData)object2).id, 2)) {
                            System.out.println("There was an error adding mapping to the global mapping");
                        }
                        if (((UserEventData)object2).noc != 0) {
                            globalMappingElement = this.globalMapping.getGlobalMappingElement(((UserEventData)object2).id, 2);
                            if (globalMappingElement.getMaxUserEventNumberValue() < ((UserEventData)object2).noc) {
                                globalMappingElement.setMaxUserEventNumberValue(((UserEventData)object2).noc);
                            }
                            if (globalMappingElement.getMaxUserEventMinValue() < ((UserEventData)object2).min) {
                                globalMappingElement.setMaxUserEventMinValue(((UserEventData)object2).min);
                            }
                            if (globalMappingElement.getMaxUserEventMaxValue() < ((UserEventData)object2).max) {
                                globalMappingElement.setMaxUserEventMaxValue(((UserEventData)object2).max);
                            }
                            if (globalMappingElement.getMaxUserEventMeanValue() < ((UserEventData)object2).mean) {
                                globalMappingElement.setMaxUserEventMeanValue(((UserEventData)object2).mean);
                            }
                            object5 = (GlobalThreadDataElement)vector.elementAt(((UserEventData)object2).id);
                            object5 = new GlobalThreadDataElement(this, true);
                            ((GlobalThreadDataElement)object5).setUserEventID(((UserEventData)object2).id);
                            ((GlobalThreadDataElement)object5).setUserEventNumberValue(((UserEventData)object2).noc);
                            ((GlobalThreadDataElement)object5).setUserEventMinValue(((UserEventData)object2).min);
                            ((GlobalThreadDataElement)object5).setUserEventMaxValue(((UserEventData)object2).max);
                            ((GlobalThreadDataElement)object5).setUserEventMeanValue(((UserEventData)object2).mean);
                            ((GlobalThread)object).addUserThreadDataElement((GlobalThreadDataElement)object5, ((UserEventData)object2).id);
                        }
                        ++n11;
                    }
                    this.setUserEventsPresent(true);
                }
                ++this.bSDCounter;
            }
            bufferedReader.close();
            if (ParaProf.debugIsOn) {
                System.out.println("The total number of threads is: " + this.getTotalNumberOfThreads());
                System.out.println("The number of mappings is: " + this.getNumberOfMappings());
                System.out.println("The number of user events is: " + this.getNumberOfUserEvents());
            }
            System.out.println("Processing callpath data ...");
            if (CallPathUtilFuncs.isAvailable(this.getGlobalMapping().getMappingIterator(0))) {
                this.setCallPathDataPresent(true);
                CallPathUtilFuncs.buildRelations(this.getGlobalMapping());
            } else {
                System.out.println("No callpath data found.");
            }
            System.out.println("Done - Processing callpath data!");
            this.firstRun = false;
            l = System.currentTimeMillis() - l;
            System.out.println("Done processing data file, please wait ......");
            System.out.println("Time to process file (in milliseconds): " + l);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD01");
        }
    }

    public boolean noue(String string) {
        int n = 0;
        char c = string.charAt(n);
        while (c != ' ') {
            c = string.charAt(++n);
        }
        return (c = string.charAt(++n)) == 'u';
    }

    public UserEventData getData(String string, String string2, boolean bl) {
        UserEventData userEventData = new UserEventData();
        try {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n = 44;
            int n2 = 10;
            int n3 = 0;
            int n4 = 9;
            int n5 = 0;
            int n6 = n3;
            while (n6 < 9) {
                if (n6 == 2) {
                    n = 32;
                } else if (n6 == 4) {
                    if (bl) {
                        ++n2;
                        n = 34;
                        while (cArray[n2] != n) {
                            ++n2;
                        }
                        ++n2;
                        n6 = 5;
                        n = 32;
                        ++n2;
                    } else {
                        n = 34;
                        ++n2;
                    }
                } else if (n6 == 5) {
                    n = 32;
                    ++n2;
                }
                while (cArray[n2] != n) {
                    cArray2[n5] = cArray[n2];
                    ++n2;
                    ++n5;
                }
                switch (n6) {
                    case 0: {
                        userEventData.node = Integer.parseInt(new String(cArray2, 0, n5));
                        break;
                    }
                    case 1: {
                        userEventData.context = Integer.parseInt(new String(cArray2, 0, n5));
                        break;
                    }
                    case 2: {
                        userEventData.thread = Integer.parseInt(new String(cArray2, 0, n5));
                        break;
                    }
                    case 3: {
                        userEventData.id = Integer.parseInt(new String(cArray2, 0, n5));
                        break;
                    }
                    case 4: {
                        if (this.userEventsPresent) break;
                        userEventData.name = new String(cArray2, 0, n5);
                        break;
                    }
                    case 5: {
                        userEventData.noc = (int)Double.parseDouble(new String(cArray2, 0, n5));
                        break;
                    }
                    case 6: {
                        userEventData.max = Double.parseDouble(new String(cArray2, 0, n5));
                        break;
                    }
                    case 7: {
                        userEventData.min = Double.parseDouble(new String(cArray2, 0, n5));
                        break;
                    }
                    case 8: {
                        userEventData.mean = Double.parseDouble(new String(cArray2, 0, n5));
                        break;
                    }
                    default: {
                        throw new UnexpectedStateException(String.valueOf(n6));
                    }
                }
                n5 = 0;
                ++n2;
                ++n6;
            }
            int n7 = cArray.length;
            while (n2 < n7) {
                cArray2[n5] = cArray[n2];
                ++n2;
                ++n5;
            }
            userEventData.std = Double.parseDouble(new String(cArray2, 0, n5));
        }
        catch (Exception exception) {
            System.out.println("An error occured!");
            exception.printStackTrace();
        }
        return userEventData;
    }

    String getMappingName(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            return string2;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD08");
            return null;
        }
    }

    int getMappingID(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD09");
            return -1;
        }
    }

    boolean checkForExcInc(String string, boolean bl, boolean bl2) {
        boolean bl3;
        block5: {
            bl3 = false;
            try {
                StringTokenizer stringTokenizer;
                String string2;
                if (bl2 && (string2 = (stringTokenizer = new StringTokenizer(string, " ")).nextToken()).indexOf(",") == -1) {
                    return bl3;
                }
                stringTokenizer = new StringTokenizer(string, "\"");
                string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\n\r");
                string2 = stringTokenizer2.nextToken();
                if (bl) {
                    if (!string2.equals("excl")) break block5;
                    bl3 = true;
                    break block5;
                }
                if (string2.equals("incl")) {
                    bl3 = true;
                }
            }
            catch (Exception exception) {
                ParaProf.systemError(exception, null, "SSD04");
            }
        }
        return bl3;
    }

    private void setNumberOfCSU(String string, GlobalMappingElement globalMappingElement, GlobalThread globalThread, GlobalThreadDataElement globalThreadDataElement) {
        try {
            String string2 = null;
            double d = -1.0;
            int n = -1;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            n = (int)d;
            if (globalMappingElement.getMaxNumberOfCalls() < n) {
                globalMappingElement.setMaxNumberOfCalls(n);
            }
            if (globalThread.getMaxNumberOfCalls() < n) {
                globalThread.setMaxNumberOfCalls(n);
            }
            globalThreadDataElement.setNumberOfCalls(n);
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            n = (int)d;
            if (globalMappingElement.getMaxNumberOfSubRoutines() < n) {
                globalMappingElement.setMaxNumberOfSubRoutines(n);
            }
            if (globalThread.getMaxNumberOfSubRoutines() < n) {
                globalThread.setMaxNumberOfSubRoutines(n);
            }
            globalThreadDataElement.setNumberOfSubRoutines(n);
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            if (globalMappingElement.getMaxUserSecPerCall(this.currentValueLocation) < d) {
                globalMappingElement.setMaxUserSecPerCall(this.currentValueLocation, d);
            }
            if (globalThread.getMaxUserSecPerCall(this.currentValueLocation) < d) {
                globalThread.setMaxUserSecPerCall(this.currentValueLocation, d);
            }
            globalThreadDataElement.setUserSecPerCall(this.currentValueLocation, d);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD10");
        }
    }

    private void setNumberOfCSUMean(String string, GlobalMappingElement globalMappingElement) {
        try {
            String string2 = null;
            double d = -1.0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            if (this.getMaxMeanNumberOfCalls() < d) {
                this.setMaxMeanNumberOfCalls(d);
            }
            globalMappingElement.setMeanNumberOfCalls(d);
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            if (this.getMaxMeanNumberOfSubRoutines() < d) {
                this.setMaxMeanNumberOfSubRoutines(d);
            }
            globalMappingElement.setMeanNumberOfSubRoutines(d);
            string2 = stringTokenizer.nextToken();
            d = Double.parseDouble(string2);
            if (this.getMaxMeanUserSecPerCall(this.currentValueLocation) < d) {
                this.setMaxMeanUserSecPerCall(this.currentValueLocation, d);
            }
            globalMappingElement.setMeanUserSecPerCall(this.currentValueLocation, d);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD10");
        }
    }

    String getGroupNames(String string) {
        try {
            String string2 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (!this.groupNamesCheck) {
                int n = string2.indexOf("GROUP=");
                if (n > 0) {
                    this.groupNamesPresent = true;
                }
                this.groupNamesCheck = true;
            }
            if (this.groupNamesPresent) {
                string2 = stringTokenizer.nextToken();
                return string2;
            }
            return null;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD12");
            return null;
        }
    }

    double getValue(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\n\r");
            string2 = stringTokenizer2.nextToken();
            string2 = stringTokenizer2.nextToken();
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD13");
            return -1.0;
        }
    }

    double getPercentValue(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\"");
            String string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\n\r");
            string2 = stringTokenizer2.nextToken();
            string2 = stringTokenizer2.nextToken();
            string2 = stringTokenizer2.nextToken();
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD14");
            return -1.0;
        }
    }

    int getNumberOfUserEvents(String string) {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r");
            String string2 = stringTokenizer.nextToken();
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD16");
            return -1;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int getNCT(int var1_1, String var2_2, boolean var3_3) {
        var4_4 = -1;
        var5_5 = 32;
        try {
            var6_6 = ' ';
            var7_8 = new StringBuffer();
            var8_9 = 0;
            if (var3_3) {
                var8_9 = 10;
            }
            if (var1_1 != 2) {
                var5_5 = 44;
            }
            var9_10 = 0;
            ** GOTO lbl19
            {
                var6_6 = var2_2.charAt(var8_9);
                ++var8_9;
                do {
                    if (var6_6 != 44) continue block2;
                    var6_6 = ' ';
                    ++var9_10;
lbl19:
                    // 2 sources

                } while (var9_10 < var1_1);
            }
            var6_6 = var2_2.charAt(var8_9);
            while (var6_6 != var5_5) {
                var7_8.append(var6_6);
                var6_6 = var2_2.charAt(++var8_9);
            }
            var4_4 = Integer.parseInt(var7_8.toString());
        }
        catch (Exception var6_7) {
            ParaProf.systemError(var6_7, null, "SSD23");
        }
        return var4_4;
    }

    String getCounterName(String string) {
        try {
            String string2 = null;
            int n = string.indexOf("_MULTI_");
            if (n > 0) {
                string2 = string.substring(n + 7);
                return string2;
            }
            return string2;
        }
        catch (Exception exception) {
            ParaProf.systemError(exception, null, "SSD26");
            return null;
        }
    }

    public Value applyOperation(String string, String string2, String string3) {
        Object object;
        Enumeration enumeration;
        Serializable serializable;
        Object object2;
        int n = this.getValuePosition(string);
        int n2 = this.getValuePosition(string2);
        String string4 = null;
        int n3 = -1;
        if (string3.equals("Add")) {
            n3 = 0;
            string4 = string + " + " + string2;
        } else if (string3.equals("Subtract")) {
            n3 = 1;
            string4 = string + " - " + string2;
        } else if (string3.equals("Multiply")) {
            n3 = 2;
            string4 = string + " * " + string2;
        } else if (string3.equals("Divide")) {
            n3 = 3;
            string4 = string + " / " + string2;
        } else {
            System.out.println("Wrong operation type");
        }
        Value value = this.addValue();
        value.setValueName(string4);
        this.setCurValLoc(value.getValueID());
        Enumeration enumeration2 = this.globalMapping.getMapping(0).elements();
        while (enumeration2.hasMoreElements()) {
            object2 = (GlobalMappingElement)enumeration2.nextElement();
            ((GlobalMappingElement)object2).incrementStorage();
            ((GlobalMappingElement)object2).setTotalExclusiveValue(0.0);
            ((GlobalMappingElement)object2).setTotalInclusiveValue(0.0);
            ((GlobalMappingElement)object2).setCounter(0);
        }
        object2 = this.globalMapping.getMapping(2).elements();
        while (object2.hasMoreElements()) {
            serializable = (GlobalMappingElement)object2.nextElement();
            ((GlobalMappingElement)serializable).incrementStorage();
        }
        this.addDefaultToVectors();
        Vector vector = this.getNodes();
        Enumeration enumeration3 = vector.elements();
        while (enumeration3.hasMoreElements()) {
            serializable = (GlobalServer)enumeration3.nextElement();
            Vector vector2 = ((GlobalServer)serializable).getContextList();
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                GlobalContext globalContext = (GlobalContext)enumeration.nextElement();
                Vector vector3 = globalContext.getThreadList();
                object = vector3.elements();
                while (object.hasMoreElements()) {
                    GlobalThreadDataElement globalThreadDataElement;
                    GlobalThread globalThread = (GlobalThread)object.nextElement();
                    globalThread.incrementStorage();
                    Vector vector4 = globalThread.getThreadDataList();
                    Enumeration enumeration4 = vector4.elements();
                    while (enumeration4.hasMoreElements()) {
                        globalThreadDataElement = (GlobalThreadDataElement)enumeration4.nextElement();
                        if (globalThreadDataElement == null) continue;
                        int n4 = globalThreadDataElement.getMappingID();
                        GlobalMappingElement globalMappingElement = this.globalMapping.getGlobalMappingElement(n4, 0);
                        globalMappingElement.incrementCounter();
                        globalThreadDataElement.incrementStorage();
                        double d = 0.0;
                        double d2 = 0.0;
                        double d3 = 0.0;
                        switch (n3) {
                            case 0: {
                                d = globalThreadDataElement.getExclusiveValue(n);
                                d2 = globalThreadDataElement.getExclusiveValue(n2);
                                d3 = d + d2;
                                globalThreadDataElement.setExclusiveValue(this.currentValueLocation, d3);
                                if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                    globalThread.setMaxExclusiveValue(this.currentValueLocation, d3);
                                }
                                globalThread.incrementTotalExclusiveValue(d3);
                                if (globalMappingElement.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                    globalMappingElement.setMaxExclusiveValue(this.currentValueLocation, d3);
                                }
                                globalMappingElement.incrementTotalExclusiveValue(d3);
                                d = globalThreadDataElement.getInclusiveValue(n);
                                d2 = globalThreadDataElement.getInclusiveValue(n2);
                                d3 = d + d2;
                                globalThreadDataElement.setInclusiveValue(this.currentValueLocation, d3);
                                if (globalThread.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalThread.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalThread.incrementTotalInclusiveValue(d3);
                                if (globalMappingElement.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalMappingElement.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalMappingElement.incrementTotalInclusiveValue(d3);
                                break;
                            }
                            case 1: {
                                d = globalThreadDataElement.getExclusiveValue(n);
                                d2 = globalThreadDataElement.getExclusiveValue(n2);
                                if (d > d2) {
                                    d3 = d - d2;
                                    globalThreadDataElement.setExclusiveValue(this.currentValueLocation, d3);
                                    if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                        globalThread.setMaxExclusiveValue(this.currentValueLocation, d3);
                                    }
                                    globalThread.incrementTotalExclusiveValue(d3);
                                    if (globalMappingElement.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                        globalMappingElement.setMaxExclusiveValue(this.currentValueLocation, d3);
                                    }
                                    globalMappingElement.incrementTotalExclusiveValue(d3);
                                }
                                if (!((d = globalThreadDataElement.getInclusiveValue(n)) > (d2 = globalThreadDataElement.getInclusiveValue(n2)))) break;
                                d3 = d - d2;
                                globalThreadDataElement.setInclusiveValue(this.currentValueLocation, d3);
                                if (globalThread.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalThread.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalThread.incrementTotalInclusiveValue(d3);
                                if (globalMappingElement.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalMappingElement.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalMappingElement.incrementTotalInclusiveValue(d3);
                                break;
                            }
                            case 2: {
                                d = globalThreadDataElement.getExclusiveValue(n);
                                d2 = globalThreadDataElement.getExclusiveValue(n2);
                                d3 = d * d2;
                                globalThreadDataElement.setExclusiveValue(this.currentValueLocation, d3);
                                if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                    globalThread.setMaxExclusiveValue(this.currentValueLocation, d3);
                                }
                                globalThread.incrementTotalExclusiveValue(d3);
                                if (globalMappingElement.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                    globalMappingElement.setMaxExclusiveValue(this.currentValueLocation, d3);
                                }
                                globalMappingElement.incrementTotalExclusiveValue(d3);
                                d = globalThreadDataElement.getInclusiveValue(n);
                                d2 = globalThreadDataElement.getInclusiveValue(n2);
                                d3 = d * d2;
                                globalThreadDataElement.setInclusiveValue(this.currentValueLocation, d3);
                                if (globalThread.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalThread.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalThread.incrementTotalInclusiveValue(d3);
                                if (globalMappingElement.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalMappingElement.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalMappingElement.incrementTotalInclusiveValue(d3);
                                break;
                            }
                            case 3: {
                                d = globalThreadDataElement.getExclusiveValue(n);
                                d2 = globalThreadDataElement.getExclusiveValue(n2);
                                if (d2 != 0.0) {
                                    d3 = d / d2;
                                    globalThreadDataElement.setExclusiveValue(this.currentValueLocation, d3);
                                    if (globalThread.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                        globalThread.setMaxExclusiveValue(this.currentValueLocation, d3);
                                    }
                                    globalThread.incrementTotalExclusiveValue(d3);
                                    if (globalMappingElement.getMaxExclusiveValue(this.currentValueLocation) < d3) {
                                        globalMappingElement.setMaxExclusiveValue(this.currentValueLocation, d3);
                                    }
                                    globalMappingElement.incrementTotalExclusiveValue(d3);
                                }
                                d = globalThreadDataElement.getInclusiveValue(n);
                                d2 = globalThreadDataElement.getInclusiveValue(n2);
                                if (d2 == 0.0) break;
                                d3 = d / d2;
                                globalThreadDataElement.setInclusiveValue(this.currentValueLocation, d3);
                                if (globalThread.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalThread.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalThread.incrementTotalInclusiveValue(d3);
                                if (globalMappingElement.getMaxInclusiveValue(this.currentValueLocation) < d3) {
                                    globalMappingElement.setMaxInclusiveValue(this.currentValueLocation, d3);
                                }
                                globalMappingElement.incrementTotalInclusiveValue(d3);
                                break;
                            }
                        }
                    }
                    Enumeration enumeration5 = vector4.elements();
                    while (enumeration5.hasMoreElements()) {
                        double d;
                        globalThreadDataElement = (GlobalThreadDataElement)enumeration5.nextElement();
                        double d4 = globalThread.getTotalExclusiveValue();
                        double d5 = globalThread.getMaxInclusiveValue(this.currentValueLocation);
                        boolean bl = false;
                        boolean bl2 = false;
                        if (d4 != 0.0) {
                            bl = true;
                        }
                        if (d5 != 0.0) {
                            bl2 = true;
                        }
                        if (globalThreadDataElement == null) continue;
                        int n5 = globalThreadDataElement.getMappingID();
                        GlobalMappingElement globalMappingElement = this.globalMapping.getGlobalMappingElement(n5, 0);
                        double d6 = globalThreadDataElement.getExclusiveValue(this.currentValueLocation);
                        double d7 = globalThreadDataElement.getInclusiveValue(this.currentValueLocation);
                        if (bl) {
                            d = d6 / d4 * 100.0;
                            globalThreadDataElement.setExclusivePercentValue(this.currentValueLocation, d);
                            if (globalThread.getMaxExclusivePercentValue(this.currentValueLocation) < d) {
                                globalThread.setMaxExclusivePercentValue(this.currentValueLocation, d);
                            }
                            if (globalMappingElement.getMaxExclusivePercentValue(this.currentValueLocation) < d) {
                                globalMappingElement.setMaxExclusivePercentValue(this.currentValueLocation, d);
                            }
                        }
                        if (!bl2) continue;
                        d = d7 / d5 * 100.0;
                        globalThreadDataElement.setInclusivePercentValue(this.currentValueLocation, d);
                        if (globalThread.getMaxInclusivePercentValue(this.currentValueLocation) < d) {
                            globalThread.setMaxInclusivePercentValue(this.currentValueLocation, d);
                        }
                        if (!(globalMappingElement.getMaxInclusivePercentValue(this.currentValueLocation) < d)) continue;
                        globalMappingElement.setMaxInclusivePercentValue(this.currentValueLocation, d);
                    }
                }
            }
        }
        enumeration = this.globalMapping.getMapping(0).elements();
        while (enumeration.hasMoreElements()) {
            object = (GlobalMappingElement)enumeration.nextElement();
            if (((GlobalMappingElement)object).getCounter() == 0) continue;
            double d = ((GlobalMappingElement)object).getTotalExclusiveValue() / (double)((GlobalMappingElement)object).getCounter();
            this.setTotalMeanExclusiveValue(this.getCurValLoc(), this.getTotalMeanExclusiveValue(this.getCurValLoc()) + d);
            ((GlobalMappingElement)object).setMeanExclusiveValue(this.getCurValLoc(), d);
            if (this.getMaxMeanExclusiveValue(this.getCurValLoc()) < d) {
                this.setMaxMeanExclusiveValue(this.getCurValLoc(), d);
            }
            d = ((GlobalMappingElement)object).getTotalInclusiveValue() / (double)((GlobalMappingElement)object).getCounter();
            this.setTotalMeanInclusiveValue(this.getCurValLoc(), this.getTotalMeanInclusiveValue(this.getCurValLoc()) + d);
            ((GlobalMappingElement)object).setMeanInclusiveValue(this.getCurValLoc(), d);
            if (!(this.getMaxMeanInclusiveValue(this.getCurValLoc()) < d)) continue;
            this.setMaxMeanInclusiveValue(this.getCurValLoc(), d);
        }
        double d = this.getTotalMeanExclusiveValue(this.getCurValLoc());
        double d8 = this.getMaxMeanInclusiveValue(this.getCurValLoc());
        boolean bl = false;
        boolean bl3 = false;
        if (d != 0.0) {
            bl = true;
        }
        if (d8 != 0.0) {
            bl3 = true;
        }
        Enumeration enumeration6 = this.globalMapping.getMapping(0).elements();
        while (enumeration6.hasMoreElements()) {
            GlobalMappingElement globalMappingElement = (GlobalMappingElement)enumeration6.nextElement();
            if (bl) {
                double d9 = globalMappingElement.getMeanExclusiveValue(this.getCurValLoc()) / d * 100.0;
                globalMappingElement.setMeanExclusivePercentValue(this.currentValueLocation, d9);
                if (this.getMaxMeanExclusivePercentValue(this.getCurValLoc()) < d9) {
                    this.setMaxMeanExclusivePercentValue(this.getCurValLoc(), d9);
                }
            }
            if (!bl3) continue;
            double d10 = globalMappingElement.getMeanInclusiveValue(this.getCurValLoc()) / d8 * 100.0;
            globalMappingElement.setMeanInclusivePercentValue(this.getCurValLoc(), d10);
            if (!(this.getMaxMeanInclusivePercentValue(this.getCurValLoc()) < d10)) continue;
            this.setMaxMeanInclusivePercentValue(this.getCurValLoc(), d10);
        }
        return value;
    }

    public int getNumberOfMappings() {
        return this.numberOfMappings;
    }

    public int getNumberOfUserEvents() {
        return this.numberOfUserEvents;
    }

    public int getTotalNumberOfThreads() {
        return this.totalNumberOfThreads;
    }

    public void setMaxMeanInclusiveValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanInclusiveValueList.add(n, d2);
    }

    public double getMaxMeanInclusiveValue(int n) {
        Double d = (Double)this.maxMeanInclusiveValueList.elementAt(n);
        return d;
    }

    public void setMaxMeanExclusiveValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanExclusiveValueList.add(n, d2);
    }

    public double getMaxMeanExclusiveValue(int n) {
        Double d = (Double)this.maxMeanExclusiveValueList.elementAt(n);
        return d;
    }

    public void setMaxMeanInclusivePercentValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanInclusivePercentValueList.add(n, d2);
    }

    public double getMaxMeanInclusivePercentValue(int n) {
        Double d = (Double)this.maxMeanInclusivePercentValueList.elementAt(n);
        return d;
    }

    public void setMaxMeanExclusivePercentValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanExclusivePercentValueList.add(n, d2);
    }

    public double getMaxMeanExclusivePercentValue(int n) {
        Double d = (Double)this.maxMeanExclusivePercentValueList.elementAt(n);
        return d;
    }

    public void setMaxMeanNumberOfCalls(double d) {
        this.maxMeanNumberOfCalls = d;
    }

    public double getMaxMeanNumberOfCalls() {
        return this.maxMeanNumberOfCalls;
    }

    public void setMaxMeanNumberOfSubRoutines(double d) {
        this.maxMeanNumberOfSubRoutines = d;
    }

    public double getMaxMeanNumberOfSubRoutines() {
        return this.maxMeanNumberOfSubRoutines;
    }

    public void setMaxMeanUserSecPerCall(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanUserSecPerCallList.add(n, d2);
    }

    public double getMaxMeanUserSecPerCall(int n) {
        Double d = (Double)this.maxMeanUserSecPerCallList.elementAt(n);
        return d;
    }

    public void setTotalMeanInclusiveValue(int n, double d) {
        Double d2 = new Double(d);
        this.totalMeanInclusiveValueList.add(n, d2);
    }

    public double getTotalMeanInclusiveValue(int n) {
        Double d = (Double)this.totalMeanInclusiveValueList.elementAt(n);
        return d;
    }

    public void setTotalMeanExclusiveValue(int n, double d) {
        Double d2 = new Double(d);
        this.totalMeanExclusiveValueList.add(n, d2);
    }

    public double getTotalMeanExclusiveValue(int n) {
        Double d = (Double)this.totalMeanExclusiveValueList.elementAt(n);
        return d;
    }

    public boolean groupNamesPresent() {
        return this.groupNamesPresent;
    }

    private void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean userEventsPresent() {
        return this.userEventsPresent;
    }

    private void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean callPathDataPresent() {
        return this.callPathDataPresent;
    }
}

