/*
  Trial.java
  
  
  Title:      ParaProf
  Author:     Robert Bell
  Description:  This class is the heart of Racy's static data system.
  This class is rather an ongoing project.  Much work needs
  to be done with respect to data format.
  The use of tokenizers here could impact the performance
  with large data sets, but for now, this will be sufficient.
  The naming and creation of the tokenizers has been done mainly
  to improve the readability of the code.
          
  It must also be noted that the correct funtioning of this
  class is heavily dependent on the format of the pprof -d format.
  It is NOT resistant to change in that format at all.
*/

package paraprof;

import java.io.*;
import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;

public class Trial{ //extends Thread{
    //Constructor.
    public Trial(Experiment inParentExp){
	parentExperiment = inParentExp;
	globalMapping = new GlobalMapping(this);
	systemEvents = new SystemEvents();
	nodes = new Vector();
	counterName = null;
	isUserEventHeadingSet = false;
    }
  
    public Experiment getParentExperiment(){
	return parentExperiment;
    }
  
    public void setDMTN(DefaultMutableTreeNode inNode){
	nodeRef = inNode;
    }
  
    public DefaultMutableTreeNode getDMTN(){
	return nodeRef;
    }
  
    public void setTrialName(String inString){
	trialName = inString;
    }
  
    public String getTrialName(){
	return trialName;
    }
  
    public void setTrialID(int inTrialID){
	trialID = inTrialID;
	//Since the parentApplication is set in the constructor,
	//it is not null.  Therefore we can safely set the experimentIDString.
	trialIDString = parentExperiment.getExperimentIDString() + trialID;
    }
  
    public int getTrialID(){
	return trialID;
    }
  
    public String getTrialIDString(){
	return trialIDString;
    }
  
    public Value addValue(){
	Value newValue = new Value(this);
	newValue.setValueID((values.size()));
	values.add(newValue);
	return newValue;
    }
  
    public ColorChooser getColorChooser(){
	return clrChooser;
    }
  
    public Preferences getPreferences(){
	return preferences;
    }
  
    public void setProfilePathName(String inString){
	profilePathName = inString;
    }
  
    public void setProfilePathNameReverse(String inString){
	profilePathNameReverse = inString;
    }
  
    public String getProfilePathName(){
	return profilePathName;
    }
  
    public String getProfilePathNameReverse(){
	return profilePathNameReverse;
    }
  
    public Vector getValues(){
	return values;
    }
  
    public int getValuePosition(String inString){
	int counter = 0;
	for(Enumeration e = values.elements(); e.hasMoreElements() ;){
	    Value tmpValue = (Value) e.nextElement();
	    if((tmpValue.getValueName()).equals(inString))
		return counter;
	    counter++;
	}
	return -1;
    }
  
    public String toString(){
	return trialName;}
  
    public int getNumberOfNodes(){
	return nodes.size();}

    public Vector getNodes(){
	return nodes;}

    public Node getNode(int nodeID){
	return (Node) nodes.elementAt(nodeID);}

    //Returns the total number of contexts in this trial.
    public int getTotalNumberOfContexts(){
	if(totalNumberOfContexts==-1){
	    for(Enumeration e = this.getNodes().elements(); e.hasMoreElements() ;){
	     Node node = (Node) e.nextElement();
	     totalNumberOfContexts+=(node.getNumberOfContexts());
	    }
	}
	return totalNumberOfContexts;
    }

    //Returns the number of contexts on the specified node.
    public int getNumberOfContexts(int nodeID){
	return ((Node) nodes.elementAt(nodeID)).getNumberOfContexts();}

    public Vector getContexts(int nodeID){
	return (this.getNode(nodeID)).getContexts();}

    public Context getContext(int nodeID, int contextID){
	return (this.getNode(nodeID)).getContext(contextID);}

    //Returns the total number of threads in this trial.
    public int getTotalNumberOfThreads(){
	if(totalNumberOfThreads==-1){
	    for(Enumeration e1 = this.getNodes().elements(); e1.hasMoreElements() ;){
		Node node = (Node) e1.nextElement();
		for(Enumeration e2 = node.getContexts().elements(); e2.hasMoreElements() ;){
		    Context context = (Context) e2.nextElement();
		    totalNumberOfThreads+=(context.getNumberOfThreads());
		}
	    }
	}
	return totalNumberOfThreads;
    }

    //Returns the number of threads on the specified node,context.
    public int getNumberOfThreads(int nodeID, int contextID){
	return (this.getContext(nodeID,contextID)).getNumberOfThreads();}

    public Vector getThreads(int nodeID, int contextID){
	return (this.getContext(nodeID,contextID)).getThreads();}

    public Thread getThread(int nodeID, int contextID, int threadID){
	return (this.getContext(nodeID,contextID)).getThread(threadID);}

    //Returns an array of length 3 which contains the maximum number
    //of nodes, contexts and threads reached. This is not a total,
    //except in the case of the number of nodes.
    //This method is useful for determining an upper bound on the
    //string sizes being displayed in ParaProf's different windows.
    //Computation will only occur during the first call to this method.
    //Subsequent calls will return the results obtained from the first
    //call.
    public int[] getMaxNCTNumbers(){
	if(nct==null){
	    nct = new int[3];
	    for(int i=0;i<3;i++){
		nct[i]=0;}
	    nct[0] = this.getNumberOfNodes();
	    for(Enumeration e1 = (this.getNodes()).elements(); e1.hasMoreElements() ;){
		Node node = (Node) e1.nextElement();
		if(node.getNumberOfContexts()>nct[1])
		    nct[1]=node.getNumberOfContexts();
		for(Enumeration e2 = (node.getContexts()).elements(); e2.hasMoreElements() ;){
		    Context context = (Context) e2.nextElement();
		    if(context.getNumberOfThreads()>nct[2])
			nct[2]=context.getNumberOfThreads();
		}
	    }
	}
	return nct;
    }
    

    //####################################
    //Functions that control the obtaining and the openning
    //and closing of the static main window for
    //this trial.
    //####################################
    public StaticMainWindow getStaticMainWindow(){
	return sMW;
    }
  
    public void showMainWindow(){
  
	if(sMW == null){
	    sMW = new StaticMainWindow(this);
	    sMW.setVisible(true);
	    this.getSystemEvents().addObserver(sMW);
	}
	else{
	    this.getSystemEvents().addObserver(sMW);
	    sMW.show();
	}
    }
  
    public void closeStaticMainWindow(){
	if(sMW != null){
	    this.getSystemEvents().deleteObserver(sMW);
	    sMW.setVisible(false);
	}
    }
    //####################################
    //Functions that control the openning and closing of the static main window for
    //this trial.
    //####################################
  
    public SystemEvents getSystemEvents(){
	return systemEvents;
    }
  
    public void setCurValLoc(int inValueLocation){
	currentValueLocation = inValueLocation;
    }
  
    public int getCurValLoc(){
	return currentValueLocation;
    }
  
  
    public void addDefaultToVectors(){
	maxMeanInclusiveValueList.add(new Double(0));
	maxMeanExclusiveValueList.add(new Double(0));
	maxMeanInclusivePercentValueList.add(new Double(0));
	maxMeanExclusivePercentValueList.add(new Double(0));
	maxMeanUserSecPerCallList.add(new Double(0));
	totalMeanInclusiveValueList.add(new Double(0));
	totalMeanExclusiveValueList.add(new Double(0));
    }
  
    //The following funtion initializes the GlobalMapping object.
    //Since we are in the static mode, the number of mappings is known,
    //therefore, the appropriate number of GlobalMappingElements are created.
    void initializeGlobalMapping(int inNumberOfMappings, int mappingSelection){
	for(int i=0; i<inNumberOfMappings; i++){
	    //globalMapping.addGlobalMapping("Error ... the mapping name has not been set!");
	    globalMapping.addGlobalMapping(null, mappingSelection);
	}
    }
  
    //Rest of the public functions.
    GlobalMapping getGlobalMapping(){
	return globalMapping;
    }
  
    public String getCounterName(){
	Value tmpValue = (Value) values.elementAt(currentValueLocation);
	return tmpValue.getValueName();
    }

    public boolean isTimeMetric(){
	String trialName = this.getCounterName();
	trialName = trialName.toUpperCase();
	if(trialName.indexOf("TIME") == -1)
	    return false;
	else
	    return true;
    }
  
    //The core public function of this class.  It reads pprof dump files ... that is pprof
    //run with the -d option.  If any changes occur to the "pprof -d" file output format,
    //the working of this function might be affected.
  
    //This method is now implemted 
    public void buildStaticData(File inFile){
	try{
	    System.out.println("Processing data file, please wait ......");
	    long time = System.currentTimeMillis();

	    FileInputStream fileIn = new FileInputStream(inFile);
	    //ProgressMonitorInputStream progressIn = new ProgressMonitorInputStream(null, "Processing ...", fileIn);
	    //InputStreamReader inReader = new InputStreamReader(progressIn);
	    InputStreamReader inReader = new InputStreamReader(fileIn);
	    BufferedReader br = new BufferedReader(inReader);
	    
	    String inputString = null;
	    String s1 = null;
	    String s2 = null;
	    //Some useful strings.
	    //String inputString;
	    String tokenString;
	    String mappingNameString = null;
	    String groupNamesString = null;
	    StringTokenizer genericTokenizer;
      
	    int mappingID = -1;
	    double value = -1;
	    double percentValue = -1;
	          
	    GlobalMappingElement tmpGlobalMappingElement;

	    int nodeID = -1;
	    int contextID = -1;
	    int threadID = -1;
	    int lastNodeID = -1;
	    int lastContextID = -1;
	    int lastThreadID = -1;
      
	    Node currentNode = null;
	    Context currentContext = null;
	    Thread currentThread = null;
	    GlobalThreadDataElement tmpGlobalThreadDataElement = null;
            
	    //A loop counter.
	    bSDCounter = 0;
      
	    //Another one.
	    int i=0;
	    int maxID = 0;

	    //Process the file.
      
	    //********************
	    //First Line
	    //********************
	    //This line is not required. Check to make sure that it is there however.
	    inputString = br.readLine();
	    if(inputString == null)
		return;
	    bSDCounter++;
	    //********************
	    //End - First Line
	    //********************
      
	    //********************
	    //Second  Line
	    //********************
	    //This is an important line.
	    inputString = br.readLine();
	    genericTokenizer = new StringTokenizer(inputString, " \t\n\r");
	    //It's first token will be the number of mappings present.  Get it.
	    tokenString = genericTokenizer.nextToken();
      
	    if(firstRun){
		//Set the number of mappings.
		numberOfMappings = Integer.parseInt(tokenString);
	    }
	    else{
		if(numberOfMappings != Integer.parseInt(tokenString)){
		    System.out.println("***********************");
		    System.out.println("The number of mappings does not match!!!");
		    System.out.println("");
		    System.out.println("To add to an existing run, you must be choosing from");
		    System.out.println("a list of multiple metrics from that same run!!!");
		    System.out.println("***********************");
	      
		    return;
		}
	    }
	    //Now initialize the global mapping with the correct number of mappings for mapping position 0.
	    if(firstRun)
		initializeGlobalMapping(Integer.parseInt(tokenString), 0);
      
	    //Set the counter name.
	    counterName = getCounterName(inputString);
      
	    //Ok, we are adding a counter name.  Since nothing much has happened yet, it is a
	    //good place to initialize a few things.
      
	    //Need to call addDefaultToVectors() on all objects that require it.
	    this.addDefaultToVectors();

	    //Only need to call addDefaultToVectors() if not the first run.
	    if(!firstRun){
		if(ParaProf.debugIsOn)
		    System.out.println("Increasing the storage for the new counter.");
		
		for(Enumeration e1 = (globalMapping.getMapping(0)).elements(); e1.hasMoreElements() ;){
		    GlobalMappingElement tmpGME = (GlobalMappingElement) e1.nextElement();
		    tmpGME.incrementStorage();
		}
	  
		for(Enumeration e2 = (globalMapping.getMapping(2)).elements(); e2.hasMoreElements() ;){
		    GlobalMappingElement tmpGME = (GlobalMappingElement) e2.nextElement();
		    tmpGME.incrementStorage();
		}
	  
		for(Enumeration e3 = this.getNodes().elements(); e3.hasMoreElements() ;){
		    Node node = (Node) e3.nextElement();
		    for(Enumeration e4 = node.getContexts().elements(); e4.hasMoreElements() ;){
			Context context = (Context) e4.nextElement();
			for(Enumeration e5 = context.getThreads().elements(); e5.hasMoreElements() ;){
			    Thread thread = (Thread) e5.nextElement();
			    thread.incrementStorage();
			    for(Enumeration e6 = thread.getFunctionList().elements(); e6.hasMoreElements() ;){
				GlobalThreadDataElement ref = (GlobalThreadDataElement) e6.nextElement();
				//Only want to add an element if this mapping existed on this thread.
				//Check for this.
				if(ref != null)
				    ref.incrementStorage();
			    }
			}
		    }
		}
	  
		if(ParaProf.debugIsOn)
		    System.out.println("Done increasing the storage for the new counter.");
	    }
      
	    //Now set the counter name.
      
	    if(counterName == null)
		counterName = new String("Wallclock Time");

	    System.out.println("Counter name is: " + counterName);
      
	    Value newValue = addValue();
	    newValue.setValueName(counterName);
	    setCurValLoc(newValue.getValueID());
	    System.out.println("The number of mappings in the system is: " + tokenString);
      
	    bSDCounter++;
	    //********************
	    //End - Second Line
	    //********************
      
	    //********************
	    //Third Line
	    //********************
	    //Do not need the third line.
	    inputString = br.readLine();
	    if(inputString == null)
		return;
	    bSDCounter++;
	    //********************
	    //End - Third Line
	    //********************	
      
	    while((inputString = br.readLine()) != null){
		genericTokenizer = new StringTokenizer(inputString, " \t\n\r");
          
		//Check to See if the String begins with a t.
		if((inputString.charAt(0)) == 't'){
		    mappingID = getMappingID(inputString);
		    value = getValue(inputString);
		    if(checkForExcInc(inputString, true, false)){
			mappingNameString = getMappingName(inputString);
			mappingID = getMappingID(inputString);
			if(mappingID > maxID)
			    maxID = mappingID;
			
			if(firstRun){ 
			    //Grab the group names.
			    groupNamesString = getGroupNames(inputString);
			    if(groupNamesString != null){
				StringTokenizer st = new StringTokenizer(groupNamesString, " |");
				while (st.hasMoreTokens()){
				    String tmpString = st.nextToken();
				    if(tmpString != null){
					//The potential new group is added here.  If the group is already present, the the addGlobalMapping
					//function will just return the already existing group id.  See the GlobalMapping class for more details.
					int tmpInt = globalMapping.addGlobalMapping(tmpString, 1);
					//The group is either already present, or has just been added in the above line.  Now, using the addGroup
					//function, update this mapping to be a member of this group.
					globalMapping.addGroup(mappingID, tmpInt, 0);
					if((tmpInt != -1) && (ParaProf.debugIsOn))
					    System.out.println("Adding " + tmpString + " group with id: " + tmpInt + " to mapping: " + mappingNameString);
				    }    
				}    
			    }
			}
                  
			if(firstRun){
			    //Now that we have the mapping name and id, fill in the global mapping element
			    //for this mapping.  I am assuming here that pprof's output lists only the
			    //global ids.
			    if(!(globalMapping.setMappingNameAt(mappingNameString, mappingID, 0)))
				System.out.println("There was an error adding mapping to the global mapping");
			}
                  
			//Set the value for this mapping.
			if(!(globalMapping.setTotalExclusiveValueAt(currentValueLocation, value, mappingID, 0)))
			    System.out.println("There was an error setting Exc/Inc total time");  
		    }
		    else{
			if(!(globalMapping.setTotalInclusiveValueAt(currentValueLocation, value, mappingID, 0)))
			    System.out.println("There was an error setting Exc/Inc total time");
		    }
		} //End - Check to See if the String begins with a t.
		//Check to See if the String begins with a mt.
		else if((inputString.charAt(0)) == 'm'){
		    mappingID = getMappingID(inputString);
		    value = getValue(inputString);
		    percentValue = getPercentValue(inputString);
		    //Grab the correct global mapping element.
		    tmpGlobalMappingElement = globalMapping.getGlobalMappingElement(mappingID, 0);
                
		    if(checkForExcInc(inputString, true, false)){
			//Now set the values correctly.
			if((getMaxMeanExclusiveValue(currentValueLocation)) < value){
			    setMaxMeanExclusiveValue(currentValueLocation, value);}
			if((getMaxMeanExclusivePercentValue(currentValueLocation)) < percentValue){
			    setMaxMeanExclusivePercentValue(currentValueLocation, percentValue);}
			
			tmpGlobalMappingElement.setMeanExclusiveValue(currentValueLocation, value);
			tmpGlobalMappingElement.setMeanExclusivePercentValue(currentValueLocation, percentValue);
		    }
		    else{
			//Now set the values correctly.
			if((getMaxMeanInclusiveValue(currentValueLocation)) < value){
			    setMaxMeanInclusiveValue(currentValueLocation, value);}
			if((getMaxMeanInclusivePercentValue(currentValueLocation)) < percentValue){
			    setMaxMeanInclusivePercentValue(currentValueLocation, percentValue);}
                  
			tmpGlobalMappingElement.setMeanInclusiveValue(currentValueLocation, value);
			tmpGlobalMappingElement.setMeanInclusivePercentValue(currentValueLocation, percentValue);
                  
			//Set number of calls/subroutines/usersec per call.
			inputString = br.readLine();
			setNumberOfCSUMean(inputString, tmpGlobalMappingElement);
			tmpGlobalMappingElement.setMeanValuesSet(true);
		    }
		}//End - Check to See if the String begins with a m.
		//String does not begin with either an m or a t, the rest of the checks go here.
		else{
		    if(checkForExcInc(inputString, true, true)){ 
			
			//Stuff common to a non-first run and a first run.
			//Grab the mapping ID.
			mappingID = getMappingID(inputString);
			//Grab the value.
			value = getValue(inputString);
			percentValue = getPercentValue(inputString);
			
			//Update the max values if required.
			//Grab the correct global mapping element.
			tmpGlobalMappingElement = globalMapping.getGlobalMappingElement(mappingID, 0);
			if((tmpGlobalMappingElement.getMaxExclusiveValue(currentValueLocation)) < value)
			    tmpGlobalMappingElement.setMaxExclusiveValue(currentValueLocation, value);
			if((tmpGlobalMappingElement.getMaxExclusivePercentValue(currentValueLocation)) < percentValue)
			    tmpGlobalMappingElement.setMaxExclusivePercentValue(currentValueLocation, percentValue);
			//Get the node,context,thread.
			nodeID = getNCT(0,inputString, false);
			contextID = getNCT(1,inputString, false);
			threadID = getNCT(2,inputString, false);
			
			if(firstRun){
			    //Now the complicated part.  Setting up the node,context,thread data.
			    //These first two if statements force a change if the current node or
			    //current context changes from the last, but without a corresponding change
			    //in the thread number.  For example, if we have the sequence:
			    //0,0,0 - 1,0,0 - 2,0,0 or 0,0,0 - 0,1,0 - 1,0,0.
			    if(lastNodeID != nodeID){
				lastContextID = -1;
				lastThreadID = -1;
			    }
			    if(lastContextID != contextID){
				lastThreadID = -1;
			    }
			    if(lastThreadID != threadID){
				if(threadID == 0){
				    //Create a new thread ... and set it to be the current thread.
				    currentThread = new Thread();
				    //Add the correct number of global thread data elements.
				    currentThread.initializeFunctionList(numberOfMappings);
				    //Update the thread number.
				    lastThreadID = threadID;
				    
				    //Set the appropriate global thread data element.
				    Vector tmpVector = currentThread.getFunctionList();
				    GlobalThreadDataElement tmpGTDE = null;
				    
				    tmpGTDE = (GlobalThreadDataElement) tmpVector.elementAt(mappingID);
				    
				    if(tmpGTDE == null){
					tmpGTDE = new GlobalThreadDataElement(this, false);
					tmpGTDE.setMappingID(mappingID);
					currentThread.addFunction(tmpGTDE, mappingID);
				    }
				    tmpGTDE.setMappingExists();
				    tmpGTDE.setExclusiveValue(currentValueLocation, value);
				    tmpGTDE.setExclusivePercentValue(currentValueLocation, percentValue);
				    //Now check the max values on this thread.
				    if((currentThread.getMaxExclusiveValue(currentValueLocation)) < value)
					currentThread.setMaxExclusiveValue(currentValueLocation, value);
				    if((currentThread.getMaxExclusivePercentValue(currentValueLocation)) < value)
					currentThread.setMaxExclusivePercentValue(currentValueLocation, percentValue);
				    
				    //Check to see if the context is zero.
				    if(contextID == 0){
					//Create a new context ... and set it to be the current context.
					currentContext = new Context();
					//Add the current thread
					currentContext.addThread(currentThread);
					
					//Create a new server ... and set it to be the current server.
					currentNode = new Node();
					//Add the current context.
					currentNode.addContext(currentContext);
					//Add the current server.
					nodes.addElement(currentNode);
					
					//Update last context and last node.
					lastContextID = contextID;
					lastNodeID = nodeID;
				    }
				    else{
					//Context number is not zero.  Create a new context ... and set it to be current.
					currentContext = new Context();
					//Add the current thread
					currentContext.addThread(currentThread);
					
					//Add the current context.
					currentNode.addContext(currentContext);
					
					//Update last context and last node.
					lastContextID = contextID;
				    }
				}
				else{
				    //Thread number is not zero.  Create a new thread ... and set it to be the current thread.
				    currentThread = new Thread();
				    //Add the correct number of global thread data elements.
				    currentThread.initializeFunctionList(numberOfMappings);
				    //Update the thread number.
				    lastThreadID = threadID;
				    
				    //Not thread changes.  Just set the appropriate global thread data element.
				    Vector tmpVector = currentThread.getFunctionList();
				    GlobalThreadDataElement tmpGTDE = null;
				    tmpGTDE = (GlobalThreadDataElement) tmpVector.elementAt(mappingID);
				    				    
				    if(tmpGTDE == null){
					tmpGTDE = new GlobalThreadDataElement(this, false);
					tmpGTDE.setMappingID(mappingID);
					currentThread.addFunction(tmpGTDE, mappingID);
				    }
				    
				    tmpGTDE.setMappingExists();
				    tmpGTDE.setExclusiveValue(currentValueLocation, value);
				    tmpGTDE.setExclusivePercentValue(currentValueLocation, percentValue);
				    //Now check the max values on this thread.
				    if((currentThread.getMaxExclusiveValue(currentValueLocation)) < value)
					currentThread.setMaxExclusiveValue(currentValueLocation, value);
				    if((currentThread.getMaxExclusivePercentValue(currentValueLocation)) < value)
					currentThread.setMaxExclusivePercentValue(currentValueLocation, percentValue);
				    
				    //Add the current thread
				    currentContext.addThread(currentThread);
				}
			    }
			    else{
				//Not thread changes.  Just set the appropriate global thread data element.
				Vector tmpVector = currentThread.getFunctionList();
				GlobalThreadDataElement tmpGTDE = null;
				tmpGTDE = (GlobalThreadDataElement) tmpVector.elementAt(mappingID);
				
				
				if(tmpGTDE == null){
				    tmpGTDE = new GlobalThreadDataElement(this, false);
				    tmpGTDE.setMappingID(mappingID);
				    currentThread.addFunction(tmpGTDE, mappingID);
				}
				
				tmpGTDE.setMappingExists();
				tmpGTDE.setExclusiveValue(currentValueLocation, value);
				tmpGTDE.setExclusivePercentValue(currentValueLocation, percentValue);
				//Now check the max values on this thread.
				if((currentThread.getMaxExclusiveValue(currentValueLocation)) < value)
				    currentThread.setMaxExclusiveValue(currentValueLocation, value);
				if((currentThread.getMaxExclusivePercentValue(currentValueLocation)) < percentValue)
				    currentThread.setMaxExclusivePercentValue(currentValueLocation, percentValue);
			    }
			}
			else{
			    Thread thread = this.getThread(nodeID,contextID,threadID);
			    GlobalThreadDataElement tmpGTDE = thread.getFunction(mappingID);
			    tmpGTDE.setExclusiveValue(currentValueLocation, value);
			    tmpGTDE.setExclusivePercentValue(currentValueLocation, percentValue);
			    if((thread.getMaxExclusiveValue(currentValueLocation)) < value)
				thread.setMaxExclusiveValue(currentValueLocation, value);
			    if((thread.getMaxExclusivePercentValue(currentValueLocation)) < percentValue)
				thread.setMaxExclusivePercentValue(currentValueLocation, percentValue);
			}
		    }
		    else if(checkForExcInc(inputString, false, true)){
			//Grab the mapping ID.
			mappingID = getMappingID(inputString);
			//Grab the value.
			value = getValue(inputString);
			percentValue = getPercentValue(inputString);
			
			//Update the max values if required.
			//Grab the correct global mapping element.
			tmpGlobalMappingElement = globalMapping.getGlobalMappingElement(mappingID, 0);
			
			if((tmpGlobalMappingElement.getMaxInclusiveValue(currentValueLocation)) < value)
			    tmpGlobalMappingElement.setMaxInclusiveValue(currentValueLocation, value);
			
			if((tmpGlobalMappingElement.getMaxInclusivePercentValue(currentValueLocation)) < percentValue)
			    tmpGlobalMappingElement.setMaxInclusivePercentValue(currentValueLocation, percentValue);
			
			//Print out the node,context,thread.
			nodeID = getNCT(0,inputString, false);
			contextID = getNCT(1,inputString, false);
			threadID = getNCT(2,inputString, false);
			Thread thread = this.getThread(nodeID,contextID,threadID);
			GlobalThreadDataElement tmpGTDE = thread.getFunction(mappingID);
			
			tmpGTDE.setInclusiveValue(currentValueLocation, value);
			tmpGTDE.setInclusivePercentValue(currentValueLocation, percentValue);
			if((thread.getMaxInclusiveValue(currentValueLocation)) < value)
			    thread.setMaxInclusiveValue(currentValueLocation, value);
			if((thread.getMaxInclusivePercentValue(currentValueLocation)) < percentValue)
			    thread.setMaxInclusivePercentValue(currentValueLocation, percentValue);
			
			//Get the number of calls and number of sub routines
			inputString = br.readLine();
			setNumberOfCSU(inputString, tmpGlobalMappingElement, thread, tmpGTDE);
		    }
		    else if(noue(inputString)){
			//Just ignore the string if this is not the first check.
			//Assuming is that user events do not change for each counter value.
			if(firstRun){
			    //The first time a user event string is encountered, get the number of user events and 
			    //initialize the global mapping for mapping position 2.
			    if(!(userEventsPresent())){
				//Get the number of user events.
				numberOfUserEvents = getNumberOfUserEvents(inputString);
				initializeGlobalMapping(numberOfUserEvents, 2);
				if(ParaProf.debugIsOn){
				    System.out.println("The number of user events defined is: " + numberOfUserEvents);
				    System.out.println("Initializing mapping selection 2 (The loaction of the user event mapping) for " +
						       numberOfUserEvents + " mappings.");
				}
			    } 
			    
			    //The first line will be the user event heading ... skip it.
			    br.readLine();
			    //Now that we know how many user events to expect, we can grab that number of lines.
			    for(int j=0; j<numberOfUserEvents; j++){
				s1 = br.readLine();
				s2 = br.readLine();
				UserEventData ued = getData(s1,s2, userEventsPresent);

				//Initialize the user list for this thread.
				if(j == 0){
				    //Note that this works correctly because we process the user events in a different manner.
				    //ALL the user events for each THREAD NODE are processed in the above for-loop.  Therefore,
				    //the below for-loop is only run once on each THREAD NODE.

				    Thread thread = this.getThread(nodeID,contextID,threadID);
				    if(firstRun){
					thread.initializeUsereventList(numberOfUserEvents);
				    }
				}
				//Only need to set the name in the global mapping once.
				if(!(userEventsPresent())){
				    if(!(globalMapping.setMappingNameAt(ued.name, ued.id, 2)))
					System.out.println("There was an error adding mapping to the global mapping");
				}
				if(ued.noc != 0){
				    //Update the max values if required.
				    //Grab the correct global mapping element.
				    tmpGlobalMappingElement = globalMapping.getGlobalMappingElement(ued.id, 2);
				    if((tmpGlobalMappingElement.getMaxUserEventNumberValue()) < ued.noc)
					tmpGlobalMappingElement.setMaxUserEventNumberValue(ued.noc);
				    if((tmpGlobalMappingElement.getMaxUserEventMinValue()) < ued.min)
					tmpGlobalMappingElement.setMaxUserEventMinValue(ued.min);
				    if((tmpGlobalMappingElement.getMaxUserEventMaxValue()) < ued.max)
					tmpGlobalMappingElement.setMaxUserEventMaxValue(ued.max);
				    if((tmpGlobalMappingElement.getMaxUserEventMeanValue()) < ued.mean)
					tmpGlobalMappingElement.setMaxUserEventMeanValue(ued.mean);
				    
				    GlobalThreadDataElement tmpGTDEUE = new GlobalThreadDataElement(this, true);
				    tmpGTDEUE.setUserEventID(ued.id);
				    tmpGTDEUE.setUserEventNumberValue(ued.noc);
				    tmpGTDEUE.setUserEventMinValue(ued.min);
				    tmpGTDEUE.setUserEventMaxValue(ued.max);
				    tmpGTDEUE.setUserEventMeanValue(ued.mean);
				    (this.getThread(nodeID,contextID,threadID)).addUserevent(tmpGTDEUE, ued.id);
				}
			    }
			    //Now set the userEvents flag.
			    setUserEventsPresent(true);
			}
		    }
		}
		//Increment the loop counter.
		bSDCounter++;
	    }
	    
	    //Close the file.
	    br.close();

	    if(ParaProf.debugIsOn){
		System.out.println("The total number of threads is: " + this.getTotalNumberOfThreads());
		System.out.println("The number of mappings is: " + this.getNumberOfMappings());
		System.out.println("The number of user events is: " + this.getNumberOfUserEvents());
	    }

	    System.out.println("Processing callpath data ...");
	    if(CallPathUtilFuncs.isAvailable(getGlobalMapping().getMappingIterator(0))){
		setCallPathDataPresent(true);
		CallPathUtilFuncs.buildRelations(getGlobalMapping());
	    }
	    else{
		System.out.println("No callpath data found.");
	    }
	    System.out.println("Done - Processing callpath data!");
      
	    //Set firstRun to false.
	    firstRun = false;
      
	    time = (System.currentTimeMillis()) - time;
	    System.out.println("Done processing data file, please wait ......");
	    System.out.println("Time to process file (in milliseconds): " + time);
	    //Ok, now show the static main window.
	    //this.showMainWindow();
	}
        catch(Exception e){
	    ParaProf.systemError(e, null, "SSD01");
	}
    }
  
    //******************************
    //Helper functions for buildStatic data.
    //******************************

    public boolean noue(String s){
	int stringPosition = 0;
	char tmpChar = s.charAt(stringPosition);
	while(tmpChar!='\u0020'){
	    stringPosition++;
	    tmpChar = s.charAt(stringPosition);
	}
	stringPosition++;
	tmpChar = s.charAt(stringPosition);
	if(tmpChar=='u')
	    return true;
	else
	    return false;
    }

    public UserEventData getData(String s1, String s2, boolean doneNames){
	UserEventData ued = new UserEventData();
	try{
	    char[] tmpArray = s1.toCharArray();
	    char[] result = new char[tmpArray.length];

	    char lastCharCheck = ',';
	    int stringPosition = 10;
	    
	    int start = 0;
	    int end = 9;
	    int resultPosition = 0;

	    for(int i=start;i<9;i++){
		if(i==2)
		    lastCharCheck = '\u0020';
		else if(i==4){
		    //Want to skip processing the name if we
		    //do not need it.
		    if(doneNames){
			stringPosition++;
			lastCharCheck = '"';
			while(tmpArray[stringPosition]!=lastCharCheck){
			    stringPosition++;
			}
			stringPosition++;

			//Set things to look as if we are in i=5 iteration.
			i=5;
			lastCharCheck = '\u0020';
			stringPosition++;
		    }
		    else{
			lastCharCheck = '"';
			stringPosition++;
		    }
		}
		else if(i==5){
		    lastCharCheck = '\u0020';
		    stringPosition++;
		}
		while(tmpArray[stringPosition]!=lastCharCheck){
		    result[resultPosition]=tmpArray[stringPosition];
		    stringPosition++;
		    resultPosition++;
		}
		
		switch(i){
		case 0:
		    ued.node = Integer.parseInt(new String(result,0,resultPosition));
		    break;
		case 1:
		    ued.context = Integer.parseInt(new String(result,0,resultPosition));
		    break;
		case 2:
		    ued.threadID = Integer.parseInt(new String(result,0,resultPosition));
		    break;
		case 3:
		    ued.id = Integer.parseInt(new String(result,0,resultPosition));
		    break;
		case 4:
		    if(!userEventsPresent)
			ued.name = new String(result,0,resultPosition);  
		    break;
		case 5:
		    ued.noc = (int) Double.parseDouble(new String(result,0,resultPosition));
		    break;
		case 6:
		    ued.max = Double.parseDouble(new String(result,0,resultPosition));
		    break;
		case 7:
		    ued.min = Double.parseDouble(new String(result,0,resultPosition));
		    break;
		case 8:
		    ued.mean = Double.parseDouble(new String(result,0,resultPosition));
		    break;
		default:
		    throw new UnexpectedStateException(String.valueOf(i));
		}
		resultPosition=0;
		stringPosition++;
	    }
	    //One more item to pick up if userevent string.
	    int length = tmpArray.length;
	    while(stringPosition < length){
		result[resultPosition]=tmpArray[stringPosition];
		stringPosition++;
		resultPosition++;
	    }
	    ued.std = Double.parseDouble(new String(result,0,resultPosition));
	}
	catch(Exception e){
	    System.out.println("An error occured!");
	    e.printStackTrace();
	}
	return ued;
    }

    String getMappingName(String inString)
    {
	try{
	    String tmpString;
      
	    StringTokenizer getMappingNameTokenizer = new StringTokenizer(inString, "\"");
      
	    //Since we know that the mapping name is the only one in the quotes, just ignore the
	    //first token, and then grab the next.
      
	    //Grab the first token.
	    tmpString = getMappingNameTokenizer.nextToken();
      
	    //Grab the second token.
	    tmpString = getMappingNameTokenizer.nextToken();
      
	    //Now return the second string.
	    return tmpString;
	}
	catch(Exception e)
	    {
		ParaProf.systemError(e, null, "SSD08");
	    }
    
	return null;
    }
  
    int getMappingID(String inString)
    {
	try{
	    String tmpString;
      
	    StringTokenizer getMappingIDTokenizer = new StringTokenizer(inString, " \t\n\r");
      
	    //The mapping id will be the second token on its line.
      
	    //Grab the first token.
	    tmpString = getMappingIDTokenizer.nextToken();
      
	    //Grab the second token.
	    tmpString = getMappingIDTokenizer.nextToken();
      
      
	    //Now return the id.
	    //Integer tmpInteger = new Integer(tmpString);
	    //int tmpInt = tmpInteger.intValue();
	    return Integer.parseInt(tmpString);
	}
	catch(Exception e){
	    ParaProf.systemError(e, null, "SSD09");
	}
	return -1;
    }
    
    boolean checkForExcInc(String inString, boolean exclusive, boolean checkString){
	boolean result = false;
    
	try{
	    //In this function I need to be careful.  If the mapping name contains "excl", I
	    //might interpret this line as being the exclusive line when in fact it is not.
      
	    if(checkString){
		StringTokenizer checkTokenizer = new StringTokenizer(inString," ");
		String tmpString2 = checkTokenizer.nextToken();
		if((tmpString2.indexOf(",")) == -1)
		    return result;
	    }
      
	    //Now, we want to grab the substring that occurs AFTER the SECOND '"'.
	    //At present, pprof does not seem to allow an '"' in the mapping name.  So
	    //, I can be assured that I will not find more than two before the "excl" or "incl".
	    StringTokenizer checkQuotesTokenizer = new StringTokenizer(inString,"\"");
      
	    //Need to get the third token.  Could do it in a loop, just as quick this way.
	    String tmpString = checkQuotesTokenizer.nextToken();
	    tmpString = checkQuotesTokenizer.nextToken();
	    tmpString = checkQuotesTokenizer.nextToken();
      
	    //Ok, now, the string in tmpString should include at least "excl" or "incl", and
	    //also, the first token should be either "excl" or "incl".
	    StringTokenizer checkForExclusiveTokenizer = new StringTokenizer(tmpString, " \t\n\r");
	    tmpString = checkForExclusiveTokenizer.nextToken();
      
	    //At last, do the check.  
	    if(exclusive){
		if(tmpString.equals("excl"))
		    result = true;
	    }
	    else{
		if(tmpString.equals("incl"))
		    result = true;
	    }
	}
	catch(Exception e){
	    ParaProf.systemError(e, null, "SSD04");}
	return result;
    }
  
    private void setNumberOfCSU(String inString, GlobalMappingElement inGME,
				Thread thread, GlobalThreadDataElement inGTDE){ 
	//Set the number of calls/subroutines/usersec per call.
	//The number of calls will be the fourth token on its line.
	//The number of subroutines will be the fifth token on its line.
	//The usersec per call will be the sixth token on its line.
	try{
	    String tmpString = null;
	    double tmpDouble = -1;
	    int tmpInt = -1;  //Parse as a double, but cast to this int just in case pprof.dat records as a double.
	    StringTokenizer getMappingIDTokenizer = new StringTokenizer(inString, " \t\n\r");
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpString = getMappingIDTokenizer.nextToken();
	    //Set number of calls.
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpDouble = Double.parseDouble(tmpString);
	    tmpInt = (int) tmpDouble;
	    if((inGME.getMaxNumberOfCalls()) < tmpInt)
		inGME.setMaxNumberOfCalls(tmpInt);
	    if((thread.getMaxNumberOfCalls()) < tmpInt)
		thread.setMaxNumberOfCalls(tmpInt);
	    inGTDE.setNumberOfCalls(tmpInt);
	    //Set number of subroutines.
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpDouble = Double.parseDouble(tmpString);
	    tmpInt = (int) tmpDouble;
	    if((inGME.getMaxNumberOfSubRoutines()) < tmpInt)
		inGME.setMaxNumberOfSubRoutines(tmpInt);
	    if((thread.getMaxNumberOfSubRoutines()) < tmpInt)
		thread.setMaxNumberOfSubRoutines(tmpInt);
	    inGTDE.setNumberOfSubRoutines(tmpInt);
	    //Set usersec per call.
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpDouble = Double.parseDouble(tmpString);
	    if((inGME.getMaxUserSecPerCall(currentValueLocation)) < tmpDouble)
		inGME.setMaxUserSecPerCall(currentValueLocation, tmpDouble);
	    if((thread.getMaxUserSecPerCall(currentValueLocation)) < tmpDouble)
		thread.setMaxUserSecPerCall(currentValueLocation, tmpDouble);
	    inGTDE.setUserSecPerCall(currentValueLocation, tmpDouble);
	}
	catch(Exception e){
	    ParaProf.systemError(e, null, "SSD10");
	}
    }
    
    private void setNumberOfCSUMean(String inString, GlobalMappingElement inGME){ //Set the number of calls/subroutines/usersec per call for mean.
	//The number of calls will be the fourth token on its line.
	//The number of subroutines will be the fifth token on its line.
	//The usersec per call will be the sixth token on its line.
	try{
	    String tmpString = null;
	    double tmpDouble = -1;
	    StringTokenizer getMappingIDTokenizer = new StringTokenizer(inString, " \t\n\r");
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpString = getMappingIDTokenizer.nextToken();
	    //Set number of calls.
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpDouble = Double.parseDouble(tmpString);
	    if((this.getMaxMeanNumberOfCalls()) < tmpDouble)
		this.setMaxMeanNumberOfCalls(tmpDouble);
	    inGME.setMeanNumberOfCalls(tmpDouble);
	    //Set number of subroutines.
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpDouble = Double.parseDouble(tmpString);
	    if((this.getMaxMeanNumberOfSubRoutines()) < tmpDouble)
		this.setMaxMeanNumberOfSubRoutines(tmpDouble);
	    inGME.setMeanNumberOfSubRoutines(tmpDouble);
	    //Set usersec per call.
	    tmpString = getMappingIDTokenizer.nextToken();
	    tmpDouble = Double.parseDouble(tmpString);
	    if((this.getMaxMeanUserSecPerCall(currentValueLocation)) < tmpDouble)
		this.setMaxMeanUserSecPerCall(currentValueLocation, tmpDouble);
	    inGME.setMeanUserSecPerCall(currentValueLocation, tmpDouble);
	}
	catch(Exception e)
	    {
		ParaProf.systemError(e, null, "SSD10");
	    }
    }
  
    String getGroupNames(String inString){
    
	try{  
	    String tmpString = null;
        
	    StringTokenizer getMappingNameTokenizer = new StringTokenizer(inString, "\"");
        
	    //Grab the first token.
	    tmpString = getMappingNameTokenizer.nextToken();
	    //Grab the second token.
	    tmpString = getMappingNameTokenizer.nextToken();
	    //Grab the third token.
	    tmpString = getMappingNameTokenizer.nextToken();
        
	    //Just do the group check once.
	    if(!groupNamesCheck)
		{
		    //If present, "GROUP=" will be in this token.
		    int tmpInt = tmpString.indexOf("GROUP=");
		    if(tmpInt > 0)
			{
			    groupNamesPresent = true;
			}
          
		    groupNamesCheck = true;
          
		}
        
	    if(groupNamesPresent)
		{
		    //We can grab the group name.
          
		    //Grab the forth token.
		    tmpString = getMappingNameTokenizer.nextToken();
		    return tmpString;
		}
        
	    //If here, this profile file does not track the group names.
	    return null;

	}
	catch(Exception e)
	    {
		ParaProf.systemError(e, null, "SSD12");
	    }
    
	return null;
    }
  
    double getValue(String inString){
	try{
	    String tmpString;
      
	    //First strip away the portion of the string not needed.
	    StringTokenizer valueQuotesTokenizer = new StringTokenizer(inString,"\"");
      
	    //Grab the third token.
	    tmpString = valueQuotesTokenizer.nextToken();
	    tmpString = valueQuotesTokenizer.nextToken();
	    tmpString = valueQuotesTokenizer.nextToken();
      
	    //Ok, now concentrate on the third token.  The token in question should be the second.
	    StringTokenizer valueTokenizer = new StringTokenizer(tmpString, " \t\n\r");
	    tmpString = valueTokenizer.nextToken();
	    tmpString = valueTokenizer.nextToken();
      
	    return (double)Double.parseDouble(tmpString);
	}
	catch(Exception e)
	    {
		ParaProf.systemError(e, null, "SSD13");
	    }
    
	return -1;
    }
  
    double getPercentValue(String inString){
	try{
	    String tmpString;
      
	    //First strip away the portion of the string not needed.
	    StringTokenizer percentValueQuotesTokenizer = new StringTokenizer(inString,"\"");
      
	    //Grab the third token.
	    tmpString = percentValueQuotesTokenizer.nextToken();
	    tmpString = percentValueQuotesTokenizer.nextToken();
	    tmpString = percentValueQuotesTokenizer.nextToken();
      
	    //Ok, now concentrate on the third token.  The token in question should be the third.
	    StringTokenizer percentValueTokenizer = new StringTokenizer(tmpString, " \t\n\r");
	    tmpString = percentValueTokenizer.nextToken();
	    tmpString = percentValueTokenizer.nextToken();
	    tmpString = percentValueTokenizer.nextToken();
      
	    //Now return the value obtained.
	    return Double.parseDouble(tmpString);
	}
	catch(Exception e)
	    {
		ParaProf.systemError(e, null, "SSD14");
	    }
    
	return -1;
    }
  
    int getNumberOfUserEvents(String inString){
	try{
	    StringTokenizer getNumberOfUserEventsTokenizer = new StringTokenizer(inString, " \t\n\r");
      
	    String tmpString;
      
	    //It will be the first token.
	    tmpString = getNumberOfUserEventsTokenizer.nextToken();
      
	    //Now return the number of user events number.
	    return Integer.parseInt(tmpString);
	}
	catch(Exception e)
	    {
		ParaProf.systemError(e, null, "SSD16");
	    }
    
	return -1;
    }
  
    public int getNCT(int selector, String inString, boolean UEvent){
	//I am assuming an quick implimentation of charAt and append for this function.
	int nCT = -1;
	char lastCharCheck = '\u0020';
    
	try{
	    char tmpChar = '\u0020';
	    StringBuffer tmpBuffer = new StringBuffer();
	    int stringPosition = 0;
	    if(UEvent)
		stringPosition = 10;
      
	    if(selector != 2)
		lastCharCheck = ',';
        
	    for(int i=0;i<selector;i++){
		//Skip over ','.
		while(tmpChar!=','){
		    tmpChar = inString.charAt(stringPosition);
		    stringPosition++;
		}
		//Reset tmpChar.
		tmpChar = '\u0020';
		//Skip over the second ','.
	    }
          
	    tmpChar = inString.charAt(stringPosition);
	    while(tmpChar!=lastCharCheck){
		tmpBuffer.append(tmpChar);
		stringPosition++;
		tmpChar = inString.charAt(stringPosition);
	    }
        
	    //System.out.println("nCT string is: " + tmpBuffer.toString());
	    //System.out.println("String length is: " + tmpBuffer.toString().length());
	    nCT = Integer.parseInt(tmpBuffer.toString());
	}
	catch(Exception e){
	    ParaProf.systemError(e, null, "SSD23");
	}
    
	return nCT;
    }
  
    String getCounterName(String inString){
	try{
	    String tmpString = null;
	    int tmpInt = inString.indexOf("_MULTI_");
      
	    if(tmpInt > 0){
		//We are reading data from a multiple counter run.
		//Grab the counter name.
		tmpString = inString.substring(tmpInt+7);
		return tmpString;
	    }
      	    //We are not reading data from a multiple counter run.
	    return tmpString; 
      	}
	catch(Exception e){
	    ParaProf.systemError(e, null, "SSD26");
	}
    
	return null;
    }
  
    //******************************
    //End - Helper functions for buildStatic data.
    //******************************
    
    //******************************
    //Operation functions to work on the stored data.
    //******************************
    public Value applyOperation(String tmpString1, String tmpString2, String inOperation){
  
	int opA = this.getValuePosition(tmpString1);
	int opB = this.getValuePosition(tmpString2);
	String tmpString3 = null;
    
	int operation = -1;
    
	if(inOperation.equals("Add")){
	    operation = 0;
	    tmpString3 = tmpString1 + " + " + tmpString2;
	}
	else if(inOperation.equals("Subtract")){
	    operation = 1;
	    tmpString3 = tmpString1 + " - " + tmpString2;
	}
	else if(inOperation.equals("Multiply")){
	    operation = 2;
	    tmpString3 = tmpString1 + " * " + tmpString2;
	}
	else if(inOperation.equals("Divide")){
	    operation = 3;
	    tmpString3 = tmpString1 + " / " + tmpString2;
	}
	else{
	    System.out.println("Wrong operation type");
	}
      
	Value newValue = this.addValue();
	newValue.setValueName(tmpString3);
	this.setCurValLoc(newValue.getValueID());
  
	for(Enumeration e1 = (this.globalMapping.getMapping(0)).elements(); e1.hasMoreElements() ;){
                  
	    GlobalMappingElement tmpGME = (GlobalMappingElement) e1.nextElement();
	    tmpGME.incrementStorage();
	    tmpGME.setTotalExclusiveValue(0);
	    tmpGME.setTotalInclusiveValue(0);
	    tmpGME.setCounter(0);
	}
    
	for(Enumeration e2 = (this.globalMapping.getMapping(2)).elements(); e2.hasMoreElements() ;){
      
	    GlobalMappingElement tmpGME = (GlobalMappingElement) e2.nextElement();
	    tmpGME.incrementStorage();
	}
    
	this.addDefaultToVectors();
    
	Node node;
	Context context;
	Thread thread;
	GlobalThreadDataElement tmpGlobalThreadDataElement;
     
	//Get a reference to the global data.
	Vector tmpVector = this.getNodes();
    
	for(Enumeration e3 = tmpVector.elements(); e3.hasMoreElements() ;){
	    node = (Node) e3.nextElement();
 	    for(Enumeration e4 = node.getContexts().elements(); e4.hasMoreElements() ;){
		context = (Context) e4.nextElement();
 		for(Enumeration e5 = context.getThreads().elements(); e5.hasMoreElements() ;){
		    thread = (Thread) e5.nextElement();
		    thread.incrementStorage();
		    for(Enumeration e6 = thread.getFunctionList().elements(); e6.hasMoreElements() ;){
			tmpGlobalThreadDataElement = (GlobalThreadDataElement) e6.nextElement();
			//Only want to add an element if this mapping existed on this thread.
			//Check for this.
			if(tmpGlobalThreadDataElement != null){
			    int mappingID = tmpGlobalThreadDataElement.getMappingID();
			    GlobalMappingElement tmpGlobalMappingElement = globalMapping.getGlobalMappingElement(mappingID, 0);
			    tmpGlobalMappingElement.incrementCounter();
              
			    tmpGlobalThreadDataElement.incrementStorage();
              
			    double tmpDouble1 = 0;
			    double tmpDouble2 = 0;
              
			    double tmpDouble = 0;
              
              
			    switch(operation){
			    case(0):
				tmpDouble1 = tmpGlobalThreadDataElement.getExclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getExclusiveValue(opB);
                  
				tmpDouble = tmpDouble1+tmpDouble2;
				tmpGlobalThreadDataElement.setExclusiveValue(currentValueLocation, tmpDouble);
				if((thread.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
				    thread.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				thread.incrementTotalExclusiveValue(tmpDouble);
                    
				//Now do the global mapping element exclusive stuff.
				if((tmpGlobalMappingElement.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
				    tmpGlobalMappingElement.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				tmpGlobalMappingElement.incrementTotalExclusiveValue(tmpDouble);
                  
                  
                  
				tmpDouble1 = tmpGlobalThreadDataElement.getInclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getInclusiveValue(opB);
                  
				tmpDouble = tmpDouble1+tmpDouble2;
				tmpGlobalThreadDataElement.setInclusiveValue(currentValueLocation, tmpDouble);
				if((thread.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
				    thread.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				thread.incrementTotalInclusiveValue(tmpDouble);
                    
				//Now do the global mapping element inclusive stuff.
				if((tmpGlobalMappingElement.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
				    tmpGlobalMappingElement.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				tmpGlobalMappingElement.incrementTotalInclusiveValue(tmpDouble);
            
				break;
			    case(1):
				tmpDouble1 = tmpGlobalThreadDataElement.getExclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getExclusiveValue(opB);
                  
				if(tmpDouble1 > tmpDouble2){
				    tmpDouble = tmpDouble1 - tmpDouble2;
				    tmpGlobalThreadDataElement.setExclusiveValue(currentValueLocation, tmpDouble);
				    if((thread.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
					thread.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				    thread.incrementTotalExclusiveValue(tmpDouble);
                      
				    //Now do the global mapping element exclusive stuff.
				    if((tmpGlobalMappingElement.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
					tmpGlobalMappingElement.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				    tmpGlobalMappingElement.incrementTotalExclusiveValue(tmpDouble);
				}
                  
				tmpDouble1 = tmpGlobalThreadDataElement.getInclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getInclusiveValue(opB);
                  
				if(tmpDouble1 > tmpDouble2){
				    tmpDouble = tmpDouble1 - tmpDouble2;
				    tmpGlobalThreadDataElement.setInclusiveValue(currentValueLocation, tmpDouble);
				    if((thread.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
					thread.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				    thread.incrementTotalInclusiveValue(tmpDouble);
                      
				    //Now do the global mapping element inclusive stuff.
				    if((tmpGlobalMappingElement.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
					tmpGlobalMappingElement.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				    tmpGlobalMappingElement.incrementTotalInclusiveValue(tmpDouble);
				}
                  
				break;
			    case(2):
				tmpDouble1 = tmpGlobalThreadDataElement.getExclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getExclusiveValue(opB);
                  
				tmpDouble = tmpDouble1*tmpDouble2;
				tmpGlobalThreadDataElement.setExclusiveValue(currentValueLocation, tmpDouble);
				if((thread.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
				    thread.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				thread.incrementTotalExclusiveValue(tmpDouble);
                    
				//Now do the global mapping element exclusive stuff.
				if((tmpGlobalMappingElement.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
				    tmpGlobalMappingElement.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				tmpGlobalMappingElement.incrementTotalExclusiveValue(tmpDouble);
                  
				tmpDouble1 = tmpGlobalThreadDataElement.getInclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getInclusiveValue(opB);
                  
				tmpDouble = tmpDouble1*tmpDouble2;
				tmpGlobalThreadDataElement.setInclusiveValue(currentValueLocation, tmpDouble);
				if((thread.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
				    thread.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				thread.incrementTotalInclusiveValue(tmpDouble);
                  
				//Now do the global mapping element inclusive stuff.
				if((tmpGlobalMappingElement.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
				    tmpGlobalMappingElement.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				tmpGlobalMappingElement.incrementTotalInclusiveValue(tmpDouble);
                  
                  
				break;
			    case(3):
				tmpDouble1 = tmpGlobalThreadDataElement.getExclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getExclusiveValue(opB);
                  
				if(tmpDouble2 != 0){
				    tmpDouble = tmpDouble1/tmpDouble2;
                    
				    tmpGlobalThreadDataElement.setExclusiveValue(currentValueLocation, tmpDouble);
				    if((thread.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
					thread.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				    thread.incrementTotalExclusiveValue(tmpDouble);
                    
				    //Now do the global mapping element exclusive stuff.
				    if((tmpGlobalMappingElement.getMaxExclusiveValue(currentValueLocation)) < tmpDouble)
					tmpGlobalMappingElement.setMaxExclusiveValue(currentValueLocation, tmpDouble);
				    tmpGlobalMappingElement.incrementTotalExclusiveValue(tmpDouble);
				}
                  
				tmpDouble1 = tmpGlobalThreadDataElement.getInclusiveValue(opA);
				tmpDouble2 = tmpGlobalThreadDataElement.getInclusiveValue(opB);
                  
				if(tmpDouble2 != 0){
				    tmpDouble = tmpDouble1/tmpDouble2;
				    tmpGlobalThreadDataElement.setInclusiveValue(currentValueLocation, tmpDouble);
				    if((thread.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
					thread.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				    thread.incrementTotalInclusiveValue(tmpDouble);
                    
				    //Now do the global mapping element inclusive stuff.
				    if((tmpGlobalMappingElement.getMaxInclusiveValue(currentValueLocation)) < tmpDouble)
					tmpGlobalMappingElement.setMaxInclusiveValue(currentValueLocation, tmpDouble);
				    tmpGlobalMappingElement.incrementTotalInclusiveValue(tmpDouble);
				}
              
				break;
			    default:
				break;
			    }
			}
		    }
          
		    //Now try setting the percent values.
		    for(Enumeration e7 = thread.getFunctionList().elements(); e7.hasMoreElements() ;){
			tmpGlobalThreadDataElement = (GlobalThreadDataElement) e7.nextElement();
            
			double exclusiveTotal = thread.getTotalExclusiveValue();
			double inclusiveMax = thread.getMaxInclusiveValue(currentValueLocation);
            
			boolean excl = false;
			boolean incl = false;
            
			if(exclusiveTotal != 0)
			    excl = true;
              
			if(inclusiveMax != 0)
			    incl = true;
            
            
			//Only want to add an element if this mapping existed on this thread.
			//Check for this.
			if(tmpGlobalThreadDataElement != null){
			    int mappingID = tmpGlobalThreadDataElement.getMappingID();
			    GlobalMappingElement tmpGlobalMappingElement = globalMapping.getGlobalMappingElement(mappingID, 0);
            
			    double tmpDouble1 = tmpGlobalThreadDataElement.getExclusiveValue(currentValueLocation);
			    double tmpDouble2 = tmpGlobalThreadDataElement.getInclusiveValue(currentValueLocation);
              
			    if(excl){
				double result = (tmpDouble1/exclusiveTotal) * 100;
				tmpGlobalThreadDataElement.setExclusivePercentValue(currentValueLocation, result);
				if((thread.getMaxExclusivePercentValue(currentValueLocation)) < result)
				    thread.setMaxExclusivePercentValue(currentValueLocation, result);
                
				//Now do the global mapping element exclusive stuff.
				if((tmpGlobalMappingElement.getMaxExclusivePercentValue(currentValueLocation)) < result)
				    tmpGlobalMappingElement.setMaxExclusivePercentValue(currentValueLocation, result);
			    }
              
			    if(incl){
				double result = (tmpDouble2/inclusiveMax) * 100;
				tmpGlobalThreadDataElement.setInclusivePercentValue(currentValueLocation, result);
				if((thread.getMaxInclusivePercentValue(currentValueLocation)) < result){
				    thread.setMaxInclusivePercentValue(currentValueLocation, result);}
                  
				//Now do the global mapping element exclusive stuff.
				if((tmpGlobalMappingElement.getMaxInclusivePercentValue(currentValueLocation)) < result)
				    tmpGlobalMappingElement.setMaxInclusivePercentValue(currentValueLocation, result);
			    }
              
			}
		    }
		}
	    }
	}
    
	//Ok,  now compute some mean values.
	for(Enumeration e10 = (this.globalMapping.getMapping(0)).elements(); e10.hasMoreElements() ;){
                  
	    GlobalMappingElement tmpGME = (GlobalMappingElement) e10.nextElement();
      
	    if((tmpGME.getCounter()) != 0){
		double tmpDouble = (tmpGME.getTotalExclusiveValue())/(tmpGME.getCounter());
		//Increment the total values.
		this.setTotalMeanExclusiveValue(this.getCurValLoc(),(this.getTotalMeanExclusiveValue(this.getCurValLoc())) + tmpDouble);
		tmpGME.setMeanExclusiveValue(this.getCurValLoc(), tmpDouble);
		if((this.getMaxMeanExclusiveValue(this.getCurValLoc()) < tmpDouble))
		    this.setMaxMeanExclusiveValue(this.getCurValLoc(), tmpDouble);
        
		tmpDouble = (tmpGME.getTotalInclusiveValue())/(tmpGME.getCounter());
		//Increment the total values.
		this.setTotalMeanInclusiveValue(this.getCurValLoc(),(this.getTotalMeanInclusiveValue(this.getCurValLoc())) + tmpDouble);
		tmpGME.setMeanInclusiveValue(this.getCurValLoc(), tmpDouble);
		if((this.getMaxMeanInclusiveValue(this.getCurValLoc()) < tmpDouble))
		    this.setMaxMeanInclusiveValue(this.getCurValLoc(), tmpDouble);
	    }
	}
    
	double exclusiveTotal = this.getTotalMeanExclusiveValue(this.getCurValLoc());
	double inclusiveMax = this.getMaxMeanInclusiveValue(this.getCurValLoc());
    
	boolean excl = false;
	boolean incl = false;
    
	if(exclusiveTotal != 0)
	    excl = true;
      
	if(inclusiveMax != 0)
	    incl = true;
    
	//Now do the percent values.
	for(Enumeration e11 = (this.globalMapping.getMapping(0)).elements(); e11.hasMoreElements() ;){
                  
	    GlobalMappingElement tmpGME = (GlobalMappingElement) e11.nextElement();
      
	    if(excl){
		double tmpDouble = ((tmpGME.getMeanExclusiveValue(this.getCurValLoc()))/exclusiveTotal) * 100;
		tmpGME.setMeanExclusivePercentValue(currentValueLocation, tmpDouble);
		if((this.getMaxMeanExclusivePercentValue(this.getCurValLoc()) < tmpDouble))
		    this.setMaxMeanExclusivePercentValue(this.getCurValLoc(), tmpDouble);
	    }
      
	    if(incl){
		double tmpDouble = ((tmpGME.getMeanInclusiveValue(this.getCurValLoc()))/inclusiveMax) * 100;
		tmpGME.setMeanInclusivePercentValue(this.getCurValLoc(), tmpDouble);
		if((this.getMaxMeanInclusivePercentValue(this.getCurValLoc()) < tmpDouble))
		    this.setMaxMeanInclusivePercentValue(this.getCurValLoc(), tmpDouble);
	    }
	}
	return newValue;
    }
  
    //******************************
    //End - Operation functions to work on the stored data.
    //******************************
  
    //******************************
    //Useful functions to help the drawing windows.
    //
    //For the most part, these functions just return data
    //items that are easier to calculate whilst building the global
    //lists
    //******************************
    public int getNumberOfMappings(){
	return numberOfMappings;
    }
  
    public int getNumberOfUserEvents(){
	return numberOfUserEvents;
    }
  
    public void setMaxMeanInclusiveValue(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	maxMeanInclusiveValueList.add(dataValueLocation, tmpDouble);}
  
    public double getMaxMeanInclusiveValue(int dataValueLocation){
	Double tmpDouble = (Double) maxMeanInclusiveValueList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
  
    public void setMaxMeanExclusiveValue(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	maxMeanExclusiveValueList.add(dataValueLocation, tmpDouble);}
  
    public double getMaxMeanExclusiveValue(int dataValueLocation){
	Double tmpDouble = (Double) maxMeanExclusiveValueList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
  
    public void setMaxMeanInclusivePercentValue(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	maxMeanInclusivePercentValueList.add(dataValueLocation, tmpDouble);}
  
    public double getMaxMeanInclusivePercentValue(int dataValueLocation){
	Double tmpDouble = (Double) maxMeanInclusivePercentValueList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
  
    public void setMaxMeanExclusivePercentValue(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	maxMeanExclusivePercentValueList.add(dataValueLocation, tmpDouble);}
  
    public double getMaxMeanExclusivePercentValue(int dataValueLocation){
	Double tmpDouble = (Double) maxMeanExclusivePercentValueList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
  
    public void setMaxMeanNumberOfCalls(double inDouble){
	maxMeanNumberOfCalls = inDouble;}
  
    public double getMaxMeanNumberOfCalls(){
	return maxMeanNumberOfCalls;}
  
    public void setMaxMeanNumberOfSubRoutines(double inDouble){
	maxMeanNumberOfSubRoutines = inDouble;}
  
    public double getMaxMeanNumberOfSubRoutines(){
	return maxMeanNumberOfSubRoutines;}
  
    public void setMaxMeanUserSecPerCall(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	maxMeanUserSecPerCallList.add(dataValueLocation, tmpDouble);}
  
    public double getMaxMeanUserSecPerCall(int dataValueLocation){
	Double tmpDouble = (Double) maxMeanUserSecPerCallList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
    
    
    public void setTotalMeanInclusiveValue(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	totalMeanInclusiveValueList.add(dataValueLocation, tmpDouble);}
  
    public double getTotalMeanInclusiveValue(int dataValueLocation){
	Double tmpDouble = (Double) totalMeanInclusiveValueList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
  
    public void setTotalMeanExclusiveValue(int dataValueLocation, double inDouble){
	Double tmpDouble = new Double(inDouble);
	totalMeanExclusiveValueList.add(dataValueLocation, tmpDouble);}
  
    public double getTotalMeanExclusiveValue(int dataValueLocation){
	Double tmpDouble = (Double) totalMeanExclusiveValueList.elementAt(dataValueLocation);
	return tmpDouble.doubleValue();}
  
    public boolean groupNamesPresent(){
	return groupNamesPresent;
    }
  
    private void setUserEventsPresent(boolean inBoolean){
	userEventsPresent = inBoolean;
    }
  
    public boolean userEventsPresent(){
	return userEventsPresent;
    }

    private void setCallPathDataPresent(boolean inBoolean){
	callPathDataPresent = inBoolean;
    }
  
    public boolean callPathDataPresent(){
	return callPathDataPresent;
    }
    //******************************
    //End - Useful functions to help the drawing windows.
    //******************************
  
  
    //******************************
    //Instance data.
    //******************************
    Experiment parentExperiment = null;
    DefaultMutableTreeNode nodeRef = null;
    private String trialName = null;
    private int trialID = -1;
    private String trialIDString = null;
  
    private Vector values = new Vector();
  
    private SystemEvents systemEvents = null;
    private StaticMainWindow sMW = null;
    private ColorChooser clrChooser = new ColorChooser(this, null);
    private Preferences  preferences = new  Preferences(this, null);
  
    //The file that the is currently being worked on by the
    //running thread.
    private File currentFile = null;
  
    //Flag indicating whether we have already processed a file in
    //this trial.  This cuts down on repeated work.
    private boolean firstRun = true;    
  
    private String profilePathName = null;
    private String profilePathNameReverse = null;
    //private Vector valueNameList = new Vector(); 
    private int currentValueLocation = 0;
    private int currentValueWriteLocation = 0;    
  
    private GlobalMapping globalMapping;
    private Vector nodes;
    private String counterName;
    private boolean isUserEventHeadingSet;
    boolean groupNamesCheck = false;
    boolean groupNamesPresent = false;
    boolean userEventsPresent = false;
    boolean callPathDataPresent = false;
    int bSDCounter;

    private int numberOfMappings = -1;
    private int numberOfUserEvents = -1;
    private int totalNumberOfContexts = -1;
    private int totalNumberOfThreads = -1;
    private int[] nct = null;
  
    //Max mean values.
    private Vector maxMeanInclusiveValueList = new Vector();
    private Vector maxMeanExclusiveValueList = new Vector();
    private Vector maxMeanInclusivePercentValueList = new Vector();
    private Vector maxMeanExclusivePercentValueList = new Vector();
    private double maxMeanNumberOfCalls = 0;
    private double maxMeanNumberOfSubRoutines = 0;
    private Vector maxMeanUserSecPerCallList = new Vector();
  
    private Vector totalMeanInclusiveValueList = new Vector();
    private Vector totalMeanExclusiveValueList = new Vector();
  
  
    //******************************
    //End - Instance data.
    //******************************

}

class UserEventData{
    public int node = -1;
    public int context = -1;
    public int threadID = -1;
    public int id = -1;
    public String name = null;
    public int noc = -1;
    public double max = -1.0;
    public double min = -1.0;
    public double mean = -1.0;
    public double std = -1.0;
}

class UnexpectedStateException extends Exception{
    public UnexpectedStateException(){}
    public UnexpectedStateException(String err){
	super("UnexpectedStateException - message: " + err);
    }
}

