/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.compile;

import org.jatha.Jatha;
import org.jatha.compile.EvalPrimitive;
import org.jatha.compile.LispCompiler;
import org.jatha.compile.LispPrimitive;
import org.jatha.compile.SetfSymbolValuePrimitive;
import org.jatha.dynatype.LispValue;
import org.jatha.machine.SECDMachine;

class DefvarPrimitive
extends LispPrimitive {
    public DefvarPrimitive(Jatha lisp) {
        super(lisp, "DEFVAR", 1L, 3L);
    }

    public void Execute(SECDMachine machine) {
        LispValue args = machine.S.pop();
        LispValue sym = args.first();
        LispValue val = args.second();
        sym.set_special(true);
        if (args.basic_length() == 2 && sym.boundp() == this.f_lisp.NIL) {
            machine.C.pop();
            machine.C.push(new SetfSymbolValuePrimitive(this.f_lisp));
            machine.C.push(new EvalPrimitive(this.f_lisp));
            machine.S.push(sym);
            machine.S.push(val);
        } else {
            machine.S.push(sym);
            machine.C.pop();
        }
    }

    public LispValue CompileArgs(LispCompiler compiler, SECDMachine machine, LispValue args, LispValue valueList, LispValue code) {
        return compiler.compileConstantArgsLeftToRight(machine, args, valueList, this.f_lisp.makeCons(machine.LIS, this.f_lisp.makeCons(args.length(), code)));
    }
}

