/*
 * Decompiled with CFR 0.152.
 */
package org.jatha.dynatype;

import java.io.PrintStream;
import org.jatha.Jatha;
import org.jatha.dynatype.LispIndexOutOfRangeException;
import org.jatha.dynatype.LispInteger;
import org.jatha.dynatype.LispString;
import org.jatha.dynatype.LispValue;
import org.jatha.dynatype.LispValueNotAnIntegerException;
import org.jatha.dynatype.StandardLispAtom;
import org.jatha.dynatype.StandardLispCharacter;
import org.jatha.dynatype.StandardLispInteger;

public class StandardLispString
extends StandardLispAtom
implements LispString {
    private String str;

    public StandardLispString() {
    }

    public StandardLispString(Jatha lisp, String strName) {
        super(lisp);
        this.str = strName;
    }

    public String getValue() {
        return this.str;
    }

    public void internal_princ(PrintStream os) {
        os.print(this.str);
    }

    public void internal_prin1(PrintStream os) {
        os.print("\"" + this.str + "\"");
    }

    public void internal_print(PrintStream os) {
        os.print("\"" + this.str + "\"");
    }

    public Object toJava() {
        return this.str;
    }

    public String toString() {
        return "\"" + this.str + "\"";
    }

    public String toStringSimple() {
        return this.str;
    }

    public boolean basic_constantp() {
        return true;
    }

    public boolean basic_stringp() {
        return true;
    }

    public LispValue concatenate(LispValue value) {
        if (value instanceof LispString) {
            return new StandardLispString(this.f_lisp, this.str + value.toStringSimple());
        }
        return new StandardLispString(this.f_lisp, this.str + value.toString());
    }

    public LispValue elt(int index) {
        return this.elt(new StandardLispInteger(this.f_lisp, index));
    }

    public LispValue elt(LispValue index) {
        if (!index.basic_integerp()) {
            throw new LispValueNotAnIntegerException("to ELT");
        }
        long indexValue = ((LispInteger)index).getLongValue();
        if (indexValue < 0L || indexValue >= (long)this.str.length()) {
            throw new LispIndexOutOfRangeException(String.valueOf(indexValue) + " to ELT");
        }
        return new StandardLispCharacter(this.f_lisp, this.str.charAt((int)indexValue));
    }

    public LispValue eql(LispValue other) {
        if (other instanceof LispString && this.str.equals(((LispString)other).getValue())) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }

    public LispValue equal(LispValue other) {
        return this.eql(other);
    }

    public boolean equals(LispValue other) {
        return this.eql(other) == this.f_lisp.T;
    }

    public LispValue first() {
        return this.elt(0);
    }

    public LispValue second() {
        return this.elt(1);
    }

    public LispValue third() {
        return this.elt(2);
    }

    public LispValue fourth() {
        return this.elt(3);
    }

    public LispValue fifth() {
        return this.elt(4);
    }

    public LispValue sixth() {
        return this.elt(5);
    }

    public LispValue seventh() {
        return this.elt(6);
    }

    public LispValue eighth() {
        return this.elt(7);
    }

    public LispValue ninth() {
        return this.elt(8);
    }

    public LispValue tenth() {
        return this.elt(9);
    }

    public LispValue length() {
        return new StandardLispInteger(this.f_lisp, this.str.length());
    }

    public LispValue stringp() {
        return this.f_lisp.T;
    }

    public LispValue substring(LispValue start) {
        return this.substring(start, new StandardLispInteger(this.f_lisp, this.str.length()));
    }

    public LispValue substring(LispValue start, LispValue end) {
        if (start instanceof LispInteger) {
            if (end instanceof LispInteger) {
                long i_begin = ((LispInteger)start).getLongValue();
                long i_end = ((LispInteger)end).getLongValue();
                long length = this.str.length();
                if (i_begin < 0L) {
                    throw new LispIndexOutOfRangeException("The start index of substring (" + i_begin + ")");
                }
                if (i_end < 0L) {
                    throw new LispIndexOutOfRangeException("The end index of substring (" + i_end + ")");
                }
                if (i_begin >= length || i_begin >= i_end) {
                    return new StandardLispString(this.f_lisp, "");
                }
                return new StandardLispString(this.f_lisp, this.str.substring((int)i_begin, (int)i_end));
            }
            throw new LispValueNotAnIntegerException("The operand of substring (" + start + ")");
        }
        throw new LispValueNotAnIntegerException("The operand of substring (" + end + ")");
    }

    public LispValue type_of() {
        return this.f_lisp.STRING_TYPE;
    }

    public LispValue typep(LispValue type) {
        LispValue result = super.typep(type);
        if (result == this.f_lisp.T || type == this.f_lisp.STRING_TYPE) {
            return this.f_lisp.T;
        }
        return this.f_lisp.NIL;
    }
}

