/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Application {
    private int applicationID;
    private String name;
    private String version;
    private String description;
    private String language;
    private String paradigm;
    private String usage;
    private String executableOptions;
    private String userData;

    public int getID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getParaDiag() {
        return this.paradigm;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getExecutableOptions() {
        return this.executableOptions;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setParaDiag(String string) {
        this.paradigm = string;
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public void setExecutableOptions(String string) {
        this.executableOptions = string;
    }

    public void setUserData(String string) {
        this.userData = string;
    }

    public static Vector getApplicationList(DB dB, String string) {
        Vector<Application> vector = new Vector<Application>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select * from application ");
        stringBuffer.append(string);
        stringBuffer.append(" order by name asc ");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Application application = new Application();
                application.setID(resultSet.getInt(1));
                application.setName(resultSet.getString(2));
                application.setVersion(resultSet.getString(3));
                application.setDescription(resultSet.getString(4));
                application.setLanguage(resultSet.getString(5));
                application.setParaDiag(resultSet.getString(6));
                application.setUsage(resultSet.getString(7));
                application.setExecutableOptions(resultSet.getString(8));
                application.setUserData(resultSet.getString(9));
                vector.addElement(application);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public int saveApplication(DB dB) {
        boolean bl = this.exists(dB);
        int n = 0;
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = bl ? dB.prepareStatement("UPDATE APPLICATION SET name = ?, version = ?, description = ?, language = ?, paradigm = ?, usage_text = ?, execution_options = ?, userdata = ? WHERE id = ?") : dB.prepareStatement("INSERT INTO APPLICATION (name, version, description, language, paradigm, usage_text, execution_options, userdata) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setString(1, this.name);
            preparedStatement.setString(2, this.version);
            preparedStatement.setString(3, this.description);
            preparedStatement.setString(4, this.language);
            preparedStatement.setString(5, this.paradigm);
            preparedStatement.setString(6, this.usage);
            preparedStatement.setString(7, this.executableOptions);
            preparedStatement.setString(8, this.userData);
            if (bl) {
                preparedStatement.setInt(9, this.applicationID);
            }
            preparedStatement.executeUpdate();
            if (bl) {
                n = this.applicationID;
            } else {
                String string = new String();
                if (dB.getDBType().compareTo("mysql") == 0) {
                    string = "select LAST_INSERT_ID();";
                }
                string = dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM application" : "select currval('application_id_seq');";
                n = Integer.parseInt(dB.getDataItem(string));
            }
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the application.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        return n;
    }

    private boolean exists(DB dB) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM application WHERE id = ?");
            preparedStatement.setInt(1, this.applicationID);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the application.");
            sQLException.printStackTrace();
            System.exit(0);
        }
        return bl;
    }

    public static void deleteApplication(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from application where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while deleting the application.");
            sQLException.printStackTrace();
            System.exit(0);
        }
    }
}

