/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DataSessionIterator;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.GlobalSortedMappingElement;
import edu.uoregon.tau.dms.dss.UtilFncs;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Vector;

public class GlobalMapping {
    private Vector[] mappings = new Vector[3];
    private Vector[] sortedMappings = new Vector[3];
    private Vector maxMeanInclusiveValueList = new Vector();
    private Vector maxMeanExclusiveValueList = new Vector();
    private Vector maxMeanInclusivePercentValueList = new Vector();
    private Vector maxMeanExclusivePercentValueList = new Vector();
    private double maxMeanNumberOfCalls = 0.0;
    private double maxMeanNumberOfSubRoutines = 0.0;
    private Vector maxMeanUserSecPerCallList = new Vector();
    private int selectedGroupID = -1;
    private int groupFilter = 0;

    public GlobalMapping() {
        this.mappings[0] = new Vector();
        this.mappings[1] = new Vector();
        this.mappings[2] = new Vector();
        this.sortedMappings[0] = new Vector();
        this.sortedMappings[1] = new Vector();
        this.sortedMappings[2] = new Vector();
    }

    public void increaseVectorStorage() {
        this.maxMeanInclusiveValueList.add(new Double(0.0));
        this.maxMeanExclusiveValueList.add(new Double(0.0));
        this.maxMeanInclusivePercentValueList.add(new Double(0.0));
        this.maxMeanExclusivePercentValueList.add(new Double(0.0));
        this.maxMeanUserSecPerCallList.add(new Double(0.0));
    }

    public int addGlobalMapping(String string, int n, int n2) {
        int n3 = -1;
        int n4 = this.getSortedMappingPosition(string, n);
        if (n4 < 0) {
            n3 = this.mappings[n].size();
            GlobalMappingElement globalMappingElement = new GlobalMappingElement(n2);
            globalMappingElement.setMappingName(string);
            globalMappingElement.setMappingID(n3);
            this.mappings[n].addElement(globalMappingElement);
            GlobalSortedMappingElement globalSortedMappingElement = new GlobalSortedMappingElement(string, n3);
            this.sortedMappings[n].insertElementAt(globalSortedMappingElement, -(n4 + 1));
        } else {
            GlobalSortedMappingElement globalSortedMappingElement = this.getGlobalSortedMappingElement(n4, n);
            n3 = globalSortedMappingElement.getMappingID();
        }
        return n3;
    }

    public int getMappingID(String string, int n) {
        GlobalSortedMappingElement globalSortedMappingElement = null;
        globalSortedMappingElement = this.getGlobalSortedMappingElement(string, n);
        if (globalSortedMappingElement != null) {
            return globalSortedMappingElement.getMappingID();
        }
        return -1;
    }

    public GlobalMappingElement getGlobalMappingElement(int n, int n2) {
        GlobalMappingElement globalMappingElement = null;
        try {
            globalMappingElement = (GlobalMappingElement)this.mappings[n2].elementAt(n);
        }
        catch (Exception exception) {
            UtilFncs.systemError(exception, null, "GM04");
        }
        return globalMappingElement;
    }

    public GlobalMappingElement getGlobalMappingElement(String string, int n) {
        return (GlobalMappingElement)this.mappings[n].elementAt(this.getMappingID(string, n));
    }

    public int getNumberOfMappings(int n) {
        return this.mappings[n].size();
    }

    public Vector getMapping(int n) {
        return this.mappings[n];
    }

    public ListIterator getMappingIterator(int n) {
        return new DataSessionIterator(this.mappings[n]);
    }

    public void addGroup(int n, int n2, int n3) {
        GlobalMappingElement globalMappingElement = this.getGlobalMappingElement(n, n3);
        globalMappingElement.addGroup(n2);
    }

    public boolean isGroupMember(int n, int n2, int n3) {
        GlobalMappingElement globalMappingElement = this.getGlobalMappingElement(n, n3);
        return globalMappingElement.isGroupMember(n2);
    }

    public boolean displayMapping(int n) {
        switch (this.groupFilter) {
            case 0: {
                return true;
            }
            case 1: {
                return this.isGroupMember(n, this.getSelectedGroupID(), 0);
            }
            case 2: {
                return !this.isGroupMember(n, this.getSelectedGroupID(), 0);
            }
        }
        return true;
    }

    public void setSelectedGroupID(int n) {
        this.selectedGroupID = n;
    }

    public int getSelectedGroupID() {
        return this.selectedGroupID;
    }

    public void setGroupFilter(int n) {
        this.groupFilter = n;
    }

    public int getGroupFilter() {
        return this.groupFilter;
    }

    public void setMeanExclusiveValueAt(int n, double d, int n2, int n3) {
        GlobalMappingElement globalMappingElement = this.getGlobalMappingElement(n2, n3);
        globalMappingElement.setMeanExclusiveValue(n, d);
    }

    public void setMeanInclusiveValueAt(int n, double d, int n2, int n3) {
        GlobalMappingElement globalMappingElement = this.getGlobalMappingElement(n2, n3);
        globalMappingElement.setMeanInclusiveValue(n, d);
    }

    public void setTotalExclusiveValueAt(int n, double d, int n2, int n3) {
        GlobalMappingElement globalMappingElement = this.getGlobalMappingElement(n2, n3);
        globalMappingElement.setTotalExclusiveValue(n, d);
    }

    public void setTotalInclusiveValueAt(int n, double d, int n2, int n3) {
        GlobalMappingElement globalMappingElement = this.getGlobalMappingElement(n2, n3);
        globalMappingElement.setTotalInclusiveValue(n, d);
    }

    public void setMaxMeanInclusiveValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanInclusiveValueList.add(n, d2);
    }

    public void setMaxMeanExclusiveValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanExclusiveValueList.add(n, d2);
    }

    public void setMaxMeanInclusivePercentValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanInclusivePercentValueList.add(n, d2);
    }

    public void setMaxMeanExclusivePercentValue(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanExclusivePercentValueList.add(n, d2);
    }

    public void setMaxMeanNumberOfCalls(double d) {
        this.maxMeanNumberOfCalls = d;
    }

    public void setMaxMeanNumberOfSubRoutines(double d) {
        this.maxMeanNumberOfSubRoutines = d;
    }

    public void setMaxMeanUserSecPerCall(int n, double d) {
        Double d2 = new Double(d);
        this.maxMeanUserSecPerCallList.add(n, d2);
    }

    public double getMaxMeanExclusiveValue(int n) {
        Double d = (Double)this.maxMeanExclusiveValueList.elementAt(n);
        return d;
    }

    public double getMaxMeanInclusiveValue(int n) {
        Double d = (Double)this.maxMeanInclusiveValueList.elementAt(n);
        return d;
    }

    public double getMaxMeanInclusivePercentValue(int n) {
        Double d = (Double)this.maxMeanInclusivePercentValueList.elementAt(n);
        return d;
    }

    public double getMaxMeanExclusivePercentValue(int n) {
        Double d = (Double)this.maxMeanExclusivePercentValueList.elementAt(n);
        return d;
    }

    public double getMaxMeanNumberOfCalls() {
        return this.maxMeanNumberOfCalls;
    }

    public double getMaxMeanNumberOfSubRoutines() {
        return this.maxMeanNumberOfSubRoutines;
    }

    public double getMaxMeanUserSecPerCall(int n) {
        Double d = (Double)this.maxMeanUserSecPerCallList.elementAt(n);
        return d;
    }

    private GlobalSortedMappingElement getGlobalSortedMappingElement(String string, int n) {
        int n2 = this.getSortedMappingPosition(string, n);
        if (n2 >= 0) {
            return this.getGlobalSortedMappingElement(n2, n);
        }
        return null;
    }

    private GlobalSortedMappingElement getGlobalSortedMappingElement(int n, int n2) {
        return (GlobalSortedMappingElement)this.sortedMappings[n2].elementAt(n);
    }

    private int getSortedMappingPosition(String string, int n) {
        return Collections.binarySearch(this.sortedMappings[n], new GlobalSortedMappingElement(string, -1));
    }
}

