/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.GlobalMapping;
import edu.uoregon.tau.dms.dss.GlobalMappingElement;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.MappingDataWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.SMWThreadDataElement;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class MappingDataWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private ParaProfTrial trial = null;
    private MappingDataWindow mDWindow = null;
    private Vector list = null;
    private int mappingID = -1;
    GlobalMappingElement gME = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int barXCoord = 0;
    private int lastHeaderEndPosition = 0;
    int xPanelSize = 0;
    int yPanelSize = 0;
    private JPopupMenu popup1 = new JPopupMenu();
    private JPopupMenu popup2 = new JPopupMenu();
    private JPopupMenu popup3 = new JPopupMenu();
    private Object clickedOnObject = null;
    private boolean debug = false;

    public MappingDataWindowPanel() {
        try {
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            this.repaint();
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP01");
        }
    }

    public MappingDataWindowPanel(ParaProfTrial paraProfTrial, int n, MappingDataWindow mappingDataWindow, boolean bl) {
        try {
            this.trial = paraProfTrial;
            this.mDWindow = mappingDataWindow;
            this.debug = bl;
            this.gME = paraProfTrial.getGlobalMapping().getGlobalMappingElement(n, 0);
            this.mappingID = n;
            this.barLength = this.baseBarLength;
            this.setBackground(Color.white);
            this.addMouseListener(this);
            JMenuItem jMenuItem = new JMenuItem("Show Mean Total Statistics Windows");
            jMenuItem.addActionListener(this);
            this.popup1.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Mean Call Path edu.uoregon.tau.dms.dss.Thread Relations");
            jMenuItem.addActionListener(this);
            this.popup1.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Total Statistics Windows");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Total User Event Statistics Windows");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Call Path edu.uoregon.tau.dms.dss.Thread Relations");
            jMenuItem.addActionListener(this);
            this.popup2.add(jMenuItem);
            jMenuItem = new JMenuItem("Change Function Color");
            jMenuItem.addActionListener(this);
            this.popup3.add(jMenuItem);
            jMenuItem = new JMenuItem("Reset to Generic Color");
            jMenuItem.addActionListener(this);
            this.popup3.add(jMenuItem);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP02");
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, 0, false);
        }
        catch (Exception exception) {
            System.out.println(exception);
            UtilFncs.systemError((Object)exception, null, (String)"TDWP03");
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (pageFormat.getOrientation() == 1) {
            System.out.println("PORTRAIT");
        } else if (pageFormat.getOrientation() == 0) {
            System.out.println("LANDSCAPE");
        }
        if (n >= 3) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.renderIt(graphics2D, 2, false);
        return 0;
    }

    public void renderIt(Graphics2D graphics2D, int n, boolean bl) {
        try {
            if (this.debug()) {
                System.out.println("####################################");
                System.out.println("MappingDataWindowPanel.renderIt(...)");
                System.out.println("####################################");
            }
            this.list = this.mDWindow.getData();
            double d = 0.0;
            double d2 = 0.0;
            int n2 = 0;
            int n3 = 0;
            this.barXCoord = this.barLength + this.textOffset;
            SMWThreadDataElement sMWThreadDataElement = null;
            this.trial.getPreferences().setBarDetails(graphics2D);
            this.barSpacing = this.trial.getPreferences().getBarSpacing();
            this.barHeight = this.trial.getPreferences().getBarHeight();
            Font font = new Font(this.trial.getPreferences().getParaProfFont(), this.trial.getPreferences().getFontStyle(), this.barHeight);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            switch (this.mDWindow.getValueType()) {
                case 2: {
                    if (this.mDWindow.isPercent()) {
                        d2 = this.gME.getMaxExclusivePercentValue(this.trial.getSelectedMetricID());
                        d = this.gME.getMeanExclusivePercentValue(this.trial.getSelectedMetricID());
                        break;
                    }
                    d2 = this.gME.getMaxExclusiveValue(this.trial.getSelectedMetricID());
                    d = this.gME.getMeanExclusiveValue(this.trial.getSelectedMetricID());
                    break;
                }
                case 4: {
                    if (this.mDWindow.isPercent()) {
                        d2 = this.gME.getMaxInclusivePercentValue(this.trial.getSelectedMetricID());
                        d = this.gME.getMeanInclusivePercentValue(this.trial.getSelectedMetricID());
                        break;
                    }
                    d2 = this.gME.getMaxInclusiveValue(this.trial.getSelectedMetricID());
                    d = this.gME.getMeanInclusiveValue(this.trial.getSelectedMetricID());
                    break;
                }
                case 6: {
                    d2 = this.gME.getMaxNumberOfCalls();
                    d = this.gME.getMeanNumberOfCalls();
                    break;
                }
                case 8: {
                    d2 = this.gME.getMaxNumberOfSubRoutines();
                    d = this.gME.getMeanNumberOfSubRoutines();
                    break;
                }
                case 10: {
                    d2 = this.gME.getMaxUserSecPerCall(this.trial.getSelectedMetricID());
                    d = this.gME.getMeanUserSecPerCall(this.trial.getSelectedMetricID());
                    break;
                }
                default: {
                    UtilFncs.systemError(null, null, (String)("Unexpected type - MDWP value: " + this.mDWindow.getValueType()));
                }
            }
            if (this.debug()) {
                System.out.println("Max value: " + d2);
                System.out.println("Mean value: " + d);
            }
            if (this.mDWindow.isPercent()) {
                n2 = fontMetrics.stringWidth(UtilFncs.adjustDoublePresision((double)d2, (int)ParaProf.defaultNumberPrecision) + "%");
                this.barXCoord += n2;
            } else {
                n2 = fontMetrics.stringWidth(UtilFncs.getOutputString((int)this.mDWindow.units(), (double)d2, (int)ParaProf.defaultNumberPrecision));
                this.barXCoord += n2;
            }
            if (this.resizePanel(fontMetrics, this.barXCoord) && n == 0) {
                this.revalidate();
                return;
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (n == 0 || n == 1) {
                if (n == 0) {
                    rectangle = graphics2D.getClipBounds();
                    n4 = (int)rectangle.getY();
                    n5 = (int)((double)n4 + rectangle.getHeight());
                } else {
                    rectangle2 = this.mDWindow.getViewRect();
                    n4 = (int)rectangle2.getY();
                    n5 = (int)((double)n4 + rectangle2.getHeight());
                }
                n6 = (n4 - n3) / this.barSpacing - 1;
                n7 = (n5 - n3) / this.barSpacing + 1;
                if (n6 < 0) {
                    n6 = 0;
                }
                if (n7 < 0) {
                    n7 = 0;
                }
                if (n6 > this.list.size() - 1) {
                    n6 = this.list.size() - 1;
                }
                if (n7 > this.list.size() - 1) {
                    n7 = this.list.size() - 1;
                }
                if (n == 0) {
                    n3 += n6 * this.barSpacing;
                }
            } else if (n == 2 || n == 3) {
                n6 = 0;
                n7 = this.list.size() - 1;
            }
            boolean bl2 = this.gME.isGroupMember(this.trial.getColorChooser().getGroupHighlightColorID());
            if (bl) {
                n3 += this.barSpacing;
                String string = this.mDWindow.getHeaderString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
                while (stringTokenizer.hasMoreTokens()) {
                    graphics2D.drawString(stringTokenizer.nextToken(), 15, n3);
                    n3 += this.barSpacing;
                }
                this.lastHeaderEndPosition = n3;
            }
            n3 += this.barSpacing;
            if (n6 == 0) {
                this.drawBar(graphics2D, fontMetrics, d, d2, "mean", this.barXCoord, n3, this.barHeight, bl2, n);
            }
            for (int i = n6; i <= n7; ++i) {
                sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(i);
                switch (this.mDWindow.getValueType()) {
                    case 2: {
                        if (this.mDWindow.isPercent()) {
                            d = sMWThreadDataElement.getExclusivePercentValue();
                            break;
                        }
                        d = sMWThreadDataElement.getExclusiveValue();
                        break;
                    }
                    case 4: {
                        if (this.mDWindow.isPercent()) {
                            d = sMWThreadDataElement.getInclusivePercentValue();
                            break;
                        }
                        d = sMWThreadDataElement.getInclusiveValue();
                        break;
                    }
                    case 6: {
                        d = sMWThreadDataElement.getNumberOfCalls();
                        break;
                    }
                    case 8: {
                        d = sMWThreadDataElement.getNumberOfSubRoutines();
                        break;
                    }
                    case 10: {
                        d = sMWThreadDataElement.getUserSecPerCall();
                        break;
                    }
                    default: {
                        UtilFncs.systemError(null, null, (String)("Unexpected type - MDWP value: " + this.mDWindow.getValueType()));
                    }
                }
                if (this.debug()) {
                    System.out.println("Value: " + d);
                }
                this.drawBar(graphics2D, fontMetrics, d, d2, "n,c,t " + sMWThreadDataElement.getNodeID() + "," + sMWThreadDataElement.getContextID() + "," + sMWThreadDataElement.getThreadID(), this.barXCoord, n3 += this.barSpacing, this.barHeight, bl2, n);
            }
            if (this.debug()) {
                System.out.println("####################################");
                System.out.println("End - MappingDataWindowPanel.renderIt(...)");
                System.out.println("####################################");
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP03");
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, String string, int n, int n2, int n3, boolean bl, int n4) {
        if (this.debug()) {
            System.out.println("####################################");
            System.out.println("MappingDataWindowPanel.drawBar(...)");
            System.out.println("####################################");
        }
        int n5 = 0;
        double d3 = 0.0;
        String string2 = null;
        int n6 = 0;
        int n7 = 0;
        d3 = d / d2;
        n5 = (int)(d3 * (double)this.barLength);
        if (n5 == 0) {
            n5 = 1;
        }
        if (n5 > 2 && n3 > 2) {
            graphics2D.setColor(this.gME.getColor());
            graphics2D.fillRect(n - n5 + 1, n2 - n3 + 1, n5 - 1, n3 - 1);
            if (this.mappingID == this.trial.getColorChooser().getHighlightColorID()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else if (bl) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
                graphics2D.drawRect(n - n5 + 1, n2 - n3 + 1, n5 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n5, n2 - n3, n5, n3);
            }
        } else {
            if (this.mappingID == this.trial.getColorChooser().getHighlightColorID()) {
                graphics2D.setColor(this.trial.getColorChooser().getHighlightColor());
            } else if (this.gME.isGroupMember(this.trial.getColorChooser().getGroupHighlightColorID())) {
                graphics2D.setColor(this.trial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(this.gME.getColor());
            }
            graphics2D.fillRect(n - n5, n2 - n3, n5, n3);
        }
        graphics2D.setColor(Color.black);
        string2 = this.mDWindow.isPercent() && this.mDWindow.getValueType() <= 4 ? UtilFncs.adjustDoublePresision((double)d, (int)ParaProf.defaultNumberPrecision) + "%" : UtilFncs.getOutputString((int)this.mDWindow.units(), (double)d, (int)ParaProf.defaultNumberPrecision);
        n6 = fontMetrics.stringWidth(string2);
        n7 = n - n5 - n6 - 5;
        graphics2D.drawString(string2, n7, n2);
        graphics2D.drawString(string, n + 5, n2);
        if (this.debug()) {
            System.out.println("####################################");
            System.out.println("End - MappingDataWindowPanel.drawBar(...)");
            System.out.println("####################################");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            SMWThreadDataElement sMWThreadDataElement = null;
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Show Mean Total Statistics Windows")) {
                    StatWindow statWindow = new StatWindow(this.trial, -1, -1, -1, this.mDWindow.getSMWData(), 0, this.debug());
                    this.trial.getSystemEvents().addObserver(statWindow);
                    statWindow.show();
                } else if (string.equals("Show Mean Total User Event Statistics Windows")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID(), this.mDWindow.getSMWData(), 2, this.debug());
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Mean Call Path edu.uoregon.tau.dms.dss.Thread Relations")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        CallPathUtilFuncs.trimCallPathData((GlobalMapping)this.trial.getGlobalMapping(), (Thread)this.trial.getNCT().getThread(sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID()));
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID(), this.mDWindow.getSMWData(), false, this.debug());
                        this.trial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    }
                } else if (string.equals("Show Total Statistics Windows")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID(), this.mDWindow.getSMWData(), 1, this.debug());
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Total User Event Statistics Windows")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        StatWindow statWindow = new StatWindow(this.trial, sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID(), this.mDWindow.getSMWData(), 2, this.debug());
                        this.trial.getSystemEvents().addObserver(statWindow);
                        statWindow.show();
                    }
                } else if (string.equals("Show Call Path edu.uoregon.tau.dms.dss.Thread Relations")) {
                    if (this.clickedOnObject instanceof SMWThreadDataElement) {
                        sMWThreadDataElement = (SMWThreadDataElement)this.clickedOnObject;
                        CallPathUtilFuncs.trimCallPathData((GlobalMapping)this.trial.getGlobalMapping(), (Thread)this.trial.getNCT().getThread(sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID()));
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(this.trial, sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID(), this.mDWindow.getSMWData(), false, this.debug());
                        this.trial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    }
                } else if (string.equals("Change Function Color")) {
                    Color color = this.gME.getColor();
                    JColorChooser jColorChooser = new JColorChooser();
                    if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                        this.gME.setSpecificColor(color);
                        this.gME.setColorFlag(true);
                        this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    }
                } else if (string.equals("Reset to Generic Color")) {
                    this.gME.setColorFlag(false);
                    this.trial.getSystemEvents().updateRegisteredObjects("colorEvent");
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP04");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            SMWThreadDataElement sMWThreadDataElement = null;
            int n4 = n2 / this.trial.getPreferences().getBarSpacing() - 1;
            if (n4 < this.list.size()) {
                if (n4 != -1) {
                    sMWThreadDataElement = (SMWThreadDataElement)this.list.elementAt(n4);
                }
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    this.clickedOnObject = sMWThreadDataElement;
                    if (n > this.barXCoord) {
                        if (n4 == -1) {
                            this.popup1.show(this, mouseEvent.getX(), mouseEvent.getY());
                        } else {
                            this.popup2.show(this, mouseEvent.getX(), mouseEvent.getY());
                        }
                    } else {
                        this.popup3.show(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                } else if (n > this.barXCoord) {
                    if (n4 == -1) {
                        ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.trial, -1, -1, -1, this.mDWindow.getSMWData(), 0, this.debug());
                        this.trial.getSystemEvents().addObserver(threadDataWindow);
                        threadDataWindow.show();
                    } else {
                        ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.trial, sMWThreadDataElement.getNodeID(), sMWThreadDataElement.getContextID(), sMWThreadDataElement.getThreadID(), this.mDWindow.getSMWData(), 1, this.debug());
                        this.trial.getSystemEvents().addObserver(threadDataWindow);
                        threadDataWindow.show();
                    }
                } else if (this.trial.getColorChooser().getHighlightColorID() == -1) {
                    this.trial.getColorChooser().setHighlightColorID(this.mappingID);
                } else if (this.trial.getColorChooser().getHighlightColorID() != this.mappingID) {
                    this.trial.getColorChooser().setHighlightColorID(this.mappingID);
                } else {
                    this.trial.getColorChooser().setHighlightColorID(-1);
                }
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP05");
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getPreferredSize() : this.mDWindow.getSize();
        dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        return dimension;
    }

    public void changeInMultiples() {
        this.computeBarLength();
        this.repaint();
    }

    public void computeBarLength() {
        try {
            double d = this.mDWindow.getSliderValue();
            double d2 = this.mDWindow.getSliderMultiple();
            this.barLength = this.baseBarLength * (int)(d * d2);
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP06");
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        try {
            int n2 = (this.mDWindow.getData().size() + 2) * this.barSpacing + 10;
            int[] nArray = this.trial.getMaxNCTNumbers();
            String string = "n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2];
            int n3 = n + 5 + fontMetrics.stringWidth(string) + 25;
            if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
                this.yPanelSize = n2;
                this.xPanelSize = n3;
                this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
                bl = false;
            }
        }
        catch (Exception exception) {
            UtilFncs.systemError((Object)exception, null, (String)"MDWP07");
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean debug() {
        return this.debug;
    }
}

