/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.enums.CallGraphOption;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class CallGraphWindow
extends JFrame
implements ActionListener,
KeyListener,
ChangeListener,
Observer,
ParaProfImageInterface,
Printable,
ParaProfWindow {
    private static final int MARGIN = 20;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 120;
    private ParaProfTrial ppTrial = null;
    private Thread thread;
    private boolean meanWindow = false;
    private JMenu optionsMenu = null;
    private JMenuItem groupLedger = null;
    private JMenuItem usereventLedger = null;
    private JMenuItem callPathRelations = null;
    private JCheckBoxMenuItem slidersCheckBox = null;
    private Graph graph = null;
    private JScrollPane jGraphPane = null;
    private CallGraphOption widthOption = CallGraphOption.INCLUSIVE;
    private CallGraphOption colorOption = CallGraphOption.EXCLUSIVE;
    private int boxWidth = 120;
    private JLabel boxWidthLabel = new JLabel("Box width");
    private JSlider boxWidthSlider = new JSlider(0, 500, this.boxWidth);
    private Vector functionProfileList;
    private DefaultGraphModel model;
    private Vector graphCellVector;
    private Object[] cells;
    private Vector levels;
    private Vector backEdges;
    private Map vertexMap;
    private int widthMetricID;
    private int colorMetricID;
    private Font font;
    private int boxHeight;
    private Object clickedOnObject = null;
    private double scale = 1.0;

    public CallGraphWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this.ppTrial = paraProfTrial;
        this.colorMetricID = paraProfTrial.getDefaultMetricID();
        this.widthMetricID = paraProfTrial.getDefaultMetricID();
        if (thread.getNodeID() < 0) {
            this.meanWindow = true;
        }
        this.thread = thread;
        if (paraProfTrial.callPathDataPresent()) {
            CallPathUtilFuncs.buildThreadRelations((DataSource)paraProfTrial.getDataSource(), (Thread)thread);
        }
        this.functionProfileList = thread.getFunctionProfiles();
        if (this.meanWindow) {
            this.setTitle("Mean Call Graph - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("Call Graph n,c,t, " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CallGraphWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.boxWidthSlider.setPaintTicks(true);
        this.boxWidthSlider.setMajorTickSpacing(50);
        this.boxWidthSlider.setMinorTickSpacing(10);
        this.boxWidthSlider.setPaintLabels(true);
        this.boxWidthSlider.setSnapToTicks(false);
        this.boxWidthSlider.addChangeListener(this);
        this.boxWidthSlider.addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.font = new Font(paraProfTrial.getPreferencesWindow().getParaProfFont(), paraProfTrial.getPreferencesWindow().getFontStyle(), paraProfTrial.getPreferencesWindow().getBarHeight());
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        ColorBar colorBar = new ColorBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(colorBar, gridBagConstraints, 0, 0, 2, 1);
        this.createGraph();
        Dimension dimension = this.jGraphPane.getPreferredSize();
        dimension.width += 25;
        dimension.height += 95;
        if (dimension.width > 1000) {
            dimension.width = 1000;
        }
        if (dimension.height > 1000) {
            dimension.height = 1000;
        }
        this.setSize(dimension);
        this.setVisible(true);
        ParaProf.incrementNumWindows();
    }

    private Component createWidthMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.widthMetricID && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.widthMetricID = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private Component createColorMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.widthMetricID && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.colorMetricID = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        Object var3_3 = null;
        this.optionsMenu = new JMenu("Options");
        Object var4_4 = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Width Slider", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        jMenu = new JMenu("Box width by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Name Length", CallGraphOption.NAME_LENGTH == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NAME_LENGTH;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenu = new JMenu("Box color by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private double getMaxValue(CallGraphOption callGraphOption, int n) {
        double d = 1.0;
        if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d = this.thread.getMaxExclusive(n);
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d = this.thread.getMaxInclusive(n);
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d = this.thread.getMaxNumCalls();
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d = this.thread.getMaxNumSubr();
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d = this.thread.getMaxInclusivePerCall(n);
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d = this.thread.getMaxExclusivePerCall(n);
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d = 1.0;
        } else if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            d = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d;
    }

    private double getValue(FunctionProfile functionProfile, CallGraphOption callGraphOption, double d, int n) {
        double d2 = 1.0;
        if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d2 = functionProfile.getExclusive(n) / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d2 = functionProfile.getInclusive(n) / d;
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d2 = functionProfile.getNumCalls() / d;
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d2 = functionProfile.getNumSubr() / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d2 = functionProfile.getInclusivePerCall(n) / d;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d2 = functionProfile.getExclusivePerCall(n) / d;
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d2;
    }

    private int getWidth(FunctionProfile functionProfile, double d) {
        int n = 0;
        if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n = fontMetrics.stringWidth(functionProfile.getName()) + 5;
        } else {
            n = (int)((double)this.boxWidth * this.getValue(functionProfile, this.widthOption, d, this.widthMetricID));
        }
        return n;
    }

    private void createGraph() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.vertexMap = new HashMap();
        this.backEdges = new Vector();
        double d = this.getMaxValue(this.widthOption, this.widthMetricID);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetricID);
        for (int i = 0; i < this.functionProfileList.size(); ++i) {
            object4 = (FunctionProfile)this.functionProfileList.elementAt(i);
            if (object4 == null || object4.isCallPathFunction()) continue;
            Vertex vertex = new Vertex((FunctionProfile)object4, this.getWidth((FunctionProfile)object4, d));
            vertex.colorRatio = (float)this.getValue((FunctionProfile)object4, this.colorOption, d2, this.colorMetricID);
            this.vertexMap.put(object4, vertex);
        }
        Stack<FunctionProfile> stack = new Stack<FunctionProfile>();
        object4 = new Stack();
        for (int i = 0; i < this.functionProfileList.size(); ++i) {
            FunctionProfile functionProfile = (FunctionProfile)this.functionProfileList.elementAt(i);
            if (functionProfile == null || functionProfile.isCallPathFunction() || ((Vertex)(object3 = (Vertex)this.vertexMap.get(functionProfile))).visited) continue;
            ((Vector)object4).add(functionProfile);
            stack.add(null);
            object2 = functionProfile.getChildProfiles();
            while (object2.hasNext()) {
                object = (FunctionProfile)object2.next();
                stack.add((FunctionProfile)object);
            }
            while (!stack.empty()) {
                int n2;
                object2 = (FunctionProfile)stack.pop();
                if (object2 == null) {
                    ((Stack)object4).pop();
                    continue;
                }
                object = (Vertex)this.vertexMap.get(object2);
                FunctionProfile functionProfile2 = (FunctionProfile)((Stack)object4).peek();
                Vertex vertex = (Vertex)this.vertexMap.get(functionProfile2);
                boolean bl = false;
                Iterator iterator = ((Vector)object4).iterator();
                while (iterator.hasNext()) {
                    if ((FunctionProfile)iterator.next() != object2) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.backEdges.add(new BackEdge(vertex, (Vertex)object));
                    continue;
                }
                boolean bl2 = false;
                for (n2 = 0; n2 < vertex.children.size(); ++n2) {
                    if (vertex.children.get(n2) != object) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    vertex.children.add(object);
                }
                bl2 = false;
                for (n2 = 0; n2 < ((Vertex)object).parents.size(); ++n2) {
                    if (((Vertex)object).parents.get(n2) != vertex) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    ((Vertex)object).parents.add(vertex);
                }
                if (((Vertex)object).visited) continue;
                ((Vertex)object).visited = true;
                ((Vector)object4).add(object2);
                stack.add(null);
                Iterator iterator2 = object2.getChildProfiles();
                while (iterator2.hasNext()) {
                    FunctionProfile functionProfile3 = (FunctionProfile)iterator2.next();
                    Vertex vertex2 = (Vertex)this.vertexMap.get(functionProfile3);
                    stack.add(functionProfile3);
                }
            }
        }
        Vector vector = this.findRoots(this.vertexMap);
        for (n = 0; n < this.functionProfileList.size(); ++n) {
            object3 = (FunctionProfile)this.functionProfileList.elementAt(n);
            if (object3 == null || object3.isCallPathFunction() || ((Vertex)(object2 = (Vertex)this.vertexMap.get(object3))).level != -1) continue;
            this.assignLevel((Vertex)object2);
        }
        for (n = 0; n < this.functionProfileList.size(); ++n) {
            object3 = (FunctionProfile)this.functionProfileList.elementAt(n);
            if (object3 == null || object3.isCallPathFunction()) continue;
            object2 = (Vertex)this.vertexMap.get(object3);
            this.insertDummies((Vertex)object2);
        }
        for (n = 0; n < this.functionProfileList.size(); ++n) {
            object3 = (FunctionProfile)this.functionProfileList.elementAt(n);
            if (object3 == null || object3.isCallPathFunction()) continue;
            object2 = (Vertex)this.vertexMap.get(object3);
            ((Vertex)object2).visited = false;
        }
        this.levels = new Vector();
        for (n = 0; n < vector.size(); ++n) {
            object3 = (Vertex)vector.elementAt(n);
            this.fillLevels((Vertex)object3, this.levels, 0);
        }
        for (n = 0; n < this.levels.size(); ++n) {
            object3 = (Vector)this.levels.get(n);
            for (int i = 0; i < ((Vector)object3).size(); ++i) {
                object = (Vertex)((Vector)object3).get(i);
            }
        }
        this.runSugiyama(this.levels);
        this.assignPositions(this.levels);
        this.model = new DefaultGraphModel();
        this.graph = new Graph((GraphModel)this.model, this);
        this.graph.addMouseListener(this.graph);
        this.graph.addKeyListener(this);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.graph));
        this.createCustomGraph(this.levels, this.backEdges);
        this.jGraphPane = new JScrollPane((Component)((Object)this.graph));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 0, 0);
    }

    void recreateGraph() {
        for (int i = 0; i < this.graphCellVector.size(); ++i) {
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)this.graphCellVector.get(i);
            defaultGraphCell.removeAllChildren();
        }
        this.model.remove(this.cells);
        this.reassignWidths(this.levels);
        this.assignPositions(this.levels);
        this.createCustomGraph(this.levels, this.backEdges);
    }

    void reassignWidths(Vector vector) {
        double d = this.getMaxValue(this.widthOption, this.widthMetricID);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetricID);
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.get(i);
            for (int j = 0; j < vector2.size(); ++j) {
                Vertex vertex = (Vertex)vector2.get(j);
                if (vertex.function == null) continue;
                FunctionProfile functionProfile = vertex.functionProfile;
                vertex.width = this.getWidth(functionProfile, d);
                if (vertex.width < 5) {
                    vertex.width = 5;
                }
                vertex.colorRatio = (float)this.getValue(functionProfile, this.colorOption, d2, this.colorMetricID);
                vertex.height = this.boxHeight;
            }
        }
    }

    void createCustomGraph(Vector vector, Vector vector2) {
        Vertex vertex;
        int n;
        Object object;
        Vector vector3;
        int n2;
        HashMap hashMap = new HashMap();
        this.graphCellVector = new Vector();
        Vector<Object> vector4 = new Vector<Object>();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            vector3 = (Vector)vector.get(n2);
            for (int i = 0; i < vector3.size(); ++i) {
                Vertex vertex2 = (Vertex)vector3.get(i);
                object = null;
                if (vertex2.function == null) continue;
                object = this.createGraphCell(vertex2, vertex2.position - vertex2.width / 2, 20 + n2 * 120, vertex2.height, vertex2.width, vertex2.colorRatio, hashMap);
                vertex2.graphCell = (GraphCell)((Object)object);
                vector4.add(object);
                this.graphCellVector.add(object);
            }
        }
        n2 = vector4.size();
        vector3 = new ConnectionSet();
        Vector<Object> vector5 = new Vector<Object>();
        for (n = 0; n < vector.size(); ++n) {
            object = (Vector)vector.get(n);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                vertex = (Vertex)((Vector)object).get(i);
                if (vertex.function == null) continue;
                GraphCell graphCell = vertex.graphCell;
                Iterator iterator = vertex.children.iterator();
                while (iterator.hasNext()) {
                    Object object2;
                    Vertex vertex3 = (Vertex)iterator.next();
                    if (vertex3.function != null) {
                        object2 = vertex3.graphCell;
                        DefaultEdge defaultEdge = this.createEdge(graphCell, (DefaultGraphCell)object2, hashMap, (ConnectionSet)vector3, null);
                        vector4.add(defaultEdge);
                        vector5.add(defaultEdge);
                        continue;
                    }
                    object2 = new ArrayList();
                    int n3 = 1;
                    ((ArrayList)object2).add(new Point(3000, 3000));
                    while (vertex3.function == null) {
                        ((ArrayList)object2).add(new Point(vertex3.position, 20 + (n + n3) * 120 + this.boxHeight / 2));
                        vertex3 = (Vertex)vertex3.children.get(0);
                        ++n3;
                    }
                    ((ArrayList)object2).add(new Point(3000, 3000));
                    DefaultEdge defaultEdge = this.createEdge(graphCell, vertex3.graphCell, hashMap, (ConnectionSet)vector3, (ArrayList)object2);
                    vector4.add(defaultEdge);
                    vector5.add(defaultEdge);
                }
            }
        }
        for (n = 0; n < vector2.size(); ++n) {
            object = (BackEdge)vector2.get(n);
            ArrayList<Point> arrayList = new ArrayList<Point>();
            arrayList.add(new Point(3000, 3000));
            arrayList.add(new Point(((BackEdge)object).a.position + ((BackEdge)object).a.width / 2 + 50, ((BackEdge)object).a.level * 120 + 20 + this.boxHeight / 2));
            arrayList.add(new Point(((BackEdge)object).b.position + 25, ((BackEdge)object).b.level * 120 - 25 + 20));
            arrayList.add(new Point(3000, 3000));
            vertex = this.createEdge(((BackEdge)object).a.graphCell, ((BackEdge)object).b.graphCell, hashMap, (ConnectionSet)vector3, arrayList);
            vector4.add(vertex);
            vector5.add(vertex);
        }
        this.cells = vector4.toArray();
        this.model.insert(this.cells, hashMap, (ConnectionSet)vector3, null, null);
        this.moveDownToVisible(vector4, vector5);
    }

    private void moveDownToVisible(Vector vector, Vector vector2) {
        Rectangle2D rectangle2D;
        int n = 0;
        for (int i = 0; i < vector2.size(); ++i) {
            CellView cellView = this.graph.getGraphLayoutCache().getMapping(vector2.get(i), false);
            rectangle2D = cellView.getBounds();
            if (!(rectangle2D.getY() < (double)n)) continue;
            n = (int)rectangle2D.getY();
        }
        if (n != 0) {
            n -= 5;
            HashMap<Rectangle2D, AttributeMap> hashMap = new HashMap<Rectangle2D, AttributeMap>();
            for (int i = 0; i < vector.size(); ++i) {
                rectangle2D = (DefaultGraphCell)vector.get(i);
                AttributeMap attributeMap = rectangle2D.getAttributes();
                CallGraphWindow.translate((Map)attributeMap, 0.0, -n);
                hashMap.put(rectangle2D, attributeMap);
            }
            this.graph.getGraphLayoutCache().edit(hashMap, null, null, null);
        }
    }

    public static void translate(Map map, double d, double d2) {
        if (GraphConstants.isMoveable((Map)map)) {
            List list;
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)map);
            if (rectangle2D != null) {
                int n = GraphConstants.getMoveableAxis((Map)map);
                if (n == 1) {
                    d2 = 0.0;
                } else if (n == 2) {
                    d = 0.0;
                }
                rectangle2D.setFrame(Math.max(0.0, rectangle2D.getX() + d), Math.max(0.0, rectangle2D.getY() + d2), rectangle2D.getWidth(), rectangle2D.getHeight());
                GraphConstants.setBounds((Map)map, (Rectangle2D)rectangle2D);
            }
            if ((list = GraphConstants.getPoints((Map)map)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Object e = list.get(i);
                    if (!(e instanceof Point2D)) continue;
                    Point2D point2D = (Point2D)e;
                    point2D.setLocation(Math.max(0.0, point2D.getX() + d), Math.max(0.0, point2D.getY() + d2));
                }
                GraphConstants.setPoints((Map)map, (List)list);
            }
        }
    }

    void runPhaseOne(Vector vector) {
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 100; i > 0; --i) {
            int n;
            for (n = 0; n < vector.size() - 1; ++n) {
                this.assignBaryCenters((Vector)vector.get(n), (Vector)vector.get(n + 1), true);
                Collections.sort((Vector)vector.get(n));
            }
            for (n = vector.size() - 1; n > 0; --n) {
                this.assignBaryCenters((Vector)vector.get(n), (Vector)vector.get(n - 1), false);
                Collections.sort((Vector)vector.get(n));
            }
        }
    }

    void assignBaryCenters(Vector vector, Vector vector2, boolean bl) {
        Vertex vertex;
        int n;
        for (n = 0; n < vector2.size(); ++n) {
            vertex = (Vertex)vector2.get(n);
            vertex.levelIndex = n;
        }
        for (n = 0; n < vector.size(); ++n) {
            int n2;
            int n3;
            vertex = (Vertex)vector.get(n);
            if (bl) {
                n3 = 0;
                for (n2 = 0; n2 < vertex.children.size(); ++n2) {
                    n3 += ((Vertex)vertex.children.get(n2)).levelIndex;
                }
                if (vertex.children.size() == 0) continue;
                vertex.baryCenter = n3 / vertex.children.size();
                continue;
            }
            n3 = 0;
            for (n2 = 0; n2 < vertex.parents.size(); ++n2) {
                n3 += ((Vertex)vertex.parents.get(n2)).levelIndex;
            }
            if (vertex.parents.size() == 0) continue;
            vertex.baryCenter = n3 / vertex.parents.size();
        }
    }

    void assignGridBaryCenters(Vector vector, boolean bl, boolean bl2) {
        for (int i = 0; i < vector.size(); ++i) {
            int n;
            float f;
            Vertex vertex = (Vertex)vector.get(i);
            if (bl) {
                if (vertex.children.size() == 0) continue;
                f = 0.0f;
                for (n = 0; n < vertex.children.size(); ++n) {
                    f += (float)((Vertex)vertex.children.get(n)).position;
                }
                vertex.gridBaryCenter = f / (float)vertex.children.size();
                continue;
            }
            if (vertex.parents.size() == 0) continue;
            f = 0.0f;
            for (n = 0; n < vertex.parents.size(); ++n) {
                f += (float)((Vertex)vertex.parents.get(n)).position;
            }
            vertex.gridBaryCenter = f / (float)vertex.parents.size();
        }
    }

    void runSugiyama(Vector vector) {
        this.runPhaseOne(vector);
    }

    private void assignPositions(Vector vector) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            Vector vector2 = (Vector)vector.get(n3);
            int n4 = 0;
            ((Vertex)vector2.get(0)).position = 0;
            for (n2 = 1; n2 < vector2.size(); ++n2) {
                Vertex vertex = (Vertex)vector2.get(n2);
                vertex.position = n4 + 10 + (((Vertex)vector2.get(n2 - 1)).width + vertex.width) / 2;
                n4 = vertex.position;
                vertex.downPriority = vertex.children.size();
                if (vertex.function == null) {
                    vertex.downPriority = 2;
                }
                vertex.upPriority = vertex.parents.size();
                if (vertex.function != null) continue;
                vertex.upPriority = 2;
            }
            if (vector2.size() % 2 == 0) {
                int n5 = ((Vertex)vector2.get((vector2.size() - 2) / 2)).position;
                int n6 = ((Vertex)vector2.get(vector2.size() / 2)).position;
                n2 = (n5 + n6) / 2;
            } else {
                n2 = ((Vertex)vector2.get((vector2.size() - 1) / 2)).position;
            }
            for (int i = 0; i < vector2.size(); ++i) {
                Vertex vertex = (Vertex)vector2.get(i);
                vertex.position = vertex.position - n2;
            }
        }
        for (n3 = 1; n3 < vector.size(); ++n3) {
            this.improvePositions(vector, n3, false, false);
        }
        for (n3 = vector.size() - 2; n3 >= 0; --n3) {
            this.improvePositions(vector, n3, true, false);
        }
        for (n3 = 1; n3 < vector.size(); ++n3) {
            this.improvePositions(vector, n3, false, false);
        }
        for (n3 = vector.size() - 2; n3 >= 0; --n3) {
            this.improvePositions(vector, n3, true, true);
        }
        for (n3 = vector.size() - 2; n3 >= 0; --n3) {
            this.improvePositions(vector, n3, true, false);
        }
        n3 = 0;
        for (n = 0; n < vector.size(); ++n) {
            Vector vector3 = (Vector)vector.get(n);
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                Vertex vertex = (Vertex)vector3.get(n2);
                if (vertex.position - vertex.width / 2 >= n3) continue;
                n3 = vertex.position - vertex.width / 2;
            }
        }
        for (n = 0; n < vector.size(); ++n) {
            Vector vector4 = (Vector)vector.get(n);
            for (n2 = 0; n2 < vector4.size(); ++n2) {
                Vertex vertex = (Vertex)vector4.get(n2);
                vertex.position += -n3 + 20;
            }
        }
    }

    private int moveRight(Vector vector, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = (Vertex)vector.get(n);
        int n5 = n + 1;
        if (n5 >= vector.size()) {
            vertex.position = vertex.position + n2;
            return n2;
        }
        Vertex vertex2 = (Vertex)vector.get(n5);
        int n6 = vertex.position + vertex.width / 2;
        if (n6 + n2 + 10 < (n4 = vertex2.position - vertex2.width / 2)) {
            vertex.position = vertex.position + n2;
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.position - (vertex.width + vertex2.width) / 2 - 10;
            int n8 = n7 - vertex.position;
            vertex.position = vertex.position + n8;
            return n8;
        }
        int n9 = vertex.position + n2 + (vertex2.width + vertex.width) / 2 + 10;
        this.moveRight(vector, n5, n9 - vertex2.position, bl, n3);
        int n10 = vertex2.position - (vertex.width + vertex2.width) / 2 - 10;
        int n11 = n10 - vertex.position;
        vertex.position = vertex.position + n11;
        return n11;
    }

    private int moveLeft(Vector vector, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = (Vertex)vector.get(n);
        int n5 = n - 1;
        if (n5 < 0) {
            vertex.position = vertex.position - n2;
            return n2;
        }
        Vertex vertex2 = (Vertex)vector.get(n5);
        int n6 = vertex.position - vertex.width / 2;
        if (n6 - n2 - 10 > (n4 = vertex2.position + vertex2.width / 2)) {
            vertex.position = vertex.position - n2;
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.position + (vertex2.width + vertex.width) / 2 + 10;
            int n8 = vertex.position - n7;
            vertex.position = vertex.position - n8;
            return n8;
        }
        int n9 = vertex.position - n2 - vertex.width / 2 - 10 - vertex2.width / 2;
        this.moveLeft(vector, n5, vertex2.position - n9, bl, n3);
        int n10 = vertex2.position + (vertex2.width + vertex.width) / 2 + 10;
        int n11 = vertex.position - n10;
        vertex.position = vertex.position - n11;
        return n11;
    }

    private void improvePositions(Vector vector, int n, boolean bl, boolean bl2) {
        Vector vector2 = (Vector)vector.get(n);
        this.assignGridBaryCenters(vector2, bl, bl2);
        for (int i = 0; i < vector2.size(); ++i) {
            int n2;
            int n3;
            Vertex vertex = (Vertex)vector2.get(i);
            int n4 = (int)vertex.gridBaryCenter;
            if (bl && vertex.children.size() == 0) continue;
            if (n4 > vertex.position) {
                n3 = this.moveRight(vector2, i, n4 - vertex.position, bl, vertex.getPriority(bl));
                for (n2 = i - 1; n2 >= 0 && bl2; --n2) {
                    this.moveRight(vector2, n2, n3, bl, vertex.getPriority(bl));
                }
                continue;
            }
            n3 = this.moveLeft(vector2, i, vertex.position - n4, bl, vertex.getPriority(bl));
            for (n2 = i + 1; n2 < vector2.size() && bl2; ++n2) {
                this.moveLeft(vector2, n2, n3, bl, vertex.getPriority(bl));
            }
        }
    }

    private void fillLevels(Vertex vertex, Vector vector, int n) {
        if (vertex.visited) {
            return;
        }
        vertex.visited = true;
        if (vector.size() == n) {
            vector.insertElementAt(new Vector(), n);
        }
        vertex.level = n;
        Vector vector2 = (Vector)vector.get(n);
        vector2.add(vertex);
        for (int i = 0; i < vertex.children.size(); ++i) {
            Vertex vertex2 = (Vertex)vertex.children.elementAt(i);
            this.fillLevels(vertex2, vector, n + 1);
        }
    }

    private void insertDummies(Vertex vertex) {
        for (int i = 0; i < vertex.children.size(); ++i) {
            Vertex vertex2 = (Vertex)vertex.children.elementAt(i);
            if (vertex2.level - vertex.level <= 1) continue;
            vertex.children.remove(i);
            vertex2.parents.remove(vertex);
            Vertex vertex3 = new Vertex(null, 1);
            vertex3.level = vertex.level + 1;
            vertex3.children.add(vertex2);
            vertex2.parents.add(vertex3);
            vertex.children.insertElementAt(vertex3, i);
            vertex3.parents.add(vertex);
            this.insertDummies(vertex3);
        }
    }

    private void assignLevel(Vertex vertex) {
        int n = 0;
        for (int i = 0; i < vertex.parents.size(); ++i) {
            Vertex vertex2 = (Vertex)vertex.parents.elementAt(i);
            if (vertex2.level == -1) {
                this.assignLevel(vertex2);
            }
            if (vertex2.level <= n) continue;
            n = vertex2.level;
        }
        vertex.level = n + 1;
    }

    private Vector findRoots(Map map) {
        Vertex vertex;
        Vector<Vertex> vector = new Vector<Vertex>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vertex = (Vertex)iterator.next();
            vertex.visited = false;
        }
        iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vertex = (Vertex)iterator.next();
            for (int i = 0; i < vertex.children.size(); ++i) {
                Vertex vertex2 = (Vertex)vertex.children.get(i);
                vertex2.visited = true;
            }
        }
        iterator = map.values().iterator();
        while (iterator.hasNext()) {
            vertex = (Vertex)iterator.next();
            if (vertex.visited) continue;
            vector.add(vertex);
        }
        return vector;
    }

    public GraphCell createGraphCell(Vertex vertex, int n, int n2, int n3, int n4, float f, Map map) {
        GraphCell graphCell = new GraphCell(vertex);
        Hashtable hashtable = new Hashtable();
        map.put(graphCell, hashtable);
        vertex.xBeg = n;
        vertex.xEnd = n + n4;
        vertex.yBeg = n2;
        vertex.yEnd = n2 + n3;
        Rectangle rectangle = new Rectangle(n, n2, n4, n3);
        GraphConstants.setBounds(hashtable, (Rectangle2D)rectangle);
        GraphConstants.setBorderColor(hashtable, (Color)Color.black);
        if (this.colorOption == CallGraphOption.STATIC) {
            GraphConstants.setBackground(hashtable, (Color)Color.orange);
            GraphConstants.setForeground(hashtable, (Color)Color.black);
        } else {
            GraphConstants.setBackground(hashtable, (Color)ColorBar.getColor(f));
            GraphConstants.setForeground(hashtable, (Color)ColorBar.getContrast(ColorBar.getColor(f)));
        }
        GraphConstants.setOpaque(hashtable, (boolean)true);
        GraphConstants.setEditable(hashtable, (boolean)false);
        GraphConstants.setFont(hashtable, (Font)this.font);
        GraphConstants.setBorder(hashtable, (Border)BorderFactory.createRaisedBevelBorder());
        DefaultPort defaultPort = new DefaultPort();
        graphCell.add((MutableTreeNode)defaultPort);
        return graphCell;
    }

    public DefaultEdge createEdge(DefaultGraphCell defaultGraphCell, DefaultGraphCell defaultGraphCell2, Map map, ConnectionSet connectionSet, ArrayList arrayList) {
        DefaultEdge defaultEdge = new DefaultEdge();
        Hashtable hashtable = new Hashtable();
        map.put(defaultEdge, hashtable);
        if (arrayList != null) {
            GraphConstants.setPoints(hashtable, (List)arrayList);
            GraphConstants.setLineStyle(hashtable, (int)13);
        }
        GraphConstants.setLineEnd(hashtable, (int)1);
        GraphConstants.setEndFill(hashtable, (boolean)true);
        GraphConstants.setDisconnectable(hashtable, (boolean)false);
        if (defaultGraphCell == defaultGraphCell2) {
            DefaultPort defaultPort = new DefaultPort();
            defaultGraphCell.add((MutableTreeNode)defaultPort);
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell.getChildAt(1));
        } else {
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell2.getChildAt(0));
        }
        return defaultEdge;
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.boxWidthLabel);
            container.remove(this.boxWidthSlider);
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public Edge getEdge(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Vertex vertex = (Vertex)this.vertexMap.get(functionProfile);
        Vertex vertex2 = (Vertex)this.vertexMap.get(functionProfile2);
        int n = vertex2.graphCell.getChildCount();
        for (int i = 0; i < n; ++i) {
            Port port = (Port)vertex2.graphCell.getChildAt(i);
            Iterator iterator = port.edges();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (edge.getTarget() != port) continue;
                Port port2 = (Port)edge.getSource();
                Object object = this.model.getParent((Object)port2);
                CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
                GraphCell graphCell = (GraphCell)((Object)cellView.getCell());
                if (graphCell.getVertex() != vertex) continue;
                return edge;
            }
        }
        return null;
    }

    private void handlePrefEvent() {
        Hashtable hashtable = new Hashtable();
        this.font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.ppTrial.getPreferencesWindow().getBarHeight());
        this.setFont(this.font);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        this.recreateGraph();
    }

    public void handleColorEvent() {
        Object object;
        Object object2;
        GraphCell graphCell;
        int n;
        Hashtable hashtable = new Hashtable();
        for (n = 0; n < this.graphCellVector.size(); ++n) {
            graphCell = (GraphCell)((Object)this.graphCellVector.get(n));
            Vertex vertex = graphCell.getVertex();
            vertex.pathHighlight = false;
            int n2 = this.model.getChildCount((Object)graphCell);
            for (int i = 0; i < n2; ++i) {
                object2 = this.model.getChild((Object)graphCell, i);
                Iterator iterator = this.model.edges(object2);
                while (iterator.hasNext()) {
                    object = iterator.next();
                    HashMap hashMap = new HashMap();
                    GraphConstants.setLineColor(hashMap, (Color)Color.black);
                    hashtable.put(object, hashMap);
                }
            }
        }
        for (n = 0; n < this.graphCellVector.size(); ++n) {
            graphCell = (GraphCell)((Object)this.graphCellVector.get(n));
            if (graphCell.function != this.ppTrial.getHighlightedFunction()) continue;
            for (int i = 0; i < this.functionProfileList.size(); ++i) {
                Function function;
                FunctionProfile functionProfile = (FunctionProfile)this.functionProfileList.elementAt(i);
                if (functionProfile == null || !(function = functionProfile.getFunction()).isCallPathFunction() || ((String)(object2 = function.getName())).indexOf(graphCell.getFunction().getName()) == -1) continue;
                int n3 = ((String)object2).indexOf("=>");
                while (n3 != -1) {
                    object = ((String)object2).substring(0, n3);
                    int n4 = ((String)object2).indexOf("=>", n3 + 1);
                    if (n4 == -1) {
                        n4 = ((String)object2).length();
                    }
                    String string = ((String)object2).substring(n3 + 2, n4);
                    FunctionProfile functionProfile2 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction(object));
                    FunctionProfile functionProfile3 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction(string));
                    Vertex vertex = (Vertex)this.vertexMap.get(functionProfile2);
                    vertex.pathHighlight = true;
                    vertex = (Vertex)this.vertexMap.get(functionProfile3);
                    vertex.pathHighlight = true;
                    Edge edge = this.getEdge(functionProfile2, functionProfile3);
                    HashMap hashMap = new HashMap();
                    GraphConstants.setLineColor(hashMap, (Color)Color.blue);
                    if (edge != null) {
                        hashtable.put(edge, hashMap);
                    }
                    object2 = ((String)object2).substring(n3 + 3);
                    n3 = ((String)object2).indexOf("=>");
                }
            }
        }
        for (n = 0; n < this.graphCellVector.size(); ++n) {
            graphCell = (GraphCell)((Object)this.graphCellVector.get(n));
            HashMap hashMap = new HashMap();
            if (graphCell.function == this.ppTrial.getHighlightedFunction()) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getHighlightColor(), this.ppTrial.getColorChooser().getHighlightColor()));
            } else if (graphCell.getVertex().pathHighlight) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, Color.blue, Color.blue));
            } else if (graphCell.function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getGroupHighlightColor(), this.ppTrial.getColorChooser().getGroupHighlightColor()));
            } else {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createRaisedBevelBorder());
            }
            hashtable.put((Object)((Object)graphCell), hashMap);
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (string.equals("prefEvent")) {
            this.handlePrefEvent();
        } else if (string.equals("colorEvent")) {
            this.handleColorEvent();
        } else if (string.equals("dataEvent")) {
            this.setupMenus();
            this.validate();
            this.recreateGraph();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the Call Graph Window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you a graph of call paths present in the profile data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Click on a box to highlight paths that go through that function.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right-click on a box to access the Function Data Window for that function.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Experiment with the \"Box Width by...\" and \"Box Color by...\" menus (under Options) to display different types of data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("If you only see a single line of boxes (no edges connecting them), it probably means that your profile data does not contain call path data.  If you believe this to be incorrect please contact us with the data at tau-bugs@cs.uoregon.edu");
        ParaProf.helpWindow.writeText("");
    }

    public Dimension getViewportSize() {
        return this.jGraphPane.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.jGraphPane.getViewport().getViewRect();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.getSystemEvents().deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public GraphCell getGraphCellForLocation(int n, int n2) {
        for (int i = 0; i < this.graphCellVector.size(); ++i) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellVector.get(i));
            AttributeMap attributeMap = graphCell.getAttributes();
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
            if (!rectangle2D.contains(n, n2)) continue;
            return graphCell;
        }
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.boxWidth = this.boxWidthSlider.getValue();
            this.recreateGraph();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (keyEvent.getKeyChar() == '+') {
                this.scale += 0.1;
                if (this.scale > 5.0) {
                    this.scale = 5.0;
                }
                this.graph.setScale(this.scale);
            } else if (keyEvent.getKeyChar() == '-') {
                this.scale -= 0.1;
                if (this.scale < 0.1) {
                    this.scale = 0.1;
                }
                this.graph.setScale(this.scale);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.getSize();
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.graph.paintAll(graphics2D);
        } else {
            this.graph.paint(graphics2D);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d = this.graph.getScale();
        try {
            this.graph.setDoubleBuffered(false);
            if (n >= 1) {
                int n2 = 1;
                return n2;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.graph.getWidth(), this.graph.getHeight());
            this.graph.paint(graphics);
        }
        finally {
            this.graph.setDoubleBuffered(true);
            this.graph.setScale(d);
        }
        return 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Show Width Slider")) {
                if (this.slidersCheckBox.isSelected()) {
                    this.displaySliders(true);
                } else {
                    this.displaySliders(false);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private class Vertex
    implements Comparable {
        private Vector children = new Vector();
        private Vector parents = new Vector();
        private Function function;
        private FunctionProfile functionProfile;
        private boolean visited;
        private int downPriority;
        private int upPriority;
        private int level = -1;
        private int levelIndex;
        private double baryCenter;
        private double gridBaryCenter;
        private GraphCell graphCell;
        private int position = -1;
        private int width;
        private int height;
        private float colorRatio;
        private int xBeg;
        private int yBeg;
        private int xEnd;
        private int yEnd;
        private boolean pathHighlight = false;
        private Vector pathEdges = new Vector();

        Vertex(FunctionProfile functionProfile, int n) {
            if (functionProfile != null) {
                this.function = functionProfile.getFunction();
                this.functionProfile = functionProfile;
            }
            this.width = n;
            this.height = CallGraphWindow.this.boxHeight;
            if (this.function != null && n < 5) {
                this.width = 5;
            }
        }

        public int compareTo(Object object) {
            if (this.baryCenter < ((Vertex)object).baryCenter) {
                return -1;
            }
            if (this.baryCenter > ((Vertex)object).baryCenter) {
                return 1;
            }
            return 0;
        }

        private int getPriority(boolean bl) {
            if (bl) {
                return this.downPriority;
            }
            return this.upPriority;
        }
    }

    private static class BackEdge {
        private Vertex a;
        private Vertex b;

        BackEdge(Vertex vertex, Vertex vertex2) {
            this.a = vertex;
            this.b = vertex2;
        }
    }

    private class Graph
    extends JGraph
    implements MouseListener {
        private CallGraphWindow callGraphWindow;

        public String getToolTipText(MouseEvent mouseEvent) {
            double d;
            double d2 = (double)mouseEvent.getX() / this.getScale();
            GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d2, (int)(d = (double)mouseEvent.getY() / this.getScale()));
            if (graphCell != null) {
                return graphCell.getToolTipString();
            }
            return null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                double d = (double)mouseEvent.getX() / this.getScale();
                double d2 = (double)mouseEvent.getY() / this.getScale();
                GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d, (int)d2);
                if (graphCell != null) {
                    Function function = graphCell.getFunction();
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(CallGraphWindow.this.ppTrial, function, (JComponent)((Object)this));
                        jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        CallGraphWindow.this.ppTrial.toggleHighlightedFunction(function);
                    }
                }
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.setSize(dimension.width + 10, dimension.height + 10);
            return dimension;
        }

        public Graph(GraphModel graphModel, CallGraphWindow callGraphWindow2) {
            super(graphModel);
            this.callGraphWindow = callGraphWindow2;
            this.setSelectionModel((org.jgraph.graph.GraphSelectionModel)new GraphSelectionModel(this));
        }
    }

    private class GraphCell
    extends DefaultGraphCell {
        private final Function function;
        private final Vertex vertex;

        public GraphCell(Vertex vertex) {
            super((Object)vertex.function.getName());
            this.vertex = vertex;
            this.function = vertex.function;
        }

        public String getToolTipString() {
            float f;
            String string = "<html>" + this.function;
            if (CallGraphWindow.this.widthOption != CallGraphOption.STATIC && CallGraphWindow.this.widthOption != CallGraphOption.NAME_LENGTH) {
                f = (float)CallGraphWindow.this.getValue(this.vertex.functionProfile, CallGraphWindow.this.widthOption, 1.0, CallGraphWindow.this.widthMetricID);
                string = string + "<br>Width Value (" + CallGraphWindow.this.widthOption;
                if (CallGraphWindow.this.widthOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.widthOption != CallGraphOption.NUMSUBR) {
                    string = string + ", " + CallGraphWindow.this.ppTrial.getMetricName(CallGraphWindow.this.widthMetricID);
                }
                string = string + ") : " + f;
            }
            if (CallGraphWindow.this.colorOption != CallGraphOption.STATIC) {
                f = (float)CallGraphWindow.this.getValue(this.vertex.functionProfile, CallGraphWindow.this.colorOption, 1.0, CallGraphWindow.this.colorMetricID);
                string = string + "<br>Color Value (" + CallGraphWindow.this.colorOption;
                if (CallGraphWindow.this.colorOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.colorOption != CallGraphOption.NUMSUBR) {
                    string = string + ", " + CallGraphWindow.this.ppTrial.getMetricName(CallGraphWindow.this.colorMetricID);
                }
                string = string + ") : " + f;
            }
            return string;
        }

        public Function getFunction() {
            return this.function;
        }

        public Vertex getVertex() {
            return this.vertex;
        }
    }

    private static class GraphSelectionModel
    extends DefaultGraphSelectionModel {
        GraphSelectionModel(JGraph jGraph) {
            super(jGraph);
        }

        public Object[] getSelectables() {
            if (this.isChildrenSelectable()) {
                ArrayList arrayList = new ArrayList();
                Stack<Object> stack = new Stack<Object>();
                GraphModel graphModel = this.graph.getModel();
                for (int i = 0; i < graphModel.getRootCount(); ++i) {
                    stack.add(graphModel.getRootAt(i));
                }
                while (!stack.isEmpty()) {
                    Object e = stack.pop();
                    if (!graphModel.isPort(e) && !graphModel.isEdge(e)) {
                        arrayList.add(e);
                    }
                    if (!this.isChildrenSelectable(e)) continue;
                    for (int i = 0; i < graphModel.getChildCount(e); ++i) {
                        stack.add(graphModel.getChild(e, i));
                    }
                }
                return arrayList.toArray();
            }
            return this.graph.getRoots();
        }
    }
}

