/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.paraprof.ColorDefaultsWindow;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.Preferences;
import edu.uoregon.tau.paraprof.enums.SortType;
import java.awt.Color;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ColorChooser
implements WindowListener {
    private Vector colors = new Vector();
    private Vector groupColors = new Vector();
    private Color functionHighlightColor = Color.red;
    private Color groupHighlightColor = new Color(0, 255, 255);
    private Color userEventHighlightColor = new Color(255, 255, 0);
    private Color miscFunctionColor = Color.black;
    private boolean clrChooserFrameShowing = false;
    private ColorDefaultsWindow clrChooserFrame;

    public ColorChooser(Preferences preferences) {
        if (preferences != null) {
            this.colors = preferences.getColors();
            this.groupColors = preferences.getGroupColors();
            this.functionHighlightColor = preferences.getHighlightColor();
            this.groupHighlightColor = preferences.getGroupHighlightColor();
            this.userEventHighlightColor = preferences.getUserEventHighlightColor();
            this.miscFunctionColor = preferences.getMiscFunctionColor();
            if (this.functionHighlightColor == null) {
                this.functionHighlightColor = Color.red;
            }
            if (this.groupHighlightColor == null) {
                this.groupHighlightColor = new Color(0, 255, 255);
            }
            if (this.userEventHighlightColor == null) {
                this.userEventHighlightColor = new Color(255, 255, 0);
            }
            if (this.miscFunctionColor == null) {
                this.miscFunctionColor = Color.black;
            }
        } else {
            this.setDefaultColors();
            this.setDefaultGroupColors();
        }
    }

    public void showColorChooser() {
        if (!this.clrChooserFrameShowing) {
            this.clrChooserFrame = new ColorDefaultsWindow(this);
            this.clrChooserFrame.addWindowListener(this);
            this.clrChooserFrame.show();
            this.clrChooserFrameShowing = true;
        } else {
            this.clrChooserFrame.show();
        }
    }

    public void setSavedColors() {
        ParaProf.preferences.setColors(this.colors);
        ParaProf.preferences.setGroupColors(this.groupColors);
        ParaProf.preferences.setHighlightColor(this.functionHighlightColor);
        ParaProf.preferences.setGroupHighlightColor(this.groupHighlightColor);
        ParaProf.preferences.setMiscFunctionColor(this.miscFunctionColor);
    }

    public int getNumberOfColors() {
        int n = -1;
        n = this.colors.size();
        return n;
    }

    public int getNumberOfGroupColors() {
        int n = -1;
        n = this.groupColors.size();
        return n;
    }

    public void addColor(Color color) {
        this.colors.add(color);
    }

    public void setColor(Color color, int n) {
        this.colors.setElementAt(color, n);
    }

    public Color getColor(int n) {
        Color color = null;
        color = (Color)this.colors.elementAt(n);
        return color;
    }

    public Vector getColors() {
        return this.colors;
    }

    public void addGroupColor(Color color) {
        this.groupColors.add(color);
    }

    public void setGroupColor(Color color, int n) {
        this.groupColors.setElementAt(color, n);
    }

    public Color getGroupColor(int n) {
        return (Color)this.groupColors.elementAt(n);
    }

    public Vector getGroupColors() {
        return this.groupColors;
    }

    public void setHighlightColor(Color color) {
        this.functionHighlightColor = color;
    }

    public Color getHighlightColor() {
        return this.functionHighlightColor;
    }

    public void setGroupHighlightColor(Color color) {
        this.groupHighlightColor = color;
    }

    public Color getGroupHighlightColor() {
        return this.groupHighlightColor;
    }

    public void setUserEventHighlightColor(Color color) {
        this.userEventHighlightColor = color;
    }

    public Color getUserEventHighlightColor() {
        return this.userEventHighlightColor;
    }

    public void setMiscFunctionColor(Color color) {
        this.miscFunctionColor = color;
    }

    public Color getMiscFunctionColor() {
        return this.miscFunctionColor;
    }

    public void setDefaultColors() {
        this.colors.clear();
        this.addColor(new Color(70, 156, 168));
        this.addColor(new Color(255, 153, 0));
        this.addColor(new Color(0, 51, 255));
        this.addColor(new Color(102, 0, 51));
        this.addColor(new Color(221, 232, 30));
        this.addColor(new Color(0, 255, 0));
        this.addColor(new Color(121, 196, 144));
        this.addColor(new Color(86, 88, 112));
        this.addColor(new Color(151, 204, 255));
        this.addColor(new Color(102, 102, 255));
        this.addColor(new Color(0, 102, 102));
        this.addColor(new Color(204, 255, 51));
        this.addColor(new Color(102, 132, 25));
        this.addColor(new Color(255, 204, 153));
        this.addColor(new Color(204, 0, 204));
        this.addColor(new Color(0, 102, 102));
        this.addColor(new Color(204, 204, 255));
        this.addColor(new Color(61, 104, 63));
        this.addColor(new Color(102, 255, 255));
        this.addColor(new Color(255, 102, 102));
        this.addColor(new Color(119, 71, 145));
        this.addColor(new Color(255, 204, 204));
        this.addColor(new Color(240, 97, 159));
        this.addColor(new Color(0, 102, 153));
    }

    public void setDefaultGroupColors() {
        this.groupColors.clear();
        this.addGroupColor(new Color(102, 0, 102));
        this.addGroupColor(new Color(51, 51, 0));
        this.addGroupColor(new Color(204, 0, 51));
        this.addGroupColor(new Color(0, 102, 102));
        this.addGroupColor(new Color(255, 255, 102));
        this.addGroupColor(new Color(0, 0, 102));
        this.addGroupColor(new Color(153, 153, 255));
        this.addGroupColor(new Color(255, 51, 0));
        this.addGroupColor(new Color(255, 153, 0));
        this.addGroupColor(new Color(255, 102, 102));
        this.addGroupColor(new Color(51, 0, 51));
        this.addGroupColor(new Color(255, 255, 102));
    }

    public void setColors(ParaProfTrial paraProfTrial, int n) {
        Object object;
        Object object2;
        int n2;
        if (n == -1 || n == 0) {
            n2 = this.getNumberOfColors();
            object2 = new DataSorter(paraProfTrial);
            ((DataSorter)object2).setSortType(SortType.MEAN_VALUE);
            ((DataSorter)object2).setDescendingOrder(true);
            object = ((DataSorter)object2).getFunctionProfiles(-1, -1, -1);
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                Function function = ((PPFunctionProfile)((Vector)object).get(i)).getFunction();
                Color color = ParaProf.colorMap.getColor(function);
                if (color == null) {
                    function.setColor(this.getColor(i % n2));
                    continue;
                }
                function.setColor(color);
            }
        }
        if (n == -1 || n == 1) {
            n2 = this.getNumberOfGroupColors();
            object2 = paraProfTrial.getDataSource().getGroups();
            while (object2.hasNext()) {
                object = (Group)object2.next();
                object.setColor(this.getGroupColor(object.getID() % n2));
            }
        }
        if (n == -1 || n == 2) {
            n2 = this.getNumberOfColors();
            object2 = paraProfTrial.getDataSource().getUserEvents();
            while (object2.hasNext()) {
                object = (UserEvent)object2.next();
                object.setColor(this.getColor(object.getID() % n2));
            }
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this.clrChooserFrame) {
            this.clrChooserFrameShowing = false;
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

