/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;

public class HistogramWindowPanel
extends JPanel
implements Printable,
ParaProfImageInterface {
    private ParaProfTrial ppTrial = null;
    private HistogramWindow window = null;
    private Vector data = null;
    private int xPanelSize;
    private int yPanelSize;
    private int[] bins;
    private int maxInAnyBin;
    private double maxValue;
    private double minValue;
    private int xOffset;
    private double binWidth;
    private int lastHeaderEndPosition = 0;

    public HistogramWindowPanel(ParaProfTrial paraProfTrial, HistogramWindow histogramWindow) {
        this.ppTrial = paraProfTrial;
        this.window = histogramWindow;
        this.setToolTipText("ParaProf histogram window!");
        this.setBackground(Color.white);
        this.xPanelSize = 600;
        this.yPanelSize = 400;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            if ((n -= this.xOffset) < 0 || n > 550) {
                return null;
            }
            int n2 = 550 / this.window.getNumBins();
            int n3 = n / n2;
            if (n3 < 0 || n3 > this.window.getNumBins() - 1) {
                return null;
            }
            String string = UtilFncs.getOutputString((int)this.window.units(), (double)(this.minValue + (double)n3 * this.binWidth), (int)5);
            String string2 = UtilFncs.getOutputString((int)this.window.units(), (double)(this.minValue + (double)(n3 + 1) * this.binWidth), (int)5);
            return "<html>Number of threads: " + this.bins[n3] + "<br>Range minimum: " + string + "<br>Range maximum: " + string2 + "</html>";
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = this.getSize();
        boolean bl3 = false;
        if (bl2) {
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        } else {
            dimension.setSize(dimension.getWidth(), dimension.getHeight());
        }
        return dimension;
    }

    private void processData() {
        int n;
        double d;
        this.data = this.window.getData();
        this.maxValue = 0.0;
        this.minValue = 0.0;
        PPFunctionProfile pPFunctionProfile = null;
        int n2 = 0;
        boolean bl = true;
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            pPFunctionProfile = (PPFunctionProfile)enumeration.nextElement();
            ++n2;
            d = pPFunctionProfile.getValue();
            if (bl) {
                this.minValue = d;
                bl = false;
            }
            this.maxValue = Math.max(this.maxValue, d);
            this.minValue = Math.min(this.minValue, d);
        }
        int n3 = this.window.getNumBins();
        d = this.maxValue / (double)n3;
        this.binWidth = (this.maxValue - this.minValue) / (double)n3;
        this.bins = new int[n3];
        for (n = 0; n < n3; ++n) {
            this.bins[n] = 0;
        }
        n = 0;
        Enumeration enumeration2 = this.data.elements();
        block2: while (enumeration2.hasMoreElements()) {
            pPFunctionProfile = (PPFunctionProfile)enumeration2.nextElement();
            double d2 = pPFunctionProfile.getValue();
            for (int i = 0; i < n3; ++i) {
                if (!(d2 <= this.minValue + this.binWidth * (double)(i + 1))) continue;
                int n4 = i;
                this.bins[n4] = this.bins[n4] + 1;
                ++n;
                continue block2;
            }
        }
        this.maxInAnyBin = 0;
        for (int i = 0; i < n3; ++i) {
            this.maxInAnyBin = Math.max(this.maxInAnyBin, this.bins[i]);
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        int n2;
        Object object;
        this.processData();
        Font font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.ppTrial.getPreferencesWindow().getFontSize());
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        int n3 = 0;
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Insets insets = this.getInsets();
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                AttributedString attributedString = new AttributedString(stringTokenizer.nextToken());
                attributedString.addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                object = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - insets.left - insets.right;
                float f2 = insets.left;
                float f3 = insets.right;
                while (((LineBreakMeasurer)object).getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = ((LineBreakMeasurer)object).nextLayout(f);
                    textLayout.draw(graphics2D, f2, n3 += this.ppTrial.getPreferencesWindow().getBarSpacing());
                    f2 = insets.left;
                }
            }
            this.lastHeaderEndPosition = n3;
            n3 += this.ppTrial.getPreferencesWindow().getBarSpacing();
        }
        int n4 = fontMetrics.getMaxAscent();
        int n5 = fontMetrics.getMaxDescent();
        int n6 = 550 / this.bins.length;
        graphics2D.setColor(Color.black);
        graphics2D.drawString("# Threads", 3, n3 + n4);
        n3 = n3 + n4 * 2 + 3;
        this.xOffset = 0;
        for (n2 = 0; n2 < 10; ++n2) {
            double d = (double)(10 - n2) * (double)this.maxInAnyBin / 10.0;
            object = UtilFncs.formatDouble((double)d, (int)4);
            int n7 = fontMetrics.stringWidth((String)object);
            this.xOffset = Math.max(this.xOffset, n7);
        }
        this.xOffset += 25;
        for (n2 = 0; n2 < 10; ++n2) {
            double d = (double)(10 - n2) * (double)this.maxInAnyBin / 10.0;
            object = UtilFncs.formatDouble((double)d, (int)4);
            int n8 = fontMetrics.stringWidth((String)object);
            graphics2D.drawLine(this.xOffset - 5, n3 + n2 * 40, this.xOffset, n3 + n2 * 40);
            graphics2D.drawString((String)object, 15, n3 + 5 + n2 * 40);
        }
        n2 = n6 / 10 / 2;
        int n9 = n6 * this.bins.length + this.xOffset + 4 - n2;
        graphics2D.drawLine(this.xOffset, 400 + n3, this.xOffset, n3);
        graphics2D.drawLine(this.xOffset, 400 + n3, n9, 400 + n3);
        for (int i = 1; i < this.bins.length + 1; ++i) {
            graphics2D.drawLine(this.xOffset + 4 + i * n6 - n2, 400 + n3, this.xOffset + 4 + i * n6 - n2, 405 + n3);
        }
        String string = "Max Value = " + UtilFncs.getOutputString((int)this.window.units(), (double)this.maxValue, (int)5);
        int n10 = fontMetrics.stringWidth(string);
        graphics2D.drawString("Min Value = " + UtilFncs.getOutputString((int)this.window.units(), (double)this.minValue, (int)5), this.xOffset, 420 + n3);
        graphics2D.drawString(string, n9 - n10, 420 + n3);
        this.xPanelSize = n9 + 10;
        for (n = 0; n < this.bins.length; ++n) {
            if (this.bins[n] == 0) continue;
            double d = this.bins[n];
            double d2 = d / (double)this.maxInAnyBin * 100.0;
            int n11 = (int)d2;
            if (n11 < 1) {
                n11 = 1;
            }
            int n12 = n6 - n6 / 10;
            if (n6 < 10) {
                n12 = n6;
            }
            if (n12 < 1) {
                n12 = 1;
            }
            graphics2D.setColor(Color.red);
            graphics2D.fillRect(this.xOffset + 4 + n * n6, 400 + n3 - n11 * 4, n12, n11 * 4);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(this.xOffset + 4 + n * n6, 400 + n3 - n11 * 4, n12, n11 * 4);
        }
        n = Math.max(this.xPanelSize, this.lastHeaderEndPosition);
        int n13 = 420 + n3;
        boolean bl4 = false;
        if (n != this.xPanelSize || n13 != this.yPanelSize) {
            this.xPanelSize = n;
            this.yPanelSize = n13;
            this.revalidate();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }
}

