/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.LedgerDataElement;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.UserEventWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class LedgerWindowPanel
extends JPanel
implements ActionListener,
MouseListener,
Printable,
ParaProfImageInterface {
    private int xPanelSize = 300;
    private int yPanelSize = 400;
    private int barHeight = -1;
    private int barSpacing = -1;
    private ParaProfTrial ppTrial = null;
    private LedgerWindow window = null;
    private JPopupMenu popup = new JPopupMenu();
    private Object clickedOnObject = null;
    private Vector list = new Vector();
    private boolean widthSet = false;
    private int windowType = -1;

    public void setupMenus() {
        JMenuItem jMenuItem = null;
        switch (this.windowType) {
            case 0: {
                jMenuItem = new JMenuItem("Show Function Details");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Change Function Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Reset to Generic Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                break;
            }
            case 1: {
                jMenuItem = new JMenuItem("Change Group Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Reset to Generic Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show This Group Only");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show All Groups Except This One");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Show All Groups");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                break;
            }
            case 2: {
                jMenuItem = new JMenuItem("Show User Event Details");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Change User Event Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
                jMenuItem = new JMenuItem("Reset to Generic Color");
                jMenuItem.addActionListener(this);
                this.popup.add(jMenuItem);
            }
        }
    }

    public LedgerWindowPanel(ParaProfTrial paraProfTrial, LedgerWindow ledgerWindow, int n) {
        this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
        this.setBackground(Color.white);
        this.ppTrial = paraProfTrial;
        this.window = ledgerWindow;
        this.windowType = n;
        this.addMouseListener(this);
        this.setupMenus();
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        int n;
        this.list = this.window.getData();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.ppTrial.getPreferencesWindow().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferencesWindow().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferencesWindow().getBarHeight();
        Font font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        if (!this.widthSet) {
            for (int i = 0; i < this.list.size(); ++i) {
                LedgerDataElement ledgerDataElement = (LedgerDataElement)this.list.get(i);
                if (ledgerDataElement.getName() == null || this.xPanelSize >= (n = 5 + this.barHeight + fontMetrics.stringWidth(ledgerDataElement.getName()))) continue;
                this.xPanelSize = n + 11;
            }
            this.widthSet = true;
        }
        if (this.resizePanel(fontMetrics, n4) && bl) {
            this.revalidate();
            return;
        }
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.barSpacing, n3);
        int n6 = nArray[0];
        n = nArray[1];
        n3 = nArray[2];
        n2 = 5;
        for (int i = n6; i <= n; ++i) {
            LedgerDataElement ledgerDataElement = (LedgerDataElement)this.list.get(i);
            if (ledgerDataElement.getName() == null) continue;
            graphics2D.setColor(ledgerDataElement.getColor());
            graphics2D.fillRect(n2, (n3 += this.barSpacing) - this.barHeight, this.barHeight, this.barHeight);
            if (ledgerDataElement.isHighlighted(this.ppTrial)) {
                graphics2D.setColor(ledgerDataElement.getHighlightColor(this.ppTrial.getColorChooser()));
                graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
                graphics2D.drawRect(n2 + 1, n3 - this.barHeight + 1, this.barHeight - 2, this.barHeight - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n2, n3 - this.barHeight, this.barHeight, this.barHeight);
            }
            graphics2D.setColor(Color.black);
            String string = ledgerDataElement.getName();
            graphics2D.drawString(string, n2 += this.barHeight + 10, n3);
            int n7 = 5 + this.barHeight + fontMetrics.stringWidth(string);
            if (n5 < n7) {
                n5 = n7 + 11;
            }
            if (bl) {
                ledgerDataElement.setDrawCoords(0, n7, n3 - this.barHeight, n3);
            }
            n2 -= this.barHeight + 10;
        }
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = this.window.getData().size() * this.barSpacing;
        if (n2 != this.yPanelSize) {
            this.yPanelSize = n2;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem) {
                String string = actionEvent.getActionCommand();
                if (this.clickedOnObject instanceof LedgerDataElement) {
                    LedgerDataElement ledgerDataElement = (LedgerDataElement)this.clickedOnObject;
                    if (string.equals("Show Function Details")) {
                        this.ppTrial.setHighlightedFunction(ledgerDataElement.getFunction());
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(this.ppTrial, ledgerDataElement.getFunction());
                        this.ppTrial.getSystemEvents().addObserver(functionDataWindow);
                        functionDataWindow.show();
                    } else if (string.equals("Show User Event Details")) {
                        this.ppTrial.setHighlightedUserEvent(ledgerDataElement.getUserEvent());
                        UserEventWindow userEventWindow = new UserEventWindow(this.ppTrial, ledgerDataElement.getUserEvent(), this.ppTrial.getStaticMainWindow().getDataSorter());
                        this.ppTrial.getSystemEvents().addObserver(userEventWindow);
                        userEventWindow.show();
                    } else if (string.equals("Change Function Color") || string.equals("Change User Event Color") || string.equals("Change Group Color")) {
                        Color color = ledgerDataElement.getColor();
                        if ((color = JColorChooser.showDialog(this, "Please select a new color", color)) != null) {
                            ledgerDataElement.setSpecificColor(color);
                            ledgerDataElement.setColorFlag(true);
                            this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                        }
                    } else if (string.equals("Reset to Generic Color")) {
                        ledgerDataElement.setColorFlag(false);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("colorEvent");
                    } else if (string.equals("Show This Group Only")) {
                        this.ppTrial.setSelectedGroup(ledgerDataElement.getGroup());
                        this.ppTrial.setGroupFilter(1);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    } else if (string.equals("Show All Groups Except This One")) {
                        this.ppTrial.setSelectedGroup(ledgerDataElement.getGroup());
                        this.ppTrial.setGroupFilter(2);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    } else if (string.equals("Show All Groups")) {
                        this.ppTrial.setSelectedGroup(null);
                        this.ppTrial.setGroupFilter(0);
                        this.ppTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            if (this.list == null) {
                return;
            }
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            Enumeration enumeration = this.list.elements();
            while (enumeration.hasMoreElements()) {
                LedgerDataElement ledgerDataElement = (LedgerDataElement)enumeration.nextElement();
                if (n2 > ledgerDataElement.getYEnd()) continue;
                if (n2 >= ledgerDataElement.getYBeg() && n >= ledgerDataElement.getXBeg() && n <= ledgerDataElement.getXEnd()) {
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        this.clickedOnObject = ledgerDataElement;
                        this.popup.show(this, mouseEvent.getX(), mouseEvent.getY());
                        return;
                    }
                    if (this.windowType == 2) {
                        this.ppTrial.toggleHighlightedUserEvent(ledgerDataElement.getUserEvent());
                    } else if (this.windowType == 1) {
                        this.ppTrial.toggleHighlightedGroup(ledgerDataElement.getGroup());
                    } else {
                        this.ppTrial.toggleHighlightedFunction(ledgerDataElement.getFunction());
                    }
                    return;
                }
                return;
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.window.getSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize + 10, this.yPanelSize + 10);
    }

    public void help(boolean bl) {
    }

    public Rectangle getViewRect() {
        return null;
    }
}

