/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class LoadTrialWindow
extends JFrame
implements ActionListener {
    static String lastDirectory;
    private ParaProfManagerWindow paraProfManagerWindow = null;
    private ParaProfApplication application = null;
    private ParaProfExperiment experiment = null;
    private boolean newExperiment;
    private boolean newApplication;
    private JTextField dirLocationField = new JTextField(lastDirectory, 30);
    private String[] trialTypeStrings = new String[]{"Tau profiles", "Tau pprof.dat", "Dynaprof", "MpiP", "HPMToolkit", "Gprof", "PSRun", "ParaProf Packed Profile"};
    private JComboBox trialTypes = null;
    private File[] selectedFiles;
    private JButton selectButton = null;

    public LoadTrialWindow(ParaProfManagerWindow paraProfManagerWindow, ParaProfApplication paraProfApplication, ParaProfExperiment paraProfExperiment, boolean bl, boolean bl2) {
        this.paraProfManagerWindow = paraProfManagerWindow;
        this.application = paraProfApplication;
        this.experiment = paraProfExperiment;
        this.newApplication = bl;
        this.newExperiment = bl2;
        if (lastDirectory == null) {
            lastDirectory = System.getProperty("user.dir");
            this.dirLocationField.setText(lastDirectory);
        }
        int n = 400;
        int n2 = 200;
        Point point = paraProfManagerWindow.getLocationOnScreen();
        Dimension dimension = paraProfManagerWindow.getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        this.setLocation(n5, n6);
        this.setSize(new Dimension(n, n2));
        this.setTitle("Load Trial");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LoadTrialWindow.this.thisWindowClosing(windowEvent);
            }
        });
        this.trialTypes = new JComboBox<String>(this.trialTypeStrings);
        this.trialTypes.addActionListener(this);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(new JLabel("Trial Type"), gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.trialTypes, gridBagConstraints, 1, 0, 1, 1);
        this.selectButton = new JButton("Select Directory");
        this.selectButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.selectButton, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(this.dirLocationField, gridBagConstraints, 1, 1, 2, 1);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 2, 1, 1);
        jButton = new JButton("Ok");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 2, 2, 1, 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (string.equals("Select Directory")) {
                JFileChooser jFileChooser = new JFileChooser(lastDirectory);
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setMultiSelectionEnabled(false);
                jFileChooser.setDialogTitle("Select Directory");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(this) != 0) {
                    return;
                }
                lastDirectory = jFileChooser.getSelectedFile().getParent();
                this.dirLocationField.setText(jFileChooser.getSelectedFile().getCanonicalPath());
            } else if (string.equals("  Select File(s)  ")) {
                JFileChooser jFileChooser = new JFileChooser(lastDirectory);
                jFileChooser.setFileSelectionMode(0);
                jFileChooser.setMultiSelectionEnabled(true);
                jFileChooser.setDialogTitle("Select File(s)");
                jFileChooser.setApproveButtonText("Select");
                if (jFileChooser.showOpenDialog(this) != 0) {
                    return;
                }
                this.selectedFiles = jFileChooser.getSelectedFiles();
                lastDirectory = jFileChooser.getSelectedFile().getParent();
                if (this.selectedFiles.length > 1) {
                    this.dirLocationField.setText("<Multiple Files Selected>");
                    this.dirLocationField.setEditable(false);
                } else {
                    this.dirLocationField.setText(this.selectedFiles[0].toString());
                    this.dirLocationField.setEditable(true);
                }
            } else if (string.equals("Cancel")) {
                if (this.newExperiment) {
                    this.paraProfManagerWindow.handleDelete(this.experiment);
                }
                if (this.newApplication) {
                    this.paraProfManagerWindow.handleDelete(this.application);
                }
                this.closeThisWindow();
            } else if (string.equals("Ok")) {
                if (this.trialTypes.getSelectedIndex() == 0) {
                    File[] fileArray = new File[]{new File(this.dirLocationField.getText().trim())};
                    if (!fileArray[0].exists()) {
                        JOptionPane.showMessageDialog(this, this.dirLocationField.getText().trim() + " does not exist");
                        return;
                    }
                    this.paraProfManagerWindow.addTrial(this.application, this.experiment, fileArray, this.trialTypes.getSelectedIndex(), false);
                } else {
                    if (this.selectedFiles == null) {
                        this.selectedFiles = new File[1];
                        this.selectedFiles[0] = new File(this.dirLocationField.getText().trim());
                        if (!this.selectedFiles[0].exists()) {
                            JOptionPane.showMessageDialog(this, this.dirLocationField.getText().trim() + " does not exist");
                            return;
                        }
                    }
                    this.paraProfManagerWindow.addTrial(this.application, this.experiment, this.selectedFiles, this.trialTypes.getSelectedIndex(), false);
                }
                this.closeThisWindow();
            } else if (string.equals("comboBoxChanged")) {
                if (this.trialTypes.getSelectedIndex() == 0) {
                    this.selectButton.setText("Select Directory");
                    this.dirLocationField.setEditable(true);
                } else {
                    this.selectButton.setText("  Select File(s)  ");
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    void closeThisWindow() {
        this.setVisible(false);
        this.dispose();
    }
}

