/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.Iterator;

public class PPFunctionProfile
implements Comparable {
    private DataSorter dataSorter;
    private Thread thread;
    private FunctionProfile functionProfile;
    private FunctionProfile meanProfile;
    private int xBeg = 0;
    private int xEnd = 0;
    private int yBeg = 0;
    private int yEnd = 0;

    public PPFunctionProfile(DataSorter dataSorter, Thread thread, FunctionProfile functionProfile) {
        this.dataSorter = dataSorter;
        this.thread = thread;
        this.functionProfile = functionProfile;
        this.meanProfile = this.functionProfile.getFunction().getMeanProfile();
    }

    public FunctionProfile getMeanProfile() {
        return this.meanProfile;
    }

    public int getNodeID() {
        return this.thread.getNodeID();
    }

    public int getContextID() {
        return this.thread.getContextID();
    }

    public int getThreadID() {
        return this.thread.getThreadID();
    }

    public FunctionProfile getFunctionProfile() {
        return this.functionProfile;
    }

    public Function getFunction() {
        return this.functionProfile.getFunction();
    }

    public String getFunctionName() {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return this.functionProfile.getFunction().getReversedName();
        }
        return this.functionProfile.getFunction().getName();
    }

    public String getFunctionNameReversedCallPath() {
        return this.functionProfile.getFunction().getReversedName();
    }

    public Color getColor() {
        return this.functionProfile.getFunction().getColor();
    }

    public boolean isGroupMember(Group group) {
        return this.functionProfile.getFunction().isGroupMember(group);
    }

    public boolean isCallPathObject() {
        return this.functionProfile.getFunction().isCallPathFunction();
    }

    public double getInclusiveValue() {
        return this.functionProfile.getInclusive(this.dataSorter.getSelectedMetricID());
    }

    public double getExclusiveValue() {
        return this.functionProfile.getExclusive(this.dataSorter.getSelectedMetricID());
    }

    public double getInclusivePercentValue() {
        return this.functionProfile.getInclusivePercent(this.dataSorter.getSelectedMetricID());
    }

    public double getExclusivePercentValue() {
        return this.functionProfile.getExclusivePercent(this.dataSorter.getSelectedMetricID());
    }

    public double getNumberOfCalls() {
        return this.functionProfile.getNumCalls();
    }

    public double getNumberOfSubRoutines() {
        return this.functionProfile.getNumSubr();
    }

    public double getInclusivePerCall() {
        return this.functionProfile.getInclusivePerCall(this.dataSorter.getSelectedMetricID());
    }

    public Iterator getChildProfiles() {
        return this.functionProfile.getChildProfiles();
    }

    public Iterator getParentProfiles() {
        return this.functionProfile.getParentProfiles();
    }

    public DataSorter getDataSorter() {
        return this.dataSorter;
    }

    public double getValue() {
        return this.dataSorter.getValueType().getValue(this.getFunctionProfile(), this.dataSorter.getSelectedMetricID());
    }

    private int checkDescending(int n) {
        if (this.dataSorter.getDescendingOrder()) {
            return -n;
        }
        return n;
    }

    public int compareTo(Object object) {
        ValueType valueType = this.dataSorter.getValueType();
        PPFunctionProfile pPFunctionProfile = (PPFunctionProfile)object;
        if (this.dataSorter.getSortType() == SortType.NAME) {
            return this.checkDescending(pPFunctionProfile.getFunctionName().compareTo(this.getFunctionName()));
        }
        if (this.dataSorter.getSortType() == SortType.NCT) {
            if (pPFunctionProfile.getNodeID() != this.getNodeID()) {
                return this.checkDescending(this.getNodeID() - pPFunctionProfile.getNodeID());
            }
            if (pPFunctionProfile.getContextID() != this.getContextID()) {
                return this.checkDescending(this.getContextID() - pPFunctionProfile.getContextID());
            }
            return this.checkDescending(this.getThreadID() - pPFunctionProfile.getThreadID());
        }
        if (this.dataSorter.getSortType() == SortType.MEAN_VALUE) {
            return this.checkDescending(this.compareToHelper(valueType.getValue(this.meanProfile, this.dataSorter.getSelectedMetricID()), valueType.getValue(pPFunctionProfile.meanProfile, this.dataSorter.getSelectedMetricID()), this.meanProfile, pPFunctionProfile.meanProfile));
        }
        if (this.dataSorter.getSortType() == SortType.VALUE) {
            return this.checkDescending(this.compareToHelper(valueType.getValue(this.getFunctionProfile(), this.dataSorter.getSelectedMetricID()), valueType.getValue(pPFunctionProfile.getFunctionProfile(), this.dataSorter.getSelectedMetricID())));
        }
        throw new ParaProfException("Unexpected sort type: " + this.dataSorter.getSortType());
    }

    private int compareToHelper(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return 0;
        }
        return 1;
    }

    private int compareToHelper(double d, double d2, FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            return -1;
        }
        if (d3 == 0.0) {
            return functionProfile.getFunction().compareTo((Object)functionProfile2.getFunction());
        }
        return 1;
    }

    public void setDrawCoords(int n, int n2, int n3, int n4) {
        this.xBeg = n;
        this.xEnd = n2;
        this.yBeg = n3;
        this.yEnd = n4;
    }

    public int getXBeg() {
        return this.xBeg;
    }

    public int getXEnd() {
        return this.xEnd;
    }

    public int getYBeg() {
        return this.yBeg;
    }

    public int getYEnd() {
        return this.yEnd;
    }

    public String getStatString(int n) {
        int n2 = this.dataSorter.getSelectedMetricID();
        DecimalFormat decimalFormat = new DecimalFormat("##0.0");
        String string = UtilFncs.lpad((String)decimalFormat.format(this.functionProfile.getInclusivePercent(n2)), (int)13);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getExclusive(n2), (int)14);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusive(n2), (int)16);
        string = string + "  " + UtilFncs.formatDouble((double)this.functionProfile.getNumCalls(), (int)12);
        string = string + "  " + UtilFncs.formatDouble((double)this.functionProfile.getNumSubr(), (int)12);
        string = string + "  " + UtilFncs.getOutputString((int)n, (double)this.functionProfile.getInclusivePerCall(n2), (int)19);
        return string;
    }

    public static String getStatStringHeading(String string) {
        return UtilFncs.lpad((String)("%Total " + string), (int)13) + UtilFncs.lpad((String)"Exclusive", (int)16) + UtilFncs.lpad((String)"Inclusive", (int)18) + UtilFncs.lpad((String)"#Calls", (int)14) + UtilFncs.lpad((String)"#Child Calls", (int)14) + UtilFncs.lpad((String)"Inclusive/Call", (int)21) + "   ";
    }

    public String toString() {
        return this.functionProfile.toString();
    }

    public Thread getThread() {
        return this.thread;
    }
}

