/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.database.DBConnector;
import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.DatabaseAPI;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.paraprof.ParaProfApplication;
import edu.uoregon.tau.paraprof.ParaProfExperiment;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultTreeModel;

public class ParaProfManagerTableModel
extends AbstractTableModel {
    private int type = -1;
    private ParaProfApplication application = null;
    private ParaProfExperiment experiment = null;
    private ParaProfTrial trial = null;
    private ParaProfMetric metric = null;
    private ParaProfManagerWindow paraProfManager = null;
    private DefaultTreeModel defaultTreeModel = null;
    String[] columnNames = new String[]{"Field", "Value"};

    public ParaProfManagerTableModel(ParaProfManagerWindow paraProfManagerWindow, Object object, DefaultTreeModel defaultTreeModel) {
        if (object instanceof ParaProfApplication) {
            this.application = (ParaProfApplication)object;
            this.type = 0;
        } else if (object instanceof ParaProfExperiment) {
            this.experiment = (ParaProfExperiment)object;
            this.type = 1;
        } else if (object instanceof ParaProfTrial) {
            this.trial = (ParaProfTrial)object;
            this.type = 2;
        } else {
            this.metric = (ParaProfMetric)object;
            this.type = 3;
        }
        this.paraProfManager = paraProfManagerWindow;
        this.defaultTreeModel = defaultTreeModel;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        switch (this.type) {
            case 0: {
                return this.application.getNumFields() + 2;
            }
            case 1: {
                return this.experiment.getNumFields() + 3;
            }
            case 2: {
                return this.trial.getTrial().getNumFields() + 4;
            }
            case 3: {
                return 5;
            }
        }
        return 0;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public Object getValueAt(int n, int n2) {
        try {
            switch (this.type) {
                case 0: {
                    if (n2 == 0) {
                        switch (n) {
                            case 0: {
                                return "Name";
                            }
                            case 1: {
                                return "Application ID";
                            }
                        }
                        return this.application.getFieldName(n - 2);
                    }
                    switch (n) {
                        case 0: {
                            return this.application.getName();
                        }
                        case 1: {
                            return new Integer(this.application.getID());
                        }
                    }
                    return this.application.getField(n - 2);
                }
                case 1: {
                    if (n2 == 0) {
                        switch (n) {
                            case 0: {
                                return "Name";
                            }
                            case 1: {
                                return "Application ID";
                            }
                            case 2: {
                                return "Experiment ID";
                            }
                        }
                        return this.experiment.getFieldName(n - 3);
                    }
                    switch (n) {
                        case 0: {
                            return this.experiment.getName();
                        }
                        case 1: {
                            return new Integer(this.experiment.getApplicationID());
                        }
                        case 2: {
                            return new Integer(this.experiment.getID());
                        }
                    }
                    return this.experiment.getField(n - 3);
                }
                case 2: {
                    if (n2 == 0) {
                        switch (n) {
                            case 0: {
                                return "Name";
                            }
                            case 1: {
                                return "Application ID";
                            }
                            case 2: {
                                return "Experiment ID";
                            }
                            case 3: {
                                return "Trial ID";
                            }
                        }
                        return this.trial.getTrial().getFieldName(n - 4);
                    }
                    switch (n) {
                        case 0: {
                            return this.trial.getName();
                        }
                        case 1: {
                            return new Integer(this.trial.getTrial().getApplicationID());
                        }
                        case 2: {
                            return new Integer(this.trial.getTrial().getExperimentID());
                        }
                        case 3: {
                            return new Integer(this.trial.getTrial().getID());
                        }
                    }
                    return this.trial.getTrial().getField(n - 4);
                }
                case 3: {
                    if (n2 == 0) {
                        switch (n) {
                            case 0: {
                                return "Name";
                            }
                            case 1: {
                                return "Application ID";
                            }
                            case 2: {
                                return "Experiment ID";
                            }
                            case 3: {
                                return "Trial ID";
                            }
                            case 4: {
                                return "Metric ID";
                            }
                        }
                        return "";
                    }
                    switch (n) {
                        case 0: {
                            return this.metric.getName();
                        }
                        case 1: {
                            return new Integer(this.metric.getApplicationID());
                        }
                        case 2: {
                            return new Integer(this.metric.getExperimentID());
                        }
                        case 3: {
                            return new Integer(this.metric.getTrialID());
                        }
                        case 4: {
                            return new Integer(this.metric.getID());
                        }
                    }
                    return "";
                }
            }
            return "";
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return "";
        }
    }

    public boolean isCellEditable(int n, int n2) {
        try {
            switch (this.type) {
                case 0: {
                    return n2 == 1 && n != 1;
                }
                case 1: {
                    return n2 == 1 && n != 1 && n != 2;
                }
                case 2: {
                    if (n2 != 1) {
                        return false;
                    }
                    if (n == 0) {
                        return true;
                    }
                    if (n >= 1 && n <= 3) {
                        return false;
                    }
                    return DBConnector.isWritableType((int)this.trial.getTrial().getFieldType(n - 4));
                }
                case 3: {
                    return false;
                }
            }
            return n2 == 1 && n != 1;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return false;
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        try {
            if (object instanceof String) {
                String string = (String)object;
                if (n2 == 1) {
                    switch (this.type) {
                        case 0: {
                            switch (n) {
                                case 0: {
                                    this.application.setName(string);
                                    this.updateDB(this.application);
                                    break;
                                }
                                default: {
                                    this.application.setField(n - 2, string);
                                    this.updateDB(this.application);
                                }
                            }
                            this.defaultTreeModel.nodeChanged(this.application.getDMTN());
                            break;
                        }
                        case 1: {
                            switch (n) {
                                case 0: {
                                    this.experiment.setName(string);
                                    this.updateDB(this.experiment);
                                    break;
                                }
                                default: {
                                    this.experiment.setField(n - 3, string);
                                    this.updateDB(this.experiment);
                                }
                            }
                            this.defaultTreeModel.nodeChanged(this.experiment.getDMTN());
                            break;
                        }
                        case 2: {
                            switch (n) {
                                case 0: {
                                    this.trial.getTrial().setName(string);
                                    this.updateDB(this.trial);
                                    break;
                                }
                                default: {
                                    this.trial.getTrial().setField(n - 4, string);
                                    this.updateDB(this.trial);
                                }
                            }
                            this.defaultTreeModel.nodeChanged(this.trial.getDMTN());
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private void updateDB(Object object) {
        try {
            DatabaseAPI databaseAPI;
            ParaProfTrial paraProfTrial;
            if (object instanceof ParaProfApplication) {
                DatabaseAPI databaseAPI2;
                ParaProfApplication paraProfApplication = (ParaProfApplication)object;
                if (paraProfApplication.dBApplication() && (databaseAPI2 = this.paraProfManager.getDatabaseAPI()) != null) {
                    databaseAPI2.saveApplication((Application)paraProfApplication);
                    databaseAPI2.terminate();
                }
            } else if (object instanceof ParaProfExperiment) {
                DatabaseAPI databaseAPI3;
                ParaProfExperiment paraProfExperiment = (ParaProfExperiment)object;
                if (paraProfExperiment.dBExperiment() && (databaseAPI3 = this.paraProfManager.getDatabaseAPI()) != null) {
                    databaseAPI3.saveExperiment((Experiment)paraProfExperiment);
                    databaseAPI3.terminate();
                }
            } else if (object instanceof ParaProfTrial && (paraProfTrial = (ParaProfTrial)object).dBTrial() && (databaseAPI = this.paraProfManager.getDatabaseAPI()) != null) {
                databaseAPI.saveTrial(paraProfTrial.getTrial());
                databaseAPI.terminate();
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }
}

