/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.paraprof.CallGraphWindow;
import edu.uoregon.tau.paraprof.CallPathTextWindow;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.HistogramWindow;
import edu.uoregon.tau.paraprof.LedgerWindow;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageFormatFileFilter;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfImageOutput;
import edu.uoregon.tau.paraprof.ParaProfManagerWindow;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.StatWindow;
import edu.uoregon.tau.paraprof.ThreeDeeWindow;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.GZIPOutputStream;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class ParaProfUtils {
    static boolean verbose;
    static boolean verboseSet;

    private ParaProfUtils() {
    }

    private static void checkVerbose() {
        if (!verboseSet) {
            if (System.getProperty("paraprof.verbose") != null) {
                verbose = true;
            }
            verboseSet = true;
        }
    }

    public static void verr(String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            System.err.println(string);
        }
    }

    public static void vout(String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            System.out.println(string);
        }
    }

    public static void vout(Object object, String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.out.println(string2 + ": " + string);
        }
    }

    public static void verr(Object object, String string) {
        ParaProfUtils.checkVerbose();
        if (verbose) {
            String string2 = object.getClass().getName();
            int n = string2.lastIndexOf(46);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.println(string2 + ": " + string);
        }
    }

    public static void helperAddRadioMenuItem(String string, String string2, boolean bl, ButtonGroup buttonGroup, JMenu jMenu, ActionListener actionListener) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string, bl);
        jRadioButtonMenuItem.addActionListener(actionListener);
        jRadioButtonMenuItem.setActionCommand(string2);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
    }

    public static void addCompItem(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        container.add(component, gridBagConstraints);
    }

    public static void print(Printable printable) {
        PageFormat pageFormat;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat2 = printerJob.defaultPage();
        if (pageFormat2 != (pageFormat = printerJob.pageDialog(pageFormat2))) {
            printerJob.setPrintable(printable, pageFormat);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    ParaProfUtils.handleException(printerException);
                }
            }
        }
    }

    public static JMenu createHelpMenu(final JFrame jFrame, final ParaProfWindow paraProfWindow) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object instanceof JMenuItem) {
                        String string = actionEvent.getActionCommand();
                        if (string.equals("About ParaProf")) {
                            JOptionPane.showMessageDialog(jFrame, ParaProf.getInfoString());
                        } else if (string.equals("Show Help Window")) {
                            paraProfWindow.help(true);
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem("Show Help Window");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("About ParaProf");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createFileMenu(final ParaProfWindow paraProfWindow, final Printable printable, final Object object) {
        if (printable == null) {
            throw new ParaProfException("File menu created with null panel!");
        }
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object3 = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Print")) {
                        ParaProfUtils.print(printable);
                    } else if (string.equals("Preferences...")) {
                        ParaProf.preferencesWindow.showPreferencesWindow();
                    } else if (string.equals("Save Image")) {
                        Object object2;
                        if (object instanceof ParaProfImageInterface) {
                            object2 = (ParaProfImageInterface)object;
                            ParaProfImageOutput.saveImage((ParaProfImageInterface)object2);
                        }
                        if (object instanceof ThreeDeeWindow) {
                            object2 = (ThreeDeeWindow)object;
                            ParaProfImageOutput.save3dImage((ThreeDeeWindow)object2);
                        }
                    } else if (string.equals("Close This Window")) {
                        paraProfWindow.closeThisWindow();
                    } else if (string.equals("Exit ParaProf!")) {
                        ParaProf.exitParaProf(0);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Save ...");
        JMenuItem jMenuItem = new JMenuItem("Save Image");
        jMenuItem.addActionListener(actionListener);
        jMenu2.add(jMenuItem);
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem("Preferences...");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Print");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Close This Window");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Exit ParaProf!");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createThreadMenu(ParaProfTrial paraProfTrial, JFrame jFrame, Thread thread) {
        JMenu jMenu = new JMenu("Thread");
        JMenuItem jMenuItem = new JMenuItem("Function Graph");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Callpath Relations");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Call Graph");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Function Statistics");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("User Event Statistics");
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createFunctionMenu(ParaProfTrial paraProfTrial, JFrame jFrame, Thread thread) {
        JMenu jMenu = new JMenu("Function");
        JMenuItem jMenuItem = new JMenuItem("Thread Graph");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Histogram");
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public static JMenu createWindowsMenu(final ParaProfTrial paraProfTrial, final JFrame jFrame) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("ParaProf Manager")) {
                        new ParaProfManagerWindow().show();
                    } else if (string.equals("Function Ledger")) {
                        new LedgerWindow(paraProfTrial, 0).show();
                    } else if (string.equals("Group Ledger")) {
                        new LedgerWindow(paraProfTrial, 1).show();
                    } else if (string.equals("User Event Ledger")) {
                        new LedgerWindow(paraProfTrial, 2).show();
                    } else if (string.equals("3D Visualization")) {
                        if ("1.4".equals("1.3")) {
                            JOptionPane.showMessageDialog(jFrame, "3D Visualization requires Java 1.4 or above\nPlease make sure Java 1.4 is in your path, then reconfigure TAU and re-run ParaProf");
                            return;
                        }
                        try {
                            new ThreeDeeWindow(paraProfTrial).show();
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            JOptionPane.showMessageDialog(jFrame, "Unable to load jogl library.  Possible reasons:\nlibjogl.so is not in your LD_LIBRARY_PATH.\nJogl is not built for this platform.\nOpenGL is not installed\n\nJogl is available at jogl.dev.java.net");
                        }
                        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
                            JOptionPane.showMessageDialog(jFrame, "Unsupported class version.  Are you using Java 1.4 or above?");
                        }
                    } else if (string.equals("Call Path Relations")) {
                        CallPathTextWindow callPathTextWindow = new CallPathTextWindow(paraProfTrial, -1, -1, -1, null, 2);
                        paraProfTrial.getSystemEvents().addObserver(callPathTextWindow);
                        callPathTextWindow.show();
                    } else if (string.equals("Close All Sub-Windows")) {
                        paraProfTrial.getSystemEvents().updateRegisteredObjects("subWindowCloseEvent");
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Windows");
        JMenuItem jMenuItem = new JMenuItem("ParaProf Manager");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("3D Visualization");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Call Path Relations");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Function Ledger");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem("Group Ledger");
        jMenuItem2.addActionListener(actionListener);
        jMenu.add(jMenuItem2);
        final JMenuItem jMenuItem3 = new JMenuItem("User Event Ledger");
        jMenuItem3.addActionListener(actionListener);
        jMenu.add(jMenuItem3);
        jMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Close All Sub-Windows");
        jMenuItem.addActionListener(actionListener);
        jMenu.add(jMenuItem);
        MenuListener menuListener = new MenuListener(){

            public void menuSelected(MenuEvent menuEvent) {
                try {
                    jMenuItem2.setEnabled(paraProfTrial.groupNamesPresent());
                    jMenuItem3.setEnabled(paraProfTrial.userEventsPresent());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }

            public void menuCanceled(MenuEvent menuEvent) {
            }

            public void menuDeselected(MenuEvent menuEvent) {
            }
        };
        jMenu.addMenuListener(menuListener);
        return jMenu;
    }

    public static void scaleForPrint(Graphics graphics, PageFormat pageFormat, int n, int n2) {
        double d = pageFormat.getImageableWidth();
        double d2 = pageFormat.getImageableHeight();
        int n3 = (int)((double)n / d) + 1;
        int n4 = (int)((double)n2 / d2) + 1;
        double d3 = d / (double)n;
        double d4 = d2 / (double)n2;
        double d5 = Math.min(d3, d4);
        double d6 = 0.0;
        double d7 = 0.0;
        if (d3 > d5) {
            d6 = 0.5 * (d3 - d5) * (double)n;
        } else {
            d7 = 0.5 * (d4 - d5) * (double)n2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        graphics2D.translate(d6, d7);
        graphics2D.scale(d5, d5);
    }

    public static JPopupMenu createFunctionClickPopUp(final ParaProfTrial paraProfTrial, final Function function, final JComponent jComponent) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Show Function Details")) {
                        FunctionDataWindow functionDataWindow = new FunctionDataWindow(paraProfTrial, function);
                        paraProfTrial.getSystemEvents().addObserver(functionDataWindow);
                        functionDataWindow.show();
                    } else if (string.equals("Show Function Histogram")) {
                        HistogramWindow histogramWindow = new HistogramWindow(paraProfTrial, function);
                        paraProfTrial.getSystemEvents().addObserver(histogramWindow);
                        histogramWindow.show();
                    } else if (string.equals("Assign Function Color")) {
                        ParaProf.colorMap.assignColor(jComponent, function);
                    } else if (string.equals("Reset to Default Color")) {
                        ParaProf.colorMap.removeColor(function);
                        ParaProf.colorMap.reassignColors();
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Show Function Details");
        jMenuItem.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Show Function Histogram");
        jMenuItem2.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Assign Function Color");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        jMenuItem3 = new JMenuItem("Reset to Default Color");
        jMenuItem3.addActionListener(actionListener);
        jPopupMenu.add(jMenuItem3);
        return jPopupMenu;
    }

    public static void handleThreadClick(final ParaProfTrial paraProfTrial, final Thread thread, JPanel jPanel, MouseEvent mouseEvent) {
        if (thread.getNodeID() == -1) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Object object = actionEvent.getSource();
                        String string = actionEvent.getActionCommand();
                        if (string.equals("Show Mean Statistics Window")) {
                            StatWindow statWindow = new StatWindow(paraProfTrial, -1, -1, -1, false);
                            paraProfTrial.getSystemEvents().addObserver(statWindow);
                            statWindow.show();
                        } else if (string.equals("Show Mean Call Graph")) {
                            CallGraphWindow callGraphWindow = new CallGraphWindow(paraProfTrial, paraProfTrial.getDataSource().getMeanData());
                            paraProfTrial.getSystemEvents().addObserver(callGraphWindow);
                            callGraphWindow.show();
                        } else if (string.equals("Show Mean Call Path Thread Relations")) {
                            CallPathTextWindow callPathTextWindow = new CallPathTextWindow(paraProfTrial, -1, -1, -1, null, 0);
                            paraProfTrial.getSystemEvents().addObserver(callPathTextWindow);
                            callPathTextWindow.show();
                        }
                    }
                    catch (Exception exception) {
                        ParaProfUtils.handleException(exception);
                    }
                }
            };
            jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Show Mean Statistics Window");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Mean Call Path Thread Relations");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Mean Call Graph");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
        } else {
            JPopupMenu jPopupMenu = new JPopupMenu();
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Object object = actionEvent.getSource();
                        String string = actionEvent.getActionCommand();
                        if (string.equals("Show Thread Statistics Window")) {
                            StatWindow statWindow = new StatWindow(paraProfTrial, thread.getNodeID(), thread.getContextID(), thread.getThreadID(), false);
                            paraProfTrial.getSystemEvents().addObserver(statWindow);
                            statWindow.show();
                        } else if (string.equals("Show Thread Call Graph")) {
                            CallGraphWindow callGraphWindow = new CallGraphWindow(paraProfTrial, thread);
                            paraProfTrial.getSystemEvents().addObserver(callGraphWindow);
                            callGraphWindow.show();
                        } else if (string.equals("Show Call Path Thread Relations")) {
                            CallPathTextWindow callPathTextWindow = new CallPathTextWindow(paraProfTrial, thread.getNodeID(), thread.getContextID(), thread.getThreadID(), null, 1);
                            paraProfTrial.getSystemEvents().addObserver(callPathTextWindow);
                            callPathTextWindow.show();
                        } else if (string.equals("Show User Event Statistics Window")) {
                            StatWindow statWindow = new StatWindow(paraProfTrial, thread.getNodeID(), thread.getContextID(), thread.getThreadID(), true);
                            paraProfTrial.getSystemEvents().addObserver(statWindow);
                            statWindow.show();
                        }
                    }
                    catch (Exception exception) {
                        ParaProfUtils.handleException(exception);
                    }
                }
            };
            jPopupMenu = new JPopupMenu();
            JMenuItem jMenuItem = new JMenuItem("Show Thread Statistics Window");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            if (paraProfTrial.userEventsPresent()) {
                jMenuItem = new JMenuItem("Show User Event Statistics Window");
                jMenuItem.addActionListener(actionListener);
                jPopupMenu.add(jMenuItem);
            }
            jMenuItem = new JMenuItem("Show Call Path Thread Relations");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem("Show Thread Call Graph");
            jMenuItem.addActionListener(actionListener);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.show(jPanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public static int[] computeClipping(Rectangle rectangle, Rectangle rectangle2, boolean bl, boolean bl2, int n, int n2, int n3) {
        int n4;
        int n5;
        if (!bl2) {
            int n6 = 0;
            int n7 = 0;
            if (bl) {
                n6 = (int)rectangle.getY();
                n7 = (int)((double)n6 + rectangle.getHeight());
            } else {
                n6 = (int)rectangle2.getY();
                n7 = (int)((double)n6 + rectangle2.getHeight());
            }
            n5 = (n6 - n3) / n2 - 1;
            n4 = (n7 - n3) / n2 + 1;
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (n5 > n - 1) {
                n5 = n - 1;
            }
            if (n4 > n - 1) {
                n4 = n - 1;
            }
            if (bl) {
                n3 += n5 * n2;
            }
        } else {
            n5 = 0;
            n4 = n - 1;
        }
        int[] nArray = new int[]{n5, n4, n3};
        return nArray;
    }

    public static JMenu createUnitsMenu(final UnitListener unitListener, int n) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    String string = actionEvent.getActionCommand();
                    if (string.equals("Microseconds")) {
                        unitListener.setUnits(0);
                    } else if (string.equals("Milliseconds")) {
                        unitListener.setUnits(1);
                    } else if (string.equals("Seconds")) {
                        unitListener.setUnits(2);
                    } else if (string.equals("hr:min:sec")) {
                        unitListener.setUnits(3);
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        JMenu jMenu = new JMenu("Select Units");
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Microseconds", n == 0);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Milliseconds", n == 1);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Seconds", n == 2);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("hr:min:sec", n == 3);
        jRadioButtonMenuItem.addActionListener(actionListener);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        return jMenu;
    }

    private static int findGroupID(Group[] groupArray, Group group) {
        for (int i = 0; i < groupArray.length; ++i) {
            if (groupArray[i] != group) continue;
            return i;
        }
        throw new ParaProfException("Couldn't find group: " + group.getName());
    }

    public static void writePacked(DataSource dataSource, File file) throws FileNotFoundException, IOException {
        Group group;
        Vector vector;
        Object object;
        Object object2;
        Group[] groupArray;
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(gZIPOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        int n2 = dataSource.getNumFunctions();
        int n3 = dataSource.getNumberOfMetrics();
        int n4 = dataSource.getNumUserEvents();
        int n5 = dataSource.getNumGroups();
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(80);
        dataOutputStream.writeChar(75);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(n3);
        for (n = 0; n < n3; ++n) {
            groupArray = dataSource.getMetricName(n);
            dataOutputStream.writeUTF((String)groupArray);
        }
        n = 0;
        dataOutputStream.writeInt(n5);
        groupArray = new Group[n5];
        Function[] functionArray = dataSource.getGroups();
        while (functionArray.hasNext()) {
            object2 = (Group)functionArray.next();
            object = object2.getName();
            dataOutputStream.writeUTF((String)object);
            groupArray[n++] = object2;
        }
        functionArray = new Function[n2];
        n = 0;
        dataOutputStream.writeInt(n2);
        object2 = dataSource.getFunctions();
        while (object2.hasNext()) {
            object = (Function)object2.next();
            functionArray[n++] = object;
            dataOutputStream.writeUTF(object.getName());
            vector = object.getGroups();
            if (vector == null) {
                dataOutputStream.writeInt(0);
                continue;
            }
            dataOutputStream.writeInt(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                group = (Group)vector.get(i);
                dataOutputStream.writeInt(ParaProfUtils.findGroupID(groupArray, group));
            }
        }
        object2 = new UserEvent[n4];
        n = 0;
        dataOutputStream.writeInt(n4);
        object = dataSource.getUserEvents();
        while (object.hasNext()) {
            vector = (UserEvent)object.next();
            object2[n++] = vector;
            dataOutputStream.writeUTF(vector.getName());
        }
        dataOutputStream.writeInt(dataSource.getTotalNumberOfThreads());
        object = dataSource.getNodes();
        while (object.hasNext()) {
            vector = (Node)object.next();
            Iterator iterator = vector.getContexts();
            while (iterator.hasNext()) {
                group = (Context)iterator.next();
                Iterator iterator2 = group.getThreads();
                while (iterator2.hasNext()) {
                    FunctionProfile functionProfile;
                    int n6;
                    Thread thread = (Thread)iterator2.next();
                    dataOutputStream.writeInt(thread.getNodeID());
                    dataOutputStream.writeInt(thread.getContextID());
                    dataOutputStream.writeInt(thread.getThreadID());
                    int n7 = 0;
                    for (n6 = 0; n6 < n2; ++n6) {
                        functionProfile = thread.getFunctionProfile(functionArray[n6]);
                        if (functionProfile == null) continue;
                        ++n7;
                    }
                    dataOutputStream.writeInt(n7);
                    for (n6 = 0; n6 < n2; ++n6) {
                        functionProfile = thread.getFunctionProfile(functionArray[n6]);
                        if (functionProfile == null) continue;
                        dataOutputStream.writeInt(n6);
                        dataOutputStream.writeDouble(functionProfile.getNumCalls());
                        dataOutputStream.writeDouble(functionProfile.getNumSubr());
                        for (int i = 0; i < n3; ++i) {
                            dataOutputStream.writeDouble(functionProfile.getExclusive(i));
                            dataOutputStream.writeDouble(functionProfile.getInclusive(i));
                        }
                    }
                    n7 = 0;
                    for (n6 = 0; n6 < n4; ++n6) {
                        functionProfile = thread.getUserEventProfile((UserEvent)object2[n6]);
                        if (functionProfile == null) continue;
                        ++n7;
                    }
                    dataOutputStream.writeInt(n7);
                    for (n6 = 0; n6 < n4; ++n6) {
                        functionProfile = thread.getUserEventProfile((UserEvent)object2[n6]);
                        if (functionProfile == null) continue;
                        dataOutputStream.writeInt(n6);
                        dataOutputStream.writeInt(functionProfile.getUserEventNumberValue());
                        dataOutputStream.writeDouble(functionProfile.getUserEventMinValue());
                        dataOutputStream.writeDouble(functionProfile.getUserEventMaxValue());
                        dataOutputStream.writeDouble(functionProfile.getUserEventMeanValue());
                        dataOutputStream.writeDouble(functionProfile.getUserEventSumSquared());
                    }
                }
            }
        }
        dataOutputStream.close();
        gZIPOutputStream.close();
        fileOutputStream.close();
    }

    public static void exportTrial(ParaProfTrial paraProfTrial, Component component) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Export Trial");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        jFileChooser.setFileFilter(new ParaProfImageFormatFileFilter(ParaProfImageFormatFileFilter.PPK));
        jFileChooser.setFileSelectionMode(0);
        int n = jFileChooser.showSaveDialog(component);
        if (n != 0) {
            return;
        }
        try {
            int n2;
            File file = jFileChooser.getSelectedFile();
            String string = file.getCanonicalPath();
            String string2 = ParaProfImageFormatFileFilter.getExtension(file);
            if (string2 == null) {
                string = string + ".ppk";
                file = new File(string);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(component, file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
                return;
            }
            ParaProfUtils.writePacked(paraProfTrial.getDataSource(), file);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private static void writeMetric(String string, DataSource dataSource, int n, Function[] functionArray, String[] stringArray, UserEvent[] userEventArray) throws IOException {
        int n2 = dataSource.getNumFunctions();
        int n3 = dataSource.getNumberOfMetrics();
        int n4 = dataSource.getNumUserEvents();
        int n5 = dataSource.getNumGroups();
        Iterator iterator = dataSource.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    FunctionProfile functionProfile;
                    int n6;
                    Thread thread = (Thread)iterator3.next();
                    File file = new File(string + "/profile." + thread.getNodeID() + "." + thread.getContextID() + "." + thread.getThreadID());
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                    BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
                    int n7 = 0;
                    for (n6 = 0; n6 < n2; ++n6) {
                        functionProfile = thread.getFunctionProfile(functionArray[n6]);
                        if (functionProfile == null) continue;
                        ++n7;
                    }
                    if (dataSource.getNumberOfMetrics() == 1 && dataSource.getMetricName(n).equals("Time")) {
                        bufferedWriter.write(n7 + " templated_functions\n");
                    } else {
                        bufferedWriter.write(n7 + " templated_functions_MULTI_" + dataSource.getMetricName(n) + "\n");
                    }
                    bufferedWriter.write("# Name Calls Subrs Excl Incl ProfileCalls\n");
                    for (n6 = 0; n6 < n2; ++n6) {
                        functionProfile = thread.getFunctionProfile(functionArray[n6]);
                        if (functionProfile == null) continue;
                        bufferedWriter.write('\"' + functionArray[n6].getName() + "\" ");
                        bufferedWriter.write((int)functionProfile.getNumCalls() + " ");
                        bufferedWriter.write((int)functionProfile.getNumSubr() + " ");
                        bufferedWriter.write(functionProfile.getExclusive(n) + " ");
                        bufferedWriter.write(functionProfile.getInclusive(n) + " ");
                        bufferedWriter.write("0 GROUP=\"" + stringArray[n6] + "\"\n");
                    }
                    bufferedWriter.write("0 aggregates\n");
                    n7 = 0;
                    for (n6 = 0; n6 < n4; ++n6) {
                        functionProfile = thread.getUserEventProfile(userEventArray[n6]);
                        if (functionProfile == null) continue;
                        ++n7;
                    }
                    if (n7 > 0) {
                        bufferedWriter.write(n7 + " userevents\n");
                        bufferedWriter.write("# eventname numevents max min mean sumsqr\n");
                        for (n6 = 0; n6 < n4; ++n6) {
                            functionProfile = thread.getUserEventProfile(userEventArray[n6]);
                            if (functionProfile == null) continue;
                            bufferedWriter.write('\"' + userEventArray[n6].getName() + "\" ");
                            bufferedWriter.write(functionProfile.getUserEventNumberValue() + " ");
                            bufferedWriter.write(functionProfile.getUserEventMaxValue() + " ");
                            bufferedWriter.write(functionProfile.getUserEventMinValue() + " ");
                            bufferedWriter.write(functionProfile.getUserEventMeanValue() + " ");
                            bufferedWriter.write(functionProfile.getUserEventSumSquared() + "\n");
                        }
                    }
                    bufferedWriter.close();
                    outputStreamWriter.close();
                    fileOutputStream.close();
                }
            }
        }
    }

    public static void writeProfiles(DataSource dataSource, File file) throws IOException {
        int n;
        Object object;
        Object object2;
        UserEvent[] userEventArray;
        String[] stringArray;
        int n2 = dataSource.getNumFunctions();
        int n3 = dataSource.getNumberOfMetrics();
        int n4 = dataSource.getNumUserEvents();
        int n5 = dataSource.getNumGroups();
        int n6 = 0;
        Group[] groupArray = new Group[n5];
        Function[] functionArray = dataSource.getGroups();
        while (functionArray.hasNext()) {
            stringArray = (String[])functionArray.next();
            userEventArray = stringArray.getName();
            groupArray[n6++] = stringArray;
        }
        functionArray = new Function[n2];
        stringArray = new String[n2];
        n6 = 0;
        userEventArray = dataSource.getFunctions();
        while (userEventArray.hasNext()) {
            object2 = (Function)userEventArray.next();
            functionArray[n6] = object2;
            object = object2.getGroups();
            if (object == null) {
                stringArray[n6] = "";
            } else {
                stringArray[n6] = "";
                for (n = 0; n < ((Vector)object).size(); ++n) {
                    Group group = (Group)((Vector)object).get(n);
                    stringArray[n6] = stringArray[n6] + " " + group.getName();
                }
                stringArray[n6] = stringArray[n6].trim();
            }
            ++n6;
        }
        userEventArray = new UserEvent[n4];
        n6 = 0;
        object2 = dataSource.getUserEvents();
        while (object2.hasNext()) {
            object = (UserEvent)object2.next();
            userEventArray[n6++] = object;
        }
        if (n3 == 1) {
            ParaProfUtils.writeMetric(".", dataSource, 0, functionArray, stringArray, userEventArray);
        } else {
            for (int i = 0; i < n3; ++i) {
                object = "MULTI__" + dataSource.getMetricName(i);
                n = new File((String)object).mkdir() ? 1 : 0;
                if (n == 0) {
                    System.err.println("Failed to create directory: " + (String)object);
                    continue;
                }
                ParaProfUtils.writeMetric((String)object, dataSource, i, functionArray, stringArray, userEventArray);
            }
        }
    }

    public static String getFunctionName(Function function) {
        if (ParaProf.preferences.getReversedCallPaths()) {
            return function.getReversedName();
        }
        return function.getName();
    }

    public static void handleException(Exception exception) {
        new ParaProfErrorDialog(exception);
    }
}

