/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PrefSpacingPanel;
import edu.uoregon.tau.paraprof.Preferences;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;

public class PreferencesWindow
extends JFrame
implements ActionListener,
Observer {
    private boolean mShown = false;
    private PrefSpacingPanel prefSpacingPanel;
    private JCheckBox bold;
    private JCheckBox italic;
    private JComboBox fontComboBox;
    private JLabel barHeightLabel = new JLabel("Size");
    private JSlider barHeightSlider = new JSlider(0, 0, 40, 0);
    private Preferences preferences;
    private int barSpacing = 0;
    private int barHeight = 0;
    private boolean barDetailsSet = false;
    private String paraProfFont = "SansSerif";
    private int fontStyle = 0;
    private int fontSize = 12;
    JComboBox unitsBox;
    JCheckBox showValuesAsPercentBox = new JCheckBox("Show Values as Percent");
    JCheckBox showPathTitleInReverseBox = new JCheckBox("Show Path Title in Reverse");
    JCheckBox reverseCallPathsBox = new JCheckBox("Reverse Call Paths");

    void setControls() {
        int n = this.fontComboBox.getItemCount();
        int n2 = 0;
        String string = (String)this.fontComboBox.getItemAt(n2);
        while (n2 < n && !this.paraProfFont.equals(string)) {
            string = (String)this.fontComboBox.getItemAt(++n2);
        }
        if (n2 == n) {
            System.out.println("The default font was not found!  This is not a good thing as it is a default Java font!");
        } else {
            this.fontComboBox.setSelectedIndex(n2);
        }
        this.bold.setSelected(this.fontStyle == 1 || this.fontStyle == 3);
        this.italic.setSelected(this.fontStyle == 2 || this.fontStyle == 3);
        this.barHeightSlider.setValue(this.fontSize);
    }

    public PreferencesWindow(Preferences preferences) {
        this.preferences = preferences;
        String[] stringArray = new String[]{"Microseconds", "Milliseconds", "Seconds", "hr:mm:ss"};
        this.unitsBox = new JComboBox<String>(stringArray);
        if (preferences.getLoaded()) {
            this.paraProfFont = preferences.getParaProfFont();
            this.fontStyle = preferences.getFontStyle();
            this.fontSize = preferences.getFontSize();
            this.unitsBox.setSelectedIndex(preferences.getUnits());
            this.showValuesAsPercentBox.setSelected(preferences.getShowValuesAsPercent());
            this.showPathTitleInReverseBox.setSelected(preferences.getShowPathTitleInReverse());
            this.reverseCallPathsBox.setSelected(preferences.getReversedCallPaths());
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferencesWindow.this.thisWindowClosing(windowEvent);
            }
        });
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray2 = graphicsEnvironment.getAvailableFontFamilyNames();
        this.fontComboBox = new JComboBox<String>(stringArray2);
        this.fontComboBox.addActionListener(this);
        this.prefSpacingPanel = new PrefSpacingPanel();
        this.setTitle("ParaProf Preferences");
        int n = 550;
        int n2 = 350;
        this.setSize(new Dimension(n, n2));
        this.setResizable(true);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        int n5 = 0;
        int n6 = 0;
        this.setLocation(n5, n6);
        this.setupMenus();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        JScrollPane jScrollPane = new JScrollPane(this.prefSpacingPanel);
        jScrollPane.setPreferredSize(new Dimension(300, 200));
        this.bold = new JCheckBox("Bold");
        this.bold.addActionListener(this);
        this.italic = new JCheckBox("Italic");
        this.italic.addActionListener(this);
        this.setControls();
        this.barHeightSlider.setPaintTicks(true);
        this.barHeightSlider.setMajorTickSpacing(10);
        this.barHeightSlider.setMinorTickSpacing(5);
        this.barHeightSlider.setPaintLabels(true);
        this.barHeightSlider.addChangeListener(this.prefSpacingPanel);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Font"));
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(jPanel, this.fontComboBox, gridBagConstraints, 0, 0, 2, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(jPanel, this.bold, gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(jPanel, this.italic, gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(jPanel, this.barHeightLabel, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.weighty = 0.25;
        ParaProfUtils.addCompItem(jPanel, this.barHeightSlider, gridBagConstraints, 1, 2, 1, 1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Window defaults"));
        jPanel2.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Units");
        ParaProfUtils.addCompItem(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(jPanel2, this.unitsBox, gridBagConstraints, 1, 0, 1, 1);
        ParaProfUtils.addCompItem(jPanel2, this.showValuesAsPercentBox, gridBagConstraints, 0, 1, 2, 1);
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Settings"));
        jPanel3.setLayout(new GridBagLayout());
        ParaProfUtils.addCompItem(jPanel3, this.showPathTitleInReverseBox, gridBagConstraints, 0, 2, 2, 1);
        ParaProfUtils.addCompItem(jPanel3, this.reverseCallPathsBox, gridBagConstraints, 0, 3, 2, 1);
        this.addCompItem(jPanel, gridBagConstraints, 0, 0, 1, 1);
        this.addCompItem(jPanel2, gridBagConstraints, 0, 1, 1, 1);
        this.addCompItem(jPanel3, gridBagConstraints, 1, 1, 1, 1);
        JButton jButton = new JButton("Restore Defaults");
        jButton.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jButton, gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.addCompItem(jScrollPane, gridBagConstraints, 1, 0, 1, 1);
        JPanel jPanel4 = new JPanel();
        JButton jButton2 = new JButton("Apply");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Cancel");
        jButton3.addActionListener(this);
        jPanel4.add(jButton2);
        jPanel4.add(jButton3);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(jPanel4, gridBagConstraints, 1, 2, 1, 1);
        this.setSavedPreferences();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Load Preferences...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Save Preferences...");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Edit Default Colors");
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Show Color Map");
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Apply and Close Window");
        jMenuItem4.addActionListener(this);
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("Exit ParaProf!");
        jMenuItem5.addActionListener(this);
        jMenu.add(jMenuItem5);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    public void showPreferencesWindow() {
        this.setTitle("ParaProf Preferences");
        this.show();
    }

    public void loadSavedPreferences() {
        this.preferences = ParaProf.preferences;
        if (this.preferences.getLoaded()) {
            this.paraProfFont = this.preferences.getParaProfFont();
            this.fontStyle = this.preferences.getFontStyle();
            this.fontSize = this.preferences.getFontSize();
        }
    }

    public void setSavedPreferences() {
        ParaProf.preferences.setParaProfFont(this.paraProfFont);
        ParaProf.preferences.setFontStyle(this.fontStyle);
        ParaProf.preferences.setFontSize(this.fontSize);
        ParaProf.preferences.setUnits(this.unitsBox.getSelectedIndex());
        ParaProf.preferences.setShowValuesAsPercent(this.showValuesAsPercentBox.isSelected());
        ParaProf.preferences.setShowPathTitleInReverse(this.showPathTitleInReverseBox.isSelected());
        ParaProf.preferences.setReversedCallPaths(this.reverseCallPathsBox.isSelected());
    }

    public boolean areBarDetailsSet() {
        return this.barDetailsSet;
    }

    public String getParaProfFont() {
        return this.paraProfFont;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setBarDetails(Graphics2D graphics2D) {
        if (!this.barDetailsSet) {
            Font font = new Font(this.paraProfFont, this.fontStyle, this.fontSize);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n = fontMetrics.getAscent();
            int n2 = fontMetrics.getMaxDescent();
            this.barHeight = n;
            this.barSpacing = n + n2 + 2;
            this.barDetailsSet = true;
        }
    }

    public void setFontSize(int n) {
        this.fontSize = n;
        this.barDetailsSet = false;
    }

    public void updateFontSize() {
        this.fontSize = Math.max(1, this.barHeightSlider.getValue());
        this.barDetailsSet = false;
    }

    public int getBarSpacing() {
        return this.barSpacing;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block28: {
            try {
                Object object = actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                if (object instanceof JMenuItem) {
                    if (string.equals("Show Color Map")) {
                        ParaProf.colorMap.showColorMap();
                        break block28;
                    }
                    if (string.equals("Load Preferences...")) {
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setCurrentDirectory(new File("."));
                        int n = jFileChooser.showOpenDialog(this);
                        if (n != 0) break block28;
                        File file = jFileChooser.getSelectedFile();
                        try {
                            ParaProf.loadPreferences(file);
                        }
                        catch (Exception exception) {
                            JOptionPane.showMessageDialog(this, "Error loading preferences!", "ParaProf Preferences", 0);
                        }
                        this.loadSavedPreferences();
                        this.setControls();
                        break block28;
                    }
                    if (string.equals("Save Preferences...")) {
                        File file;
                        JFileChooser jFileChooser = new JFileChooser();
                        jFileChooser.setCurrentDirectory(new File("."));
                        int n = jFileChooser.showSaveDialog(this);
                        if (n == 0 && !ParaProf.savePreferences(file = jFileChooser.getSelectedFile())) {
                            JOptionPane.showMessageDialog(this, "Error Saving preferences!", "ParaProf Preferences", 0);
                        }
                    } else if (string.equals("Edit Default Colors")) {
                        ParaProf.colorChooser.showColorChooser();
                    } else if (string.equals("Exit ParaProf!")) {
                        this.setVisible(false);
                        this.dispose();
                        ParaProf.exitParaProf(0);
                    } else if (string.equals("Apply and Close Window")) {
                        this.setVisible(false);
                        this.apply();
                    }
                    break block28;
                }
                if (object instanceof JCheckBox) {
                    if (string.equals("Bold Font")) {
                        this.fontStyle = this.italic.isSelected() ? 3 : 1;
                        this.prefSpacingPanel.repaint();
                    } else if (string.equals("Italic Font")) {
                        this.fontStyle = this.italic.isSelected() ? (this.bold.isSelected() ? 3 : 2) : (this.bold.isSelected() ? 1 : 0);
                        this.prefSpacingPanel.repaint();
                    }
                } else if (object == this.fontComboBox) {
                    this.paraProfFont = (String)this.fontComboBox.getSelectedItem();
                    this.prefSpacingPanel.repaint();
                } else if (object instanceof JButton) {
                    if (string.equals("Apply")) {
                        this.apply();
                    } else if (string.equals("Cancel")) {
                        this.setVisible(false);
                        this.paraProfFont = this.preferences.getParaProfFont();
                        this.fontStyle = this.preferences.getFontStyle();
                        this.fontSize = this.preferences.getFontSize();
                        this.setControls();
                    } else if (string.equals("Restore Defaults")) {
                        this.paraProfFont = "SansSerif";
                        this.fontStyle = 0;
                        this.fontSize = 12;
                        this.unitsBox.setSelectedIndex(0);
                        this.showValuesAsPercentBox.setSelected(true);
                        this.showPathTitleInReverseBox.setSelected(true);
                        this.reverseCallPathsBox.setSelected(false);
                        this.setControls();
                    }
                }
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    private void apply() {
        boolean bl = false;
        if (this.reverseCallPathsBox.isSelected() != ParaProf.preferences.getReversedCallPaths()) {
            bl = true;
        }
        this.setSavedPreferences();
        Vector vector = ParaProf.paraProfManager.getLoadedTrials();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
            paraProfTrial.getSystemEvents().updateRegisteredObjects("prefEvent");
            paraProfTrial.getSystemEvents().updateRegisteredObjects("dataEvent");
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("colorEvent")) {
            this.prefSpacingPanel.repaint();
        }
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.paraProfFont = this.preferences.getParaProfFont();
        this.fontStyle = this.preferences.getFontStyle();
        this.fontSize = this.preferences.getFontSize();
        this.setControls();
    }
}

