/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl;

import java.awt.Canvas;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLContextHelper;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLException;
import net.java.games.jogl.GLPbuffer;
import net.java.games.jogl.GLU;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextFactory;
import net.java.games.jogl.impl.GLDrawableHelper;
import net.java.games.jogl.impl.GLPbufferImpl;
import net.java.games.jogl.impl.SingleThreadedWorkaround;

public final class GLCanvas
extends Canvas
implements GLDrawable {
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private GLContext context;
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new DisplayOnEventDispatchThreadAction();
    private SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new SwapBuffersOnEventDispatchThreadAction();

    GLCanvas(GraphicsConfiguration graphicsConfiguration, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLDrawable gLDrawable) {
        super(graphicsConfiguration);
        this.context = GLContextFactory.getFactory().createGLContext(this, gLCapabilities, gLCapabilitiesChooser, GLContextHelper.getContext(gLDrawable));
    }

    public void display() {
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction, false);
    }

    public void paint(Graphics graphics) {
        if (!this.context.getNoAutoRedrawMode()) {
            this.display();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.context.setRealized();
    }

    public void removeNotify() {
        this.context.destroy();
        super.removeNotify();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        final int n5 = n3;
        final int n6 = n4;
        final Runnable runnable = new Runnable(){

            public void run() {
                GLCanvas.this.getGL().glViewport(0, 0, n5, n6);
                GLCanvas.this.drawableHelper.reshape(GLCanvas.this, 0, 0, n5, n6);
            }
        };
        Runnable runnable2 = new Runnable(){

            public void run() {
                GLCanvas.this.context.invokeGL(runnable, true, GLCanvas.this.initAction);
            }
        };
        this.maybeDoSingleThreadedWorkaround(runnable2, runnable, true);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GL getGL() {
        return this.context.getGL();
    }

    public void setGL(GL gL) {
        this.context.setGL(gL);
    }

    public GLU getGLU() {
        return this.context.getGLU();
    }

    public void setGLU(GLU gLU) {
        this.context.setGLU(gLU);
    }

    void willSetRenderingThread() {
        this.context.willSetRenderingThread();
    }

    public void setRenderingThread(Thread thread) throws GLException {
        this.context.setRenderingThread(thread, this.initAction);
    }

    public Thread getRenderingThread() {
        return this.context.getRenderingThread();
    }

    public void setNoAutoRedrawMode(boolean bl) {
        this.context.setNoAutoRedrawMode(bl);
    }

    public boolean getNoAutoRedrawMode() {
        return this.context.getNoAutoRedrawMode();
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.context.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.context.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction, false);
    }

    public boolean canCreateOffscreenDrawable() {
        return this.context.canCreatePbufferContext();
    }

    public GLPbuffer createOffscreenDrawable(GLCapabilities gLCapabilities, int n, int n2) {
        return new GLPbufferImpl(this.context.createPbufferContext(gLCapabilities, n, n2));
    }

    GLContext getContext() {
        return this.context;
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2, boolean bl) {
        if (SingleThreadedWorkaround.doWorkaround() && !EventQueue.isDispatchThread()) {
            try {
                if (!bl) {
                    EventQueue.invokeAndWait(runnable);
                }
                EventQueue.invokeLater(runnable);
            }
            catch (Exception exception) {
                throw new GLException(exception);
            }
        } else {
            this.context.invokeGL(runnable2, bl, this.initAction);
        }
    }

    class SwapBuffersOnEventDispatchThreadAction
    implements Runnable {
        SwapBuffersOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.context.invokeGL(GLCanvas.this.swapBuffersAction, false, GLCanvas.this.initAction);
        }
    }

    class DisplayOnEventDispatchThreadAction
    implements Runnable {
        DisplayOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.context.invokeGL(GLCanvas.this.displayAction, false, GLCanvas.this.initAction);
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLCanvas.this.context.swapBuffers();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.display(GLCanvas.this);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.init(GLCanvas.this);
        }
    }
}

