/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Group;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public abstract class DataSource {
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private boolean groupNamesPresent = false;
    private Vector metrics = null;
    protected Thread meanData = null;
    protected Thread totalData = null;
    private Map nodes = new TreeMap();
    private Map functions = new TreeMap();
    private Map groups = new TreeMap();
    private Map userEvents = new TreeMap();
    private int[] maxNCT = null;

    public abstract void load() throws FileNotFoundException, IOException, DataSourceException, SQLException;

    public abstract int getProgress();

    public abstract void cancelLoad();

    public Thread getMeanData() {
        return this.meanData;
    }

    public Thread getTotalData() {
        return this.totalData;
    }

    protected void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean getCallPathDataPresent() {
        return this.callPathDataPresent;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    public boolean getGroupNamesPresent() {
        return this.groupNamesPresent;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean getUserEventsPresent() {
        return this.userEventsPresent;
    }

    public Function addFunction(String string, int n) {
        Object v = this.functions.get(string = string.trim());
        if (v != null) {
            return (Function)v;
        }
        Function function = new Function(string, this.functions.size(), n);
        this.functions.put(string, function);
        return function;
    }

    public Function getFunction(String string) {
        Function function = (Function)this.functions.get(string.trim());
        return (Function)this.functions.get(string.trim());
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public Iterator getFunctions() {
        return this.functions.values().iterator();
    }

    public UserEvent addUserEvent(String string) {
        Object v = this.userEvents.get(string);
        if (v != null) {
            return (UserEvent)v;
        }
        UserEvent userEvent = new UserEvent(string, this.userEvents.size() + 1);
        this.userEvents.put(string, userEvent);
        return userEvent;
    }

    public UserEvent getUserEvent(String string) {
        return (UserEvent)this.userEvents.get(string);
    }

    public int getNumUserEvents() {
        return this.userEvents.size();
    }

    public Iterator getUserEvents() {
        return this.userEvents.values().iterator();
    }

    public Group addGroup(String string) {
        Object v = this.groups.get(string);
        if (v != null) {
            return (Group)v;
        }
        Group group = new Group(string, this.groups.size() + 1);
        this.groups.put(string, group);
        return group;
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public Iterator getGroups() {
        return this.groups.values().iterator();
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            Iterator iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (node.getNodeID() > this.maxNCT[0]) {
                    this.maxNCT[0] = node.getNodeID();
                }
                Iterator iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = (Context)iterator2.next();
                    if (context.getContextID() > this.maxNCT[1]) {
                        this.maxNCT[1] = context.getContextID();
                    }
                    Iterator iterator3 = context.getThreads();
                    while (iterator3.hasNext()) {
                        Thread thread = (Thread)iterator3.next();
                        if (thread.getThreadID() <= this.maxNCT[2]) continue;
                        this.maxNCT[2] = thread.getThreadID();
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public int getNumThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    iterator3.next();
                    ++n;
                }
            }
        }
        return n;
    }

    public void setMetrics(Vector vector) {
        this.metrics = vector;
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new Vector();
        }
        metric.setID(this.getNumberOfMetrics());
        this.metrics.add(metric);
    }

    public Metric addMetric(String string) {
        Object object;
        if (this.metrics != null) {
            object = this.metrics.iterator();
            while (object.hasNext()) {
                Metric metric = (Metric)object.next();
                if (!metric.getName().equals(string)) continue;
                return metric;
            }
        }
        object = new Metric();
        ((Metric)object).setName(string);
        this.addMetric((Metric)object);
        return object;
    }

    public Vector getMetrics() {
        return this.metrics;
    }

    public Metric getMetric(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return (Metric)this.metrics.elementAt(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return ((Metric)this.metrics.elementAt(n)).getName();
        }
        return null;
    }

    public int getNumberOfMetrics() {
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return -1;
    }

    protected void generateDerivedData() {
        Enumeration enumeration = this.getThreads().elements();
        while (enumeration.hasMoreElements()) {
            ((Thread)enumeration.nextElement()).setThreadDataAllMetrics();
        }
        this.setMeanData(0, this.getNumberOfMetrics() - 1);
        this.meanData.setThreadDataAllMetrics();
    }

    public void setMeanData(int n, int n2) {
        Object object;
        Object object2;
        Comparable comparable;
        Object object3;
        int n3 = this.getNumberOfMetrics();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray3 = new double[n3];
        Iterator iterator = this.getFunctions();
        if (this.meanData == null) {
            this.meanData = new Thread(-1, -1, -1, n3);
        }
        if (this.totalData == null) {
            this.totalData = new Thread(-2, -2, -2, n3);
        }
        for (int i = 0; i < n3; ++i) {
            object3 = this.getNodes();
            while (object3.hasNext()) {
                comparable = (Node)object3.next();
                Iterator iterator2 = ((Node)comparable).getContexts();
                while (iterator2.hasNext()) {
                    Context context = (Context)iterator2.next();
                    object2 = context.getThreads();
                    while (object2.hasNext()) {
                        object = (Thread)object2.next();
                        int n4 = i;
                        dArray3[n4] = dArray3[n4] + ((Thread)object).getMaxInclusive(i);
                    }
                }
            }
        }
        while (iterator.hasNext()) {
            int n5;
            Function function = (Function)iterator.next();
            object3 = this.meanData.getFunctionProfile(function);
            if (object3 == null) {
                object3 = new FunctionProfile(function, n3);
                this.meanData.addFunctionProfile((FunctionProfile)object3);
            }
            function.setMeanProfile((FunctionProfile)object3);
            comparable = this.totalData.getFunctionProfile(function);
            if (comparable == null) {
                comparable = new FunctionProfile(function, n3);
                this.totalData.addFunctionProfile((FunctionProfile)comparable);
            }
            function.setTotalProfile((FunctionProfile)comparable);
            d = 0.0;
            d2 = 0.0;
            for (n5 = 0; n5 < n3; ++n5) {
                dArray[n5] = 0.0;
                dArray2[n5] = 0.0;
            }
            n5 = 0;
            Iterator iterator3 = this.getNodes();
            while (iterator3.hasNext()) {
                object2 = (Node)iterator3.next();
                object = ((Node)object2).getContexts();
                while (object.hasNext()) {
                    Context context = (Context)object.next();
                    Iterator iterator4 = context.getThreads();
                    while (iterator4.hasNext()) {
                        Thread thread = (Thread)iterator4.next();
                        FunctionProfile functionProfile = thread.getFunctionProfile(function);
                        if (functionProfile != null) {
                            for (int i = n; i <= n2; ++i) {
                                int n6 = i;
                                dArray[n6] = dArray[n6] + functionProfile.getExclusive(i);
                                int n7 = i;
                                dArray2[n7] = dArray2[n7] + functionProfile.getInclusive(i);
                                if (i != 0) continue;
                                d += functionProfile.getNumCalls();
                                d2 += functionProfile.getNumSubr();
                            }
                        }
                        ++n5;
                    }
                }
            }
            if (n == 0) {
                ((FunctionProfile)comparable).setNumCalls(d);
                ((FunctionProfile)comparable).setNumSubr(d2);
                ((FunctionProfile)object3).setNumCalls(d / (double)n5);
                ((FunctionProfile)object3).setNumSubr(d2 / (double)n5);
            }
            for (int i = n; i <= n2; ++i) {
                ((FunctionProfile)comparable).setExclusive(i, dArray[i]);
                ((FunctionProfile)comparable).setInclusive(i, dArray2[i]);
                ((FunctionProfile)object3).setExclusive(i, dArray[i] / (double)n5);
                ((FunctionProfile)object3).setInclusive(i, dArray2[i] / (double)n5);
                if (dArray3[i] == 0.0) continue;
                ((FunctionProfile)comparable).setInclusivePercent(i, ((FunctionProfile)comparable).getInclusive(i) / dArray3[i] * 100.0);
                ((FunctionProfile)comparable).setExclusivePercent(i, ((FunctionProfile)comparable).getExclusive(i) / dArray3[i] * 100.0);
                ((FunctionProfile)object3).setInclusivePercent(i, ((FunctionProfile)comparable).getInclusivePercent(i));
                ((FunctionProfile)object3).setExclusivePercent(i, ((FunctionProfile)comparable).getExclusivePercent(i));
            }
        }
    }

    public Node addNode(int n) {
        Object v = this.nodes.get(new Integer(n));
        if (v != null) {
            return (Node)v;
        }
        Node node = new Node(n);
        this.nodes.put(new Integer(n), node);
        return node;
    }

    public Node getNode(int n) {
        return (Node)this.nodes.get(new Integer(n));
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator getNodes() {
        return this.nodes.values().iterator();
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return this.getNode(n).getNumberOfContexts();
    }

    public Iterator getContexts(int n) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContexts();
        }
        return null;
    }

    public Context getContext(int n, int n2) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContext(n2);
        }
        return null;
    }

    public int getTotalNumberOfThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public Vector getThreads() {
        Vector<Thread> vector = new Vector<Thread>();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    vector.add(thread);
                }
            }
        }
        return vector;
    }

    public Vector getThreads(int n) {
        Vector<Thread> vector = new Vector<Thread>();
        Node node = this.getNode(n);
        Iterator iterator = node.getContexts();
        while (iterator.hasNext()) {
            Context context = (Context)iterator.next();
            Iterator iterator2 = context.getThreads();
            while (iterator2.hasNext()) {
                Thread thread = (Thread)iterator2.next();
                vector.add(thread);
            }
        }
        return vector;
    }

    public Iterator getThreads(int n, int n2) {
        Context context = this.getContext(n, n2);
        if (context != null) {
            return context.getThreads();
        }
        return null;
    }

    public Thread getThread(int n, int n2, int n3) {
        Object var4_4 = null;
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }
}

