/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.Function;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FunctionProfile
implements Comparable {
    private static final int METRIC_SIZE = 4;
    private Function function;
    private double[] doubleList;
    private double numCalls;
    private double numSubr;
    private Set childProfiles;
    private Set parentProfiles;
    private Map childProfileCallPathSets;
    private Map parentProfileCallPathSets;

    public FunctionProfile(Function function) {
        this(function, 1);
    }

    public FunctionProfile(Function function, int n) {
        this.doubleList = new double[n * 4];
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public String getName() {
        return this.function.getName();
    }

    public void setInclusive(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getInclusive(int n) {
        return this.getDouble(n, 0);
    }

    public void setExclusive(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getExclusive(int n) {
        return this.getDouble(n, 1);
    }

    public void setInclusivePercent(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getInclusivePercent(int n) {
        return this.getDouble(n, 2);
    }

    public void setExclusivePercent(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getExclusivePercent(int n) {
        return this.getDouble(n, 3);
    }

    public void setNumCalls(double d) {
        this.numCalls = d;
    }

    public double getNumCalls() {
        return this.numCalls;
    }

    public void setNumSubr(double d) {
        this.numSubr = d;
    }

    public double getNumSubr() {
        return this.numSubr;
    }

    public double getInclusivePerCall(int n) {
        return this.getInclusive(n) / this.getNumCalls();
    }

    public double getExclusivePerCall(int n) {
        return this.getExclusive(n) / this.getNumCalls();
    }

    public int getStorageSize() {
        return this.doubleList.length / 4;
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + 4];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
    }

    public void addChildProfile(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        TreeSet<FunctionProfile> treeSet;
        if (this.childProfiles == null) {
            this.childProfiles = new TreeSet();
        }
        this.childProfiles.add(functionProfile);
        if (this.childProfileCallPathSets == null) {
            this.childProfileCallPathSets = new TreeMap();
        }
        if ((treeSet = (TreeSet<FunctionProfile>)this.childProfileCallPathSets.get(functionProfile)) == null) {
            treeSet = new TreeSet<FunctionProfile>();
            this.childProfileCallPathSets.put(functionProfile, treeSet);
        }
        treeSet.add(functionProfile2);
    }

    public void addParentProfile(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        TreeSet<FunctionProfile> treeSet;
        if (this.parentProfiles == null) {
            this.parentProfiles = new TreeSet();
        }
        this.parentProfiles.add(functionProfile);
        if (this.parentProfileCallPathSets == null) {
            this.parentProfileCallPathSets = new TreeMap();
        }
        if ((treeSet = (TreeSet<FunctionProfile>)this.parentProfileCallPathSets.get(functionProfile)) == null) {
            treeSet = new TreeSet<FunctionProfile>();
            this.parentProfileCallPathSets.put(functionProfile, treeSet);
        }
        treeSet.add(functionProfile2);
    }

    public Iterator getChildProfiles() {
        if (this.childProfiles != null) {
            return this.childProfiles.iterator();
        }
        return new DssIterator();
    }

    public Iterator getParentProfiles() {
        if (this.parentProfiles != null) {
            return this.parentProfiles.iterator();
        }
        return new DssIterator();
    }

    public Iterator getParentProfileCallPathIterator(FunctionProfile functionProfile) {
        if (this.parentProfileCallPathSets == null) {
            return new DssIterator();
        }
        return ((Set)this.parentProfileCallPathSets.get(functionProfile)).iterator();
    }

    public Iterator getChildProfileCallPathIterator(FunctionProfile functionProfile) {
        if (this.childProfileCallPathSets == null) {
            return new DssIterator();
        }
        return ((Set)this.childProfileCallPathSets.get(functionProfile)).iterator();
    }

    public boolean isCallPathFunction() {
        return this.function.isCallPathFunction();
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 4 + n2;
        this.doubleList[n3] = d;
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 4 + n2;
        return this.doubleList[n3];
    }

    public int compareTo(Object object) {
        return this.function.compareTo(((FunctionProfile)object).function);
    }

    public String toString() {
        return "A FunctionProfile for " + this.function.toString();
    }
}

