/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DssIterator;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class Thread
implements Comparable {
    private int nodeID = -1;
    private int contextID = -1;
    private int threadID = -1;
    private Vector functionProfiles = new Vector();
    private Vector userEventProfiles = new Vector();
    private double[] doubleList;
    private double maxNumCalls = 0.0;
    private double maxNumSubr = 0.0;
    private boolean trimmed = false;
    private boolean relationsBuilt = false;
    private int numMetrics = 0;
    private static final int METRIC_SIZE = 6;

    public Thread(int n, int n2, int n3) {
        this(n, n2, n3, 1);
    }

    public Thread(int n, int n2, int n3, int n4) {
        this.nodeID = n;
        this.contextID = n2;
        this.threadID = n3;
        this.doubleList = new double[n4 * 6];
        this.numMetrics = n4;
    }

    public int getNodeID() {
        return this.nodeID;
    }

    public int getContextID() {
        return this.contextID;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public int getNumMetrics() {
        return this.numMetrics;
    }

    public void incrementStorage() {
        int n = this.doubleList.length;
        double[] dArray = new double[n + 6];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.doubleList[i];
        }
        this.doubleList = dArray;
        ++this.numMetrics;
    }

    public void addFunctionProfile(FunctionProfile functionProfile) {
        int n = functionProfile.getFunction().getID();
        if (n >= this.functionProfiles.size()) {
            this.functionProfiles.setSize(n + 1);
        }
        this.functionProfiles.set(n, functionProfile);
    }

    public void addUserEvent(UserEventProfile userEventProfile) {
        int n = userEventProfile.getUserEvent().getID();
        if (n >= this.userEventProfiles.size()) {
            this.userEventProfiles.setSize(n + 1);
        }
        this.userEventProfiles.set(n, userEventProfile);
    }

    public FunctionProfile getFunctionProfile(Function function) {
        if (this.functionProfiles != null && function.getID() < this.functionProfiles.size()) {
            return (FunctionProfile)this.functionProfiles.get(function.getID());
        }
        return null;
    }

    public Vector getFunctionProfiles() {
        return this.functionProfiles;
    }

    public Iterator getFunctionProfileIterator() {
        return new DssIterator(this.functionProfiles);
    }

    public UserEventProfile getUserEventProfile(UserEvent userEvent) {
        if (this.userEventProfiles != null && userEvent.getID() < this.userEventProfiles.size()) {
            return (UserEventProfile)this.userEventProfiles.elementAt(userEvent.getID());
        }
        return null;
    }

    public Vector getUserEventProfiles() {
        return this.userEventProfiles;
    }

    public ListIterator getUsereventListIterator() {
        return new DssIterator(this.userEventProfiles);
    }

    private void setMaxInclusive(int n, double d) {
        this.insertDouble(n, 0, d);
    }

    public double getMaxInclusive(int n) {
        return this.getDouble(n, 0);
    }

    private void setMaxExclusive(int n, double d) {
        this.insertDouble(n, 1, d);
    }

    public double getMaxExclusive(int n) {
        return this.getDouble(n, 1);
    }

    private void setMaxInclusivePercent(int n, double d) {
        this.insertDouble(n, 2, d);
    }

    public double getMaxInclusivePercent(int n) {
        return this.getDouble(n, 2);
    }

    private void setMaxExclusivePercent(int n, double d) {
        this.insertDouble(n, 3, d);
    }

    public double getMaxExclusivePercent(int n) {
        return this.getDouble(n, 3);
    }

    private void setMaxInclusivePerCall(int n, double d) {
        this.insertDouble(n, 4, d);
    }

    public double getMaxInclusivePerCall(int n) {
        return this.getDouble(n, 4);
    }

    private void setMaxExclusivePerCall(int n, double d) {
        this.insertDouble(n, 5, d);
    }

    public double getMaxExclusivePerCall(int n) {
        return this.getDouble(n, 5);
    }

    private void setMaxNumCalls(double d) {
        this.maxNumCalls = d;
    }

    public double getMaxNumCalls() {
        return this.maxNumCalls;
    }

    private void setMaxNumSubr(double d) {
        this.maxNumSubr = d;
    }

    public double getMaxNumSubr() {
        return this.maxNumSubr;
    }

    public void setTrimmed(boolean bl) {
        this.trimmed = bl;
    }

    public boolean trimmed() {
        return this.trimmed;
    }

    public void setRelationsBuilt(boolean bl) {
        this.relationsBuilt = bl;
    }

    public boolean relationsBuilt() {
        return this.relationsBuilt;
    }

    public int compareTo(Object object) {
        return this.threadID - ((Thread)object).getThreadID();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getNodeID() + "," + this.getContextID() + "," + this.getThreadID();
    }

    public void setThreadData(int n) {
        this.setThreadValues(n, n);
    }

    public void setThreadDataAllMetrics() {
        this.setThreadValues(0, this.getNumMetrics() - 1);
    }

    private void insertDouble(int n, int n2, double d) {
        int n3 = n * 6 + n2;
        this.doubleList[n3] = d;
    }

    private double getDouble(int n, int n2) {
        int n3 = n * 6 + n2;
        return this.doubleList[n3];
    }

    private void setThreadValues(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            Iterator iterator = this.getFunctionProfileIterator();
            while (iterator.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator.next();
                if (functionProfile == null) continue;
                d = Math.max(d, functionProfile.getInclusive(i));
                d2 = Math.max(d2, functionProfile.getExclusive(i));
                d3 = Math.max(d3, functionProfile.getInclusivePerCall(i));
                d4 = Math.max(d4, functionProfile.getExclusivePerCall(i));
                d5 = Math.max(d5, functionProfile.getNumCalls());
                d6 = Math.max(d6, functionProfile.getNumSubr());
            }
            this.setMaxInclusive(i, d);
            this.setMaxExclusive(i, d2);
            this.setMaxInclusivePerCall(i, d3);
            this.setMaxExclusivePerCall(i, d4);
            this.setMaxNumCalls(d5);
            this.setMaxNumSubr(d6);
            double d7 = 0.0;
            double d8 = 0.0;
            Iterator iterator2 = this.getFunctionProfileIterator();
            while (iterator2.hasNext()) {
                double d9;
                FunctionProfile functionProfile = (FunctionProfile)iterator2.next();
                if (functionProfile == null) continue;
                Function function = functionProfile.getFunction();
                if (this.getNodeID() > -1 && (d9 = this.getMaxInclusive(i)) != 0.0) {
                    double d10 = functionProfile.getExclusive(i) / d9 * 100.0;
                    double d11 = functionProfile.getInclusive(i) / d9 * 100.0;
                    functionProfile.setExclusivePercent(i, d10);
                    functionProfile.setInclusivePercent(i, d11);
                }
                d8 = Math.max(d8, functionProfile.getExclusivePercent(i));
                d7 = Math.max(d7, functionProfile.getInclusivePercent(i));
            }
            this.setMaxInclusivePercent(i, d7);
            this.setMaxExclusivePercent(i, d8);
        }
    }
}

