/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.DynaprofDataSource;
import edu.uoregon.tau.dms.dss.FileList;
import edu.uoregon.tau.dms.dss.GprofDataSource;
import edu.uoregon.tau.dms.dss.HPMToolkitDataSource;
import edu.uoregon.tau.dms.dss.MpiPDataSource;
import edu.uoregon.tau.dms.dss.PSRunDataSource;
import edu.uoregon.tau.dms.dss.PackedProfileDataSource;
import edu.uoregon.tau.dms.dss.TauDataSource;
import edu.uoregon.tau.dms.dss.TauPprofDataSource;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Vector;

public class UtilFncs {
    public static String lpad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        String string2 = new String(cArray, 0, n2);
        return string2.concat(string);
    }

    public static String pad(String string, int n) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = 32;
        }
        return string.concat(new String(cArray, 0, n2));
    }

    public static String formatDouble(double d, int n) {
        boolean bl = false;
        String string = Double.toString(d);
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'E') continue;
            bl = true;
            break;
        }
        if (!bl) {
            int n2;
            String string2 = "";
            for (n2 = 0; n2 < string.length(); ++n2) {
                string2 = string.charAt(n2) != '.' ? string2 + "#" : string2 + ".";
            }
            n2 = n;
            if (string2.length() < n2) {
                n2 = string2.length();
            }
            if (string2.indexOf(46) + 4 < n2) {
                n2 = string2.indexOf(46) + 4;
            }
            if ((string2 = string2.substring(0, n2)).charAt(string2.length() - 1) == '.') {
                string2 = string2.substring(0, string2.length() - 2);
            }
            DecimalFormat decimalFormat = new DecimalFormat(string2);
            string = decimalFormat.format(d);
            return UtilFncs.lpad(string, n);
        }
        String string3 = "0.0###";
        string3 = string3 + "E0";
        DecimalFormat decimalFormat = new DecimalFormat(string3);
        string = decimalFormat.format(d);
        return UtilFncs.lpad(string, n);
    }

    public static String getOutputString(int n, double d, int n2) {
        switch (n) {
            case 0: {
                return UtilFncs.formatDouble(d, n2);
            }
            case 1: {
                return UtilFncs.formatDouble(d / 1000.0, n2);
            }
            case 2: {
                return UtilFncs.formatDouble(d / 1000000.0, n2);
            }
            case 3: {
                int n3 = 0;
                int n4 = 0;
                n3 = (int)(d / 3.6E9);
                n4 = (int)((d -= (double)n3 * 3.6E9) / 6.0E7);
                String string = Integer.toString(n3);
                String string2 = Integer.toString(n4);
                String string3 = UtilFncs.formatDouble((d -= (double)n4 * 6.0E7) / 1000000.0, 7);
                int n5 = 0;
                for (int i = 0; i < string3.length(); ++i) {
                    if (string3.charAt(i) == ' ') continue;
                    n5 = i;
                    break;
                }
                string3 = string3.substring(n5);
                return UtilFncs.lpad(string + ":" + string2 + ":" + string3, n2);
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static String getUnitsString(int n, boolean bl, boolean bl2) {
        if (bl2) {
            if (!bl) {
                return "counts";
            }
            switch (n) {
                case 0: {
                    return "Derived metric shown in microseconds format";
                }
                case 1: {
                    return "Derived metric shown in milliseconds format";
                }
                case 2: {
                    return "Derived metric shown in seconds format";
                }
                case 3: {
                    return "Derived metric shown in hour:minute:seconds format";
                }
            }
            throw new RuntimeException("Unexpected string type: " + n);
        }
        if (!bl) {
            return "counts";
        }
        switch (n) {
            case 0: {
                return "microseconds";
            }
            case 1: {
                return "milliseconds";
            }
            case 2: {
                return "seconds";
            }
            case 3: {
                return "hour:minute:seconds";
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static String getValueTypeString(int n) {
        switch (n) {
            case 2: {
                return "exclusive";
            }
            case 4: {
                return "inclusive";
            }
            case 6: {
                return "number of calls";
            }
            case 8: {
                return "number of subroutines";
            }
            case 10: {
                return "per call value";
            }
            case 12: {
                return "number of userEvents";
            }
            case 14: {
                return "minimum number of userEvents";
            }
            case 16: {
                return "maximum number of userEvents";
            }
            case 18: {
                return "mean number of userEvents";
            }
            case 20: {
                return "Standard Deviation of User Event Value";
            }
        }
        throw new RuntimeException("Unexpected string type: " + n);
    }

    public static int exists(Vector vector, int n) {
        if (vector == null) {
            return -1;
        }
        Integer n2 = null;
        int n3 = vector.size();
        for (int i = 0; i < n3; ++i) {
            n2 = (Integer)vector.elementAt(i);
            if (n2 != n) continue;
            return i;
        }
        return -1;
    }

    public static DataSource initializeDataSource(File[] fileArray, int n, boolean bl) throws DataSourceException {
        DataSource dataSource = null;
        Vector vector = new Vector();
        switch (n) {
            case 0: {
                FileList fileList = new FileList();
                if (fileArray.length < 1) {
                    vector = fileList.helperFindProfiles(System.getProperty("user.dir"));
                    if (vector.size() == 0) {
                        throw new DataSourceException("profiles type: no profiles specified");
                    }
                } else if (fileArray[0].isDirectory()) {
                    if (fileArray.length > 1) {
                        throw new DataSourceException("profiles type: you can only specify one directory");
                    }
                    vector = fileList.helperFindProfiles(fileArray[0].toString());
                    if (vector.size() == 0) {
                        throw new DataSourceException("No profiles found in directory: " + fileArray[0]);
                    }
                } else {
                    vector.add(fileArray);
                }
                dataSource = new TauDataSource(vector);
                break;
            }
            case 1: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("pprof type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("pprof type: you must specify a file, not a directory");
                }
                vector.add(fileArray);
                dataSource = new TauPprofDataSource(vector);
                break;
            }
            case 2: {
                dataSource = new DynaprofDataSource(fileArray);
                break;
            }
            case 3: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("MpiP type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("MpiP type: you must specify a file, not a directory");
                }
                vector.add(fileArray);
                dataSource = new MpiPDataSource(vector);
                break;
            }
            case 4: {
                vector.add(fileArray);
                dataSource = new HPMToolkitDataSource(vector);
                break;
            }
            case 5: {
                dataSource = new GprofDataSource(fileArray, bl);
                break;
            }
            case 6: {
                vector.add(fileArray);
                dataSource = new PSRunDataSource(vector);
                break;
            }
            case 7: {
                if (fileArray.length != 1) {
                    throw new DataSourceException("Packed Profile type: you must specify exactly one file");
                }
                if (fileArray[0].isDirectory()) {
                    throw new DataSourceException("Packed Profile type: you must specify a file, not a directory");
                }
                dataSource = new PackedProfileDataSource(fileArray[0]);
                break;
            }
        }
        return dataSource;
    }
}

