/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.enums.CallGraphOption;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultGraphSelectionModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class CallGraphWindow
extends JFrame
implements ActionListener,
KeyListener,
ChangeListener,
Observer,
ParaProfImageInterface,
Printable,
ParaProfWindow {
    private static final int MARGIN = 20;
    private static final int HORIZONTAL_SPACING = 10;
    private static final int VERTICAL_SPACING = 120;
    private ParaProfTrial ppTrial = null;
    private Thread thread;
    private boolean meanWindow = false;
    private JMenu optionsMenu = null;
    private JMenuItem groupLedger = null;
    private JMenuItem usereventLedger = null;
    private JMenuItem callPathRelations = null;
    private JCheckBoxMenuItem slidersCheckBox = null;
    private Graph graph = null;
    private JScrollPane jGraphPane = null;
    private CallGraphOption widthOption = CallGraphOption.INCLUSIVE;
    private CallGraphOption colorOption = CallGraphOption.EXCLUSIVE;
    private int boxWidth = 120;
    private JLabel boxWidthLabel = new JLabel("Box width");
    private JSlider boxWidthSlider = new JSlider(0, 500, this.boxWidth);
    private Vector functionProfileList;
    private DefaultGraphModel model;
    private Vector graphCellVector;
    private Object[] cells;
    private Vector levels;
    private Vector backEdges;
    private Map vertexMap;
    private int widthMetricID;
    private int colorMetricID;
    private Font font;
    private int boxHeight;
    private Object clickedOnObject = null;
    private double scale = 1.0;

    public CallGraphWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this.ppTrial = paraProfTrial;
        this.colorMetricID = paraProfTrial.getDefaultMetricID();
        this.widthMetricID = paraProfTrial.getDefaultMetricID();
        if (thread.getNodeID() < 0) {
            this.meanWindow = true;
        }
        this.thread = thread;
        if (paraProfTrial.callPathDataPresent()) {
            CallPathUtilFuncs.buildThreadRelations((DataSource)paraProfTrial.getDataSource(), (Thread)thread);
        }
        this.functionProfileList = thread.getFunctionProfiles();
        if (this.meanWindow) {
            this.setTitle("Mean Call Graph - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("Call Graph n,c,t, " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CallGraphWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.boxWidthSlider.setPaintTicks(true);
        this.boxWidthSlider.setMajorTickSpacing(50);
        this.boxWidthSlider.setMinorTickSpacing(10);
        this.boxWidthSlider.setPaintLabels(true);
        this.boxWidthSlider.setSnapToTicks(false);
        this.boxWidthSlider.addChangeListener(this);
        this.boxWidthSlider.addKeyListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.font = new Font(paraProfTrial.getPreferencesWindow().getParaProfFont(), paraProfTrial.getPreferencesWindow().getFontStyle(), paraProfTrial.getPreferencesWindow().getBarHeight());
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        ColorBar colorBar = new ColorBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.addCompItem(colorBar, gridBagConstraints, 0, 0, 2, 1);
        this.createGraph();
        Dimension dimension = this.jGraphPane.getPreferredSize();
        dimension.width += 25;
        dimension.height += 95;
        if (dimension.width > 1000) {
            dimension.width = 1000;
        }
        if (dimension.height > 1000) {
            dimension.height = 1000;
        }
        ((Component)this).setSize(dimension);
        ((Component)this).setVisible(true);
        ParaProf.incrementNumWindows();
    }

    private Component createWidthMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.widthMetricID && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.widthOption = callGraphOption;
                    CallGraphWindow.this.widthMetricID = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private Component createColorMetricMenu(final CallGraphOption callGraphOption, boolean bl, ButtonGroup buttonGroup) {
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        if (this.ppTrial.getNumberOfMetrics() == 1) {
            jRadioButtonMenuItem = new JRadioButtonMenuItem(callGraphOption.toString(), bl);
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            return jRadioButtonMenuItem;
        }
        JMenu jMenu = new JMenu(callGraphOption.toString() + "...");
        int n = 0;
        while (n < this.ppTrial.getNumberOfMetrics()) {
            jRadioButtonMenuItem = n == this.widthMetricID && bl ? new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName(), true) : new JRadioButtonMenuItem(this.ppTrial.getMetric(n).getName());
            final int n2 = n++;
            jRadioButtonMenuItem.addActionListener(new ActionListener(){
                final int metric;
                {
                    this.metric = n2;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    CallGraphWindow.this.colorOption = callGraphOption;
                    CallGraphWindow.this.colorMetricID = this.metric;
                    CallGraphWindow.this.recreateGraph();
                }
            });
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        return jMenu;
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        Object var3_3 = null;
        this.optionsMenu = new JMenu("Options");
        Object var4_4 = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Width Slider", false);
        this.slidersCheckBox.addActionListener(this);
        this.optionsMenu.add(this.slidersCheckBox);
        jMenu = new JMenu("Box width by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jMenu.add(this.createWidthMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.widthOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Name Length", CallGraphOption.NAME_LENGTH == this.widthOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.widthOption = CallGraphOption.NAME_LENGTH;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenu = new JMenu("Box color by...");
        buttonGroup = new ButtonGroup();
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE, CallGraphOption.EXCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE, CallGraphOption.INCLUSIVE == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.EXCLUSIVE_PER_CALL, CallGraphOption.EXCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jMenu.add(this.createColorMetricMenu(CallGraphOption.INCLUSIVE_PER_CALL, CallGraphOption.INCLUSIVE_PER_CALL == this.colorOption, buttonGroup));
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", CallGraphOption.NUMCALLS == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMCALLS;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", CallGraphOption.NUMSUBR == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.NUMSUBR;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Static", CallGraphOption.STATIC == this.colorOption);
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphWindow.this.colorOption = CallGraphOption.STATIC;
                CallGraphWindow.this.recreateGraph();
            }
        });
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        this.optionsMenu.add(jMenu);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(this.optionsMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private double getMaxValue(CallGraphOption callGraphOption, int n) {
        double d = 1.0;
        if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d = this.thread.getMaxExclusive(n);
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d = this.thread.getMaxInclusive(n);
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d = this.thread.getMaxNumCalls();
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d = this.thread.getMaxNumSubr();
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d = this.thread.getMaxInclusivePerCall(n);
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d = this.thread.getMaxExclusivePerCall(n);
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d = 1.0;
        } else if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            d = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d;
    }

    private double getValue(FunctionProfile functionProfile, CallGraphOption callGraphOption, double d, int n) {
        double d2 = 1.0;
        if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE) {
            d2 = functionProfile.getExclusive(n) / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE) {
            d2 = functionProfile.getInclusive(n) / d;
        } else if (callGraphOption == CallGraphOption.NUMCALLS) {
            d2 = functionProfile.getNumCalls() / d;
        } else if (callGraphOption == CallGraphOption.NUMSUBR) {
            d2 = functionProfile.getNumSubr() / d;
        } else if (callGraphOption == CallGraphOption.INCLUSIVE_PER_CALL) {
            d2 = functionProfile.getInclusivePerCall(n) / d;
        } else if (callGraphOption == CallGraphOption.EXCLUSIVE_PER_CALL) {
            d2 = functionProfile.getExclusivePerCall(n) / d;
        } else if (callGraphOption == CallGraphOption.STATIC) {
            d2 = 1.0;
        } else {
            throw new ParaProfException("Unexpected CallGraphOption : " + callGraphOption);
        }
        return d2;
    }

    private int getWidth(FunctionProfile functionProfile, double d) {
        int n = 0;
        if (this.widthOption == CallGraphOption.NAME_LENGTH) {
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            n = fontMetrics.stringWidth(functionProfile.getName()) + 5;
        } else {
            n = (int)((double)this.boxWidth * this.getValue(functionProfile, this.widthOption, d, this.widthMetricID));
        }
        return n;
    }

    private void createGraph() {
        Object object;
        int n;
        Object object2;
        Vertex vertex;
        Object object3;
        Object object4;
        Object object5;
        Vector vector;
        Object object6;
        FunctionProfile functionProfile;
        this.vertexMap = new HashMap();
        this.backEdges = new Vector();
        double d = this.getMaxValue(this.widthOption, this.widthMetricID);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetricID);
        int n2 = 0;
        while (n2 < this.functionProfileList.size()) {
            functionProfile = (FunctionProfile)this.functionProfileList.elementAt(n2);
            if (functionProfile != null && !functionProfile.isCallPathFunction()) {
                object6 = new Vertex(functionProfile, this.getWidth(functionProfile, d));
                ((Vertex)object6).colorRatio = (float)this.getValue(functionProfile, this.colorOption, d2, this.colorMetricID);
                this.vertexMap.put(functionProfile, object6);
            }
            ++n2;
        }
        functionProfile = new Stack();
        object6 = new Stack();
        int n3 = 0;
        while (n3 < this.functionProfileList.size()) {
            Vertex vertex2;
            vector = (FunctionProfile)this.functionProfileList.elementAt(n3);
            if (vector != null && !vector.isCallPathFunction() && !(vertex2 = (Vertex)this.vertexMap.get(vector)).visited) {
                ((Vector)object6).add(vector);
                functionProfile.add(null);
                object5 = vector.getChildProfiles();
                while (object5.hasNext()) {
                    object4 = (FunctionProfile)object5.next();
                    functionProfile.add(object4);
                }
                while (!functionProfile.empty()) {
                    object4 = (FunctionProfile)functionProfile.pop();
                    if (object4 == null) {
                        ((Stack)object6).pop();
                        continue;
                    }
                    object3 = (Vertex)this.vertexMap.get(object4);
                    vertex = (FunctionProfile)((Stack)object6).peek();
                    object2 = (Vertex)this.vertexMap.get(vertex);
                    n = 0;
                    object = ((AbstractList)object6).iterator();
                    while (object.hasNext()) {
                        if ((FunctionProfile)object.next() != object4) continue;
                        n = 1;
                        break;
                    }
                    if (n != 0) {
                        this.backEdges.add(new BackEdge((Vertex)object2, (Vertex)object3));
                        continue;
                    }
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < ((Vertex)object2).children.size()) {
                        if (((Vertex)object2).children.get(n4) == object3) {
                            bl = true;
                        }
                        ++n4;
                    }
                    if (!bl) {
                        ((Vertex)object2).children.add(object3);
                    }
                    bl = false;
                    int n5 = 0;
                    while (n5 < ((Vertex)object3).parents.size()) {
                        if (((Vertex)object3).parents.get(n5) == object2) {
                            bl = true;
                        }
                        ++n5;
                    }
                    if (!bl) {
                        ((Vertex)object3).parents.add(object2);
                    }
                    if (((Vertex)object3).visited) continue;
                    ((Vertex)object3).visited = true;
                    ((Vector)object6).add(object4);
                    functionProfile.add(null);
                    Iterator iterator = object4.getChildProfiles();
                    while (iterator.hasNext()) {
                        FunctionProfile functionProfile2 = (FunctionProfile)iterator.next();
                        Vertex vertex3 = (Vertex)this.vertexMap.get(functionProfile2);
                        functionProfile.add(functionProfile2);
                    }
                }
            }
            ++n3;
        }
        vector = this.findRoots(this.vertexMap);
        int n6 = 0;
        while (n6 < this.functionProfileList.size()) {
            object5 = (FunctionProfile)this.functionProfileList.elementAt(n6);
            if (object5 != null && !object5.isCallPathFunction() && ((Vertex)(object4 = (Vertex)this.vertexMap.get(object5))).level == -1) {
                this.assignLevel((Vertex)object4);
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.functionProfileList.size()) {
            object4 = (FunctionProfile)this.functionProfileList.elementAt(n7);
            if (object4 != null && !object4.isCallPathFunction()) {
                object3 = (Vertex)this.vertexMap.get(object4);
                this.insertDummies((Vertex)object3);
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < this.functionProfileList.size()) {
            object3 = (FunctionProfile)this.functionProfileList.elementAt(n8);
            if (object3 != null && !object3.isCallPathFunction()) {
                vertex = (Vertex)this.vertexMap.get(object3);
                vertex.visited = false;
            }
            ++n8;
        }
        this.levels = new Vector();
        int n9 = 0;
        while (n9 < vector.size()) {
            vertex = (Vertex)vector.elementAt(n9);
            this.fillLevels(vertex, this.levels, 0);
            ++n9;
        }
        int n10 = 0;
        while (n10 < this.levels.size()) {
            object2 = (Vector)this.levels.get(n10);
            n = 0;
            while (n < ((Vector)object2).size()) {
                object = (Vertex)((Vector)object2).get(n);
                ++n;
            }
            ++n10;
        }
        this.runSugiyama(this.levels);
        this.assignPositions(this.levels);
        this.model = new DefaultGraphModel();
        this.graph = new Graph((GraphModel)this.model, this);
        ((Component)((Object)this.graph)).addMouseListener(this.graph);
        ((Component)((Object)this.graph)).addKeyListener(this);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.graph));
        this.createCustomGraph(this.levels, this.backEdges);
        this.jGraphPane = new JScrollPane((Component)((Object)this.graph));
        object2 = new GridBagConstraints();
        ((GridBagConstraints)object2).fill = 1;
        ((GridBagConstraints)object2).anchor = 15;
        ((GridBagConstraints)object2).weightx = 1.0;
        ((GridBagConstraints)object2).weighty = 1.0;
        this.addCompItem(this.jGraphPane, (GridBagConstraints)object2, 0, 1, 0, 0);
    }

    void recreateGraph() {
        int n = 0;
        while (n < this.graphCellVector.size()) {
            DefaultGraphCell defaultGraphCell = (DefaultGraphCell)this.graphCellVector.get(n);
            defaultGraphCell.removeAllChildren();
            ++n;
        }
        this.model.remove(this.cells);
        this.reassignWidths(this.levels);
        this.assignPositions(this.levels);
        this.createCustomGraph(this.levels, this.backEdges);
    }

    void reassignWidths(Vector vector) {
        double d = this.getMaxValue(this.widthOption, this.widthMetricID);
        double d2 = this.getMaxValue(this.colorOption, this.colorMetricID);
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.get(n);
            int n2 = 0;
            while (n2 < vector2.size()) {
                Vertex vertex = (Vertex)vector2.get(n2);
                if (vertex.function != null) {
                    FunctionProfile functionProfile = vertex.functionProfile;
                    vertex.width = this.getWidth(functionProfile, d);
                    if (vertex.width < 5) {
                        vertex.width = 5;
                    }
                    vertex.colorRatio = (float)this.getValue(functionProfile, this.colorOption, d2, this.colorMetricID);
                    vertex.height = this.boxHeight;
                }
                ++n2;
            }
            ++n;
        }
    }

    void createCustomGraph(Vector vector, Vector vector2) {
        GraphCell graphCell;
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        this.graphCellVector = new Vector();
        Vector<GraphCell> vector3 = new Vector<GraphCell>();
        int n = 0;
        while (n < vector.size()) {
            Vector vector4 = (Vector)vector.get(n);
            int n2 = 0;
            while (n2 < vector4.size()) {
                object2 = (Vertex)vector4.get(n2);
                GraphCell graphCell2 = null;
                if (((Vertex)object2).function != null) {
                    graphCell2 = this.createGraphCell((Vertex)object2, ((Vertex)object2).position - ((Vertex)object2).width / 2, 20 + n * 120, ((Vertex)object2).height, ((Vertex)object2).width, ((Vertex)object2).colorRatio, hashMap);
                    ((Vertex)object2).graphCell = graphCell2;
                    vector3.add(graphCell2);
                    this.graphCellVector.add(graphCell2);
                }
                ++n2;
            }
            ++n;
        }
        int n3 = vector3.size();
        ConnectionSet connectionSet = new ConnectionSet();
        object2 = new Vector();
        int n4 = 0;
        while (n4 < vector.size()) {
            Vector vector5 = (Vector)vector.get(n4);
            int n5 = 0;
            while (n5 < vector5.size()) {
                object = (Vertex)vector5.get(n5);
                if (((Vertex)object).function != null) {
                    graphCell = ((Vertex)object).graphCell;
                    Iterator iterator = ((AbstractList)((Vertex)object).children).iterator();
                    while (iterator.hasNext()) {
                        Object object3;
                        Vertex vertex = (Vertex)iterator.next();
                        if (vertex.function != null) {
                            object3 = vertex.graphCell;
                            DefaultEdge defaultEdge = this.createEdge(graphCell, (DefaultGraphCell)object3, hashMap, connectionSet, null);
                            vector3.add((GraphCell)defaultEdge);
                            ((Vector)object2).add(defaultEdge);
                            continue;
                        }
                        object3 = new ArrayList();
                        int n6 = 1;
                        ((ArrayList)object3).add(new Point(3000, 3000));
                        while (vertex.function == null) {
                            ((ArrayList)object3).add(new Point(vertex.position, 20 + (n4 + n6) * 120 + this.boxHeight / 2));
                            vertex = (Vertex)vertex.children.get(0);
                            ++n6;
                        }
                        ((ArrayList)object3).add(new Point(3000, 3000));
                        DefaultEdge defaultEdge = this.createEdge(graphCell, vertex.graphCell, hashMap, connectionSet, (ArrayList)object3);
                        vector3.add((GraphCell)defaultEdge);
                        ((Vector)object2).add(defaultEdge);
                    }
                }
                ++n5;
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < vector2.size()) {
            BackEdge backEdge = (BackEdge)vector2.get(n7);
            object = new ArrayList<Point>();
            ((ArrayList)object).add(new Point(3000, 3000));
            ((ArrayList)object).add(new Point(backEdge.a.position + backEdge.a.width / 2 + 50, backEdge.a.level * 120 + 20 + this.boxHeight / 2));
            ((ArrayList)object).add(new Point(backEdge.b.position + 25, backEdge.b.level * 120 - 25 + 20));
            ((ArrayList)object).add(new Point(3000, 3000));
            graphCell = this.createEdge(backEdge.a.graphCell, backEdge.b.graphCell, hashMap, connectionSet, (ArrayList)object);
            vector3.add(graphCell);
            ((Vector)object2).add(graphCell);
            ++n7;
        }
        this.cells = vector3.toArray();
        this.model.insert(this.cells, hashMap, connectionSet, null, null);
        this.moveDownToVisible(vector3, (Vector)object2);
    }

    private void moveDownToVisible(Vector vector, Vector vector2) {
        CellView cellView;
        int n = 0;
        int n2 = 0;
        while (n2 < vector2.size()) {
            cellView = this.graph.getGraphLayoutCache().getMapping(vector2.get(n2), false);
            Rectangle2D rectangle2D = cellView.getBounds();
            if (rectangle2D.getY() < (double)n) {
                n = (int)rectangle2D.getY();
            }
            ++n2;
        }
        if (n != 0) {
            n -= 5;
            cellView = new HashMap();
            int n3 = 0;
            while (n3 < vector.size()) {
                DefaultGraphCell defaultGraphCell = (DefaultGraphCell)vector.get(n3);
                AttributeMap attributeMap = defaultGraphCell.getAttributes();
                CallGraphWindow.translate((Map)attributeMap, 0.0, -n);
                cellView.put(defaultGraphCell, attributeMap);
                ++n3;
            }
            this.graph.getGraphLayoutCache().edit((Map)cellView, null, null, null);
        }
    }

    public static void translate(Map map, double d, double d2) {
        if (GraphConstants.isMoveable((Map)map)) {
            List list;
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)map);
            if (rectangle2D != null) {
                int n = GraphConstants.getMoveableAxis((Map)map);
                if (n == 1) {
                    d2 = 0.0;
                } else if (n == 2) {
                    d = 0.0;
                }
                rectangle2D.setFrame(Math.max(0.0, rectangle2D.getX() + d), Math.max(0.0, rectangle2D.getY() + d2), rectangle2D.getWidth(), rectangle2D.getHeight());
                GraphConstants.setBounds((Map)map, (Rectangle2D)rectangle2D);
            }
            if ((list = GraphConstants.getPoints((Map)map)) != null) {
                int n = 0;
                while (n < list.size()) {
                    Object e = list.get(n);
                    if (e instanceof Point2D) {
                        Point2D point2D = (Point2D)e;
                        point2D.setLocation(Math.max(0.0, point2D.getX() + d), Math.max(0.0, point2D.getY() + d2));
                    }
                    ++n;
                }
                GraphConstants.setPoints((Map)map, (List)list);
            }
        }
    }

    void runPhaseOne(Vector vector) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 100;
        while (n > 0) {
            int n2 = 0;
            while (n2 < vector.size() - 1) {
                this.assignBaryCenters((Vector)vector.get(n2), (Vector)vector.get(n2 + 1), true);
                Collections.sort((Vector)vector.get(n2));
                ++n2;
            }
            int n3 = vector.size() - 1;
            while (n3 > 0) {
                this.assignBaryCenters((Vector)vector.get(n3), (Vector)vector.get(n3 - 1), false);
                Collections.sort((Vector)vector.get(n3));
                --n3;
            }
            --n;
        }
    }

    void assignBaryCenters(Vector vector, Vector vector2, boolean bl) {
        int n = 0;
        while (n < vector2.size()) {
            Vertex vertex = (Vertex)vector2.get(n);
            vertex.levelIndex = n;
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            int n3;
            int n4;
            Vertex vertex = (Vertex)vector.get(n2);
            if (bl) {
                n4 = 0;
                n3 = 0;
                while (n3 < vertex.children.size()) {
                    n4 += ((Vertex)vertex.children.get(n3)).levelIndex;
                    ++n3;
                }
                if (vertex.children.size() != 0) {
                    vertex.baryCenter = n4 / vertex.children.size();
                }
            } else {
                n4 = 0;
                n3 = 0;
                while (n3 < vertex.parents.size()) {
                    n4 += ((Vertex)vertex.parents.get(n3)).levelIndex;
                    ++n3;
                }
                if (vertex.parents.size() != 0) {
                    vertex.baryCenter = n4 / vertex.parents.size();
                }
            }
            ++n2;
        }
    }

    void assignGridBaryCenters(Vector vector, boolean bl, boolean bl2) {
        int n = 0;
        while (n < vector.size()) {
            int n2;
            float f;
            Vertex vertex = (Vertex)vector.get(n);
            if (bl) {
                if (vertex.children.size() != 0) {
                    f = 0.0f;
                    n2 = 0;
                    while (n2 < vertex.children.size()) {
                        f += (float)((Vertex)vertex.children.get(n2)).position;
                        ++n2;
                    }
                    vertex.gridBaryCenter = f / (float)vertex.children.size();
                }
            } else if (vertex.parents.size() != 0) {
                f = 0.0f;
                n2 = 0;
                while (n2 < vertex.parents.size()) {
                    f += (float)((Vertex)vertex.parents.get(n2)).position;
                    ++n2;
                }
                vertex.gridBaryCenter = f / (float)vertex.parents.size();
            }
            ++n;
        }
    }

    void runSugiyama(Vector vector) {
        this.runPhaseOne(vector);
    }

    private void assignPositions(Vector vector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        while (n6 < vector.size()) {
            Vector vector2 = (Vector)vector.get(n6);
            n5 = 0;
            ((Vertex)vector2.get(0)).position = 0;
            n4 = 1;
            while (n4 < vector2.size()) {
                Vertex vertex = (Vertex)vector2.get(n4);
                vertex.position = n5 + 10 + (((Vertex)vector2.get(n4 - 1)).width + vertex.width) / 2;
                n5 = vertex.position;
                vertex.downPriority = vertex.children.size();
                if (vertex.function == null) {
                    vertex.downPriority = 2;
                }
                vertex.upPriority = vertex.parents.size();
                if (vertex.function == null) {
                    vertex.upPriority = 2;
                }
                ++n4;
            }
            if (vector2.size() % 2 == 0) {
                n3 = ((Vertex)vector2.get((vector2.size() - 2) / 2)).position;
                n2 = ((Vertex)vector2.get(vector2.size() / 2)).position;
                n = (n3 + n2) / 2;
            } else {
                n = ((Vertex)vector2.get((vector2.size() - 1) / 2)).position;
            }
            n3 = 0;
            while (n3 < vector2.size()) {
                Vertex vertex = (Vertex)vector2.get(n3);
                vertex.position = vertex.position - n;
                ++n3;
            }
            ++n6;
        }
        int n7 = 1;
        while (n7 < vector.size()) {
            this.improvePositions(vector, n7, false, false);
            ++n7;
        }
        n5 = vector.size() - 2;
        while (n5 >= 0) {
            this.improvePositions(vector, n5, true, false);
            --n5;
        }
        n4 = 1;
        while (n4 < vector.size()) {
            this.improvePositions(vector, n4, false, false);
            ++n4;
        }
        n = vector.size() - 2;
        while (n >= 0) {
            this.improvePositions(vector, n, true, true);
            --n;
        }
        n3 = vector.size() - 2;
        while (n3 >= 0) {
            this.improvePositions(vector, n3, true, false);
            --n3;
        }
        n2 = 0;
        int n8 = 0;
        while (n8 < vector.size()) {
            Vector vector3 = (Vector)vector.get(n8);
            int n9 = 0;
            while (n9 < vector3.size()) {
                Vertex vertex = (Vertex)vector3.get(n9);
                if (vertex.position - vertex.width / 2 < n2) {
                    n2 = vertex.position - vertex.width / 2;
                }
                ++n9;
            }
            ++n8;
        }
        int n10 = 0;
        while (n10 < vector.size()) {
            Vector vector4 = (Vector)vector.get(n10);
            int n11 = 0;
            while (n11 < vector4.size()) {
                Vertex vertex = (Vertex)vector4.get(n11);
                vertex.position += -n2 + 20;
                ++n11;
            }
            ++n10;
        }
    }

    private int moveRight(Vector vector, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = (Vertex)vector.get(n);
        int n5 = n + 1;
        if (n5 >= vector.size()) {
            vertex.position = vertex.position + n2;
            return n2;
        }
        Vertex vertex2 = (Vertex)vector.get(n5);
        int n6 = vertex.position + vertex.width / 2;
        if (n6 + n2 + 10 < (n4 = vertex2.position - vertex2.width / 2)) {
            vertex.position = vertex.position + n2;
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.position - (vertex.width + vertex2.width) / 2 - 10;
            int n8 = n7 - vertex.position;
            vertex.position = vertex.position + n8;
            return n8;
        }
        int n9 = vertex.position + n2 + (vertex2.width + vertex.width) / 2 + 10;
        this.moveRight(vector, n5, n9 - vertex2.position, bl, n3);
        int n10 = vertex2.position - (vertex.width + vertex2.width) / 2 - 10;
        int n11 = n10 - vertex.position;
        vertex.position = vertex.position + n11;
        return n11;
    }

    private int moveLeft(Vector vector, int n, int n2, boolean bl, int n3) {
        int n4;
        Vertex vertex = (Vertex)vector.get(n);
        int n5 = n - 1;
        if (n5 < 0) {
            vertex.position = vertex.position - n2;
            return n2;
        }
        Vertex vertex2 = (Vertex)vector.get(n5);
        int n6 = vertex.position - vertex.width / 2;
        if (n6 - n2 - 10 > (n4 = vertex2.position + vertex2.width / 2)) {
            vertex.position = vertex.position - n2;
            return n2;
        }
        if (vertex2.getPriority(bl) > n3) {
            int n7 = vertex2.position + (vertex2.width + vertex.width) / 2 + 10;
            int n8 = vertex.position - n7;
            vertex.position = vertex.position - n8;
            return n8;
        }
        int n9 = vertex.position - n2 - vertex.width / 2 - 10 - vertex2.width / 2;
        this.moveLeft(vector, n5, vertex2.position - n9, bl, n3);
        int n10 = vertex2.position + (vertex2.width + vertex.width) / 2 + 10;
        int n11 = vertex.position - n10;
        vertex.position = vertex.position - n11;
        return n11;
    }

    private void improvePositions(Vector vector, int n, boolean bl, boolean bl2) {
        Vector vector2 = (Vector)vector.get(n);
        this.assignGridBaryCenters(vector2, bl, bl2);
        int n2 = 0;
        while (n2 < vector2.size()) {
            Vertex vertex = (Vertex)vector2.get(n2);
            int n3 = (int)vertex.gridBaryCenter;
            if (!bl || vertex.children.size() != 0) {
                int n4;
                int n5;
                if (n3 > vertex.position) {
                    n5 = this.moveRight(vector2, n2, n3 - vertex.position, bl, vertex.getPriority(bl));
                    n4 = n2 - 1;
                    while (n4 >= 0 && bl2) {
                        this.moveRight(vector2, n4, n5, bl, vertex.getPriority(bl));
                        --n4;
                    }
                } else {
                    n5 = this.moveLeft(vector2, n2, vertex.position - n3, bl, vertex.getPriority(bl));
                    n4 = n2 + 1;
                    while (n4 < vector2.size() && bl2) {
                        this.moveLeft(vector2, n4, n5, bl, vertex.getPriority(bl));
                        ++n4;
                    }
                }
            }
            ++n2;
        }
    }

    private void fillLevels(Vertex vertex, Vector vector, int n) {
        if (vertex.visited) {
            return;
        }
        vertex.visited = true;
        if (vector.size() == n) {
            vector.insertElementAt(new Vector(), n);
        }
        vertex.level = n;
        Vector vector2 = (Vector)vector.get(n);
        vector2.add(vertex);
        int n2 = 0;
        while (n2 < vertex.children.size()) {
            Vertex vertex2 = (Vertex)vertex.children.elementAt(n2);
            this.fillLevels(vertex2, vector, n + 1);
            ++n2;
        }
    }

    private void insertDummies(Vertex vertex) {
        int n = 0;
        while (n < vertex.children.size()) {
            Vertex vertex2 = (Vertex)vertex.children.elementAt(n);
            if (vertex2.level - vertex.level > 1) {
                vertex.children.remove(n);
                vertex2.parents.remove(vertex);
                Vertex vertex3 = new Vertex(null, 1);
                vertex3.level = vertex.level + 1;
                vertex3.children.add(vertex2);
                vertex2.parents.add(vertex3);
                vertex.children.insertElementAt(vertex3, n);
                vertex3.parents.add(vertex);
                this.insertDummies(vertex3);
            }
            ++n;
        }
    }

    private void assignLevel(Vertex vertex) {
        int n = 0;
        int n2 = 0;
        while (n2 < vertex.parents.size()) {
            Vertex vertex2 = (Vertex)vertex.parents.elementAt(n2);
            if (vertex2.level == -1) {
                this.assignLevel(vertex2);
            }
            if (vertex2.level > n) {
                n = vertex2.level;
            }
            ++n2;
        }
        vertex.level = n + 1;
    }

    private Vector findRoots(Map map) {
        Object object;
        Object object2;
        Vector<Vertex> vector = new Vector<Vertex>();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            object2 = (Vertex)iterator.next();
            ((Vertex)object2).visited = false;
        }
        object2 = map.values().iterator();
        while (object2.hasNext()) {
            object = (Vertex)object2.next();
            int n = 0;
            while (n < ((Vertex)object).children.size()) {
                Vertex vertex = (Vertex)((Vertex)object).children.get(n);
                vertex.visited = true;
                ++n;
            }
        }
        object = map.values().iterator();
        while (object.hasNext()) {
            Vertex vertex = (Vertex)object.next();
            if (vertex.visited) continue;
            vector.add(vertex);
        }
        return vector;
    }

    public GraphCell createGraphCell(Vertex vertex, int n, int n2, int n3, int n4, float f, Map map) {
        GraphCell graphCell = new GraphCell(vertex);
        Hashtable hashtable = new Hashtable();
        map.put(graphCell, hashtable);
        vertex.xBeg = n;
        vertex.xEnd = n + n4;
        vertex.yBeg = n2;
        vertex.yEnd = n2 + n3;
        Rectangle rectangle = new Rectangle(n, n2, n4, n3);
        GraphConstants.setBounds(hashtable, (Rectangle2D)rectangle);
        GraphConstants.setBorderColor(hashtable, (Color)Color.black);
        if (this.colorOption == CallGraphOption.STATIC) {
            GraphConstants.setBackground(hashtable, (Color)Color.orange);
            GraphConstants.setForeground(hashtable, (Color)Color.black);
        } else {
            GraphConstants.setBackground(hashtable, (Color)ColorBar.getColor(f));
            GraphConstants.setForeground(hashtable, (Color)ColorBar.getContrast(ColorBar.getColor(f)));
        }
        GraphConstants.setOpaque(hashtable, (boolean)true);
        GraphConstants.setEditable(hashtable, (boolean)false);
        GraphConstants.setFont(hashtable, (Font)this.font);
        GraphConstants.setBorder(hashtable, (Border)BorderFactory.createRaisedBevelBorder());
        DefaultPort defaultPort = new DefaultPort();
        ((DefaultMutableTreeNode)((Object)graphCell)).add((MutableTreeNode)defaultPort);
        return graphCell;
    }

    public DefaultEdge createEdge(DefaultGraphCell defaultGraphCell, DefaultGraphCell defaultGraphCell2, Map map, ConnectionSet connectionSet, ArrayList arrayList) {
        DefaultEdge defaultEdge = new DefaultEdge();
        Hashtable hashtable = new Hashtable();
        map.put(defaultEdge, hashtable);
        if (arrayList != null) {
            GraphConstants.setPoints(hashtable, (List)arrayList);
            GraphConstants.setLineStyle(hashtable, (int)13);
        }
        GraphConstants.setLineEnd(hashtable, (int)1);
        GraphConstants.setEndFill(hashtable, (boolean)true);
        GraphConstants.setDisconnectable(hashtable, (boolean)false);
        if (defaultGraphCell == defaultGraphCell2) {
            DefaultPort defaultPort = new DefaultPort();
            defaultGraphCell.add((MutableTreeNode)defaultPort);
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell.getChildAt(1));
        } else {
            connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), (Object)defaultGraphCell2.getChildAt(0));
        }
        return defaultEdge;
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.boxWidthSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.boxWidthLabel);
            container.remove(this.boxWidthSlider);
            container.remove(this.jGraphPane);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.jGraphPane, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public Edge getEdge(FunctionProfile functionProfile, FunctionProfile functionProfile2) {
        Vertex vertex = (Vertex)this.vertexMap.get(functionProfile);
        Vertex vertex2 = (Vertex)this.vertexMap.get(functionProfile2);
        int n = ((DefaultMutableTreeNode)((Object)vertex2.graphCell)).getChildCount();
        int n2 = 0;
        while (n2 < n) {
            Port port = (Port)((DefaultMutableTreeNode)((Object)vertex2.graphCell)).getChildAt(n2);
            Iterator iterator = port.edges();
            while (iterator.hasNext()) {
                Edge edge = (Edge)iterator.next();
                if (edge.getTarget() != port) continue;
                Port port2 = (Port)edge.getSource();
                Object object = this.model.getParent((Object)port2);
                CellView cellView = this.graph.getGraphLayoutCache().getMapping(object, false);
                GraphCell graphCell = (GraphCell)((Object)cellView.getCell());
                if (graphCell.getVertex() != vertex) continue;
                return edge;
            }
            ++n2;
        }
        return null;
    }

    private void handlePrefEvent() {
        Hashtable hashtable = new Hashtable();
        this.font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.ppTrial.getPreferencesWindow().getBarHeight());
        this.setFont(this.font);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.boxHeight = fontMetrics.getHeight() + 5;
        this.recreateGraph();
    }

    public void handleColorEvent() {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Hashtable hashtable = new Hashtable();
        int n2 = 0;
        while (n2 < this.graphCellVector.size()) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellVector.get(n2));
            object4 = graphCell.getVertex();
            ((Vertex)object4).pathHighlight = false;
            n = this.model.getChildCount((Object)graphCell);
            int n3 = 0;
            while (n3 < n) {
                object3 = this.model.getChild((Object)graphCell, n3);
                object2 = this.model.edges(object3);
                while (object2.hasNext()) {
                    Object e = object2.next();
                    object = new HashMap();
                    GraphConstants.setLineColor(object, (Color)Color.black);
                    hashtable.put(e, object);
                }
                ++n3;
            }
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.graphCellVector.size()) {
            object4 = (GraphCell)((Object)this.graphCellVector.get(n4));
            if (((GraphCell)((Object)object4)).function == this.ppTrial.getHighlightedFunction()) {
                n = 0;
                while (n < this.functionProfileList.size()) {
                    FunctionProfile functionProfile = (FunctionProfile)this.functionProfileList.elementAt(n);
                    if (functionProfile != null && (object3 = functionProfile.getFunction()).isCallPathFunction() && ((String)(object2 = object3.getName())).indexOf(((GraphCell)((Object)object4)).getFunction().getName()) != -1) {
                        int n5 = ((String)object2).indexOf("=>");
                        while (n5 != -1) {
                            object = ((String)object2).substring(0, n5);
                            int n6 = ((String)object2).indexOf("=>", n5 + 1);
                            if (n6 == -1) {
                                n6 = ((String)object2).length();
                            }
                            String string = ((String)object2).substring(n5 + 2, n6);
                            FunctionProfile functionProfile2 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction((String)object));
                            FunctionProfile functionProfile3 = this.thread.getFunctionProfile(this.ppTrial.getDataSource().getFunction(string));
                            Vertex vertex = (Vertex)this.vertexMap.get(functionProfile2);
                            vertex.pathHighlight = true;
                            vertex = (Vertex)this.vertexMap.get(functionProfile3);
                            vertex.pathHighlight = true;
                            Edge edge = this.getEdge(functionProfile2, functionProfile3);
                            HashMap hashMap = new HashMap();
                            GraphConstants.setLineColor(hashMap, (Color)Color.blue);
                            if (edge != null) {
                                hashtable.put(edge, hashMap);
                            }
                            object2 = ((String)object2).substring(n5 + 3);
                            n5 = ((String)object2).indexOf("=>");
                        }
                    }
                    ++n;
                }
            }
            ++n4;
        }
        int n7 = 0;
        while (n7 < this.graphCellVector.size()) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellVector.get(n7));
            HashMap hashMap = new HashMap();
            if (graphCell.function == this.ppTrial.getHighlightedFunction()) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getHighlightColor(), this.ppTrial.getColorChooser().getHighlightColor()));
            } else if (graphCell.getVertex().pathHighlight) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, Color.blue, Color.blue));
            } else if (graphCell.function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createBevelBorder(0, this.ppTrial.getColorChooser().getGroupHighlightColor(), this.ppTrial.getColorChooser().getGroupHighlightColor()));
            } else {
                GraphConstants.setBorder(hashMap, (Border)BorderFactory.createRaisedBevelBorder());
            }
            hashtable.put((Object)((Object)graphCell), hashMap);
            ++n7;
        }
        this.graph.getGraphLayoutCache().edit(hashtable, null, null, null);
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        } else if (string.equals("prefEvent")) {
            this.handlePrefEvent();
        } else if (string.equals("colorEvent")) {
            this.handleColorEvent();
        } else if (string.equals("dataEvent")) {
            this.setupMenus();
            this.validate();
            this.recreateGraph();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the Call Graph Window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you a graph of call paths present in the profile data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Click on a box to highlight paths that go through that function.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Right-click on a box to access the Function Data Window for that function.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Experiment with the \"Box Width by...\" and \"Box Color by...\" menus (under Options) to display different types of data.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("If you only see a single line of boxes (no edges connecting them), it probably means that your profile data does not contain call path data.  If you believe this to be incorrect please contact us with the data at tau-bugs@cs.uoregon.edu");
        ParaProf.helpWindow.writeText("");
    }

    public Dimension getViewportSize() {
        return this.jGraphPane.getViewport().getExtentSize();
    }

    public Rectangle getViewRect() {
        return this.jGraphPane.getViewport().getViewRect();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        ((Component)this).setVisible(false);
        this.ppTrial.getSystemEvents().deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public GraphCell getGraphCellForLocation(int n, int n2) {
        int n3 = 0;
        while (n3 < this.graphCellVector.size()) {
            GraphCell graphCell = (GraphCell)((Object)this.graphCellVector.get(n3));
            AttributeMap attributeMap = graphCell.getAttributes();
            Rectangle2D rectangle2D = GraphConstants.getBounds((Map)attributeMap);
            if (rectangle2D.contains(n, n2)) {
                return graphCell;
            }
            ++n3;
        }
        return null;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.boxWidth = this.boxWidthSlider.getValue();
            this.recreateGraph();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            if (keyEvent.getKeyChar() == '+') {
                this.scale += 0.1;
                if (this.scale > 5.0) {
                    this.scale = 5.0;
                }
                this.graph.setScale(this.scale);
            } else if (keyEvent.getKeyChar() == '-') {
                this.scale -= 0.1;
                if (this.scale < 0.1) {
                    this.scale = 0.1;
                }
                this.graph.setScale(this.scale);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            return this.getPreferredSize();
        }
        return this.getSize();
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            ((Component)((Object)this.graph)).paintAll(graphics2D);
        } else {
            ((JComponent)((Object)this.graph)).paint(graphics2D);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        double d;
        block4: {
            int n2;
            block3: {
                d = this.graph.getScale();
                try {
                    ((JComponent)((Object)this.graph)).setDoubleBuffered(false);
                    if (n >= 1) {
                        n2 = 1;
                        Object var8_6 = null;
                        ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
                        break block3;
                    }
                    ParaProfUtils.scaleForPrint(graphics, pageFormat, ((JComponent)((Object)this.graph)).getWidth(), ((JComponent)((Object)this.graph)).getHeight());
                    ((JComponent)((Object)this.graph)).paint(graphics);
                    break block4;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
                    this.graph.setScale(d);
                    throw throwable;
                }
            }
            this.graph.setScale(d);
            return n2;
        }
        Object var8_7 = null;
        ((JComponent)((Object)this.graph)).setDoubleBuffered(true);
        this.graph.setScale(d);
        return 0;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string;
            Object object = actionEvent.getSource();
            if (object instanceof JMenuItem && (string = actionEvent.getActionCommand()).equals("Show Width Slider")) {
                if (this.slidersCheckBox.isSelected()) {
                    this.displaySliders(true);
                } else {
                    this.displaySliders(false);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    private class Vertex
    implements Comparable {
        private Vector children = new Vector();
        private Vector parents = new Vector();
        private Function function;
        private FunctionProfile functionProfile;
        private boolean visited;
        private int downPriority;
        private int upPriority;
        private int level = -1;
        private int levelIndex;
        private double baryCenter;
        private double gridBaryCenter;
        private GraphCell graphCell;
        private int position = -1;
        private int width;
        private int height;
        private float colorRatio;
        private int xBeg;
        private int yBeg;
        private int xEnd;
        private int yEnd;
        private boolean pathHighlight = false;
        private Vector pathEdges = new Vector();

        Vertex(FunctionProfile functionProfile, int n) {
            if (functionProfile != null) {
                this.function = functionProfile.getFunction();
                this.functionProfile = functionProfile;
            }
            this.width = n;
            this.height = CallGraphWindow.this.boxHeight;
            if (this.function != null && n < 5) {
                this.width = 5;
            }
        }

        public int compareTo(Object object) {
            if (this.baryCenter < ((Vertex)object).baryCenter) {
                return -1;
            }
            if (this.baryCenter > ((Vertex)object).baryCenter) {
                return 1;
            }
            return 0;
        }

        private int getPriority(boolean bl) {
            if (bl) {
                return this.downPriority;
            }
            return this.upPriority;
        }
    }

    private static class BackEdge {
        private Vertex a;
        private Vertex b;

        BackEdge(Vertex vertex, Vertex vertex2) {
            this.a = vertex;
            this.b = vertex2;
        }
    }

    private class Graph
    extends JGraph
    implements MouseListener {
        private CallGraphWindow callGraphWindow;

        public String getToolTipText(MouseEvent mouseEvent) {
            double d;
            double d2 = (double)mouseEvent.getX() / this.getScale();
            GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d2, (int)(d = (double)mouseEvent.getY() / this.getScale()));
            if (graphCell != null) {
                return graphCell.getToolTipString();
            }
            return null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            try {
                double d = (double)mouseEvent.getX() / this.getScale();
                double d2 = (double)mouseEvent.getY() / this.getScale();
                GraphCell graphCell = this.callGraphWindow.getGraphCellForLocation((int)d, (int)d2);
                if (graphCell != null) {
                    Function function = graphCell.getFunction();
                    if ((mouseEvent.getModifiers() & 0x10) == 0) {
                        JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(CallGraphWindow.this.ppTrial, function, (JComponent)((Object)this));
                        jPopupMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
                    } else {
                        CallGraphWindow.this.ppTrial.toggleHighlightedFunction(function);
                    }
                }
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.setSize(dimension.width + 10, dimension.height + 10);
            return dimension;
        }

        public Graph(GraphModel graphModel, CallGraphWindow callGraphWindow2) {
            super(graphModel);
            this.callGraphWindow = callGraphWindow2;
            this.setSelectionModel((org.jgraph.graph.GraphSelectionModel)new GraphSelectionModel(this));
        }
    }

    private class GraphCell
    extends DefaultGraphCell {
        private final Function function;
        private final Vertex vertex;

        public GraphCell(Vertex vertex) {
            super((Object)vertex.function.getName());
            this.vertex = vertex;
            this.function = vertex.function;
        }

        public String getToolTipString() {
            float f;
            String string = "<html>" + this.function;
            if (CallGraphWindow.this.widthOption != CallGraphOption.STATIC && CallGraphWindow.this.widthOption != CallGraphOption.NAME_LENGTH) {
                f = (float)CallGraphWindow.this.getValue(this.vertex.functionProfile, CallGraphWindow.this.widthOption, 1.0, CallGraphWindow.this.widthMetricID);
                string = string + "<br>Width Value (" + CallGraphWindow.this.widthOption;
                if (CallGraphWindow.this.widthOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.widthOption != CallGraphOption.NUMSUBR) {
                    string = string + ", " + CallGraphWindow.this.ppTrial.getMetricName(CallGraphWindow.this.widthMetricID);
                }
                string = string + ") : " + f;
            }
            if (CallGraphWindow.this.colorOption != CallGraphOption.STATIC) {
                f = (float)CallGraphWindow.this.getValue(this.vertex.functionProfile, CallGraphWindow.this.colorOption, 1.0, CallGraphWindow.this.colorMetricID);
                string = string + "<br>Color Value (" + CallGraphWindow.this.colorOption;
                if (CallGraphWindow.this.colorOption != CallGraphOption.NUMCALLS && CallGraphWindow.this.colorOption != CallGraphOption.NUMSUBR) {
                    string = string + ", " + CallGraphWindow.this.ppTrial.getMetricName(CallGraphWindow.this.colorMetricID);
                }
                string = string + ") : " + f;
            }
            return string;
        }

        public Function getFunction() {
            return this.function;
        }

        public Vertex getVertex() {
            return this.vertex;
        }
    }

    private static class GraphSelectionModel
    extends DefaultGraphSelectionModel {
        GraphSelectionModel(JGraph jGraph) {
            super(jGraph);
        }

        public Object[] getSelectables() {
            if (this.isChildrenSelectable()) {
                ArrayList arrayList = new ArrayList();
                Stack<Object> stack = new Stack<Object>();
                GraphModel graphModel = this.graph.getModel();
                int n = 0;
                while (n < graphModel.getRootCount()) {
                    stack.add(graphModel.getRootAt(n));
                    ++n;
                }
                while (!stack.isEmpty()) {
                    Object e = stack.pop();
                    if (!graphModel.isPort(e) && !graphModel.isEdge(e)) {
                        arrayList.add(e);
                    }
                    if (!this.isChildrenSelectable(e)) continue;
                    int n2 = 0;
                    while (n2 < graphModel.getChildCount(e)) {
                        stack.add(graphModel.getChild(e, n2));
                        ++n2;
                    }
                }
                return arrayList.toArray();
            }
            return this.graph.getRoots();
        }
    }
}

