/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.paraprof.ColorMapCellRenderer;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;

public class ColorMapWindow
extends JFrame
implements ActionListener,
Observer {
    private DefaultListModel listModel;
    private JList colorList;

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void setupMenus() {
        Object object;
        Object object2;
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Assign Colors");
        JMenu jMenu2 = new JMenu("Assign defaults from...");
        Vector vector = ParaProf.paraProfManager.getLoadedTrials();
        int n = 0;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            object2 = (ParaProfTrial)iterator.next();
            object = ((ParaProfTrial)object2).getTrial().getApplicationID() + ":" + ((ParaProfTrial)object2).getTrial().getExperimentID() + ":" + ((ParaProfTrial)object2).getTrial().getID() + " - " + ((ParaProfTrial)object2).getName();
            JMenuItem jMenuItem = new JMenuItem((String)object);
            jMenuItem.setActionCommand(Integer.toString(n));
            jMenuItem.addActionListener(this);
            jMenu2.add(jMenuItem);
            ++n;
        }
        jMenu.add(jMenu2);
        object2 = new JMenuItem("Close This Window");
        ((AbstractButton)object2).addActionListener(this);
        jMenu.add((JMenuItem)object2);
        object = new JMenuItem("Exit ParaProf!");
        ((AbstractButton)object).addActionListener(this);
        jMenu.add((JMenuItem)object);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
    }

    public ColorMapWindow() {
        ((Component)this).setLocation(new Point(100, 100));
        ((Component)this).setSize(new Dimension(855, 450));
        this.setTitle("ParaProf: Color Map");
        this.setupMenus();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = new JLabel("Currently Assigned Colors");
        jLabel.setFont(new Font("SansSerif", 0, 14));
        this.addCompItem(jLabel, gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.listModel = new DefaultListModel();
        this.colorList = new JList(this.listModel);
        this.colorList.setSelectionMode(0);
        this.colorList.setCellRenderer(new ColorMapCellRenderer(ParaProf.colorMap));
        this.colorList.setSize(500, 300);
        JScrollPane jScrollPane = new JScrollPane(this.colorList);
        this.addCompItem(jScrollPane, gridBagConstraints, 0, 1, 1, 2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JButton jButton = new JButton("Remove");
        jButton.addActionListener(this);
        this.addCompItem(jButton, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jButton = new JButton("Remove All");
        jButton.addActionListener(this);
        this.addCompItem(jButton, gridBagConstraints, 1, 2, 1, 1);
        this.reload();
    }

    public void reload() {
        this.listModel.clear();
        Iterator iterator = ParaProf.colorMap.getFunctions();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.listModel.addElement(string);
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("colorMap")) {
            this.reload();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object instanceof JButton) {
                if (string.equals("Remove")) {
                    int n = this.colorList.getSelectedIndex();
                    String string2 = null;
                    Iterator iterator = ParaProf.colorMap.getFunctions();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        if (n == 0) {
                            string2 = string3;
                        }
                        --n;
                    }
                    ParaProf.colorMap.removeColor(string2);
                } else if (string.equals("Remove All")) {
                    ParaProf.colorMap.removeAll();
                }
            } else if (object instanceof JMenuItem) {
                if (string.equals("Close This Window")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                } else if (string.equals("Exit ParaProf!")) {
                    ((Component)this).setVisible(false);
                    this.dispose();
                    ParaProf.exitParaProf(0);
                } else {
                    Vector vector = ParaProf.paraProfManager.getLoadedTrials();
                    int n = Integer.parseInt(string);
                    Iterator iterator = ((AbstractList)vector).iterator();
                    while (iterator.hasNext()) {
                        ParaProfTrial paraProfTrial = (ParaProfTrial)iterator.next();
                        if (n == 0) {
                            ParaProf.colorMap.assignColorsFromTrial(paraProfTrial);
                        }
                        --n;
                    }
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }
}

