/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Context;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.Node;
import edu.uoregon.tau.dms.dss.Thread;
import edu.uoregon.tau.dms.dss.UserEvent;
import edu.uoregon.tau.dms.dss.UserEventProfile;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.PPThread;
import edu.uoregon.tau.paraprof.PPUserEventProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.enums.SortType;
import edu.uoregon.tau.paraprof.enums.UserEventValueType;
import edu.uoregon.tau.paraprof.enums.ValueType;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class DataSorter {
    private ParaProfTrial trial = null;
    private double maxExclusiveSum = 0.0;
    private double[] maxExclusives;
    private int selectedMetricID;
    private boolean descendingOrder;
    private boolean showAsPercent;
    private SortType sortType = SortType.MEAN_VALUE;
    private ValueType valueType = ValueType.EXCLUSIVE;
    private UserEventValueType userEventValueType = UserEventValueType.NUMSAMPLES;

    public DataSorter(ParaProfTrial paraProfTrial) {
        this.trial = paraProfTrial;
        this.selectedMetricID = paraProfTrial.getDefaultMetricID();
    }

    public UserEventValueType getUserEventValueType() {
        return this.userEventValueType;
    }

    public void setUserEventValueType(UserEventValueType userEventValueType) {
        this.userEventValueType = userEventValueType;
    }

    public boolean isTimeMetric() {
        String string = this.trial.getMetricName(this.getSelectedMetricID());
        return (string = string.toUpperCase()).indexOf("TIME") != -1;
    }

    public boolean isDerivedMetric() {
        return this.trial.getMetric(this.getSelectedMetricID()).getDerivedMetric();
    }

    public void setSelectedMetricID(int n) {
        this.selectedMetricID = n;
    }

    public int getSelectedMetricID() {
        return this.selectedMetricID;
    }

    public void setDescendingOrder(boolean bl) {
        this.descendingOrder = bl;
    }

    public boolean getDescendingOrder() {
        return this.descendingOrder;
    }

    public void setShowAsPercent(boolean bl) {
        this.showAsPercent = bl;
    }

    public boolean getShowAsPercent() {
        return this.showAsPercent;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Vector getUserEventProfiles(int n, int n2, int n3) {
        UserEventProfile userEventProfile = null;
        Vector vector = this.trial.getDataSource().getThread(n, n2, n3).getUserEventProfiles();
        Vector<PPUserEventProfile> vector2 = new Vector<PPUserEventProfile>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            userEventProfile = (UserEventProfile)enumeration.nextElement();
            if (userEventProfile == null) continue;
            PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this, n, n2, n3, userEventProfile);
            vector2.addElement(pPUserEventProfile);
        }
        Collections.sort(vector2);
        return vector2;
    }

    public Vector getFunctionProfiles(int n, int n2, int n3) {
        Vector<PPFunctionProfile> vector = null;
        Thread thread = n == -1 ? this.trial.getDataSource().getMeanData() : this.trial.getDataSource().getThread(n, n2, n3);
        Vector vector2 = thread.getFunctionProfiles();
        vector = new Vector<PPFunctionProfile>();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            FunctionProfile functionProfile = (FunctionProfile)enumeration.nextElement();
            if (functionProfile == null || !this.trial.displayFunction(functionProfile.getFunction())) continue;
            PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
            vector.addElement(pPFunctionProfile);
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getAllFunctionProfiles() {
        PPFunctionProfile pPFunctionProfile;
        Object object;
        Object var1_1 = null;
        Vector<PPThread> vector = new Vector<PPThread>();
        Thread thread = this.trial.getDataSource().getMeanData();
        PPThread pPThread = new PPThread(thread, this.trial);
        Enumeration enumeration = thread.getFunctionProfiles().elements();
        while (enumeration.hasMoreElements()) {
            object = (FunctionProfile)enumeration.nextElement();
            if (object == null || !this.trial.displayFunction(object.getFunction())) continue;
            pPFunctionProfile = new PPFunctionProfile(this, thread, (FunctionProfile)object);
            pPThread.addFunction(pPFunctionProfile);
        }
        Collections.sort(pPThread.getFunctionList());
        vector.add(pPThread);
        this.maxExclusiveSum = 0.0;
        this.maxExclusives = new double[this.trial.getDataSource().getNumFunctions()];
        object = this.trial.getDataSource().getNodes();
        while (object.hasNext()) {
            pPFunctionProfile = (Node)object.next();
            Iterator iterator = pPFunctionProfile.getContexts();
            while (iterator.hasNext()) {
                Context context = (Context)iterator.next();
                Iterator iterator2 = context.getThreads();
                while (iterator2.hasNext()) {
                    thread = (Thread)iterator2.next();
                    int n = 0;
                    pPThread = new PPThread(thread, this.trial);
                    double d = 0.0;
                    Enumeration enumeration2 = thread.getFunctionProfiles().elements();
                    while (enumeration2.hasMoreElements()) {
                        FunctionProfile functionProfile = (FunctionProfile)enumeration2.nextElement();
                        if (functionProfile == null || !this.trial.displayFunction(functionProfile.getFunction())) continue;
                        PPFunctionProfile pPFunctionProfile2 = new PPFunctionProfile(this, thread, functionProfile);
                        pPThread.addFunction(pPFunctionProfile2);
                        ++n;
                        d += pPFunctionProfile2.getExclusiveValue();
                        this.maxExclusives[functionProfile.getFunction().getID()] = Math.max(this.maxExclusives[functionProfile.getFunction().getID()], pPFunctionProfile2.getExclusiveValue());
                    }
                    if (d > this.maxExclusiveSum) {
                        this.maxExclusiveSum = d;
                    }
                    if (n == 0) continue;
                    Collections.sort(pPThread.getFunctionList());
                    vector.add(pPThread);
                }
            }
        }
        return vector;
    }

    public Vector getFunctionData(Function function, boolean bl) {
        Object object;
        Thread thread;
        Iterator iterator;
        Vector<Object> vector = new Vector<Object>();
        if (bl && (iterator = (thread = this.trial.getDataSource().getMeanData()).getFunctionProfile(function)) != null) {
            object = new PPFunctionProfile(this, thread, (FunctionProfile)iterator);
            vector.add(object);
        }
        iterator = this.trial.getDataSource().getNodes();
        while (iterator.hasNext()) {
            object = (Node)iterator.next();
            Iterator iterator2 = object.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    thread = (Thread)iterator3.next();
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    PPFunctionProfile pPFunctionProfile = new PPFunctionProfile(this, thread, functionProfile);
                    vector.add(pPFunctionProfile);
                }
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public Vector getUserEventData(UserEvent userEvent) {
        Vector<PPUserEventProfile> vector = new Vector<PPUserEventProfile>();
        Iterator iterator = this.trial.getDataSource().getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    UserEventProfile userEventProfile = thread.getUserEventProfile(userEvent);
                    if (userEventProfile == null) continue;
                    PPUserEventProfile pPUserEventProfile = new PPUserEventProfile(this, node.getNodeID(), context.getContextID(), thread.getThreadID(), userEventProfile);
                    vector.add(pPUserEventProfile);
                }
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public double getMaxExclusiveSum() {
        return this.maxExclusiveSum;
    }

    public double[] getMaxExclusives() {
        return this.maxExclusives;
    }
}

