/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.FunctionDataWindow;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfErrorDialog;
import edu.uoregon.tau.paraprof.ParaProfImageInterface;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.ThreadDataWindow;
import edu.uoregon.tau.paraprof.enums.ValueType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class FunctionDataWindowPanel
extends JPanel
implements MouseListener,
Printable,
ParaProfImageInterface {
    private ParaProfTrial ppTrial = null;
    private FunctionDataWindow window = null;
    private Vector list = new Vector();
    private Function function = null;
    private int barHeight = -1;
    private int barSpacing = -1;
    private int baseBarLength = 250;
    private int barLength = 0;
    private int textOffset = 60;
    private int barXCoord = 0;
    private int lastHeaderEndPosition = 0;
    private int xPanelSize = 0;
    private int yPanelSize = 0;

    public FunctionDataWindowPanel(ParaProfTrial paraProfTrial, Function function, FunctionDataWindow functionDataWindow) {
        this.ppTrial = paraProfTrial;
        this.window = functionDataWindow;
        this.function = function;
        this.barLength = this.baseBarLength;
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public void paintComponent(Graphics graphics) {
        try {
            super.paintComponent(graphics);
            this.renderIt((Graphics2D)graphics, true, false, false);
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            this.window.closeThisWindow();
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, this.xPanelSize, this.yPanelSize);
            this.renderIt((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            new ParaProfErrorDialog(exception);
            return 1;
        }
    }

    public void renderIt(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        Object object2;
        this.list = this.window.getData();
        int n = 0;
        int n2 = 0;
        this.barXCoord = this.barLength + this.textOffset;
        this.ppTrial.getPreferencesWindow().setBarDetails(graphics2D);
        this.barSpacing = this.ppTrial.getPreferencesWindow().getBarSpacing();
        this.barHeight = this.ppTrial.getPreferencesWindow().getBarHeight();
        Font font = new Font(this.ppTrial.getPreferencesWindow().getParaProfFont(), this.ppTrial.getPreferencesWindow().getFontStyle(), this.barHeight);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        double d = this.window.getMaxValue();
        if (this.window.isPercent()) {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%");
            this.barXCoord += n;
        } else {
            n = fontMetrics.stringWidth(UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision));
            this.barXCoord += n;
        }
        if (this.resizePanel(fontMetrics, this.barXCoord) && bl) {
            this.revalidate();
            return;
        }
        int[] nArray = ParaProfUtils.computeClipping(graphics2D.getClipBounds(), this.window.getViewRect(), bl, bl2, this.list.size(), this.barSpacing, n2);
        int n3 = nArray[0];
        int n4 = nArray[1];
        n2 = nArray[2];
        boolean bl4 = this.function.isGroupMember(this.ppTrial.getHighlightedGroup());
        if (bl3) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            object2 = this.getInsets();
            String string = this.window.getHeaderString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "'\n'");
            while (stringTokenizer.hasMoreTokens()) {
                object = new AttributedString(stringTokenizer.nextToken());
                ((AttributedString)object).addAttribute(TextAttribute.FONT, font);
                AttributedCharacterIterator attributedCharacterIterator = ((AttributedString)object).getIterator();
                LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
                float f = this.getSize().width - ((Insets)object2).left - ((Insets)object2).right;
                float f2 = ((Insets)object2).left;
                float f3 = ((Insets)object2).right;
                while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                    TextLayout textLayout = lineBreakMeasurer.nextLayout(f);
                    textLayout.draw(graphics2D, f2, n2 += this.barSpacing);
                    f2 = ((Insets)object2).left;
                }
            }
            this.lastHeaderEndPosition = n2 += this.barSpacing;
        }
        int n5 = n3;
        while (n5 <= n4) {
            object2 = (PPFunctionProfile)this.list.elementAt(n5);
            double d2 = ((PPFunctionProfile)object2).getValue();
            object = ((PPFunctionProfile)object2).getNodeID() == -1 ? "mean" : "n,c,t " + ((PPFunctionProfile)object2).getNodeID() + "," + ((PPFunctionProfile)object2).getContextID() + "," + ((PPFunctionProfile)object2).getThreadID();
            this.drawBar(graphics2D, fontMetrics, d2, d, (String)object, this.barXCoord, n2 += this.barSpacing, this.barHeight, bl4);
            ++n5;
        }
    }

    private void drawBar(Graphics2D graphics2D, FontMetrics fontMetrics, double d, double d2, String string, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        double d3 = 0.0;
        String string2 = null;
        int n5 = 0;
        int n6 = 0;
        d3 = d / d2;
        n4 = (int)(d3 * (double)this.barLength);
        if (n4 == 0) {
            n4 = 1;
        }
        if (n4 > 2 && n3 > 2) {
            graphics2D.setColor(this.function.getColor());
            graphics2D.fillRect(n - n4 + 1, n2 - n3 + 1, n4 - 1, n3 - 1);
            if (this.function == this.ppTrial.getHighlightedFunction()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else if (bl) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
                graphics2D.drawRect(n - n4 + 1, n2 - n3 + 1, n4 - 2, n3 - 2);
            } else {
                graphics2D.setColor(Color.black);
                graphics2D.drawRect(n - n4, n2 - n3, n4, n3);
            }
        } else {
            if (this.function == this.ppTrial.getHighlightedFunction()) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getHighlightColor());
            } else if (this.function.isGroupMember(this.ppTrial.getHighlightedGroup())) {
                graphics2D.setColor(this.ppTrial.getColorChooser().getGroupHighlightColor());
            } else {
                graphics2D.setColor(this.function.getColor());
            }
            graphics2D.fillRect(n - n4, n2 - n3, n4, n3);
        }
        graphics2D.setColor(Color.black);
        string2 = this.window.getDataSorter().getValueType() == ValueType.EXCLUSIVE_PERCENT || this.window.getDataSorter().getValueType() == ValueType.INCLUSIVE_PERCENT ? UtilFncs.getOutputString((int)0, (double)d, (int)6) + "%" : UtilFncs.getOutputString((int)this.window.units(), (double)d, (int)ParaProf.defaultNumberPrecision);
        n5 = fontMetrics.stringWidth(string2);
        n6 = n - n4 - n5 - 5;
        graphics2D.drawString(string2, n6, n2);
        graphics2D.drawString(string, n + 5, n2);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = mouseEvent.getClickCount();
            PPFunctionProfile pPFunctionProfile = null;
            int n4 = n2 / this.ppTrial.getPreferencesWindow().getBarSpacing();
            if (this.list != null && n4 < this.list.size()) {
                pPFunctionProfile = (PPFunctionProfile)this.list.elementAt(n4);
                if ((mouseEvent.getModifiers() & 0x10) == 0) {
                    if (n > this.barXCoord) {
                        ParaProfUtils.handleThreadClick(this.ppTrial, pPFunctionProfile.getThread(), this, mouseEvent);
                    } else {
                        JPopupMenu jPopupMenu = ParaProfUtils.createFunctionClickPopUp(this.ppTrial, pPFunctionProfile.getFunction(), this);
                        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                    }
                    return;
                }
                if (n > this.barXCoord) {
                    ThreadDataWindow threadDataWindow = new ThreadDataWindow(this.ppTrial, pPFunctionProfile.getNodeID(), pPFunctionProfile.getContextID(), pPFunctionProfile.getThreadID());
                    this.ppTrial.getSystemEvents().addObserver(threadDataWindow);
                    threadDataWindow.show();
                } else {
                    this.ppTrial.toggleHighlightedFunction(this.function);
                }
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        Dimension dimension = null;
        dimension = bl ? this.getSize() : this.window.getSize();
        if (bl2) {
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.lastHeaderEndPosition);
        } else {
            dimension.setSize(dimension.getWidth(), dimension.getHeight());
        }
        return dimension;
    }

    public void setBarLength(int n) {
        this.barLength = Math.max(1, n);
        this.repaint();
    }

    private boolean resizePanel(FontMetrics fontMetrics, int n) {
        boolean bl = false;
        int n2 = (this.window.getData().size() + 1) * this.barSpacing + 10;
        int[] nArray = this.ppTrial.getMaxNCTNumbers();
        String string = "n,c,t " + nArray[0] + "," + nArray[1] + "," + nArray[2];
        int n3 = n + 5 + fontMetrics.stringWidth(string) + 25;
        if (n2 != this.yPanelSize || n3 != this.xPanelSize) {
            this.yPanelSize = n2;
            this.xPanelSize = n3;
            this.setSize(new Dimension(this.xPanelSize, this.yPanelSize));
            bl = false;
        }
        return bl;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.xPanelSize, this.yPanelSize);
    }
}

