/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof;

import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.UtilFncs;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.HistogramWindowPanel;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfException;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.PreferencesWindow;
import edu.uoregon.tau.paraprof.enums.ValueType;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class HistogramWindow
extends JFrame
implements ActionListener,
MenuListener,
Observer,
ChangeListener,
ParaProfWindow,
UnitListener {
    private ParaProfTrial ppTrial = null;
    private DataSorter dataSorter = null;
    private Function function = null;
    private JMenu unitsSubMenu = null;
    private JScrollPane sp = null;
    private HistogramWindowPanel panel = null;
    private Vector data = null;
    private int units = ParaProf.preferences.getUnits();
    private JCheckBoxMenuItem slidersCheckBox = null;
    private JLabel numBinsLabel = new JLabel("Number of Bins");
    private JSlider numBinsSlider = new JSlider(0, 100, 10);
    private int numBins = 10;

    public HistogramWindow(ParaProfTrial paraProfTrial, Function function) {
        this.ppTrial = paraProfTrial;
        this.dataSorter = new DataSorter(paraProfTrial);
        this.function = function;
        this.setTitle("Histogram: " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        ((Component)this).setLocation(new Point(300, 200));
        ((Component)this).setSize(new Dimension(670, 630));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                HistogramWindow.this.thisWindowClosing(windowEvent);
            }
        });
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.sortLocalData();
        this.numBinsSlider.setPaintTicks(true);
        this.numBinsSlider.setMajorTickSpacing(50);
        this.numBinsSlider.setMinorTickSpacing(10);
        this.numBinsSlider.setPaintLabels(true);
        this.numBinsSlider.setSnapToTicks(false);
        this.numBinsSlider.addChangeListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panel = new HistogramWindowPanel(paraProfTrial, this);
        this.sp = new JScrollPane(this.panel);
        this.setHeader();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.95;
        gridBagConstraints.weighty = 0.98;
        this.addCompItem(this.sp, gridBagConstraints, 0, 0, 1, 1);
        this.setupMenus();
        ParaProf.incrementNumWindows();
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = null;
        Object var3_3 = null;
        JMenu jMenu2 = new JMenu("Options");
        this.slidersCheckBox = new JCheckBoxMenuItem("Show Number of Bins Slider", false);
        this.slidersCheckBox.addActionListener(this);
        jMenu2.add(this.slidersCheckBox);
        Object var5_5 = null;
        ButtonGroup buttonGroup = null;
        JRadioButtonMenuItem jRadioButtonMenuItem = null;
        this.unitsSubMenu = ParaProfUtils.createUnitsMenu(this, this.units);
        jMenu2.add(this.unitsSubMenu);
        jMenu = new JMenu("Select Value Type");
        buttonGroup = new ButtonGroup();
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive", true);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Number of Child Calls", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Inclusive per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Exclusive per Call", false);
        jRadioButtonMenuItem.addActionListener(this);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu.add(jRadioButtonMenuItem);
        jMenu2.add(jMenu);
        jMenu2.addMenuListener(this);
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this.panel, this.panel));
        jMenuBar.add(jMenu2);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block11: {
            try {
                Object object = actionEvent.getSource();
                if (!(object instanceof JMenuItem)) break block11;
                String string = actionEvent.getActionCommand();
                if (string.equals("Exclusive")) {
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block11;
                }
                if (string.equals("Inclusive")) {
                    this.dataSorter.setValueType(ValueType.INCLUSIVE);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block11;
                }
                if (string.equals("Number of Calls")) {
                    this.dataSorter.setValueType(ValueType.NUMCALLS);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block11;
                }
                if (string.equals("Number of Child Calls")) {
                    this.dataSorter.setValueType(ValueType.NUMSUBR);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block11;
                }
                if (string.equals("Inclusive per Call")) {
                    this.dataSorter.setValueType(ValueType.INCLUSIVE_PER_CALL);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block11;
                }
                if (string.equals("Exclusive per Call")) {
                    this.dataSorter.setValueType(ValueType.EXCLUSIVE_PER_CALL);
                    this.setHeader();
                    this.sortLocalData();
                    this.panel.repaint();
                    break block11;
                }
                if (string.equals("Show Number of Bins Slider")) {
                    if (this.slidersCheckBox.isSelected()) {
                        this.displaySliders(true);
                    } else {
                        this.displaySliders(false);
                    }
                    break block11;
                }
                throw new ParaProfException("The menu item '" + string + "' is not implemented!");
            }
            catch (Exception exception) {
                ParaProfUtils.handleException(exception);
            }
        }
    }

    private void displaySliders(boolean bl) {
        Container container = this.getContentPane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (bl) {
            container.remove(this.sp);
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.1;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.numBinsLabel, gridBagConstraints, 0, 1, 1, 1);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.7;
            gridBagConstraints.weighty = 0.01;
            this.addCompItem(this.numBinsSlider, gridBagConstraints, 1, 1, 1, 1);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.99;
            this.addCompItem(this.sp, gridBagConstraints, 0, 2, 2, 1);
        } else {
            container.remove(this.numBinsLabel);
            container.remove(this.numBinsSlider);
            container.remove(this.sp);
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.addCompItem(this.sp, gridBagConstraints, 0, 1, 1, 1);
        }
        this.validate();
    }

    public void menuSelected(MenuEvent menuEvent) {
        try {
            if (this.ppTrial.isTimeMetric()) {
                this.unitsSubMenu.setEnabled(true);
            } else {
                this.unitsSubMenu.setEnabled(false);
            }
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.numBins = this.numBinsSlider.getValue();
            if (this.numBins < 1) {
                this.numBins = 1;
            }
            this.panel.repaint();
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
        }
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        if (string.equals("prefEvent")) {
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("colorEvent")) {
            this.panel.repaint();
        } else if (string.equals("dataEvent")) {
            this.dataSorter.setSelectedMetricID(this.ppTrial.getDefaultMetricID());
            this.sortLocalData();
            this.setHeader();
            this.panel.repaint();
        } else if (string.equals("subWindowCloseEvent")) {
            this.closeThisWindow();
        }
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the histogram window");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("This window shows you a histogram of all of the values for this function.");
        ParaProf.helpWindow.writeText("");
        ParaProf.helpWindow.writeText("Use the options menu to select different types of data to display.");
        ParaProf.helpWindow.writeText("");
    }

    private void sortLocalData() {
        this.data = this.dataSorter.getFunctionData(this.function, false);
    }

    public void setHeader() {
        JTextArea jTextArea = new JTextArea();
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setEditable(false);
        PreferencesWindow preferencesWindow = this.ppTrial.getPreferencesWindow();
        jTextArea.setFont(new Font(preferencesWindow.getParaProfFont(), preferencesWindow.getFontStyle(), preferencesWindow.getFontSize()));
        jTextArea.append(this.getHeaderString());
        this.sp.setColumnHeaderView(jTextArea);
    }

    public String getHeaderString() {
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\n" + "Name: " + ParaProfUtils.getFunctionName(this.function) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n";
        }
        return "Metric Name: " + this.ppTrial.getMetricName(this.ppTrial.getDefaultMetricID()) + "\n" + "Name: " + ParaProfUtils.getFunctionName(this.function) + "\n" + "Value Type: " + this.dataSorter.getValueType() + "\n" + "Units: " + UtilFncs.getUnitsString((int)this.units, (boolean)this.ppTrial.isTimeMetric(), (boolean)this.ppTrial.isDerivedMetric()) + "\n";
    }

    public Vector getData() {
        return this.data;
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        this.closeThisWindow();
    }

    public void closeThisWindow() {
        try {
            ((Component)this).setVisible(false);
            this.ppTrial.getSystemEvents().deleteObserver(this);
            ParaProf.decrementNumWindows();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.dispose();
    }

    public int units() {
        if (!this.dataSorter.isTimeMetric()) {
            return 0;
        }
        if (this.dataSorter.getValueType() == ValueType.NUMCALLS || this.dataSorter.getValueType() == ValueType.NUMSUBR) {
            return 0;
        }
        return this.units;
    }

    public void setNumBins(int n) {
        this.numBins = n;
        this.panel.repaint();
    }

    public int getNumBins() {
        return this.numBins;
    }

    public void setUnits(int n) {
        this.units = n;
        this.setHeader();
        this.panel.repaint();
    }
}

