/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.vis;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.vis.Matrix;
import edu.uoregon.tau.paraprof.vis.Shape;
import edu.uoregon.tau.paraprof.vis.Vec;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.GLEventListener;
import net.java.games.jogl.GLU;
import net.java.games.jogl.util.BufferUtils;

public class VisRenderer
implements GLEventListener,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private int prevMouseX;
    private int prevMouseY;
    private boolean mouseRButtonDown = false;
    private GL gl;
    private GLU glu;
    private GLDrawable glDrawable;
    private Vec eye;
    private Vec aim = new Vec(0.0f, 0.0f, 0.0f);
    private Vec vup;
    private Vec viewDirection;
    private static final float rad = 0.017444445f;
    private static final float lateralSense = 0.017444445f;
    private static final float verticalSense = 0.017444445f;
    private double viewAltitude = -0.5233333706855774;
    private double viewAzimuth = -2.355f;
    private double viewDistance = 50.0;
    private float fovy = 45.0f;
    private boolean reverseVideo = false;
    private Color backColor = Color.white;
    private Color foreColor = Color.black;
    private Vector shapes = new Vector();
    private float fps;
    private int framesRendered;
    private int width;
    private int height;
    private boolean makeScreenShot;
    private BufferedImage screenShot;
    private VisAnimator visAnimator;
    private volatile float rotateSpeed = 0.5f;

    public void addShape(Shape shape) {
        this.shapes.add(shape);
    }

    public void removeShape(Shape shape) {
        this.shapes.remove(shape);
    }

    private void setLighting() {
        float[] fArray = new float[]{0.0f, 0.0f, 1.0f, 0.0f};
        float[] fArray2 = new float[]{0.75f, 0.75f, 0.75f, 1.0f};
        float[] fArray3 = new float[]{0.15f, 0.15f, 0.15f, 1.0f};
        this.gl.glLightfv(16384, 4611, fArray);
        this.gl.glLightfv(16384, 4609, fArray2);
        this.gl.glLightfv(16384, 4608, fArray3);
        this.gl.glLightModelfv(2899, fArray3);
        this.gl.glEnable(2903);
        this.gl.glShadeModel(7424);
        this.gl.glEnable(2896);
        this.gl.glEnable(16384);
    }

    public void init(GLDrawable gLDrawable) {
        this.gl = gLDrawable.getGL();
        this.glu = gLDrawable.getGLU();
        this.glDrawable = gLDrawable;
        ParaProfUtils.verr(this, "Initializing OpenGL (JOGL)");
        ParaProfUtils.verr(this, "INIT GL IS: " + this.gl.getClass().getName());
        ParaProfUtils.verr(this, "GL_VENDOR: " + this.gl.glGetString(7936));
        ParaProfUtils.verr(this, "GL_RENDERER: " + this.gl.glGetString(7937));
        ParaProfUtils.verr(this, "GL_VERSION: " + this.gl.glGetString(7938));
        this.gl.glEnable(2884);
        this.gl.glEnable(2929);
        this.setLighting();
        this.computeEye();
        if (System.getProperty("vis.polyline") != null) {
            this.gl.glPolygonMode(1032, 6913);
        }
        if (System.getProperty("vis.polyfill") != null) {
            this.gl.glPolygonMode(1032, 6914);
        }
        if (System.getProperty("vis.polypoint") != null) {
            this.gl.glPolygonMode(1032, 6912);
        }
        gLDrawable.addMouseListener((MouseListener)this);
        gLDrawable.addMouseMotionListener((MouseMotionListener)this);
        gLDrawable.addMouseWheelListener((MouseWheelListener)this);
    }

    private void computeEye() {
        if (this.aim == null) {
            return;
        }
        this.eye = new Vec((float)Math.cos(this.viewAltitude), 0.0f, (float)Math.sin(this.viewAltitude));
        this.eye.sety((double)this.eye.x() * Math.sin(this.viewAzimuth));
        this.eye.setx((double)this.eye.x() * Math.cos(this.viewAzimuth));
        this.eye.normalize();
        this.vup = new Vec(0.0, 0.0, 1.0);
        this.vup = this.vup.subtract(this.eye);
        this.eye.setx((double)this.eye.x() * this.viewDistance);
        this.eye.sety((double)this.eye.y() * this.viewDistance);
        this.eye.setz((double)this.eye.z() * this.viewDistance);
        this.eye = this.eye.add(this.aim);
    }

    public void cleanUp() {
        if (this.visAnimator != null) {
            this.visAnimator.end();
        }
    }

    private void rotate(float f, float f2) {
        this.viewAltitude += (double)(0.017444445f * f2);
        if (this.viewAltitude < (double)-1.57f) {
            this.viewAltitude = -1.57f;
        }
        if (this.viewAltitude > (double)1.57f) {
            this.viewAltitude = 1.57f;
        }
        this.viewAzimuth += (double)(0.017444445f * f);
        if (this.viewAzimuth >= (double)6.28f) {
            this.viewAzimuth -= (double)6.28f;
        }
        if (this.viewAzimuth >= (double)6.28f) {
            this.viewAzimuth -= (double)6.28f;
        }
        this.computeEye();
        this.redraw();
    }

    private void translate(float f, float f2) {
        double d = this.viewAltitude;
        float f3 = this.aim.z();
        this.viewAltitude = 45.0;
        this.computeEye();
        Vec vec = this.aim.subtract(this.eye);
        Vec vec2 = new Vec(vec);
        vec2.normalize();
        Vec vec3 = this.vup.cross(vec2);
        vec3.normalize();
        Vec vec4 = vec2.cross(vec3);
        vec4.normalize();
        Matrix matrix = new Matrix();
        matrix.setToTranslate(-this.eye.x(), -this.eye.y(), -this.eye.z());
        Matrix matrix2 = new Matrix();
        matrix2.setOrthRotate(vec3, vec4, vec2);
        Matrix matrix3 = matrix2.multiply(matrix);
        Vec vec5 = matrix3.transform(this.aim);
        Vec vec6 = this.eye.subtract(this.aim);
        double d2 = Math.sqrt(vec6.length()) / 50.0;
        matrix.setToTranslate(d2 * (double)f, 0.0, d2 * (double)f2);
        matrix3 = matrix.multiply(matrix3);
        matrix2.transpose();
        matrix3 = matrix2.multiply(matrix3);
        matrix.setToTranslate(this.eye.x(), this.eye.y(), this.eye.z());
        matrix3 = matrix.multiply(matrix3);
        this.aim = matrix3.transform(this.aim);
        this.aim.setz(f3);
        this.viewAltitude = d;
        this.computeEye();
        this.redraw();
    }

    public void redraw() {
        this.glDrawable.display();
    }

    public BufferedImage createScreenShot() {
        this.makeScreenShot = true;
        this.glDrawable.display();
        return this.screenShot;
    }

    public void reshape(GLDrawable gLDrawable, int n, int n2, int n3, int n4) {
        this.width = n3;
        this.height = n4;
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        this.glu.gluPerspective(45.0, (double)((float)n3 / (float)n4), 1.0, 500.0);
        this.gl.glMatrixMode(5888);
        this.gl.glLoadIdentity();
    }

    public void display(GLDrawable gLDrawable) {
        this.reshape(gLDrawable, 0, 0, this.getWidth(), this.getHeight());
        if (this.reverseVideo) {
            this.gl.glClearColor(0.93333334f, 0.93333334f, 0.93333334f, 1.0f);
        } else {
            this.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.gl.glClear(16640);
        this.gl.glPushMatrix();
        this.gl.glTranslated(0.0, 0.0, -this.viewDistance);
        this.setLighting();
        if (this.aim == null) {
            this.aim = new Vec(0.0f, 0.0f, 0.0f);
        }
        this.glu.gluLookAt((double)this.aim.x(), (double)this.aim.y(), (double)this.aim.z(), (double)this.eye.x(), (double)this.eye.y(), (double)this.eye.z(), (double)this.vup.x(), (double)this.vup.y(), (double)this.vup.z());
        this.viewDirection = this.eye.subtract(this.aim);
        for (int i = 0; i < this.shapes.size(); ++i) {
            Shape shape = (Shape)this.shapes.get(i);
            shape.render(this);
        }
        this.gl.glPopMatrix();
        ++this.framesRendered;
        if (this.makeScreenShot) {
            this.makeScreenShot = false;
            this.makeScreenShot(gLDrawable);
        }
    }

    private void makeScreenShot(GLDrawable gLDrawable) {
        int n = gLDrawable.getSize().width;
        int n2 = gLDrawable.getSize().height;
        ByteBuffer byteBuffer = BufferUtils.newByteBuffer((int)(n * n2 * 3));
        GL gL = gLDrawable.getGL();
        gL.glReadBuffer(1029);
        gL.glPixelStorei(3333, 1);
        gL.glReadPixels(0, 0, n, n2, 6407, 5121, (Buffer)byteBuffer);
        int[] nArray = new int[n * n2];
        int n3 = n * n2 * 3;
        int n4 = 0;
        int n5 = n * 3;
        for (int i = 0; i < n2; ++i) {
            int n6 = n3 -= n5;
            for (int j = 0; j < n; ++j) {
                byte by = byteBuffer.get(n6++);
                byte by2 = byteBuffer.get(n6++);
                byte by3 = byteBuffer.get(n6++);
                nArray[n4++] = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
            }
        }
        this.screenShot = new BufferedImage(n, n2, 1);
        this.screenShot.setRGB(0, 0, n, n2, nArray, 0, n);
    }

    public void displayChanged(GLDrawable gLDrawable, boolean bl, boolean bl2) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.prevMouseX = mouseEvent.getX();
        this.prevMouseY = mouseEvent.getY();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseRButtonDown = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) != 0) {
            this.mouseRButtonDown = false;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Dimension dimension = mouseEvent.getComponent().getSize();
        float f = 360.0f * ((float)(n - this.prevMouseX) / (float)dimension.width);
        float f2 = 360.0f * ((float)(this.prevMouseY - n2) / (float)dimension.height);
        float f3 = n - this.prevMouseX;
        float f4 = n2 - this.prevMouseY;
        if (this.mouseRButtonDown) {
            this.translate(-f3, -f4);
        } else {
            this.rotate(-f3, f4);
        }
        this.prevMouseX = n;
        this.prevMouseY = n2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n > 0) {
            this.zoomOut();
        } else {
            this.zoomIn();
        }
    }

    public void zoomIn() {
        this.viewDistance /= 1.1;
        this.computeEye();
        this.glDrawable.display();
    }

    public void zoomOut() {
        this.viewDistance *= 1.1;
        this.computeEye();
        this.glDrawable.display();
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float f) {
        this.fps = f;
    }

    public int getFramesRendered() {
        return this.framesRendered;
    }

    public void setFramesRendered(int n) {
        this.framesRendered = n;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public Vec getEye() {
        return this.eye;
    }

    public void setEye(Vec vec) {
    }

    public Vec getAim() {
        return this.aim;
    }

    public void setAim(Vec vec) {
        this.aim = vec;
        this.computeEye();
    }

    public JPanel getControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.setLayout(new GridBagLayout());
        final JCheckBox jCheckBox = new JCheckBox("Rotate", this.visAnimator != null);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (jCheckBox.isSelected()) {
                        VisRenderer.this.visAnimator = new VisAnimator();
                        VisRenderer.this.visAnimator.start();
                    } else {
                        VisRenderer.this.visAnimator.end();
                        VisRenderer.this.visAnimator = null;
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        final JCheckBox jCheckBox2 = new JCheckBox("Reverse Video", this.reverseVideo);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    VisRenderer.this.setReverseVideo(jCheckBox2.isSelected());
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        final JSlider jSlider = new JSlider(0, 200, (int)(Math.sqrt(this.rotateSpeed) * 100.0));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    VisRenderer.this.rotateSpeed = (float)jSlider.getValue() / 100.0f;
                    VisRenderer.this.rotateSpeed *= VisRenderer.this.rotateSpeed;
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        ParaProfUtils.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.9;
        gridBagConstraints.fill = 0;
        ParaProfUtils.addCompItem(jPanel, new JLabel("Speed"), gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.fill = 2;
        ParaProfUtils.addCompItem(jPanel, jSlider, gridBagConstraints, 1, 1, 1, 1);
        ParaProfUtils.addCompItem(jPanel, jCheckBox2, gridBagConstraints, 0, 2, 2, 1);
        return jPanel;
    }

    public boolean getReverseVideo() {
        return this.reverseVideo;
    }

    public void setReverseVideo(boolean bl) {
        this.reverseVideo = bl;
        this.redraw();
    }

    public GLDrawable getGLDrawable() {
        return this.glDrawable;
    }

    public Vec getViewDirection() {
        return this.viewDirection;
    }

    private class VisAnimator
    extends Thread {
        private volatile boolean stop = false;

        private VisAnimator() {
        }

        public void run() {
            this.stop = false;
            while (!this.stop) {
                try {
                    if (VisRenderer.this.rotateSpeed == 0.0f) {
                        Thread.sleep(250L);
                        continue;
                    }
                    VisRenderer.this.rotate(VisRenderer.this.rotateSpeed, 0.0f);
                }
                catch (Exception exception) {}
            }
        }

        public void end() {
            this.stop = true;
        }
    }
}

