/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.AtomicEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class AtomicLocationProfile {
    private int atomicEventID;
    private int node;
    private int context;
    private int thread;
    private int sampleCount;
    private double maximumValue;
    private double minimumValue;
    private double meanValue;
    private double sumSquared;

    public int getAtomicEventID() {
        return this.atomicEventID;
    }

    public int getNode() {
        return this.node;
    }

    public int getContext() {
        return this.context;
    }

    public int getThread() {
        return this.thread;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public double getSumSquared() {
        return this.sumSquared;
    }

    public void setAtomicEventID(int n) {
        this.atomicEventID = n;
    }

    public void setNode(int n) {
        this.node = n;
    }

    public void setContext(int n) {
        this.context = n;
    }

    public void setThread(int n) {
        this.thread = n;
    }

    public void setSampleCount(int n) {
        this.sampleCount = n;
    }

    public void setMaximumValue(double d) {
        this.maximumValue = d;
    }

    public void setMinimumValue(double d) {
        this.minimumValue = d;
    }

    public void setMeanValue(double d) {
        this.meanValue = d;
    }

    public void setSumSquared(double d) {
        this.sumSquared = d;
    }

    public static Vector getAtomicEventData(DB dB, String string) {
        Vector<AtomicLocationProfile> vector = new Vector<AtomicLocationProfile>();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select p.atomic_event, p.node, ");
        stringBuffer.append("p.context, p.thread, p.sample_count, ");
        stringBuffer.append("p.maximum_value, p.minimum_value, p.mean_value, ");
        stringBuffer.append("p.standard_deviation, e.trial ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_location_profile p ");
        stringBuffer.append("inner join " + dB.getSchemaPrefix() + "atomic_event e on e.id = p.atomic_event ");
        stringBuffer.append(string);
        stringBuffer.append(" order by p.node, p.context, p.thread, p.atomic_event");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                AtomicLocationProfile atomicLocationProfile = new AtomicLocationProfile();
                atomicLocationProfile.setAtomicEventID(resultSet.getInt(1));
                atomicLocationProfile.setNode(resultSet.getInt(2));
                atomicLocationProfile.setContext(resultSet.getInt(3));
                atomicLocationProfile.setThread(resultSet.getInt(4));
                atomicLocationProfile.setSampleCount(resultSet.getInt(5));
                atomicLocationProfile.setMaximumValue(resultSet.getDouble(6));
                atomicLocationProfile.setMinimumValue(resultSet.getDouble(7));
                atomicLocationProfile.setMeanValue(resultSet.getDouble(8));
                atomicLocationProfile.setSumSquared(resultSet.getDouble(9));
                vector.addElement(atomicLocationProfile);
            }
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }

    public static void getAtomicEventDetail(DB dB, AtomicEvent atomicEvent, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select p.atomic_event, avg(p.sample_count), ");
        stringBuffer.append("avg(p.maximum_value), avg(p.minimum_value), avg(p.mean_value), ");
        stringBuffer.append("avg(p.standard_deviation), ");
        stringBuffer.append("sum(p.sample_count), ");
        stringBuffer.append("sum(p.maximum_value), sum(p.minimum_value), sum(p.mean_value), ");
        stringBuffer.append("sum(p.standard_deviation) ");
        stringBuffer.append("from " + dB.getSchemaPrefix() + "atomic_location_profile p ");
        stringBuffer.append("inner join " + dB.getSchemaPrefix() + "atomic_event e on e.id = p.atomic_event ");
        stringBuffer.append(string);
        stringBuffer.append(" group by p.atomic_event");
        stringBuffer.append(" order by p.atomic_event");
        try {
            ResultSet resultSet = dB.executeQuery(stringBuffer.toString());
            AtomicLocationProfile atomicLocationProfile = new AtomicLocationProfile();
            AtomicLocationProfile atomicLocationProfile2 = new AtomicLocationProfile();
            while (resultSet.next()) {
                atomicLocationProfile.setAtomicEventID(resultSet.getInt(1));
                atomicLocationProfile2.setAtomicEventID(resultSet.getInt(1));
                atomicLocationProfile.setSampleCount((int)resultSet.getDouble(2));
                atomicLocationProfile.setMaximumValue(resultSet.getDouble(3));
                atomicLocationProfile.setMinimumValue(resultSet.getDouble(4));
                atomicLocationProfile.setMeanValue(resultSet.getDouble(5));
                atomicLocationProfile.setSumSquared(resultSet.getDouble(6));
                atomicLocationProfile2.setSampleCount((int)resultSet.getDouble(7));
                atomicLocationProfile2.setMaximumValue(resultSet.getDouble(8));
                atomicLocationProfile2.setMinimumValue(resultSet.getDouble(9));
                atomicLocationProfile2.setMeanValue(resultSet.getDouble(10));
                atomicLocationProfile2.setSumSquared(resultSet.getDouble(11));
            }
            resultSet.close();
            atomicEvent.setMeanSummary(atomicLocationProfile);
            atomicEvent.setTotalSummary(atomicLocationProfile2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveAtomicEventData(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("INSERT INTO " + dB.getSchemaPrefix() + "atomic_location_profile (atomic_event, node, context, thread, sample_count, maximum_value, minimum_value, mean_value, standard_deviation) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, this.node);
            preparedStatement.setInt(3, this.context);
            preparedStatement.setInt(4, this.thread);
            preparedStatement.setInt(5, this.sampleCount);
            preparedStatement.setDouble(6, this.maximumValue);
            preparedStatement.setDouble(7, this.minimumValue);
            preparedStatement.setDouble(8, this.meanValue);
            preparedStatement.setDouble(9, this.sumSquared);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the trial.");
            sQLException.printStackTrace();
        }
    }
}

