/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.dms.dss;

import edu.uoregon.tau.dms.dss.CallPathUtilFuncs;
import edu.uoregon.tau.dms.dss.DataSource;
import edu.uoregon.tau.dms.dss.DataSourceException;
import edu.uoregon.tau.dms.dss.Function;
import edu.uoregon.tau.dms.dss.FunctionProfile;
import edu.uoregon.tau.dms.dss.HPCToolkitXMLHandler;
import edu.uoregon.tau.dms.dss.Thread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class HPCToolkitDataSource
extends DataSource {
    private File file;
    private HPCToolkitXMLHandler handler = new HPCToolkitXMLHandler(this);

    public HPCToolkitDataSource(File file) {
        this.file = file;
    }

    public void load() throws FileNotFoundException, IOException, DataSourceException, SQLException {
        try {
            FunctionProfile functionProfile;
            Comparable comparable;
            Object object;
            Object object2;
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xMLReader.setContentHandler(this.handler);
            xMLReader.setErrorHandler(this.handler);
            xMLReader.parse(new InputSource(new FileInputStream(this.file)));
            if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
                this.setCallPathDataPresent(true);
            }
            for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                object2 = this.getThread(0, 0, 0);
                object = this.getFunctions();
                while (object.hasNext()) {
                    FunctionProfile functionProfile2;
                    comparable = (Function)object.next();
                    functionProfile = ((Thread)object2).getFunctionProfile((Function)comparable);
                    if (functionProfile == null || (functionProfile2 = this.getParent((Thread)object2, (Function)comparable)) == null) continue;
                    double d = functionProfile2.getExclusive(i) - functionProfile.getInclusive(i);
                    if (d < 0.0) {
                        d = 0.0;
                    }
                    functionProfile2.setExclusive(i, d);
                }
            }
            Thread thread = this.getThread(0, 0, 0);
            object2 = this.getFunctions();
            while (object2.hasNext()) {
                object = (Function)object2.next();
                comparable = thread.getFunctionProfile((Function)object);
                if (comparable == null || (functionProfile = this.getFlatFunctionProfile(thread, (Function)object)) == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    functionProfile.setExclusive(i, functionProfile.getExclusive(i) + ((FunctionProfile)comparable).getExclusive(i));
                    functionProfile.setInclusive(i, functionProfile.getInclusive(i) + ((FunctionProfile)comparable).getInclusive(i));
                }
            }
            this.setGroupNamesPresent(true);
            this.generateDerivedData();
        }
        catch (SAXException sAXException) {
            throw new DataSourceException(sAXException);
        }
    }

    private FunctionProfile getParent(Thread thread, Function function) {
        if (!function.getCallPathFunction()) {
            return null;
        }
        String string = function.getName();
        String string2 = string.substring(0, string.lastIndexOf("=>"));
        Function function2 = this.getFunction(string2);
        FunctionProfile functionProfile = thread.getFunctionProfile(function2);
        return functionProfile;
    }

    private FunctionProfile getFlatFunctionProfile(Thread thread, Function function) {
        if (!function.getCallPathFunction()) {
            return null;
        }
        String string = function.getName().substring(function.getName().lastIndexOf("=>") + 2).trim();
        Function function2 = this.addFunction(string);
        FunctionProfile functionProfile = thread.getFunctionProfile(function2);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function2, this.getNumberOfMetrics());
            thread.addFunctionProfile(functionProfile);
        }
        return functionProfile;
    }

    public int getProgress() {
        return 0;
    }

    public void cancelLoad() {
    }
}

