/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.taujava.preferences;

import edu.uoregon.tau.taujava.TaujavaPlugin;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TauJavaPrefs
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EX_PATH = "exclusionPathPreference";
    public static final String EX_BOOLEAN = "exclusionPreference";
    public static final String DEF_OUT = "defaultOutputRoot";
    public static final String USR_OUT = "outputRoot";
    public static final String TDIR_PATH = "tauDirPathPreference";
    public static final String TWIN_DLL = "tauWinDLLPreference";
    public static final String PARA_BOOL = "runParaProf";

    public TauJavaPrefs() {
        super(1);
        this.setPreferenceStore(TaujavaPlugin.getDefault().getPreferenceStore());
        this.setDescription("Setup Tau instrumentation for Java");
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(EX_BOOLEAN, false);
        store.setDefault(DEF_OUT, false);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new FileFieldEditor(EX_PATH, "&Selective Instrumentation File:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(EX_BOOLEAN, "&Enable Selective Instrumentation.", this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(TDIR_PATH, "&TAU Library Directory:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(DEF_OUT, "&Use Alternative TAU Output Directory?", this.getFieldEditorParent()));
        this.addField((FieldEditor)new DirectoryFieldEditor(USR_OUT, "&Alternate TAU Output Directory:", this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(PARA_BOOL, "&Automatically run ParaProf on profile output?", this.getFieldEditorParent()));
        if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") != -1) {
            this.addField((FieldEditor)new RadioGroupFieldEditor(TWIN_DLL, "&TAU Analysis Method:", 1, (String[][])new String[][]{{"Profile", "tau-profile.dll"}, {"Callpath", "tau-callpath.dll"}, {"Trace", "tau-trace.dll"}}, this.getFieldEditorParent()));
        }
    }

    public void init(IWorkbench workbench) {
    }
}

