/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerClient;
import client.PerfExplorerConnection;
import client.PerfExplorerModel;
import client.SpeedupXYLineAndShapeRenderer;
import common.RMIChartData;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Stroke;
import java.util.List;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardLegend;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class PerfExplorerChart {
    public static void doFractionChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 0);
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        List list2 = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray = (double[])list.get(j);
                xYSeries.add(dArray[0], dArray[1]);
            }
            defaultTableXYDataset.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart((String)("Total Runtime Breakdown for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Percentage of Total Runtime", (TableXYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        list = new ChartFrame("Total Runtime Breakdown", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doEfficiencyChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 1);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = dArray[1] * d;
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency - " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        list = new ChartFrame("Relative Efficiency", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doEfficiencyEventsChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 4);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = dArray[1] * d;
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency by Event for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        list = new ChartFrame("Relative Efficiency by Event", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doEfficiencyOneEventChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 5);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = dArray[1] * d;
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency for " + PerfExplorerModel.getModel().getEventName() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        list = new ChartFrame("Relative Efficiency for Event", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doSpeedupChart() {
        XYSeries xYSeries;
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 1);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                double d4 = dArray[0] / dArray2[0];
                double d5 = dArray[1] * d4;
                d3 = d5 / dArray2[1];
                xYSeries.add(dArray2[0], d3 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries2 = new XYSeries("ideal", true, false);
        xYSeries2.add(d, 1.0);
        xYSeries2.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries2);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup - " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        xYSeries = new ChartFrame("Relative Speedup", (JFreeChart)list);
        PerfExplorerChart.centerFrame((ChartFrame)xYSeries);
        xYSeries.pack();
        xYSeries.setVisible(true);
    }

    public static void doSpeedupEventsChart() {
        XYSeries xYSeries;
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 4);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d4 = dArray[0] / dArray2[0];
                d3 = dArray[1] * d4;
                d5 = d3 / dArray2[1];
                xYSeries.add(dArray2[0], d5 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries2 = new XYSeries("ideal", true, false);
        xYSeries2.add(d, 1.0);
        xYSeries2.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries2);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup by Event for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        xYSeries = new ChartFrame("Relative Speedup by Event", (JFreeChart)list);
        PerfExplorerChart.centerFrame((ChartFrame)xYSeries);
        xYSeries.pack();
        xYSeries.setVisible(true);
    }

    public static void doSpeedupOneEventChart() {
        XYSeries xYSeries;
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 5);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d4 = dArray[0] / dArray2[0];
                d3 = dArray[1] * d4;
                d5 = d3 / dArray2[1];
                xYSeries.add(dArray2[0], d5 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries2 = new XYSeries("ideal", true, false);
        xYSeries2.add(d, 1.0);
        xYSeries2.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries2);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup for " + PerfExplorerModel.getModel().getEventName() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        xYSeries = new ChartFrame("Relative Speedup for Event", (JFreeChart)list);
        PerfExplorerChart.centerFrame((ChartFrame)xYSeries);
        xYSeries.pack();
        xYSeries.setVisible(true);
    }

    public static void doTimestepsChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 1);
        int n = Integer.parseInt(PerfExplorerModel.getModel().getTotalTimesteps());
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray = (double[])list.get(j);
                xYSeries.add(dArray[0], (double)n / dArray[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Timesteps Per Second (" + n + " total timesteps):" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Timesteps", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        list = new ChartFrame("Timesteps per Second", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doCommunicationChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 3);
        RMIChartData rMIChartData2 = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 1);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            List list3 = rMIChartData2.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray = (double[])list.get(j);
                double[] dArray2 = (double[])list3.get(j);
                xYSeries.add(dArray[0], dArray[1] / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Communication Time / Total Runtime" + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Fraction", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        list = new ChartFrame("Transpose Time / Total Runtime", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doEfficiencyPhasesChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 6);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                d = dArray[0] / dArray2[0];
                double d2 = dArray[1] * d;
                xYSeries.add(dArray2[0], d2 / dArray2[1]);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)("Relative Efficiency by Phase for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart(jFreeChart, rMIChartData.getRows(), false);
        list = new ChartFrame("Relative Efficiency by Event", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    public static void doSpeedupPhasesChart() {
        XYSeries xYSeries;
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 6);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        List list2 = rMIChartData.getRowLabels();
        double d = 99999.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            xYSeries = new XYSeries((String)list2.get(i), true, false);
            double[] dArray = (double[])list.get(0);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray2 = (double[])list.get(j);
                double d4 = dArray[0] / dArray2[0];
                double d5 = dArray[1] * d4;
                d3 = d5 / dArray2[1];
                xYSeries.add(dArray2[0], d3 / d4);
                if (!(d2 < dArray2[0])) continue;
                d2 = dArray2[0];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        XYSeries xYSeries2 = new XYSeries("ideal", true, false);
        xYSeries2.add(d, 1.0);
        xYSeries2.add(d2, d2 / d);
        xYSeriesCollection.addSeries(xYSeries2);
        list = ChartFactory.createXYLineChart((String)("Relative Speedup by Phase for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Value", (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        PerfExplorerChart.customizeChart((JFreeChart)list, rMIChartData.getRows(), true);
        xYSeries = new ChartFrame("Relative Speedup by Event", (JFreeChart)list);
        PerfExplorerChart.centerFrame((ChartFrame)xYSeries);
        xYSeries.pack();
        xYSeries.setVisible(true);
    }

    public static void doFractionPhasesChart() {
        List list;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        RMIChartData rMIChartData = perfExplorerConnection.requestChartData(PerfExplorerModel.getModel(), 7);
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        List list2 = rMIChartData.getRowLabels();
        for (int i = 0; i < rMIChartData.getRows(); ++i) {
            list = rMIChartData.getRowData(i);
            XYSeries xYSeries = new XYSeries((String)list2.get(i), true, false);
            for (int j = 0; j < list.size(); ++j) {
                double[] dArray = (double[])list.get(j);
                xYSeries.add(dArray[0], dArray[1]);
            }
            defaultTableXYDataset.addSeries(xYSeries);
        }
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart((String)("Total Runtime Breakdown for " + PerfExplorerModel.getModel().toString() + ":" + PerfExplorerModel.getModel().getMetricName()), (String)"Number of Processors", (String)"Percentage of Total Runtime", (TableXYDataset)defaultTableXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        list = new ChartFrame("Total Runtime Breakdown", jFreeChart);
        PerfExplorerChart.centerFrame((ChartFrame)list);
        list.pack();
        list.setVisible(true);
    }

    private static void customizeChart(JFreeChart jFreeChart, int n, boolean bl) {
        StandardLegend standardLegend = (StandardLegend)jFreeChart.getLegend();
        standardLegend.setDisplaySeriesShapes(true);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = null;
        xYLineAndShapeRenderer = bl ? new SpeedupXYLineAndShapeRenderer(n) : new XYLineAndShapeRenderer();
        xYLineAndShapeRenderer.setDefaultShapesFilled(true);
        xYLineAndShapeRenderer.setItemLabelsVisible(true);
        for (int i = 0; i < n; ++i) {
            xYLineAndShapeRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        if (bl) {
            xYLineAndShapeRenderer.setSeriesShapesVisible(n, false);
        }
        xYPlot.setRenderer((XYItemRenderer)xYLineAndShapeRenderer);
    }

    private static void centerFrame(ChartFrame chartFrame) {
        int n = 700;
        int n2 = 450;
        Point point = PerfExplorerClient.getMainFrame().getLocationOnScreen();
        Dimension dimension = PerfExplorerClient.getMainFrame().getSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = (n3 - n) / 2;
        int n6 = (n4 - n2) / 2;
        n5 = (int)point.getX() + n5;
        n6 = (int)point.getY() + n6;
        chartFrame.setLocation(n5, n6);
        chartFrame.setSize(new Dimension(n, n2));
    }
}

