/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.PerfExplorerConnection;
import client.PerfExplorerTreeCellRenderer;
import client.PerfExplorerTreeExpansionListener;
import client.PerfExplorerTreeSelectionListener;
import common.RMIView;
import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Trial;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class PerfExplorerJTree
extends JTree {
    private static PerfExplorerJTree theTree = null;
    private static List leafViews = null;

    private PerfExplorerJTree(DefaultTreeModel defaultTreeModel) {
        super(defaultTreeModel);
        this.putClientProperty("JTree.lineStyle", "Angled");
        PerfExplorerTreeCellRenderer perfExplorerTreeCellRenderer = new PerfExplorerTreeCellRenderer();
        this.setCellRenderer(perfExplorerTreeCellRenderer);
        this.addTreeSelectionListener(new PerfExplorerTreeSelectionListener(this));
        this.addTreeWillExpandListener(new PerfExplorerTreeExpansionListener(this));
    }

    public static PerfExplorerJTree getTree() {
        if (theTree == null) {
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(PerfExplorerJTree.createNodes());
            defaultTreeModel.setAsksAllowsChildren(true);
            theTree = new PerfExplorerJTree(defaultTreeModel);
            PerfExplorerJTree.addTrialsForViews();
        }
        return theTree;
    }

    private static DefaultMutableTreeNode createNodes() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Performance Data");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Database Profiles");
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode("Views");
        PerfExplorerJTree.addApplicationNodes(defaultMutableTreeNode2, true);
        leafViews = new ArrayList();
        PerfExplorerJTree.addViewNodes(defaultMutableTreeNode3, "0");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    public static void addViewNodes(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        List list = perfExplorerConnection.getViews(Integer.parseInt(string));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            RMIView rMIView = (RMIView)iterator.next();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(rMIView);
            PerfExplorerJTree.addViewNodes(defaultMutableTreeNode2, rMIView.getField("ID"));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
        if (list.size() == 0) {
            leafViews.add(defaultMutableTreeNode);
        }
    }

    public static void addApplicationNodes(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        ListIterator listIterator;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (perfExplorerConnection != null && (listIterator = perfExplorerConnection.getApplicationList()) != null) {
            Application application = null;
            while (listIterator.hasNext()) {
                application = (Application)listIterator.next();
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(application);
                PerfExplorerJTree.addExperimentNodes(defaultMutableTreeNode2, application, true);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public static void addExperimentNodes(DefaultMutableTreeNode defaultMutableTreeNode, Application application, boolean bl) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator listIterator = perfExplorerConnection.getExperimentList(application.getID());
        Experiment experiment = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (listIterator.hasNext()) {
            experiment = (Experiment)listIterator.next();
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(experiment);
            if (bl) {
                PerfExplorerJTree.addTrialNodes(defaultMutableTreeNode2, experiment);
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void addTrialNodes(DefaultMutableTreeNode defaultMutableTreeNode, Experiment experiment) {
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        ListIterator listIterator = perfExplorerConnection.getTrialList(experiment.getID());
        Trial trial = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        while (listIterator.hasNext()) {
            trial = (Trial)listIterator.next();
            defaultMutableTreeNode2 = new DefaultMutableTreeNode(trial);
            PerfExplorerJTree.addMetricNodes(defaultMutableTreeNode2, trial);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    public static void addTrialsForViews() {
        Iterator iterator = leafViews.iterator();
        while (iterator.hasNext()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)iterator.next();
            PerfExplorerJTree.addTrialsForView(defaultMutableTreeNode);
        }
    }

    public static void addTrialsForView(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object[] objectArray = defaultMutableTreeNode.getUserObjectPath();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof RMIView)) continue;
            arrayList.add(objectArray[i]);
        }
        PerfExplorerConnection perfExplorerConnection = PerfExplorerConnection.getConnection();
        if (arrayList.size() > 0) {
            ListIterator listIterator = perfExplorerConnection.getTrialsForView(arrayList);
            Trial trial = null;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            while (listIterator.hasNext()) {
                trial = (Trial)listIterator.next();
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(trial);
                PerfExplorerJTree.addMetricNodes(defaultMutableTreeNode2, trial);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }

    public static void addMetricNodes(DefaultMutableTreeNode defaultMutableTreeNode, Trial trial) {
        Vector vector = trial.getMetrics();
        if (vector != null) {
            ListIterator listIterator = vector.listIterator();
            Metric metric = null;
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            while (listIterator.hasNext()) {
                metric = (Metric)listIterator.next();
                defaultMutableTreeNode2 = new DefaultMutableTreeNode(metric);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        }
    }
}

