/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.RawDataInterface;
import java.util.ArrayList;
import java.util.List;

public class RRawData
implements RawDataInterface {
    private int vectors = 0;
    private int dimensions = 0;
    private double[][] data = null;
    private String[] eventNames = null;
    private String[] threadNames = null;

    public RRawData(int n, int n2) {
        this.vectors = n;
        this.dimensions = n2;
        this.data = new double[n][n2];
        this.eventNames = new String[n2];
        this.threadNames = new String[n2];
    }

    public void addValue(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    public double getValue(int n, int n2) {
        return this.data[n][n2];
    }

    public double getCartesianDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double d2 = Math.abs(this.data[n][i] - this.data[n2][i]);
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public double getManhattanDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            d += Math.abs(this.data[n][i] - this.data[n2][i]);
        }
        return d;
    }

    public Object getData() {
        return this.data;
    }

    public List getEventNames() {
        ArrayList<String> arrayList = new ArrayList<String>(this.eventNames.length);
        for (int i = 0; i < this.eventNames.length; ++i) {
            arrayList.add(this.eventNames[i]);
        }
        return arrayList;
    }

    public int numVectors() {
        return this.vectors;
    }

    public int numDimensions() {
        return this.dimensions;
    }
}

