/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.ClusterDescription;
import clustering.ClusterException;
import clustering.PrincipalComponentsAnalysisInterface;
import clustering.RawDataInterface;
import clustering.WekaRawData;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instances;
import weka.core.Utils;

public class WekaPrincipalComponents
implements PrincipalComponentsAnalysisInterface {
    private int k = 0;
    private RawDataInterface inputData = null;
    private Instances instances = null;
    private Instances components = null;
    private PrincipalComponents pca = null;
    private int numAttributes = 0;
    private double[][] correlationCoefficients = null;

    public void doPCA() throws ClusterException {
        try {
            this.pca = new PrincipalComponents();
            if (this.k > 0) {
                this.pca.setMaximumAttributeNames(this.k);
            }
            this.pca.setNormalize(true);
            this.pca.buildEvaluator(this.instances);
            this.components = this.pca.transformedData();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ClusterDescription getComponentDescription(int n) throws ClusterException {
        return null;
    }

    public void setK(int n) {
        this.k = n;
    }

    public void setInputData(RawDataInterface rawDataInterface) {
        this.inputData = rawDataInterface;
        this.instances = (Instances)rawDataInterface.getData();
    }

    public double[][] getCorrelationCoefficients() {
        if (this.correlationCoefficients == null) {
            this.numAttributes = this.instances.numAttributes();
            this.correlationCoefficients = new double[this.numAttributes][this.numAttributes];
            for (int i = 0; i < this.numAttributes; ++i) {
                double[] dArray = this.instances.attributeToDoubleArray(i);
                for (int j = 0; j < i; ++j) {
                    double[] dArray2 = this.instances.attributeToDoubleArray(j);
                    this.correlationCoefficients[i][j] = Utils.correlation((double[])dArray, (double[])dArray2, (int)this.numAttributes);
                }
            }
        }
        return this.correlationCoefficients;
    }

    public RawDataInterface getResults() {
        WekaRawData wekaRawData = new WekaRawData(this.components);
        return wekaRawData;
    }

    public void reset() {
    }
}

