/*
 * Decompiled with CFR 0.152.
 */
package clustering;

import clustering.RawDataInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaRawData
implements RawDataInterface {
    Instances instances = null;
    int vectors = 0;
    int dimensions = 0;

    public WekaRawData(String string, List list, int n, int n2) {
        int n3;
        this.vectors = n;
        this.dimensions = n2;
        FastVector fastVector = new FastVector(list.size());
        for (n3 = 0; n3 < list.size(); ++n3) {
            String string2 = (String)list.get(n3);
            fastVector.addElement((Object)new Attribute(string2));
        }
        this.instances = new Instances(string, fastVector, n);
        for (n3 = 0; n3 < n; ++n3) {
            this.instances.add(new Instance(n2));
        }
    }

    public WekaRawData(Instances instances) {
        this.instances = instances;
        this.vectors = instances.numInstances();
        if (this.vectors > 0) {
            this.dimensions = instances.instance(0).numAttributes();
        }
    }

    public void addValue(int n, int n2, double d) {
        Instance instance = this.instances.instance(n);
        instance.setValue(n2, d);
    }

    public double getValue(int n, int n2) {
        return this.instances.instance(n).value(n2);
    }

    public double getManhattanDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            d += Math.abs(this.instances.instance(n).value(i) - this.instances.instance(n2).value(i));
        }
        return d;
    }

    public double getCartesianDistance(int n, int n2) {
        double d = 0.0;
        for (int i = 0; i < this.dimensions; ++i) {
            double d2 = Math.abs(this.instances.instance(n).value(i) - this.instances.instance(n2).value(i));
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    public Object getData() {
        return this.instances;
    }

    public List getEventNames() {
        Enumeration enumeration = this.instances.enumerateAttributes();
        ArrayList<String> arrayList = new ArrayList<String>(this.instances.numDistinctValues(0));
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            arrayList.add(attribute.name());
        }
        return arrayList;
    }

    public int numVectors() {
        return this.vectors;
    }

    public int numDimensions() {
        return this.dimensions;
    }
}

