/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.RMIView;
import edu.uoregon.tau.dms.dss.Application;
import edu.uoregon.tau.dms.dss.Experiment;
import edu.uoregon.tau.dms.dss.Metric;
import edu.uoregon.tau.dms.dss.Trial;
import java.io.Serializable;
import java.util.List;

public class RMIPerfExplorerModel
implements Serializable {
    public static final String K_MEANS = "K Means";
    public static final String K_HARMONIC_MEANS = "K Harmonic Means";
    public static final String GEM = "Gaussian Expectation-Maximization";
    public static final String FUZZY_K_MEANS = "Fuzzy K Means";
    public static final String CORRELATION_ANALYSIS = "Correlation Analysis";
    public static final String LINEAR_PROJECTION = "Random Linear Projection (disabled)";
    public static final String OVER_X_PERCENT = "Over X Percent";
    public static final String REGRESSION = "PCA (disabled)";
    public static final String NONE = "none";
    public static final String PERCENTAGE_OF_TOTAL = "Percentage of Total";
    public static final String RANGE_OF_TOTAL = "Range of Total";
    public static final int MAX_CLUSTERS = 10;
    public static final double X_PERCENT = 1.0;
    public static final int NO_MULTI = 0;
    public static final int APPLICATION = 1;
    public static final int EXPERIMENT = 2;
    public static final int TRIAL = 3;
    public static final int METRIC = 4;
    public static final int VIEW = 5;
    protected List multiSelections = null;
    protected int multiSelectionType = 0;
    protected String groupName = null;
    protected String metricName = null;
    protected String eventName = null;
    protected String totalTimesteps = null;
    protected String clusterMethod = null;
    protected String dimensionReduction = null;
    protected String normalization = null;
    protected int numberOfClusters = 10;
    protected double xPercent = 1.0;
    protected Object currentSelection = null;
    protected Application application = null;
    protected Experiment experiment = null;
    protected Trial trial = null;
    protected RMIView view = null;
    protected int analysisID = 0;
    protected Object[] fullPath = null;

    public RMIPerfExplorerModel() {
    }

    public RMIPerfExplorerModel(RMIPerfExplorerModel rMIPerfExplorerModel) {
        this.multiSelectionType = rMIPerfExplorerModel.multiSelectionType;
        this.groupName = rMIPerfExplorerModel.groupName;
        this.metricName = rMIPerfExplorerModel.metricName;
        this.eventName = rMIPerfExplorerModel.eventName;
        this.totalTimesteps = rMIPerfExplorerModel.totalTimesteps;
        this.clusterMethod = rMIPerfExplorerModel.clusterMethod;
        this.dimensionReduction = rMIPerfExplorerModel.dimensionReduction;
        this.normalization = rMIPerfExplorerModel.normalization;
        this.numberOfClusters = rMIPerfExplorerModel.numberOfClusters;
        this.xPercent = rMIPerfExplorerModel.xPercent;
        this.currentSelection = rMIPerfExplorerModel.currentSelection;
        this.application = rMIPerfExplorerModel.application;
        this.experiment = rMIPerfExplorerModel.experiment;
        this.trial = rMIPerfExplorerModel.trial;
        this.view = rMIPerfExplorerModel.view;
        this.analysisID = rMIPerfExplorerModel.analysisID;
        this.fullPath = rMIPerfExplorerModel.fullPath;
    }

    public static Object[] getClusterMethods() {
        Object[] objectArray = new Object[]{K_MEANS, K_HARMONIC_MEANS, GEM, FUZZY_K_MEANS};
        return objectArray;
    }

    public static Object[] getDimensionReductions() {
        Object[] objectArray = new Object[]{OVER_X_PERCENT, NONE};
        return objectArray;
    }

    public static Object[] getNormalizations() {
        Object[] objectArray = new Object[]{PERCENTAGE_OF_TOTAL, RANGE_OF_TOTAL, NONE};
        return objectArray;
    }

    public Object getCurrentSelection() {
        return this.currentSelection;
    }

    public Application getApplication() {
        return this.application;
    }

    public Experiment getExperiment() {
        return this.experiment;
    }

    public Trial getTrial() {
        return this.trial;
    }

    public String getClusterMethod() {
        return this.clusterMethod == null ? K_MEANS : this.clusterMethod;
    }

    public String getDimensionReduction() {
        return this.dimensionReduction == null ? NONE : this.dimensionReduction;
    }

    public String getNormalization() {
        return this.normalization == null ? NONE : this.normalization;
    }

    public int getNumberOfClusters() {
        return this.numberOfClusters;
    }

    public double getXPercent() {
        return this.xPercent;
    }

    public void setCurrentSelection(Object object) {
        this.groupName = null;
        this.metricName = null;
        this.eventName = null;
        this.totalTimesteps = null;
        this.multiSelections = null;
        this.multiSelectionType = 0;
        if (object instanceof Application) {
            this.application = (Application)object;
        } else if (object instanceof Experiment) {
            this.experiment = (Experiment)object;
        } else if (object instanceof Trial) {
            this.trial = (Trial)object;
        } else if (object instanceof RMIView) {
            this.view = (RMIView)object;
        }
        this.currentSelection = object;
    }

    public void setCurrentSelection(Object[] objectArray) {
        this.groupName = null;
        this.metricName = null;
        this.eventName = null;
        this.totalTimesteps = null;
        this.multiSelections = null;
        this.multiSelectionType = 0;
        this.fullPath = objectArray;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof Application) {
                this.application = (Application)objectArray[i];
            } else if (objectArray[i] instanceof Experiment) {
                this.experiment = (Experiment)objectArray[i];
            } else if (objectArray[i] instanceof Trial) {
                this.trial = (Trial)objectArray[i];
            } else if (objectArray[i] instanceof RMIView) {
                this.view = (RMIView)objectArray[i];
            }
            this.currentSelection = objectArray[i];
        }
    }

    public void setClusterMethod(String string) {
        this.clusterMethod = string;
    }

    public void setDimensionReduction(String string) {
        this.dimensionReduction = string;
    }

    public void setNormalization(String string) {
        this.normalization = string;
    }

    public void setNumberOfClusters(String string) {
        this.numberOfClusters = Integer.parseInt(string);
    }

    public void setXPercent(String string) {
        this.xPercent = Double.parseDouble(string);
    }

    public String toString() {
        if (this.multiSelectionType == 1) {
            return "Applications";
        }
        if (this.multiSelectionType == 2) {
            String string = this.application == null ? "" : this.application.getName();
            return string;
        }
        if (this.multiSelectionType == 3) {
            String string = this.application == null ? "" : this.application.getName();
            String string2 = this.experiment.getName();
            String string3 = string + ":" + string2;
            return string3;
        }
        if (this.multiSelectionType == 4) {
            String string = this.application == null ? "" : this.application.getName();
            String string4 = this.experiment == null ? "" : this.experiment.getName();
            String string5 = this.trial.getName();
            String string6 = string + ":" + string4 + ":" + string5;
            return string6;
        }
        if (this.multiSelectionType == 5) {
            return "Custom View";
        }
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string7 = this.experiment == null ? "" : this.experiment.getName();
            String string8 = this.trial == null ? "" : this.trial.getName();
            String string9 = metric.getName();
            String string10 = string + ":" + string7 + ":" + string8 + ":" + string9;
            return string10;
        }
        if (this.currentSelection instanceof Trial) {
            Trial trial = (Trial)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string11 = this.experiment == null ? "" : this.experiment.getName();
            String string12 = trial.getName();
            String string13 = string + ":" + string11 + ":" + string12;
            return string13;
        }
        if (this.currentSelection instanceof Experiment) {
            Experiment experiment = (Experiment)this.currentSelection;
            String string = this.application == null ? "" : this.application.getName();
            String string14 = experiment.getName();
            String string15 = string + ":" + string14;
            return string15;
        }
        if (this.currentSelection instanceof Application) {
            Application application = (Application)this.currentSelection;
            String string = application.getName();
            return string;
        }
        if (this.currentSelection instanceof RMIView) {
            RMIView rMIView = (RMIView)this.currentSelection;
            String string = rMIView.getField("NAME");
            return string;
        }
        return new String("");
    }

    public String toShortString() {
        if (this.currentSelection instanceof Metric) {
            Metric metric = (Metric)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string2 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string3 = this.trial == null ? "" : "" + this.trial.getID();
            String string4 = "" + metric.getID();
            String string5 = string + "." + string2 + "." + string3 + "." + string4;
            return string5;
        }
        if (this.currentSelection instanceof Trial) {
            Trial trial = (Trial)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string6 = this.experiment == null ? "" : "" + this.experiment.getID();
            String string7 = "" + trial.getID();
            String string8 = string + "." + string6 + "." + string7;
            return string8;
        }
        if (this.currentSelection instanceof Experiment) {
            Experiment experiment = (Experiment)this.currentSelection;
            String string = this.application == null ? "" : "" + this.application.getID();
            String string9 = "" + experiment.getID();
            String string10 = string + "." + string9;
            return string10;
        }
        if (this.currentSelection instanceof Application) {
            Application application = (Application)this.currentSelection;
            String string = "" + application.getID();
            return string;
        }
        if (this.currentSelection instanceof RMIView) {
            RMIView rMIView = (RMIView)this.currentSelection;
            String string = rMIView.getField("NAME");
            return string;
        }
        return new String("");
    }

    public int getAnalysisID() {
        return this.analysisID;
    }

    public void setAnalysisID(int n) {
        this.analysisID = n;
    }

    public boolean setMultiSelection(List list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Application) {
                if (this.multiSelectionType != 1 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 1;
                continue;
            }
            if (list.get(i) instanceof Experiment) {
                if (this.multiSelectionType != 2 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 2;
                continue;
            }
            if (list.get(i) instanceof Trial) {
                if (this.multiSelectionType != 3 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 3;
                continue;
            }
            if (list.get(i) instanceof Metric) {
                if (this.multiSelectionType != 4 && this.multiSelectionType != 0) {
                    return false;
                }
                this.multiSelectionType = 4;
                continue;
            }
            if (!(list.get(i) instanceof RMIView)) continue;
            if (this.multiSelectionType != 5 && this.multiSelectionType != 0) {
                return false;
            }
            this.multiSelectionType = 5;
        }
        this.groupName = null;
        this.metricName = null;
        this.eventName = null;
        this.totalTimesteps = null;
        this.multiSelections = list;
        return true;
    }

    public List getMultiSelection() {
        return this.multiSelections;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String string) {
        this.groupName = string;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String string) {
        this.metricName = string;
    }

    public String getTotalTimesteps() {
        return this.totalTimesteps;
    }

    public void setTotalTimesteps(String string) {
        this.totalTimesteps = string;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String string) {
        this.eventName = string;
    }

    public String getViewSelectionPath(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append(" inner join experiment e on t.experiment = e.id ");
        }
        if (bl) {
            stringBuffer.append(" inner join application a on e.application = a.id ");
        }
        stringBuffer.append(" WHERE ");
        boolean bl3 = false;
        for (int i = 0; i < this.fullPath.length; ++i) {
            if (i > 0 && bl3) {
                stringBuffer.append(" AND ");
            }
            if (!(this.fullPath[i] instanceof RMIView)) continue;
            RMIView rMIView = (RMIView)this.fullPath[i];
            if (rMIView.getField("table_name").equalsIgnoreCase("Application")) {
                stringBuffer.append(" a.");
            } else if (rMIView.getField("table_name").equalsIgnoreCase("Experiment")) {
                stringBuffer.append(" e.");
            } else {
                stringBuffer.append(" t.");
            }
            stringBuffer.append(rMIView.getField("column_name"));
            stringBuffer.append(" " + rMIView.getField("operator") + " '");
            stringBuffer.append(rMIView.getField("value"));
            stringBuffer.append("' ");
            bl3 = true;
        }
        return stringBuffer.toString();
    }

    public String getViewSelectionString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.fullPath.length - 1;
        RMIView rMIView = (RMIView)this.fullPath[n];
        if (rMIView.getField("table_name").equalsIgnoreCase("Application")) {
            stringBuffer.append(" a.");
        } else if (rMIView.getField("table_name").equalsIgnoreCase("Experiment")) {
            stringBuffer.append(" e.");
        } else {
            stringBuffer.append(" t.");
        }
        stringBuffer.append(rMIView.getField("column_name"));
        return stringBuffer.toString();
    }

    public String getViewID() {
        int n = this.fullPath.length - 1;
        RMIView rMIView = (RMIView)this.fullPath[n];
        return rMIView.getField("id");
    }
}

