/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.DendrogramTree;
import common.PerfExplorerException;
import common.RMIPerfExplorerModel;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.Metric;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.TimerTask;
import org.omegahat.R.Java.REvaluator;
import org.omegahat.R.Java.ROmegahatInterpreter;
import server.PerfExplorerServer;
import server.Thumbnail;

public class AnalysisTask
extends TimerTask {
    private RMIPerfExplorerModel modelData = null;
    private PerfExplorerServer server = null;
    private ROmegahatInterpreter rInterpreter = null;
    private REvaluator rEvaluator = null;
    private DendrogramTree dendrogramTree = null;
    private int analysisID = 0;
    private int numRows = 0;
    private int numCenterRows = 0;
    private int numTotalThreads = 0;
    private int numEvents = 0;
    private int nodes = 0;
    private int contexts = 0;
    private int threads = 0;
    private Object[][] rawData = null;
    private int[] eventID = null;
    private double maximum = 0.0;
    private static final int reducedDimension = 12;

    public AnalysisTask(PerfExplorerServer perfExplorerServer) {
        this.server = perfExplorerServer;
    }

    private void makeDendrogram() throws PerfExplorerException {
        int n;
        System.out.print("Copying data...");
        this.rEvaluator.voidEval("raw <- matrix(0, nrow=" + this.numTotalThreads + ", ncol=" + this.numEvents + ")");
        for (n = 0; n < this.numTotalThreads; ++n) {
            for (int i = 0; i < this.numEvents; ++i) {
                if (this.rawData[n][i] == null) continue;
                this.rEvaluator.voidEval("raw[" + (n + 1) + "," + (i + 1) + "] <- " + this.rawData[n][i]);
            }
        }
        System.out.println(" Done!");
        if (this.modelData.getDimensionReduction().equals("Random Linear Projection (disabled)")) {
            System.out.print("Reducing Dimensions...");
            n = this.numTotalThreads * 12;
            this.rEvaluator.voidEval("reducer <- matrix((runif(" + n + ",0,1)), nrow=" + this.numEvents + ", ncol=" + 12 + ")");
            this.rEvaluator.voidEval("raw <- crossprod(t(raw), reducer)");
            this.numEvents = 12;
            System.out.println(" Done!");
        }
        if (this.numTotalThreads < 4098) {
            System.out.print("Getting distances...");
            this.rEvaluator.voidEval("threads <- dist(raw, method=\"manhattan\")");
            System.out.println(" Done!");
            System.out.print("Hierarchical clustering...");
            this.rEvaluator.voidEval("hcgtr <- hclust(threads, method=\"average\")");
            int[] nArray = (int[])this.rEvaluator.eval("t(hcgtr$merge)");
            double[] dArray = (double[])this.rEvaluator.eval("hcgtr$height");
            this.dendrogramTree = this.createDendrogramTree(nArray, dArray);
            this.rEvaluator.voidEval("dend <- as.dendrogram(hcgtr)");
            System.out.println(" Done!");
            System.out.print("Making png image...");
            String string = "dendrogram." + this.modelData.toString();
            string = string.replaceAll(":", ".");
            String string2 = this.modelData.toShortString();
            String string3 = "/tmp/dendrogram." + string2 + ".png";
            String string4 = "/tmp/dendrogram.thumb." + string2 + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string3 + "\",width=800, height=400)");
            this.rEvaluator.voidEval("plot (dend, main=\"" + string + "\", edge.root=FALSE,horiz=FALSE,axes=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.saveAnalysisResult(string, string3, string4, true);
        }
    }

    public void saveAnalysisResult(String string, String string2, String string3, boolean bl) throws PerfExplorerException {
        Thumbnail.createThumbnail(string2, string3, bl);
        try {
            PerfExplorerServer.getServer().getControl().WAIT("saveAnalysisResult");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("insert into analysis_result (analysis_settings, description, thumbnail_size, image_size, thumbnail, image, result_type) values (?, ?, ?, ?, ?, ?, 0)");
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, string2);
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string3);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setInt(4, (int)file.length());
            preparedStatement.setBinaryStream(5, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream, (int)file.length());
            preparedStatement.executeUpdate();
            fileInputStream.close();
            preparedStatement.close();
            file.delete();
            file2.delete();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
        }
        catch (Exception exception) {
            String string4 = "ERROR: Couldn't insert the analysis results into the database!";
            System.out.println(string4);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
            throw new PerfExplorerException(string4, exception);
        }
    }

    private void doKMeansClustering(boolean bl) throws PerfExplorerException {
        this.rEvaluator.voidEval("traw <- t(raw)");
        this.rEvaluator.voidEval("first <- rgb(0,0,0:15,max=15)");
        this.rEvaluator.voidEval("second <- rgb(0,0:15,15:0,max=15)");
        this.rEvaluator.voidEval("third <- rgb(0:15,15:0,0,max=15)");
        this.rEvaluator.voidEval("fourth <- rgb(15,0:15,0,max=15)");
        this.rEvaluator.voidEval("all <- c(first, second, third, fourth)");
        int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
        for (int i = 2; i <= n; ++i) {
            Object object;
            if (bl) {
                System.out.print("Making " + i + " centers...");
                object = this.dendrogramTree.findCenters(i);
                this.rEvaluator.voidEval("centers <- matrix(0, nrow=" + i + ", ncol=" + this.numEvents + ")");
                System.out.print("centers: ");
                for (int j = 1; j <= i; ++j) {
                    System.out.print((int)object[j - 1]);
                    this.rEvaluator.voidEval("centers[" + j + ",] <- raw[" + (int)object[j - 1] + ",]");
                    if (j == i) continue;
                    System.out.print(",");
                }
                System.out.println(" Done!");
            }
            System.out.print("Doing k-means clustering...");
            if (bl) {
                this.rEvaluator.voidEval("cl <- kmeans(raw, centers, 20)");
            } else {
                this.rEvaluator.voidEval("cl <- kmeans(raw, " + i + ", 20)");
            }
            System.out.println(" Done!");
            object = this.modelData.toString() + i + "_clusters";
            object = ((String)object).replaceAll(":", ".");
            String string = this.modelData.toShortString() + i;
            System.out.print("Making png image...");
            String string2 = "/tmp/clusterSizes." + string + ".png";
            String string3 = "/tmp/clusterSizes.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("barplot (cl$size, main=\"cluster sizes: " + (String)object + "\", xlab=\"count\", ylab=\"cluster\", horiz=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Making colormap image...");
            if (bl) {
                if (this.numTotalThreads > 32 && this.threads != 1) {
                    this.rEvaluator.voidEval("mymat <- matrix(cl$cluster, nrow=" + this.threads * this.contexts + ", ncol=" + this.nodes + ")");
                    this.rEvaluator.voidEval("mymat <- t(mymat)");
                } else {
                    this.rEvaluator.voidEval("mymat <- matrix(cl$cluster, nrow=" + this.numTotalThreads / 16 + ", ncol=16)");
                }
            } else {
                this.rEvaluator.voidEval("mymat <- matrix(cl$cluster, nrow=" + this.numTotalThreads / 32 + ", ncol=32)");
            }
            string2 = "/tmp/clusterimage." + string + ".png";
            string3 = "/tmp/clusterimage.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("image(mymat, col=all, axes=FALSE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Getting averages, mins, maxes...");
            this.rEvaluator.voidEval("maxes <- matrix(0.0, nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("mins <- matrix(" + this.maximum + ", nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("totals <- matrix(0.0, nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("counts <- matrix(0.0, nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("ci <- 0");
            for (int j = 1; j <= this.numTotalThreads; ++j) {
                this.rEvaluator.voidEval("ci <- cl$cluster[" + j + "]");
                for (int k = 1; k <= this.numEvents; ++k) {
                    this.rEvaluator.voidEval("if (raw[" + j + "," + k + "] > maxes[ci," + k + "]) maxes[ci," + k + "] <- raw[" + j + "," + k + "]");
                    this.rEvaluator.voidEval("if (raw[" + j + "," + k + "] < mins[ci," + k + "]) mins[ci," + k + "] <- raw[" + j + "," + k + "]");
                    this.rEvaluator.voidEval("totals[ci," + k + "] = totals[ci," + k + "] + raw[" + j + "," + k + "]");
                    this.rEvaluator.voidEval("counts[ci," + k + "] = counts[ci," + k + "] + 1");
                }
            }
            this.rEvaluator.voidEval("avgs <- totals / counts");
            System.out.println(" Done!");
            System.out.print("Making png image of averages...");
            string2 = "/tmp/barplot_averages." + string + ".png";
            string3 = "/tmp/barplot_averages.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                this.rEvaluator.voidEval("barplot(t(avgs), main=\"barplot averages: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + ((Metric)this.modelData.getCurrentSelection()).getName() + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            } else {
                this.rEvaluator.voidEval("barplot(t(avgs), main=\"barplot averages: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + "all metrics" + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            }
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Making png image of maxes...");
            string2 = "/tmp/barplot_maxes." + string + ".png";
            string3 = "/tmp/barplot_maxes.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                this.rEvaluator.voidEval("barplot(t(maxes), main=\"barplot maxes: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + ((Metric)this.modelData.getCurrentSelection()).getName() + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            } else {
                this.rEvaluator.voidEval("barplot(t(maxes), main=\"barplot maxes: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + "all metrics" + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            }
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Making png image of mins...");
            string2 = "/tmp/barplot_mins." + string + ".png";
            string3 = "/tmp/barplot_mins.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                this.rEvaluator.voidEval("barplot(t(mins), main=\"barplot mins: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + ((Metric)this.modelData.getCurrentSelection()).getName() + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            } else {
                this.rEvaluator.voidEval("barplot(t(mins), main=\"barplot mins: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + "all metrics" + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            }
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.saveAnalysisResult((String)object, string2, string3, false);
        }
    }

    private void getConstants() throws PerfExplorerException {
        System.out.print("Getting constants...");
        try {
            ResultSet resultSet;
            PerfExplorerServer.getServer().getControl().WAIT("getContstants");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            String string = null;
            string = this.modelData.getDimensionReduction().equals("Over X Percent") ? new String("select count(p.exclusive) from interval_event e inner join interval_mean_summary s on e.id = s.interval_event and s.exclusive_percentage > " + this.modelData.getXPercent() + " left outer join interval_location_profile p on e.id = p.interval_event and s.metric = p.metric where e.trial = ?") : new String("select count(p.exclusive) from interval_event e left outer join interval_location_profile p on e.id = p.interval_event where e.trial = ?");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                string = string + " and p.metric = ?";
            }
            preparedStatement = dB.prepareStatement(string);
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.numRows = resultSet.getInt(1);
            }
            resultSet.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            string = null;
            PerfExplorerServer.getServer().getControl().WAIT("getContstants");
            if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                string = new String("select count(e.id) from interval_event e inner join interval_mean_summary s on e.id = s.interval_event and s.exclusive_percentage > " + this.modelData.getXPercent() + " where e.trial = ? ");
                if (this.modelData.getCurrentSelection() instanceof Metric) {
                    string = string + " and s.metric = ? ";
                }
            } else {
                string = new String("select count(e.id) from interval_event e where e.trial = ?");
            }
            preparedStatement = dB.prepareStatement(string);
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getDimensionReduction().equals("Over X Percent") && this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.numEvents = resultSet.getInt(1);
            }
            resultSet.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            string = null;
            PerfExplorerServer.getServer().getControl().WAIT("getContstants");
            string = new String("select max(node), max(context), max(thread) from interval_location_profile inner join interval_event on id = interval_event where trial = ? ");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                string = string + " and metric = ? ";
            }
            preparedStatement = dB.prepareStatement(string);
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.nodes = resultSet.getInt(1) + 1;
                this.contexts = resultSet.getInt(2) + 1;
                this.threads = resultSet.getInt(3) + 1;
                this.numTotalThreads = this.nodes * this.contexts * this.threads;
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the constant settings from the database!";
            System.out.println(string);
            sQLException.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            throw new PerfExplorerException(string, sQLException);
        }
        System.out.println(" Done!");
    }

    private void getRawData() throws PerfExplorerException {
        System.out.print("Getting raw data...");
        this.rawData = new Double[this.numTotalThreads][this.numEvents];
        this.eventID = new int[this.numEvents];
        ResultSet resultSet = null;
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.maximum = 0.0;
        try {
            PerfExplorerServer.getServer().getControl().WAIT("getRawData");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            String string = null;
            string = this.modelData.getDimensionReduction().equals("Over X Percent") ? new String("select e.id, (p.node*" + this.contexts * this.threads + ") + (p.context*" + this.threads + ") + p.thread as thread, p.exclusive from interval_event e inner join interval_mean_summary s on e.id = s.interval_event and s.exclusive_percentage > " + this.modelData.getXPercent() + " left outer join interval_location_profile p on e.id = p.interval_event and p.metric = s.metric where e.trial = ? ") : new String("select e.id, (p.node*" + this.contexts * this.threads + ") + (p.context*" + this.threads + ") + p.thread as thread, p.exclusive from interval_event e left outer join interval_location_profile p on e.id = p.interval_event where e.trial = ? ");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                string = string + " and p.metric = ? ";
            }
            string = string + " order by 1,2 ";
            preparedStatement = dB.prepareStatement(string);
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                if (n != resultSet.getInt(1)) {
                    this.eventID[++n2] = resultSet.getInt(1);
                }
                n = resultSet.getInt(1);
                n4 = resultSet.getInt(2);
                this.rawData[n4][n2] = new Double(resultSet.getDouble(3));
                if (this.maximum < resultSet.getDouble(3)) {
                    this.maximum = resultSet.getDouble(3);
                }
                ++n3;
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the raw data from the database!";
            System.out.println(string);
            sQLException.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
            throw new PerfExplorerException(string, sQLException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            System.out.println("\ncurrentFunction: " + n);
            System.out.println("functionIndex: " + n2);
            System.out.println("rowIndex: " + n3);
            System.out.println("threadIndex: " + n4);
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
            System.exit(1);
        }
        System.out.println(" Done!");
    }

    public DendrogramTree createDendrogramTree(int[] nArray, double[] dArray) {
        DendrogramTree dendrogramTree = null;
        DendrogramTree dendrogramTree2 = null;
        DendrogramTree dendrogramTree3 = null;
        Hashtable<Integer, DendrogramTree> hashtable = new Hashtable<Integer, DendrogramTree>(nArray.length);
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dendrogramTree = nArray[n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            dendrogramTree2 = nArray[++n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            ++n;
            dendrogramTree3 = new DendrogramTree(i + 1, dArray[i]);
            dendrogramTree3.setLeftAndRight(dendrogramTree, dendrogramTree2);
            hashtable.put(new Integer(i + 1), dendrogramTree3);
        }
        return dendrogramTree3;
    }

    public void run() {
        this.modelData = this.server.getNextRequest();
        if (this.modelData != null) {
            this.analysisID = this.modelData.getAnalysisID();
            try {
                System.out.println("Processing " + this.modelData.toString());
                this.getConstants();
                this.getRawData();
                this.rInterpreter = this.server.getRInterpreter();
                this.rEvaluator = this.server.getREvaluator();
                this.makeDendrogram();
                this.doKMeansClustering(this.numTotalThreads < 4098);
            }
            catch (PerfExplorerException perfExplorerException) {
                // empty catch block
            }
            this.server.taskFinished();
            this.modelData = null;
        }
    }
}

