/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.AnalysisFactory;
import clustering.ClusterException;
import clustering.KMeansClusterInterface;
import clustering.PrincipalComponentsAnalysisInterface;
import clustering.RawDataInterface;
import clustering.WekaAnalysisFactory;
import clustering.WekaRawData;
import common.PerfExplorerException;
import common.RMIPerfExplorerModel;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.Metric;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.TimerTask;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.omegahat.R.Java.REvaluator;
import org.omegahat.R.Java.ROmegahatInterpreter;
import server.DendrogramTree;
import server.PCAPlotDataset;
import server.PerfExplorerServer;
import server.ScatterPlotDataset;
import server.Thumbnail;
import server.VirtualTopology;
import weka.core.Instances;

public class AnalysisTaskWrapper
extends TimerTask {
    public static final int RPROJECT_ENGINE = 0;
    public static final int WEKA_ENGINE = 1;
    public static final int OCTAVE_ENGINE = 2;
    public static final int DENDROGRAM = 0;
    public static final int HISTOGRAM = 1;
    public static final int VIRTUAL_TOPOLOGY = 2;
    public static final int CLUSTER_AVERAGES = 3;
    public static final int CLUSTER_MAXIMUMS = 4;
    public static final int CLUSTER_MINIMUMS = 5;
    public static final int PCA_SCATTERPLOT = 6;
    public static final int CORRELATION_SCATTERPLOT = 7;
    private int engine = 0;
    private int chartType = 0;
    private AnalysisFactory factory = null;
    private RMIPerfExplorerModel modelData = null;
    private PerfExplorerServer server = null;
    private ROmegahatInterpreter rInterpreter = null;
    private REvaluator rEvaluator = null;
    private DendrogramTree dendrogramTree = null;
    private int analysisID = 0;
    private int numRows = 0;
    private int numCenterRows = 0;
    private int numTotalThreads = 0;
    private int numEvents = 0;
    private int numMetrics = 0;
    private int nodes = 0;
    private int contexts = 0;
    private int threads = 0;
    private RawDataInterface rawData = null;
    private double maximum = 0.0;
    private static final int reducedDimension = 12;
    private List eventIDs = null;
    private List metricIDs = null;

    public AnalysisTaskWrapper(PerfExplorerServer perfExplorerServer, int n) {
        this.server = perfExplorerServer;
        this.engine = n;
        switch (n) {
            case 1: {
                this.factory = WekaAnalysisFactory.getFactory();
            }
        }
    }

    private void makeDendrogram() throws PerfExplorerException {
        int n;
        System.out.print("Copying data...");
        this.rEvaluator.voidEval("raw <- matrix(0, nrow=" + this.numTotalThreads + ", ncol=" + this.numEvents + ")");
        for (n = 0; n < this.numTotalThreads; ++n) {
            for (int i = 0; i < this.numEvents; ++i) {
                this.rEvaluator.voidEval("raw[" + (n + 1) + "," + (i + 1) + "] <- " + this.rawData.getValue(n, i));
            }
        }
        System.out.println(" Done!");
        if (this.modelData.getDimensionReduction().equals("Random Linear Projection (disabled)")) {
            System.out.print("Reducing Dimensions...");
            n = this.numTotalThreads * 12;
            this.rEvaluator.voidEval("reducer <- matrix((runif(" + n + ",0,1)), nrow=" + this.numEvents + ", ncol=" + 12 + ")");
            this.rEvaluator.voidEval("raw <- crossprod(t(raw), reducer)");
            this.numEvents = 12;
            System.out.println(" Done!");
        }
        if (this.numTotalThreads < 4098) {
            System.out.print("Getting distances...");
            this.rEvaluator.voidEval("threads <- dist(raw, method=\"manhattan\")");
            System.out.println(" Done!");
            System.out.print("Hierarchical clustering...");
            this.rEvaluator.voidEval("hcgtr <- hclust(threads, method=\"average\")");
            int[] nArray = (int[])this.rEvaluator.eval("t(hcgtr$merge)");
            double[] dArray = (double[])this.rEvaluator.eval("hcgtr$height");
            this.dendrogramTree = this.createDendrogramTree(nArray, dArray);
            this.rEvaluator.voidEval("dend <- as.dendrogram(hcgtr)");
            System.out.println(" Done!");
            System.out.print("Making png image...");
            String string = "dendrogram." + this.modelData.getApplication().getName() + "." + this.modelData.getExperiment().getName() + "." + this.modelData.getTrial().getName() + "." + ((Metric)this.modelData.getCurrentSelection()).getName();
            String string2 = this.modelData.getApplication().getID() + "." + this.modelData.getExperiment().getID() + "." + this.modelData.getTrial().getID() + "." + ((Metric)this.modelData.getCurrentSelection()).getID();
            String string3 = "/tmp/dendrogram." + string2 + ".png";
            String string4 = "/tmp/dendrogram.thumb." + string2 + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string3 + "\",width=800, height=400)");
            this.rEvaluator.voidEval("plot (dend, main=\"" + string + "\", edge.root=FALSE,horiz=FALSE,axes=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.chartType = 0;
            this.saveAnalysisResult(string, string3, string4, true);
        }
    }

    public void saveAnalysisResult(String string, String string2, String string3, boolean bl) throws PerfExplorerException {
        Thumbnail.createThumbnail(string2, string3, bl);
        try {
            PerfExplorerServer.getServer().getControl().WAIT("saveAnalysisResult");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("insert into analysis_result (analysis_settings, description, thumbnail_size, image_size, thumbnail, image, result_type) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, string2);
            File file = new File(string2);
            FileInputStream fileInputStream = new FileInputStream(file);
            File file2 = new File(string3);
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setInt(4, (int)file.length());
            preparedStatement.setBinaryStream(5, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream, (int)file.length());
            preparedStatement.setInt(7, this.chartType);
            preparedStatement.executeUpdate();
            fileInputStream.close();
            preparedStatement.close();
            file.delete();
            file2.delete();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
        }
        catch (Exception exception) {
            String string4 = "ERROR: Couldn't insert the analysis results into the database!";
            System.out.println(string4);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
            throw new PerfExplorerException(string4, exception);
        }
    }

    public void saveAnalysisResult(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, File file, File file2) throws PerfExplorerException {
        try {
            PerfExplorerServer.getServer().getControl().WAIT("saveAnalysisResult");
            DB dB = PerfExplorerServer.getServer().getDB();
            dB.setAutoCommit(false);
            PreparedStatement preparedStatement = null;
            Instances instances = (Instances)rawDataInterface.getData();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("insert into analysis_result ");
            stringBuffer.append(" (analysis_settings, description, thumbnail_size, thumbnail, image_size, image, result_type) values (?, ?, ?, ?, ?, ?, ?)");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.analysisID);
            preparedStatement.setString(2, new String("analysis_result"));
            FileInputStream fileInputStream = new FileInputStream(file);
            preparedStatement.setInt(3, (int)file2.length());
            preparedStatement.setBinaryStream(4, (InputStream)fileInputStream, (int)file.length());
            FileInputStream fileInputStream2 = new FileInputStream(file2);
            preparedStatement.setInt(5, (int)file2.length());
            preparedStatement.setBinaryStream(6, (InputStream)fileInputStream2, (int)file2.length());
            preparedStatement.setInt(7, this.chartType);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            String string = new String();
            string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM analysis_result" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT ar_id_seq.currval FROM DUAL" : "select currval('analysis_result_id_seq');"));
            int n = Integer.parseInt(dB.getDataItem(string));
            preparedStatement.close();
            dB.commit();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't insert the analysis results into the database!";
            System.out.println(string);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("saveAnalysisResult");
            throw new PerfExplorerException(string, exception);
        }
    }

    private void doKMeansClustering(boolean bl) throws PerfExplorerException {
        this.rEvaluator.voidEval("traw <- t(raw)");
        this.rEvaluator.voidEval("first <- rgb(0,0,0:15,max=15)");
        this.rEvaluator.voidEval("second <- rgb(0,0:15,15:0,max=15)");
        this.rEvaluator.voidEval("third <- rgb(0:15,15:0,0,max=15)");
        this.rEvaluator.voidEval("fourth <- rgb(15,0:15,0,max=15)");
        this.rEvaluator.voidEval("all <- c(first, second, third, fourth)");
        int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
        for (int i = 2; i <= n; ++i) {
            Object object;
            if (bl) {
                System.out.print("Making " + i + " centers...");
                object = this.dendrogramTree.findCenters(i);
                this.rEvaluator.voidEval("centers <- matrix(0, nrow=" + i + ", ncol=" + this.numEvents + ")");
                System.out.print("centers: ");
                for (int j = 1; j <= i; ++j) {
                    System.out.print(object[j - 1]);
                    this.rEvaluator.voidEval("centers[" + j + ",] <- raw[" + object[j - 1] + ",]");
                    if (j == i) continue;
                    System.out.print(",");
                }
                System.out.println(" Done!");
            }
            System.out.print("Doing k-means clustering...");
            if (bl) {
                this.rEvaluator.voidEval("cl <- kmeans(raw, centers, 20)");
            } else {
                this.rEvaluator.voidEval("cl <- kmeans(raw, " + i + ", 20)");
            }
            System.out.println(" Done!");
            object = this.modelData.getApplication().getName() + "." + this.modelData.getExperiment().getName() + "." + this.modelData.getTrial().getName() + "." + ((Metric)this.modelData.getCurrentSelection()).getName() + "." + i + "_clusters";
            String string = this.modelData.getApplication().getID() + "." + this.modelData.getExperiment().getID() + "." + this.modelData.getTrial().getID() + "." + ((Metric)this.modelData.getCurrentSelection()).getID() + i;
            System.out.print("Making png image...");
            String string2 = "/tmp/clusterSizes." + string + ".png";
            String string3 = "/tmp/clusterSizes.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("barplot (cl$size, main=\"cluster sizes: " + (String)object + "\", xlab=\"count\", ylab=\"cluster\", horiz=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.chartType = 1;
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Making colormap image...");
            if (bl) {
                if (this.numTotalThreads > 32 && this.threads != 1) {
                    this.rEvaluator.voidEval("mymat <- matrix(cl$cluster, nrow=" + this.threads * this.contexts + ", ncol=" + this.nodes + ")");
                    this.rEvaluator.voidEval("mymat <- t(mymat)");
                } else {
                    this.rEvaluator.voidEval("mymat <- matrix(cl$cluster, nrow=" + this.numTotalThreads / 16 + ", ncol=16)");
                }
            } else {
                this.rEvaluator.voidEval("mymat <- matrix(cl$cluster, nrow=" + this.numTotalThreads / 32 + ", ncol=32)");
            }
            string2 = "/tmp/clusterimage." + string + ".png";
            string3 = "/tmp/clusterimage.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("image(mymat, col=all, axes=FALSE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.chartType = 2;
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Getting averages, mins, maxes...");
            this.rEvaluator.voidEval("maxes <- matrix(0.0, nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("mins <- matrix(" + this.maximum + ", nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("totals <- matrix(0.0, nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("counts <- matrix(0.0, nrow=" + i + ", ncol=" + this.numEvents + ")");
            this.rEvaluator.voidEval("ci <- 0");
            for (int j = 1; j <= this.numTotalThreads; ++j) {
                this.rEvaluator.voidEval("ci <- cl$cluster[" + j + "]");
                for (int k = 1; k <= this.numEvents; ++k) {
                    this.rEvaluator.voidEval("if (raw[" + j + "," + k + "] > maxes[ci," + k + "]) maxes[ci," + k + "] <- raw[" + j + "," + k + "]");
                    this.rEvaluator.voidEval("if (raw[" + j + "," + k + "] < mins[ci," + k + "]) mins[ci," + k + "] <- raw[" + j + "," + k + "]");
                    this.rEvaluator.voidEval("totals[ci," + k + "] = totals[ci," + k + "] + raw[" + j + "," + k + "]");
                    this.rEvaluator.voidEval("counts[ci," + k + "] = counts[ci," + k + "] + 1");
                }
            }
            this.rEvaluator.voidEval("avgs <- totals / counts");
            System.out.println(" Done!");
            System.out.print("Making png image of averages...");
            string2 = "/tmp/barplot_averages." + string + ".png";
            string3 = "/tmp/barplot_averages.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("barplot(t(avgs), main=\"barplot averages: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + ((Metric)this.modelData.getCurrentSelection()).getName() + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.chartType = 3;
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Making png image of maxes...");
            string2 = "/tmp/barplot_maxes." + string + ".png";
            string3 = "/tmp/barplot_maxes.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("barplot(t(maxes), main=\"barplot maxes: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + ((Metric)this.modelData.getCurrentSelection()).getName() + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.chartType = 4;
            this.saveAnalysisResult((String)object, string2, string3, false);
            System.out.print("Making png image of mins...");
            string2 = "/tmp/barplot_mins." + string + ".png";
            string3 = "/tmp/barplot_mins.thumb." + string + ".jpg";
            this.rEvaluator.voidEval("png(\"" + string2 + "\")");
            this.rEvaluator.voidEval("barplot(t(mins), main=\"barplot mins: " + (String)object + "\", xlab=\"cluster\", ylab=\"" + ((Metric)this.modelData.getCurrentSelection()).getName() + "\", col=1:" + this.numEvents + ", horiz=TRUE)");
            this.rEvaluator.voidEval("dev.off()");
            System.out.println(" Done!");
            this.chartType = 5;
            this.saveAnalysisResult((String)object, string2, string3, false);
        }
    }

    private void getConstants() throws PerfExplorerException {
        System.out.print("Getting constants...");
        try {
            ResultSet resultSet;
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("select count(p.excl) ");
            } else {
                stringBuffer.append("select count(p.exclusive) ");
            }
            stringBuffer.append("from interval_event e ");
            stringBuffer.append("left outer join interval_location_profile p ");
            stringBuffer.append("on e.id = p.interval_event ");
            if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                stringBuffer.append("inner join interval_mean_summary s ");
                stringBuffer.append("on e.id = s.interval_event and s.metric = p.metric ");
                stringBuffer.append("and s.exclusive_percentage > ");
                stringBuffer.append("" + this.modelData.getXPercent() + "");
            }
            stringBuffer.append("where e.trial = ?");
            stringBuffer.append(" and e.group_name not like '%TAU_CALLPATH%' ");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and p.metric = ?");
            }
            PerfExplorerServer.getServer().getControl().WAIT("getConstants");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.numRows = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("select e.id, e.name from interval_event e ");
                if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                    stringBuffer.append("inner join interval_mean_summary s on ");
                    stringBuffer.append("e.id = s.interval_event ");
                    stringBuffer.append("and s.exclusive_percentage > ");
                    stringBuffer.append("" + this.modelData.getXPercent() + "");
                    stringBuffer.append(" where e.trial = ? ");
                    if (this.modelData.getCurrentSelection() instanceof Metric) {
                        stringBuffer.append(" and s.metric = ? ");
                    }
                } else {
                    stringBuffer.append("where e.trial = ?");
                }
                stringBuffer.append(" and e.group_name not like '%TAU_CALLPATH%' ");
                stringBuffer.append(" order by 1");
                PerfExplorerServer.getServer().getControl().WAIT("getConstants");
                preparedStatement = dB.prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, this.modelData.getTrial().getID());
                if (this.modelData.getDimensionReduction().equals("Over X Percent") && this.modelData.getCurrentSelection() instanceof Metric) {
                    preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
                }
                resultSet = preparedStatement.executeQuery();
                this.numEvents = 0;
                this.eventIDs = new ArrayList();
                while (resultSet.next()) {
                    ++this.numEvents;
                    this.eventIDs.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
                PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            } else {
                stringBuffer = new StringBuffer();
                stringBuffer.append("select m.id, m.name from metric m ");
                stringBuffer.append("where m.trial = ?");
                stringBuffer.append(" order by 1");
                PerfExplorerServer.getServer().getControl().WAIT("getConstants");
                preparedStatement = dB.prepareStatement(stringBuffer.toString());
                preparedStatement.setInt(1, this.modelData.getTrial().getID());
                resultSet = preparedStatement.executeQuery();
                this.numEvents = 0;
                this.eventIDs = new ArrayList();
                while (resultSet.next()) {
                    ++this.numEvents;
                    this.eventIDs.add(resultSet.getString(2));
                }
                resultSet.close();
                preparedStatement.close();
                PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("select max(node), max(context), max(thread) ");
            stringBuffer.append("from interval_location_profile ");
            stringBuffer.append("inner join interval_event ");
            stringBuffer.append("on id = interval_event where trial = ? ");
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and metric = ? ");
            }
            PerfExplorerServer.getServer().getControl().WAIT("getConstants");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                this.nodes = resultSet.getInt(1) + 1;
                this.contexts = resultSet.getInt(2) + 1;
                this.threads = resultSet.getInt(3) + 1;
                this.numTotalThreads = this.nodes * this.contexts * this.threads;
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the constant settings from the database!";
            System.out.println(string);
            sQLException.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("getConstants");
            throw new PerfExplorerException(string, sQLException);
        }
        System.out.println("\nnumRows: " + this.numRows);
        System.out.println("numCenterRows: " + this.numCenterRows);
        System.out.println("nodes: " + this.nodes);
        System.out.println("contexts: " + this.contexts);
        System.out.println("threads: " + this.threads);
        System.out.println("numTotalThreads: " + this.numTotalThreads);
        System.out.println("numEvents: " + this.numEvents);
        System.out.println(" Done!");
    }

    private void getRawData() throws PerfExplorerException {
        System.out.print("Getting raw data...");
        this.rawData = new WekaRawData("Cluster Test", this.eventIDs, this.numTotalThreads, this.numEvents);
        ResultSet resultSet = null;
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        this.maximum = 0.0;
        try {
            int n5;
            PerfExplorerServer.getServer().getControl().WAIT("getRawData");
            DB dB = PerfExplorerServer.getServer().getDB();
            PreparedStatement preparedStatement = null;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.modelData.getDimensionReduction().equals("Over X Percent")) {
                stringBuffer.append("select e.id, (p.node*");
                stringBuffer.append(this.contexts * this.threads);
                stringBuffer.append(") + (p.context*");
                stringBuffer.append(this.threads);
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.excl ");
                } else {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.exclusive ");
                }
                stringBuffer.append("from interval_event e ");
                stringBuffer.append("inner join interval_mean_summary s ");
                stringBuffer.append("on e.id = s.interval_event and s.exclusive_percentage > ");
                stringBuffer.append(this.modelData.getXPercent());
                stringBuffer.append(" left outer join interval_location_profile p ");
                stringBuffer.append("on e.id = p.interval_event ");
                stringBuffer.append("and p.metric = s.metric where e.trial = ? ");
            } else {
                stringBuffer.append("select e.id, (p.node*" + this.contexts * this.threads + "");
                stringBuffer.append(") + (p.context*" + this.threads + "");
                if (dB.getDBType().compareTo("oracle") == 0) {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.excl ");
                } else {
                    stringBuffer.append(") + p.thread as thread, p.metric as metric, p.exclusive ");
                }
                stringBuffer.append("from interval_event e ");
                stringBuffer.append("left outer join interval_location_profile p ");
                stringBuffer.append("on e.id = p.interval_event where e.trial = ? ");
            }
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                stringBuffer.append(" and p.metric = ? ");
            }
            stringBuffer.append(" and e.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append(" order by 3,1,2 ");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.modelData.getTrial().getID());
            if (this.modelData.getCurrentSelection() instanceof Metric) {
                preparedStatement.setInt(2, ((Metric)this.modelData.getCurrentSelection()).getID());
            }
            resultSet = preparedStatement.executeQuery();
            int n6 = n5 = this.modelData.getCurrentSelection() instanceof Metric ? 1 : 3;
            while (resultSet.next()) {
                if (n != resultSet.getInt(n5)) {
                    ++n2;
                }
                n = resultSet.getInt(n5);
                n4 = resultSet.getInt(2);
                this.rawData.addValue(n4, n2, resultSet.getDouble(4));
                if (this.maximum < resultSet.getDouble(4)) {
                    this.maximum = resultSet.getDouble(4);
                }
                ++n3;
            }
            resultSet.close();
            preparedStatement.close();
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
        }
        catch (SQLException sQLException) {
            String string = "ERROR: Couldn't the raw data from the database!";
            System.out.println(string);
            sQLException.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
            throw new PerfExplorerException(string, sQLException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            arrayIndexOutOfBoundsException.printStackTrace();
            System.out.println("\ncurrentFunction: " + n);
            System.out.println("functionIndex: " + n2);
            System.out.println("rowIndex: " + n3);
            System.out.println("threadIndex: " + n4);
            PerfExplorerServer.getServer().getControl().SIGNAL("getRawData");
            System.exit(1);
        }
        System.out.println(" Done!");
    }

    public DendrogramTree createDendrogramTree(int[] nArray, double[] dArray) {
        DendrogramTree dendrogramTree = null;
        DendrogramTree dendrogramTree2 = null;
        DendrogramTree dendrogramTree3 = null;
        Hashtable<Integer, DendrogramTree> hashtable = new Hashtable<Integer, DendrogramTree>(nArray.length);
        int n = 0;
        for (int i = 0; i < dArray.length; ++i) {
            dendrogramTree = nArray[n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            dendrogramTree2 = nArray[++n] < 0 ? new DendrogramTree(nArray[n], 0.0) : (DendrogramTree)hashtable.get(new Integer(nArray[n]));
            ++n;
            dendrogramTree3 = new DendrogramTree(i + 1, dArray[i]);
            dendrogramTree3.setLeftAndRight(dendrogramTree, dendrogramTree2);
            hashtable.put(new Integer(i + 1), dendrogramTree3);
        }
        return dendrogramTree3;
    }

    public RawDataInterface doDimensionReduction() {
        return this.rawData;
    }

    public void run() {
        this.modelData = this.server.getNextRequest();
        if (this.modelData != null) {
            this.analysisID = this.modelData.getAnalysisID();
            try {
                System.out.println("Processing " + this.modelData.toString());
                this.getConstants();
                this.getRawData();
                RawDataInterface rawDataInterface = this.doDimensionReduction();
                if (this.modelData.getClusterMethod().equals("K Means")) {
                    int n = this.numTotalThreads <= this.modelData.getNumberOfClusters() ? this.numTotalThreads - 1 : this.modelData.getNumberOfClusters();
                    for (int i = 2; i <= n; ++i) {
                        System.out.println("Doing " + i + " clusters...");
                        KMeansClusterInterface kMeansClusterInterface = this.factory.CreateKMeansEngine();
                        kMeansClusterInterface.setInputData(rawDataInterface);
                        kMeansClusterInterface.setK(i);
                        kMeansClusterInterface.findClusters();
                        RawDataInterface rawDataInterface2 = kMeansClusterInterface.getClusterCentroids();
                        RawDataInterface rawDataInterface3 = kMeansClusterInterface.getClusterStandardDeviations();
                        int[] nArray = kMeansClusterInterface.getClusterSizes();
                        File file = this.generateThumbnail(nArray, this.eventIDs);
                        File file2 = this.generateImage(nArray, this.eventIDs);
                        this.chartType = 1;
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        PrincipalComponentsAnalysisInterface principalComponentsAnalysisInterface = this.factory.CreatePCAEngine();
                        principalComponentsAnalysisInterface.setInputData(rawDataInterface);
                        principalComponentsAnalysisInterface.setK(1);
                        principalComponentsAnalysisInterface.doPCA();
                        RawDataInterface rawDataInterface4 = principalComponentsAnalysisInterface.getResults();
                        this.chartType = 6;
                        file = this.generateThumbnail(rawDataInterface4, rawDataInterface, kMeansClusterInterface);
                        file2 = this.generateImage(rawDataInterface4, rawDataInterface, kMeansClusterInterface);
                        this.chartType = 6;
                        this.saveAnalysisResult(rawDataInterface4, rawDataInterface4, file, file2);
                        VirtualTopology virtualTopology = new VirtualTopology(this.modelData, kMeansClusterInterface);
                        String string = virtualTopology.getImage();
                        String string2 = virtualTopology.getThumbnail();
                        this.saveAnalysisResult("Virtual Topology", string, string2, false);
                        file = this.generateThumbnail(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        file2 = this.generateImage(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        this.chartType = 3;
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        file = this.generateThumbnail(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        file2 = this.generateImage(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        this.chartType = 4;
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                        file = this.generateThumbnail(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        file2 = this.generateImage(rawDataInterface2, rawDataInterface3, this.eventIDs);
                        this.chartType = 5;
                        this.saveAnalysisResult(rawDataInterface2, rawDataInterface3, file, file2);
                    }
                } else {
                    System.out.println("Doing PCA...");
                    PrincipalComponentsAnalysisInterface principalComponentsAnalysisInterface = this.factory.CreatePCAEngine();
                    principalComponentsAnalysisInterface.setInputData(rawDataInterface);
                    principalComponentsAnalysisInterface.setK(1);
                    principalComponentsAnalysisInterface.doPCA();
                    RawDataInterface rawDataInterface5 = principalComponentsAnalysisInterface.getResults();
                    this.chartType = 7;
                    System.out.println(rawDataInterface5.numDimensions());
                    for (int i = 0; i < rawDataInterface5.numDimensions(); ++i) {
                        for (int j = 0; j < rawDataInterface5.numDimensions(); ++j) {
                            File file = this.generateThumbnail(rawDataInterface5, i, j);
                            File file3 = this.generateImage(rawDataInterface5, i, j);
                            this.saveAnalysisResult(rawDataInterface5, rawDataInterface5, file, file3);
                        }
                        System.out.println("Finished: " + (i + 1) + " of " + rawDataInterface5.numDimensions());
                    }
                }
            }
            catch (PerfExplorerException perfExplorerException) {
            }
            catch (ClusterException clusterException) {
                // empty catch block
            }
            this.server.taskFinished();
            this.modelData = null;
        }
    }

    public File generateThumbnail(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)((String)list.get(j))), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        File file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public File generateThumbnail(int[] nArray, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart(null, null, null, (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)true, (boolean)false);
        File file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public File generateThumbnail(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, KMeansClusterInterface kMeansClusterInterface) {
        File file = null;
        if (this.chartType == 6) {
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterface, rawDataInterface2, kMeansClusterInterface);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateImage(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, KMeansClusterInterface kMeansClusterInterface) {
        File file = null;
        if (this.chartType == 6) {
            int n = rawDataInterface.numDimensions();
            int n2 = n - 1;
            int n3 = n - 2;
            if (n < 2) {
                n2 = 0;
                n3 = 0;
            }
            PCAPlotDataset pCAPlotDataset = new PCAPlotDataset(rawDataInterface, rawDataInterface2, kMeansClusterInterface);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)"PCA Results", (String)((String)rawDataInterface.getEventNames().get(n2)), (String)((String)rawDataInterface.getEventNames().get(n3)), (XYDataset)pCAPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)800, (int)800);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateThumbnail(RawDataInterface rawDataInterface, int n, int n2) {
        File file = null;
        if (this.chartType == 7) {
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface, this.modelData.toString(), n, n2);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot(null, null, null, (XYDataset)scatterPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
            file = new File("/tmp/thumbnail." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)100, (int)100);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateImage(RawDataInterface rawDataInterface, int n, int n2) {
        File file = null;
        if (this.chartType == 7) {
            ScatterPlotDataset scatterPlotDataset = new ScatterPlotDataset(rawDataInterface, this.modelData.toString(), n, n2);
            JFreeChart jFreeChart = ChartFactory.createScatterPlot((String)"PCA Results", (String)((String)rawDataInterface.getEventNames().get(n)), (String)((String)rawDataInterface.getEventNames().get(n2)), (XYDataset)scatterPlotDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
            try {
                ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)800, (int)800);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    public File generateImage(int[] nArray, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < nArray.length; ++i) {
            defaultCategoryDataset.addValue((double)nArray[i], (Comparable)((Object)"Threads in cluster"), (Comparable)((Object)new String(Integer.toString(i))));
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)this.modelData.toString(), (String)"Cluster Number", (String)"Threads in cluster", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        File file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public File generateImage(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, List list) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < rawDataInterface.numVectors(); ++i) {
            for (int j = 0; j < rawDataInterface.numDimensions(); ++j) {
                defaultCategoryDataset.addValue(rawDataInterface.getValue(i, j), (Comparable)((Object)((String)list.get(j))), (Comparable)((Object)new String(Integer.toString(i))));
            }
        }
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart((String)this.modelData.toString(), (String)"Cluster Number", (String)"Total Runtime", (CategoryDataset)defaultCategoryDataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)true, (boolean)false);
        File file = new File("/tmp/image." + this.modelData.toShortString() + ".png");
        try {
            ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)500, (int)500);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }
}

