/*
 * Decompiled with CFR 0.152.
 */
package server;

import common.RMIChartData;
import common.RMIPerfExplorerModel;
import common.RMIView;
import edu.uoregon.tau.dms.database.DB;
import edu.uoregon.tau.dms.dss.Experiment;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import server.PerfExplorerServer;

public class ChartData
extends RMIChartData {
    private RMIPerfExplorerModel model;
    private String metricName = null;
    private String groupName = null;
    private String eventName = null;
    private String groupByColumn = null;

    public ChartData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        super(n);
        this.model = rMIPerfExplorerModel;
        this.metricName = rMIPerfExplorerModel.getMetricName();
        this.groupName = rMIPerfExplorerModel.getGroupName();
        this.eventName = rMIPerfExplorerModel.getEventName();
    }

    public static ChartData getChartData(RMIPerfExplorerModel rMIPerfExplorerModel, int n) {
        System.out.println("getChartData(" + rMIPerfExplorerModel.toString() + ")...");
        ChartData chartData = new ChartData(rMIPerfExplorerModel, n);
        chartData.doQuery();
        return chartData;
    }

    private void doQuery() {
        PerfExplorerServer.getServer().getControl().WAIT("doQuery");
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.buildStatement();
            ResultSet resultSet = preparedStatement.executeQuery();
            String string = null;
            String string2 = null;
            double d = 0.0;
            double d2 = 0.0;
            String string3 = "";
            int n = -1;
            while (resultSet.next()) {
                string = resultSet.getString(1);
                string2 = resultSet.getString(2);
                d2 = resultSet.getDouble(2);
                d = resultSet.getDouble(3);
                if (!string3.equals(string)) {
                    ++n;
                    string3 = string;
                    this.addRow(string);
                }
                this.addColumn(n, d2, d);
            }
            resultSet.close();
            preparedStatement.close();
            preparedStatement = this.buildOtherStatement();
            if (preparedStatement != null) {
                resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    string = "other";
                    string2 = resultSet.getString(1);
                    d2 = resultSet.getDouble(1);
                    d = resultSet.getDouble(2);
                    if (!string3.equals(string)) {
                        ++n;
                        string3 = string;
                        this.addRow(string);
                    }
                    this.addColumn(n, d2, d);
                }
                resultSet.close();
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            System.out.println(preparedStatement.toString());
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.out.println(string);
            exception.printStackTrace();
            PerfExplorerServer.getServer().getControl().SIGNAL("doQuery");
        }
        PerfExplorerServer.getServer().getControl().SIGNAL("doQuery");
    }

    private PreparedStatement buildStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 0) {
            stringBuffer.append("select ie.name, ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.exclusive_percentage from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie ");
            stringBuffer.append("on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ims.exclusive_percentage > 1.0 ");
            stringBuffer.append("and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 1) {
            List list = this.model.getMultiSelection();
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.inclusive from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("inner join experiment e on t.experiment = e.id ");
                stringBuffer.append("where t.experiment in (");
                if (list == null) {
                    stringBuffer.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                }
                stringBuffer.append(")");
            }
            stringBuffer.append(" and m.name = ? and ims.inclusive_percentage = 100.0 ");
            stringBuffer.append(" and ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append(" order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 3) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("sum(ims.excl) from interval_mean_summary ims ");
            } else {
                stringBuffer.append("sum(ims.exclusive) from interval_mean_summary ims ");
            }
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.trial = t.id ");
            stringBuffer.append("inner join experiment e on t.experiment = e.id ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, false));
            } else {
                stringBuffer.append("where t.experiment in (");
                List list = this.model.getMultiSelection();
                if (list == null) {
                    stringBuffer.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                }
                stringBuffer.append(") ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append(" and ie.group_name = ? group by ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * ");
            stringBuffer.append("t.threads_per_context), ie.group_name order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
            preparedStatement.setString(2, this.groupName);
        } else if (this.dataType == 4) {
            stringBuffer.append("select ");
            stringBuffer.append(" ie.name, ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("ims.excl from interval_mean_summary ims ");
            } else {
                stringBuffer.append("ims.exclusive from interval_mean_summary ims ");
            }
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ims.exclusive_percentage > 1.0 ");
            stringBuffer.append("and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 5) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" e.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("inclusive from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("inner join experiment e on t.experiment = e.id ");
                stringBuffer.append("where t.experiment in (");
                List list = this.model.getMultiSelection();
                if (list == null) {
                    stringBuffer.append(this.model.getExperiment().getID());
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        Experiment experiment = (Experiment)list.get(i);
                        if (i > 0) {
                            stringBuffer.append(",");
                        }
                        stringBuffer.append(experiment.getID());
                    }
                }
                stringBuffer.append(") ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ie.name = ? order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
            preparedStatement.setString(2, this.eventName);
        } else if (this.dataType == 6) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" ie.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.inclusive from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.trial = t.id ");
            stringBuffer.append("where t.experiment = ? and m.name = ? ");
            stringBuffer.append("and ie.group_name like '%TAU_PHASE%' order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setInt(1, this.model.getExperiment().getID());
            preparedStatement.setString(2, this.metricName);
        } else if (this.dataType == 7) {
            stringBuffer.append("select ");
            if (object instanceof RMIView) {
                if (this.isLeafView()) {
                    stringBuffer.append(" " + this.model.getViewSelectionString() + ", ");
                } else {
                    stringBuffer.append(" " + this.groupByColumn + ", ");
                }
            } else {
                stringBuffer.append(" ie.name, ");
            }
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("ims.inclusive_percentage from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.trial = t.id ");
            preparedStatement = null;
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ie.group_name like '%TAU_PHASE%' order by 1, 2");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        }
        return preparedStatement;
    }

    private PreparedStatement buildOtherStatement() throws SQLException {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        StringBuffer stringBuffer = new StringBuffer();
        Object object = this.model.getCurrentSelection();
        if (this.dataType == 0) {
            stringBuffer.append("select ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            stringBuffer.append("sum(ims.exclusive_percentage) from interval_mean_summary ims ");
            stringBuffer.append("inner join interval_event ie ");
            stringBuffer.append("on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ims.inclusive_percentage < 100.0 ");
            stringBuffer.append("and ims.exclusive_percentage < 1.0 ");
            stringBuffer.append("and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) group by (t.node_count * t.contexts_per_node * t.threads_per_context) order by 1");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        } else if (this.dataType == 4) {
            stringBuffer.append("select ");
            stringBuffer.append("(t.node_count * t.contexts_per_node * t.threads_per_context), ");
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append("sum(ims.excl) from interval_mean_summary ims ");
            } else {
                stringBuffer.append("sum(ims.exclusive) from interval_mean_summary ims ");
            }
            stringBuffer.append("inner join interval_event ie on ims.interval_event = ie.id ");
            stringBuffer.append("inner join trial t on ie.trial = t.id ");
            stringBuffer.append("inner join metric m on m.id = ims.metric ");
            if (object instanceof RMIView) {
                stringBuffer.append(this.model.getViewSelectionPath(true, true));
            } else {
                stringBuffer.append("where t.experiment = ");
                stringBuffer.append(this.model.getExperiment().getID() + " ");
            }
            stringBuffer.append(" and m.name = ? ");
            stringBuffer.append("and ims.exclusive_percentage < 1.0 ");
            stringBuffer.append("and (ie.group_name is null or (");
            stringBuffer.append("ie.group_name not like '%TAU_CALLPATH%' ");
            stringBuffer.append("and ie.group_name not like '%TAU_PHASE%')) group by (t.node_count * t.contexts_per_node * t.threads_per_context) order by 1");
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            preparedStatement.setString(1, this.metricName);
        }
        return preparedStatement;
    }

    private boolean isLeafView() {
        DB dB = PerfExplorerServer.getServer().getDB();
        PreparedStatement preparedStatement = null;
        boolean bl = true;
        try {
            preparedStatement = dB.prepareStatement("select table_name, column_name from trial_view where parent = ?");
            preparedStatement.setString(1, this.model.getViewID());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                this.groupByColumn = string.equalsIgnoreCase("Application") ? new String("a.") : (string.equalsIgnoreCase("Experiment") ? new String("e.") : new String("t."));
                this.groupByColumn = this.groupByColumn + resultSet.getString(2);
                bl = false;
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            String string = "ERROR: Couldn't select the analysis settings from the database!";
            System.out.println(string);
            exception.printStackTrace();
        }
        return bl;
    }
}

