/*
 * Decompiled with CFR 0.152.
 */
package server;

import clustering.KMeansClusterInterface;
import clustering.RawDataInterface;
import org.jfree.data.xy.AbstractXYDataset;
import weka.core.Instances;

public class PCAPlotDataset
extends AbstractXYDataset {
    private RawDataInterface pcaData = null;
    private RawDataInterface rawData = null;
    private KMeansClusterInterface clusterer = null;
    private Instances[] clusters = null;
    private int x = 0;
    private int y = 1;
    private int k = 0;

    public PCAPlotDataset(RawDataInterface rawDataInterface, RawDataInterface rawDataInterface2, KMeansClusterInterface kMeansClusterInterface) {
        int n;
        this.pcaData = rawDataInterface2;
        this.clusterer = kMeansClusterInterface;
        this.k = kMeansClusterInterface.getK();
        this.clusters = new Instances[this.k];
        Instances instances = (Instances)rawDataInterface2.getData();
        Instances instances2 = (Instances)rawDataInterface.getData();
        if (instances2.numAttributes() > 1) {
            this.x = instances2.numAttributes() - 1;
            this.y = instances2.numAttributes() - 2;
        } else {
            this.y = 0;
        }
        for (n = 0; n < this.k; ++n) {
            this.clusters[n] = new Instances(instances2, 0);
        }
        for (n = 0; n < rawDataInterface2.numVectors(); ++n) {
            int n2 = kMeansClusterInterface.clusterInstance(n);
            this.clusters[n2].add(instances2.instance(n));
        }
    }

    public int getSeriesCount() {
        return this.k;
    }

    public String getSeriesName(int n) {
        return new String("Cluster " + n);
    }

    public int getItemCount(int n) {
        return this.clusters[n].numInstances();
    }

    public Number getX(int n, int n2) {
        return new Double(this.clusters[n].instance(n2).value(this.x));
    }

    public Number getY(int n, int n2) {
        return new Double(this.clusters[n].instance(n2).value(this.y));
    }
}

