/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.AbstractCellEditor;
import edu.uoregon.tau.paraprof.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.paraprof.treetable.SortHeaderRenderer;
import edu.uoregon.tau.paraprof.treetable.SortTableModel;
import edu.uoregon.tau.paraprof.treetable.TreeTableModelAdapter;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable
implements MouseListener {
    protected TreeTableCellRenderer tree;
    private int sortedColumnIndex = 0;
    private boolean sortedColumnAscending;
    static /* synthetic */ Class class$edu$uoregon$tau$paraprof$treetable$TreeTableModel;

    public JTreeTable(AbstractTreeTableModel abstractTreeTableModel, boolean bl) {
        this.tree = new TreeTableCellRenderer(abstractTreeTableModel);
        this.tree.setShowsRootHandles(bl);
        this.tree.setRootVisible(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                try {
                    int n = JTreeTable.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                    TreePath treePath = JTreeTable.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        TreeTableNode treeTableNode = (TreeTableNode)treePath.getLastPathComponent();
                        if (ParaProfUtils.rightClick(mouseEvent)) {
                            ParaProfUtils.createFunctionClickPopUp(treeTableNode.getModel().getPPTrial(), treeTableNode.getFunctionProfile().getFunction(), JTreeTable.this).show(JTreeTable.this, mouseEvent.getX(), mouseEvent.getY());
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.getTableHeader().setDefaultRenderer(new SortHeaderRenderer());
        this.getTableHeader().addMouseListener(this);
        super.setModel(new TreeTableModelAdapter(abstractTreeTableModel, this));
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(class$edu$uoregon$tau$paraprof$treetable$TreeTableModel == null ? (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel = JTreeTable.class$("edu.uoregon.tau.paraprof.treetable.TreeTableModel")) : class$edu$uoregon$tau$paraprof$treetable$TreeTableModel, this.tree);
        this.setDefaultEditor(class$edu$uoregon$tau$paraprof$treetable$TreeTableModel == null ? (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel = JTreeTable.class$("edu.uoregon.tau.paraprof.treetable.TreeTableModel")) : class$edu$uoregon$tau$paraprof$treetable$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        this.setRowHeight(18);
    }

    public void forceRedraw() {
        SortTableModel sortTableModel = (SortTableModel)this.getModel();
        sortTableModel.updateTreeTable();
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel == null ? (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel = JTreeTable.class$("edu.uoregon.tau.paraprof.treetable.TreeTableModel")) : class$edu$uoregon$tau$paraprof$treetable$TreeTableModel) ? -1 : this.editingRow;
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
        int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX() - 3);
        int n3 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX() + 3);
        if (n != n2 || n != n3) {
            return;
        }
        int n4 = tableColumnModel.getColumn(n).getModelIndex();
        SortTableModel sortTableModel = (SortTableModel)this.getModel();
        if (sortTableModel.isSortable(n4)) {
            if (this.sortedColumnIndex == n4) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = n4;
            sortTableModel.sortColumn(n4, this.sortedColumnAscending);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        if (n % 2 == 0) {
            component.setBackground(new Color(235, 235, 235));
        } else {
            component.setBackground(this.getBackground());
        }
        return component;
    }

    public boolean getSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                    Object var2_1 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        int n3 = n;
                        while (n3 <= n2) {
                            TreePath treePath;
                            if (this.listSelectionModel.isSelectedIndex(n3) && (treePath = JTreeTable.this.tree.getPathForRow(n3)) != null) {
                                this.addSelectionPath(treePath);
                            }
                            ++n3;
                        }
                    }
                    Object var6_5 = null;
                    this.updatingListSelectionModel = false;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.updatingListSelectionModel = false;
                    throw throwable;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static /* synthetic */ Class class$edu$uoregon$tau$paraprof$treetable$TreeTableModel;

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                int n = JTreeTable.this.getColumnCount() - 1;
                while (n >= 0) {
                    if (JTreeTable.this.getColumnClass(n) == (class$edu$uoregon$tau$paraprof$treetable$TreeTableModel == null ? TreeTableCellEditor.class$("edu.uoregon.tau.paraprof.treetable.TreeTableModel") : class$edu$uoregon$tau$paraprof$treetable$TreeTableModel)) {
                        MouseEvent mouseEvent = (MouseEvent)eventObject;
                        MouseEvent mouseEvent2 = new MouseEvent(JTreeTable.this.tree, 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        mouseEvent2 = new MouseEvent(JTreeTable.this.tree, 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - JTreeTable.this.getCellRect((int)0, (int)n, (boolean)true).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(mouseEvent2);
                        break;
                    }
                    --n;
                }
            }
            return false;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void paint(Graphics graphics) {
            graphics.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(graphics);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.visibleRow = n;
            return this;
        }
    }

    static class ParaProfCellRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatter;

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return component;
        }

        public void setValue(Object object) {
            if (object instanceof Double) {
                this.setHorizontalAlignment(4);
                if (this.formatter == null) {
                    this.formatter = NumberFormat.getInstance();
                }
                this.setText(object == null ? "" : this.formatter.format(object));
            } else {
                this.setHorizontalAlignment(2);
                this.setText(object.toString());
            }
        }
    }
}

