/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.vis;

import edu.uoregon.tau.vis.Shape;
import edu.uoregon.tau.vis.VisRenderer;
import edu.uoregon.tau.vis.VisTools;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Observable;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLDrawable;
import net.java.games.jogl.util.GLUT;

public class ColorScale
extends Observable
implements Shape {
    private Color textColor = Color.white;
    private int font = 1;
    private GLUT glut = new GLUT();
    private boolean dirty = true;
    private boolean enabled = true;
    private ColorSet colorSet = ColorSet.RAINBOW;
    private String lowString;
    private String highString;
    private String label;
    private double fontScale = 0.1;
    private int displayList;

    public void setStrings(String string, String string2, String string3) {
        this.lowString = string;
        this.highString = string2;
        this.label = string3;
    }

    public Color getColor(float f) {
        float f2 = f;
        int n = 0;
        int n2 = this.colorSet.colorsR.length - 1;
        n = 0;
        f = f2 * (float)n2;
        for (float f3 = 1.0f / (float)n2; f2 > f3; f3 += 1.0f / (float)n2) {
            ++n;
            f = (f2 - f3) * (float)n2;
        }
        double d = this.colorSet.colorsR[n] + (double)f * (this.colorSet.colorsR[n + 1] - this.colorSet.colorsR[n]);
        double d2 = this.colorSet.colorsG[n] + (double)f * (this.colorSet.colorsG[n + 1] - this.colorSet.colorsG[n]);
        double d3 = this.colorSet.colorsB[n] + (double)f * (this.colorSet.colorsB[n + 1] - this.colorSet.colorsB[n]);
        d = Math.min(d, 1.0);
        d2 = Math.min(d2, 1.0);
        d3 = Math.min(d3, 1.0);
        d = Math.max(d, 0.0);
        d2 = Math.max(d2, 0.0);
        d3 = Math.max(d3, 0.0);
        return new Color((float)d, (float)d2, (float)d3);
    }

    public JPanel getControlPanel(final VisRenderer visRenderer) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 0.2;
        JCheckBox jCheckBox = new JCheckBox("Show ColorScale", true);
        VisTools.addCompItem(jPanel, jCheckBox, gridBagConstraints, 0, 0, 1, 1);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorScale.this.enabled = ((JCheckBox)actionEvent.getSource()).isSelected();
                ColorScale.this.dirty = true;
                visRenderer.redraw();
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        final HashMap<JRadioButton, ColorSet> hashMap = new HashMap<JRadioButton, ColorSet>();
        int n = 0;
        int n2 = 1;
        for (int i = 0; i < ColorSet.VALUES.length; ++i) {
            ColorSet colorSet = ColorSet.VALUES[i];
            JRadioButton jRadioButton = new JRadioButton(colorSet.toString(), this.colorSet == colorSet);
            buttonGroup.add(jRadioButton);
            hashMap.put(jRadioButton, colorSet);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColorScale.this.colorSet = (ColorSet)hashMap.get(actionEvent.getSource());
                    ColorScale.this.dirty = true;
                    ColorScale.this.setChanged();
                    ColorScale.this.notifyObservers();
                    visRenderer.redraw();
                }
            });
            VisTools.addCompItem(jPanel, jRadioButton, gridBagConstraints, n, n2, 1, 1);
            if (n == 0) {
                ++n;
                continue;
            }
            n = 0;
            ++n2;
        }
        return jPanel;
    }

    private void drawText(GL gL, double d, double d2, String string) {
        if (string == null) {
            return;
        }
        gL.glPushMatrix();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            double d3 = d;
            gL.glPushMatrix();
            String string2 = stringTokenizer.nextToken();
            float f = this.glut.glutStrokeLength(this.font, string2);
            double d4 = 0.1;
            d3 -= (double)f * d4 / 2.0;
            d3 = Math.max(d3, -20.0);
            gL.glTranslated(d3, d2, 0.0);
            gL.glScaled(d4, d4, d4);
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                this.glut.glutStrokeCharacter(gL, this.font, c);
            }
            gL.glTranslatef(-f / 2.0f, 0.0f, 0.0f);
            gL.glTranslated(0.0, -250.0, 0.0);
            gL.glPopMatrix();
            gL.glTranslated(0.0, -25.0, 0.0);
        }
        gL.glPopMatrix();
    }

    public void render(VisRenderer visRenderer) {
        GLDrawable gLDrawable = visRenderer.getGLDrawable();
        if (!this.enabled) {
            return;
        }
        this.dirty = true;
        GL gL = gLDrawable.getGL();
        if (this.dirty || this.displayList == 0) {
            this.displayList = gL.glGenLists(1);
            gL.glNewList(this.displayList, 4864);
            this.privateRender(visRenderer);
            gL.glEndList();
            this.dirty = false;
        }
        gL.glCallList(this.displayList);
    }

    private void privateRender(VisRenderer visRenderer) {
        GLDrawable gLDrawable = visRenderer.getGLDrawable();
        GL gL = gLDrawable.getGL();
        if (!this.enabled) {
            return;
        }
        int n = (int)gLDrawable.getSize().getWidth();
        int n2 = (int)gLDrawable.getSize().getHeight();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glOrtho(0.0, (double)n, 0.0, (double)n2, -1.0, 1.0);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glDisable(2896);
        gL.glDisable(2929);
        gL.glDisable(2848);
        gL.glDisable(3042);
        gL.glLineWidth(1.0f);
        int n3 = Math.min(300, n2 - 60);
        int n4 = 25;
        gL.glTranslated(25.0, (double)(n2 / 2 - n3 / 2), 0.0);
        gL.glShadeModel(7425);
        gL.glFrontFace(2304);
        gL.glBegin(7);
        int n5 = 10;
        float f = (float)n3 / 10.0f;
        for (float f2 = 0.0f; f2 < (float)n5; f2 += 1.0f) {
            float f3 = f2 / (float)n5;
            Color color = this.getColor(f3);
            float f4 = (f2 + 1.0f) / (float)n5;
            Color color2 = this.getColor(f4);
            VisTools.glSetColor(gL, color);
            gL.glVertex3f((float)n4, f2 * f, 0.0f);
            gL.glVertex3f(0.0f, f2 * f, 0.0f);
            VisTools.glSetColor(gL, color2);
            gL.glVertex3f(0.0f, (f2 + 1.0f) * f, 0.0f);
            gL.glVertex3f((float)n4, (f2 + 1.0f) * f, 0.0f);
        }
        gL.glEnd();
        if (visRenderer.getReverseVideo()) {
            VisTools.glSetColor(gL, VisTools.invert(this.textColor));
        } else {
            VisTools.glSetColor(gL, this.textColor);
        }
        this.drawText(gL, n4 / 2, n3 + 10, this.highString);
        this.drawText(gL, n4 / 2, -15.0, this.lowString);
        gL.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        this.drawText(gL, n3 / 2, -n4 - 15, this.label);
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        gL.glEnable(2896);
        gL.glEnable(2929);
    }

    public static class ColorSet {
        private final String name;
        public final double[] colorsR;
        public final double[] colorsG;
        public final double[] colorsB;
        public static final ColorSet RAINBOW = new ColorSet("Rainbow", new double[]{0.0, 0.0, 0.0, 1.0, 1.0}, new double[]{0.0, 1.0, 1.0, 1.0, 0.0}, new double[]{1.0, 1.0, 0.0, 0.0, 0.0});
        public static final ColorSet GRAYSCALE = new ColorSet("Grayscale", new double[]{0.0, 1.0}, new double[]{0.0, 1.0}, new double[]{0.0, 1.0});
        public static final ColorSet BLUE_RED = new ColorSet("Blue-Red", new double[]{0.0, 1.0}, new double[]{0.0, 0.0}, new double[]{1.0, 0.0});
        public static final ColorSet BLUE_WHITE_RED = new ColorSet("Blue-White-Red", new double[]{0.0, 1.0, 1.0}, new double[]{0.0, 1.0, 0.0}, new double[]{1.0, 1.0, 0.0});
        public static ColorSet[] VALUES = new ColorSet[]{RAINBOW, GRAYSCALE, BLUE_RED, BLUE_WHITE_RED};

        private ColorSet(String string, double[] dArray, double[] dArray2, double[] dArray3) {
            this.name = string;
            this.colorsR = dArray;
            this.colorsG = dArray2;
            this.colorsB = dArray3;
        }

        public String toString() {
            return this.name;
        }
    }
}

