package edu.uoregon.tau.taujava.popup.actions;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.nio.channels.*;
import java.io.*;


import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
//import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
//import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.action.IAction;
//import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
//import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import edu.uoregon.tau.taujava.TaujavaPlugin;

public class RunTauJava implements IObjectActionDelegate {
	/**
	 * Constructor for Action1.
	 */
	public RunTauJava() {
		super();
	}
	IStructuredSelection selection;
	/**
	 * @see IObjectActionDelegate#setActivePart(IAction, IWorkbenchPart)
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	}

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction action) {
		//If the selected file is invalid, stop
		if (selection == null)
			return;
		
		//Otherwise produce the associated compilation unit and send it to launcher
		ICompilationUnit jfile;
		IJavaElement element = (IJavaElement) selection.getFirstElement();
		if (element.getElementType() == IJavaElement.COMPILATION_UNIT) {
			jfile = (ICompilationUnit) element;
		}
		else return;
		try {
			launcher(jfile);
		} catch (JavaModelException e) {
			e.printStackTrace();
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void launcher(ICompilationUnit jfile) throws CoreException{
		//Make sure the compilation unit is valid and get its core Type (type = class)
		IType jtype = jfile.findPrimaryType();
		if(jtype==null)return;
		//Get a list of the methods enclosed in this type.
		IMethod[] seeker = jtype.getMethods();
		String main = null;

		//Seek the main method and get the package name of the file
		for(int i = 0; i<seeker.length;i++)
		{
			if(seeker[i].isMainMethod()){
				IPackageDeclaration[] pdecs = jfile.getPackageDeclarations();
				main=jtype.getElementName();
				String pacname = ".";
				//If there is a package name add it to the main name for the whole ID
				if(pdecs.length>0)
				{
					pacname = pdecs[0].getElementName()+pacname;
					main=pacname+main;
				}
				
				//+seeker[i].getElementName()
				break;
			}
		}
		//If there is no main method we can't run with this file.
		if(main==null)return;

		//Get the location  of the TAU library directory.  If it is not defined, abort
		IPreferenceStore pstore = TaujavaPlugin.getDefault().getPreferenceStore();
		String lpath = pstore.getString("tauDirPathPreference") ;
		if(lpath==null)lpath="";
		if(lpath.equals(""))return;
		
		//Generate the name of the run-operation (ProjectName(TAU))
		IJavaProject proj = jfile.getJavaProject();
		String cfg = proj.getElementName()+"(TAU)";

		//Generate and setup the launch configuration working copy, wc
		DebugPlugin plugin = DebugPlugin.getDefault();
		ILaunchManager lm = plugin.getLaunchManager();
		ILaunchConfigurationType t = lm.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
		ILaunchConfigurationWorkingCopy wc = t.newInstance(null, cfg);
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME,proj.getElementName());
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME,main);
		
		//This will contain the environment variables needed by the run operation
		Map appMap=new HashMap();
		//Set the XrunTAU:nomethods vm argument for the run op
		wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS,"-XrunTAU:nomethods");
		
		//Is this a windows system?
		boolean iswin = ((System.getProperty("os.name","").toLowerCase()).indexOf("windows")!=-1);
		
		
		IWorkspace workspace=ResourcesPlugin.getWorkspace();
		IWorkspaceRoot root = workspace.getRoot();
		IResource resource = root.findMember(proj.getPath());
		File tauout = resource.getLocation().toFile();
		String taudll;
		//System.out.println(tauout);

		String builddir;
		
		if(!pstore.getBoolean("defaultOutputRoot"))
		{
			builddir = tauout.getPath();
			//System.out.println(dir.toString());
		}
		else
		{
			builddir=pstore.getString("outputRoot");
		}
		
		builddir+=File.separator+"TAU_Output"+File.separator+main+File.separator;
		
		Calendar timer = Calendar.getInstance();
		SimpleDateFormat timestamp = new SimpleDateFormat("yyyy_MMMMM_dd(hh_mm_ssaaa)");
		Date time = timer.getTime();
		String ftime = timestamp.format(time);
		
		int toutput = -1; //(1 = trace, 2 = profile, 3=callpath, 4=trace+profile, 5=trace+callpath)
		
		File pdir=new File(builddir+"fault");
		File tdir=new File(builddir+"fault");
		File predir=new File(builddir+"fault");
		File tredir=new File(builddir+"fault");
		
		if(iswin)
		{
			taudll = pstore.getString("tauWinDLLPreference");
			
			if(taudll.equals("tau-profile.dll"))
			{
				//builddir+="profile"+File.separator;
				pdir = new File(builddir+"profile"+File.separator+ftime);
				pdir.mkdirs();
				appMap.put("PROFILEDIR",pdir.getPath());
				predir = new File(pdir.getPath()+File.separator+"Re-Run");
				predir.mkdirs();
				toutput = 2;
			}
			else
				if(taudll.equals("tau-callpath.dll"))
				{
					//builddir+="callpath"+File.separator;
					pdir = new File(builddir+"callpath"+File.separator+ftime);
					pdir.mkdirs();
					appMap.put("PROFILEDIR",pdir.getPath());
					predir = new File(pdir.getPath()+File.separator+"Re-Run");
					predir.mkdirs();
					toutput = 3;
				}
				else
					if(taudll.equals("tau-trace.dll"))
					{
						//builddir+="trace"+File.separator;
						tdir = new File(builddir+"trace"+File.separator+ftime);
						tdir.mkdirs();
						appMap.put("TRACEDIR",tdir.getPath());
						tredir = new File(tdir.getPath()+File.separator+"Re-Run");
						tredir.mkdirs();
						toutput=1;
					}
			lpath=lpath.substring(0,lpath.lastIndexOf("lib"))+"JavaDLL";
			
			try {
				
				File source = new File(lpath+"\\"+taudll);
				File dest = new File(lpath+"\\TAU.dll");
				
				
				 FileChannel c1= new RandomAccessFile(source, "r").getChannel();
				 FileChannel c2= new RandomAccessFile(dest, "rw").getChannel();

				 long tCount= 0, size= c1.size();
				 while((tCount += c2.transferFrom(c1, 0, size-tCount))<size);
				 c2.close();

			} catch (FileNotFoundException e) {
				
				e.printStackTrace();
			} catch (IOException e) {
				
				e.printStackTrace();
			} catch (Exception e) {
				
				e.printStackTrace();
			}

			appMap.put("PATH",lpath);
		}
		else{
		//wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS,"-XrunTAU:nomethods -Djava.library.path="+lpath);///home/wspear/tau2/i386_linux/lib");
		appMap.put("LD_LIBRARY_PATH",lpath);
		
		pdir=tdir=new File(builddir+ftime);
		predir=tredir=new File(pdir.getPath()+File.separator+"Re-Run");
		pdir.mkdirs();
		predir.mkdirs();
		appMap.put("TRACEDIR",tdir.getPath());
		appMap.put("PROFILEDIR",pdir.getPath());
		toutput=4;
		}
		
		wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES,appMap);
		ILaunchConfiguration config = wc.doSave();   
		//System.out.println(lm.getEnvironment(config));
		//ILaunch taurun = 
			ILaunch x = config.launch(ILaunchManager.RUN_MODE, null);
			
			switch(toutput){
			case 1: appMap.put("TRACEDIR",tredir.getPath()); break;
			case 2: appMap.put("PROFILEDIR",predir.getPath()); break;
			case 3: appMap.put("PROFILEDIR",predir.getPath()); break;
			case 4:
			appMap.put("PROFILEDIR",predir.getPath());
			appMap.put("TRACEDIR",tredir.getPath());
			break;
			case 5:
				appMap.put("PROFILEDIR",predir.getPath());
				appMap.put("TRACEDIR",tredir.getPath());
				break;
			}
			
			wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES,appMap);
			config = wc.doSave();
			
			
			try {
				while(!x.isTerminated())
				{Thread.sleep(1000);}//Thread.sleep(1000);
			} catch (InterruptedException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
			
			boolean para = pstore.getBoolean("runParaProf");
			if(para && toutput > 1)
			{
			if(iswin){
				try {
					String tbpath=lpath.substring(0,lpath.lastIndexOf("JavaDLL"))+"bin";
					
					File taubin = new File(tbpath);
					
					//System.out.println(taubin);
					//String prun = tbpath+File.separator+"paraprof.bat "+pdir.getPath();
					//System.out.println(prun); exec(prun);//"."+File.separator+
					Runtime.getRuntime().exec("cmd /c start paraprof.bat \""+pdir.getPath()+"\"", null, taubin);
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			else
			{
				try {
					String paracmd=lpath.substring(0,lpath.lastIndexOf("lib"))+"bin"+File.separator+"paraprof ";
					
					//File taubin = new File(tbpath);
					
					Runtime.getRuntime().exec(paracmd+pdir.getPath());
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			}
	}

	/**
	 * @see IActionDelegate#selectionChanged(IAction, ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection)
			this.selection = (IStructuredSelection) selection;
		else
			this.selection = null;
	}
}
