/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ParaProfMetric;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.treetable.TreeTableWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

public class ColumnChooser
extends JFrame {
    private ParaProfTrial ppTrial;
    private List metrics = new ArrayList();
    private List statistics = new ArrayList();
    private ParaProfMetric numCalls;
    private ParaProfMetric numSubr;
    private CheckBoxCellRenderer checkBoxCellRenderer = new CheckBoxCellRenderer();
    private JList metricJList;
    private DefaultListModel metricModel;
    private JList valueJList;
    private DefaultListModel valueModel;
    private JList statsJList;
    private DefaultListModel statsModel;
    private TreeTableWindow ttWindow;

    public ColumnChooser(TreeTableWindow treeTableWindow, ParaProfTrial paraProfTrial) {
        int n;
        int n2;
        this.ttWindow = treeTableWindow;
        this.setTitle("Choose Columns");
        this.setSize(500, 400);
        this.ppTrial = paraProfTrial;
        this.numCalls = new ParaProfMetric();
        this.numCalls.setName("Calls");
        this.numSubr = new ParaProfMetric();
        this.numSubr.setName("Child Calls");
        for (n2 = 0; n2 < paraProfTrial.getNumberOfMetrics(); ++n2) {
            ParaProfMetric paraProfMetric = paraProfTrial.getMetric(n2);
            this.metrics.add(paraProfMetric);
        }
        this.valueModel = new DefaultListModel();
        this.valueModel.addElement(new CheckBoxListItem("Absolute Value", true));
        this.valueModel.addElement(new CheckBoxListItem("Percent Value", false));
        this.valueModel.addElement(new CheckBoxListItem("Absolute Value Per Call", false));
        this.statistics.add("Standard Deviation");
        this.statistics.add("Mini Histogram");
        n2 = -1;
        if (this.metrics.size() > 3) {
            n2 = paraProfTrial.getDefaultMetricID();
        }
        this.metricModel = new DefaultListModel();
        for (n = 0; n < this.metrics.size(); ++n) {
            boolean bl = true;
            if (n2 != -1 && n != n2) {
                bl = false;
            }
            this.metricModel.addElement(new CheckBoxListItem((ParaProfMetric)this.metrics.get(n), bl));
        }
        this.metricModel.addElement(new CheckBoxListItem("Calls", true));
        this.metricModel.addElement(new CheckBoxListItem("Child Calls", true));
        this.metricJList = new JList(this.metricModel);
        this.metricJList.setCellRenderer(this.checkBoxCellRenderer);
        this.metricJList.addMouseListener(new MouseController(this.metricJList, this.metricModel));
        this.valueJList = new JList(this.valueModel);
        this.valueJList.setCellRenderer(this.checkBoxCellRenderer);
        this.valueJList.addMouseListener(new MouseController(this.valueJList, this.valueModel));
        this.statsModel = new DefaultListModel();
        for (n = 0; n < this.statistics.size(); ++n) {
            this.statsModel.addElement(new CheckBoxListItem(this.statistics.get(n), true));
        }
        this.statsJList = new JList(this.statsModel);
        this.statsJList.setCellRenderer(this.checkBoxCellRenderer);
        this.statsJList.addMouseListener(new MouseController(this.statsJList, this.statsModel));
        Container container = this.getContentPane();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(this.getContentPane(), (Component)new JLabel("Metrics"), gridBagConstraints, 0, 0, 1, 1);
        ParaProfUtils.addCompItem(this.getContentPane(), (Component)new JLabel("Values"), gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        ParaProfUtils.addCompItem(this.getContentPane(), (Component)new JScrollPane(this.metricJList), gridBagConstraints, 0, 1, 1, 1);
        ParaProfUtils.addCompItem(this.getContentPane(), (Component)new JScrollPane(this.valueJList), gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.weighty = 0.1;
        JButton jButton = new JButton("close");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ColumnChooser.this.ttWindow.updateColumns();
                    ColumnChooser.this.dispose();
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        ParaProfUtils.addCompItem(container, (Component)jPanel, gridBagConstraints, 1, 2, 1, 1);
    }

    private void center(JFrame jFrame) {
        int n = jFrame.getX() + jFrame.getWidth() / 2;
        int n2 = jFrame.getY() + jFrame.getHeight() / 2;
        int n3 = n - this.getWidth() / 2;
        int n4 = n2 - this.getHeight() / 2;
        n3 = Math.max(n3, 0);
        n4 = Math.max(n4, 0);
        this.setLocation(n3, n4);
    }

    public ListModel getMetricModel() {
        return this.metricModel;
    }

    public ListModel getValueModel() {
        return this.valueModel;
    }

    public void showDialog(JFrame jFrame, boolean bl) {
        this.center(jFrame);
        this.show();
    }

    static class CheckBoxCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setBackground(jList.getBackground());
            CheckBoxListItem checkBoxListItem = (CheckBoxListItem)object;
            this.setText(checkBoxListItem.getUserObject().toString());
            this.setSelected(checkBoxListItem.getSelected());
            return this;
        }
    }

    static class MouseController
    implements MouseListener {
        private JList list;
        private ListModel model;

        public MouseController(JList jList, ListModel listModel) {
            this.list = jList;
            this.model = listModel;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.list.locationToIndex(point);
            CheckBoxListItem checkBoxListItem = (CheckBoxListItem)this.model.getElementAt(n);
            if (checkBoxListItem.getSelected()) {
                checkBoxListItem.setSelected(false);
            } else {
                checkBoxListItem.setSelected(true);
            }
            this.list.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    static class CheckBoxListItem {
        private Object userObject;
        private boolean selected;

        public CheckBoxListItem(Object object, boolean bl) {
            this.userObject = object;
            this.selected = bl;
        }

        public boolean getSelected() {
            return this.selected;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public Object getUserObject() {
            return this.userObject;
        }
    }
}

