/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.ParaProf;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.paraprof.ParaProfUtils;
import edu.uoregon.tau.paraprof.WindowPlacer;
import edu.uoregon.tau.paraprof.interfaces.ParaProfWindow;
import edu.uoregon.tau.paraprof.interfaces.UnitListener;
import edu.uoregon.tau.paraprof.treetable.AbstractTreeTableModel;
import edu.uoregon.tau.paraprof.treetable.CallPathModel;
import edu.uoregon.tau.paraprof.treetable.ColumnChooser;
import edu.uoregon.tau.paraprof.treetable.JTreeTable;
import edu.uoregon.tau.paraprof.treetable.TreePortionCellRenderer;
import edu.uoregon.tau.paraprof.treetable.TreeTableColumn;
import edu.uoregon.tau.paraprof.treetable.TreeTableNode;
import edu.uoregon.tau.perfdmf.Thread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class TreeTableWindow
extends JFrame
implements TreeExpansionListener,
Observer,
ParaProfWindow,
Printable,
UnitListener,
ImageExport {
    private CallPathModel model;
    private JTreeTable treeTable;
    private ParaProfTrial ppTrial;
    private JScrollPane scrollPane;
    private Thread thread;
    private int colorMetricID;
    private int units = ParaProf.preferences.getUnits();
    private final JMenuItem showAsTreeMenuItem = new JCheckBoxMenuItem("Show as Call Tree");
    private final JMenuItem reverseTreeMenuItem = new JCheckBoxMenuItem("Reverse Call Tree", false);
    private final JMenuItem showInclExclMenuItem = new JCheckBoxMenuItem("Show Inclusive/Exclusive", true);
    private List columns;
    private ColumnChooser columnChooser;

    public TreeTableWindow(ParaProfTrial paraProfTrial, Thread thread) {
        this(paraProfTrial, thread, null);
    }

    public TreeTableWindow(ParaProfTrial paraProfTrial, Thread thread, Component component) {
        this.ppTrial = paraProfTrial;
        this.thread = thread;
        paraProfTrial.addObserver(this);
        this.columnChooser = new ColumnChooser(this, paraProfTrial);
        this.setSize(ParaProfUtils.checkSize(new Dimension(1000, 600)));
        this.setLocation(WindowPlacer.getNewLocation(this, component));
        if (thread.getNodeID() == -1) {
            this.setTitle("Mean Statistics - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -2) {
            this.setTitle("Total Statistics - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else if (thread.getNodeID() == -3) {
            this.setTitle("Std. Dev. Statistics - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        } else {
            this.setTitle("Thread Statistics: n,c,t, " + thread.getNodeID() + "," + thread.getContextID() + "," + thread.getThreadID() + " - " + paraProfTrial.getTrialIdentifier(ParaProf.preferences.getShowPathTitleInReverse()));
        }
        if (ParaProf.helpWindow.isVisible()) {
            this.help(false);
        }
        this.setupMenus();
        this.setupData();
        ParaProf.incrementNumWindows();
    }

    public void updateColumns() {
        this.setColumns();
        AbstractTableModel abstractTableModel = (AbstractTableModel)this.treeTable.getModel();
        abstractTableModel.fireTableChanged(new TableModelEvent(abstractTableModel, -1));
        for (int i = 0; i < this.columns.size(); ++i) {
            this.treeTable.setDefaultRenderer(this.columns.get(i).getClass(), ((TreeTableColumn)this.columns.get(i)).getCellRenderer());
        }
    }

    private void setColumns() {
        ColumnChooser.CheckBoxListItem checkBoxListItem;
        this.columns = new ArrayList();
        ListModel listModel = this.columnChooser.getMetricModel();
        ListModel listModel2 = this.columnChooser.getValueModel();
        for (int i = 0; i < listModel.getSize() - 2; ++i) {
            checkBoxListItem = (ColumnChooser.CheckBoxListItem)listModel.getElementAt(i);
            if (!checkBoxListItem.getSelected()) continue;
            for (int j = 0; j < listModel2.getSize(); ++j) {
                ColumnChooser.CheckBoxListItem checkBoxListItem2 = (ColumnChooser.CheckBoxListItem)listModel2.getElementAt(j);
                if (!checkBoxListItem2.getSelected()) continue;
                String string = (String)checkBoxListItem2.getUserObject();
                if (string.equals("Absolute Value")) {
                    if (this.showInclExclMenuItem.isSelected()) {
                        this.columns.add(new TreeTableColumn.InclusiveColumn(this, i));
                        this.columns.add(new TreeTableColumn.ExclusiveColumn(this, i));
                        continue;
                    }
                    this.columns.add(new TreeTableColumn.RegularMetricColumn(this, i));
                    continue;
                }
                if (string.equals("Percent Value")) {
                    if (this.showInclExclMenuItem.isSelected()) {
                        this.columns.add(new TreeTableColumn.InclusivePercentColumn(this, i));
                        this.columns.add(new TreeTableColumn.ExclusivePercentColumn(this, i));
                        continue;
                    }
                    this.columns.add(new TreeTableColumn.RegularPercentMetricColumn(this, i));
                    continue;
                }
                if (!string.equals("Absolute Value Per Call")) continue;
                if (this.showInclExclMenuItem.isSelected()) {
                    this.columns.add(new TreeTableColumn.InclusivePerCallColumn(this, i));
                    this.columns.add(new TreeTableColumn.ExclusivePerCallColumn(this, i));
                    continue;
                }
                this.columns.add(new TreeTableColumn.RegularPerCallMetricColumn(this, i));
            }
        }
        ColumnChooser.CheckBoxListItem checkBoxListItem3 = (ColumnChooser.CheckBoxListItem)listModel.getElementAt(listModel.getSize() - 2);
        checkBoxListItem = (ColumnChooser.CheckBoxListItem)listModel.getElementAt(listModel.getSize() - 1);
        if (checkBoxListItem3.getSelected()) {
            this.columns.add(new TreeTableColumn.NumCallsColumn(this));
        }
        if (checkBoxListItem.getSelected()) {
            this.columns.add(new TreeTableColumn.NumSubrColumn(this));
        }
    }

    private void addComponents() {
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (!this.showAsTreeMenuItem.isSelected()) {
            this.showInclExclMenuItem.setEnabled(false);
            this.showInclExclMenuItem.setSelected(true);
        } else {
            this.showInclExclMenuItem.setEnabled(true);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            this.addCompItem(new ColorBar(), gridBagConstraints, 0, 0, 1, 1);
        }
        if (this.scrollPane != null) {
            this.getContentPane().remove(this.scrollPane);
        }
        this.scrollPane = new JScrollPane(this.treeTable);
        for (int i = 0; i < this.columns.size(); ++i) {
            this.treeTable.setDefaultRenderer(this.columns.get(i).getClass(), ((TreeTableColumn)this.columns.get(i)).getCellRenderer());
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.addCompItem(this.scrollPane, gridBagConstraints, 0, 1, 0, 0);
        this.validate();
    }

    private void setupData() {
        this.setColumns();
        this.model = new CallPathModel(this, this.ppTrial, this.thread, this.reverseTreeMenuItem.isSelected());
        this.createTreeTable(this.model);
        this.addComponents();
    }

    private void addCompItem(Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        this.getContentPane().add(component, gridBagConstraints);
    }

    private void setupMenus() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Options");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object instanceof JMenuItem) {
                        String string = actionEvent.getActionCommand();
                        if (string.equals("Show as Call Tree")) {
                            if (TreeTableWindow.this.showAsTreeMenuItem.isSelected()) {
                                TreeTableWindow.this.showInclExclMenuItem.setSelected(false);
                            }
                            TreeTableWindow.this.setupData();
                        } else if (string.equals("Reverse Call Tree")) {
                            TreeTableWindow.this.setupData();
                        } else if (string.equals("Show Inclusive/Exclusive")) {
                            TreeTableWindow.this.setupData();
                        }
                    }
                }
                catch (Exception exception) {
                    ParaProfUtils.handleException(exception);
                }
            }
        };
        this.showAsTreeMenuItem.addActionListener(actionListener);
        jMenu.add(this.showAsTreeMenuItem);
        this.showAsTreeMenuItem.setSelected(true);
        this.reverseTreeMenuItem.addActionListener(actionListener);
        jMenu.add(this.reverseTreeMenuItem);
        this.showInclExclMenuItem.addActionListener(actionListener);
        jMenu.add(this.showInclExclMenuItem);
        JMenu jMenu2 = ParaProfUtils.createUnitsMenu(this, this.units, false);
        jMenu.add(jMenu2);
        JMenuItem jMenuItem = new JMenuItem("Choose Columns...");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TreeTableWindow.this.columnChooser.showDialog(TreeTableWindow.this, true);
            }
        });
        jMenu.add(jMenuItem);
        if (!this.ppTrial.callPathDataPresent()) {
            this.showAsTreeMenuItem.setSelected(false);
            this.showAsTreeMenuItem.setEnabled(false);
            this.showInclExclMenuItem.setSelected(true);
            this.showInclExclMenuItem.setEnabled(false);
        }
        jMenuBar.add(ParaProfUtils.createFileMenu(this, this, this));
        jMenuBar.add(jMenu);
        jMenuBar.add(ParaProfUtils.createWindowsMenu(this.ppTrial, this));
        jMenuBar.add(ParaProfUtils.createHelpMenu(this, this));
        this.setJMenuBar(jMenuBar);
    }

    private void createTreeTable(AbstractTreeTableModel abstractTreeTableModel) {
        this.treeTable = new JTreeTable(abstractTreeTableModel, true, this);
        this.treeTable.getTree().addTreeExpansionListener(this);
        this.treeTable.getTree().setCellRenderer(new TreePortionCellRenderer());
        this.treeTable.setAutoResizeMode(0);
        this.treeTable.setAutoResizeMode(2);
        TableColumn tableColumn = this.treeTable.getColumnModel().getColumn(0);
        int n = 500;
        if (this.ppTrial.getNumberOfMetrics() > 1) {
            n = 350;
        }
        if (ParaProf.demoMode) {
            n = 200;
        }
        tableColumn.setPreferredWidth(n);
        int n2 = this.treeTable.getColumnCount();
        tableColumn = this.treeTable.getColumnModel().getColumn(n2 - 2);
        tableColumn.setPreferredWidth(10);
        tableColumn = this.treeTable.getColumnModel().getColumn(n2 - 1);
        tableColumn.setPreferredWidth(10);
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreeTableNode treeTableNode = (TreeTableNode)treeExpansionEvent.getPath().getLastPathComponent();
        treeTableNode.setExpanded(false);
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreeTableNode treeTableNode = (TreeTableNode)treeExpansionEvent.getPath().getLastPathComponent();
        treeTableNode.setExpanded(true);
    }

    public void update(Observable observable, Object object) {
        this.setupData();
    }

    public void help(boolean bl) {
        ParaProf.helpWindow.clearText();
        if (bl) {
            ParaProf.helpWindow.show();
        }
        ParaProf.helpWindow.writeText("This is the Statistics Table.\n");
        ParaProf.helpWindow.writeText("This window shows you function data across a given thread (or mean/std.dev.)\n");
        ParaProf.helpWindow.writeText("If callpath data is present, it will be shown as a tree on the left.");
        ParaProf.helpWindow.writeText("In this mode, the metric values will show Inclusive when the node is collapsed, and exclusive when the node is expanded.\n");
    }

    public void closeThisWindow() {
        this.setVisible(false);
        this.ppTrial.deleteObserver(this);
        ParaProf.decrementNumWindows();
        this.dispose();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        try {
            if (n >= 1) {
                return 1;
            }
            ParaProfUtils.scaleForPrint(graphics, pageFormat, (int)this.treeTable.getSize().getWidth(), (int)this.treeTable.getSize().getHeight());
            this.export((Graphics2D)graphics, false, true, false);
            return 0;
        }
        catch (Exception exception) {
            ParaProfUtils.handleException(exception);
            return 1;
        }
    }

    public boolean getExclusiveInclusiveMode() {
        return this.showInclExclMenuItem.isSelected();
    }

    public boolean getTreeMode() {
        return this.showAsTreeMenuItem.isSelected();
    }

    public int getColorMetricID() {
        return this.colorMetricID;
    }

    public void setUnits(int n) {
        this.units = n;
        this.treeTable.forceRedraw();
    }

    public int getUnits() {
        return this.units;
    }

    public List getColumns() {
        return this.columns;
    }

    public ParaProfTrial getPPTrial() {
        return this.ppTrial;
    }

    public void export(Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this.scrollPane.getColumnHeader().paintAll(graphics2D);
            graphics2D.translate(0, this.scrollPane.getColumnHeader().getHeight());
            this.treeTable.paintAll(graphics2D);
        } else {
            this.scrollPane.paintAll(graphics2D);
        }
    }

    public Dimension getImageSize(boolean bl, boolean bl2) {
        if (bl) {
            Dimension dimension = this.treeTable.getSize();
            dimension.setSize(dimension.getWidth(), dimension.getHeight() + (double)this.scrollPane.getColumnHeader().getHeight());
            return dimension;
        }
        return this.scrollPane.getSize();
    }

    public Thread getThread() {
        return this.thread;
    }
}

