/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.DatabaseException;
import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.database.DBConnector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class Application
implements Serializable {
    public static String[] fieldNames;
    public static int[] fieldTypes;
    private int applicationID;
    private String name;
    private String[] fields;

    public Application() {
        this.fields = fieldNames == null ? new String[0] : new String[fieldNames.length];
    }

    public Application(Application application) {
        this.name = application.getName();
        this.applicationID = application.getID();
        this.fields = (String[])application.fields.clone();
    }

    public void reallocMetaData() {
        this.fields = fieldNames == null ? new String[0] : new String[fieldNames.length];
    }

    public String[] getFields() {
        return this.fields;
    }

    public void setFields(String[] stringArray) {
        this.fields = stringArray;
    }

    public static String[] getFieldNames(DB dB) throws DatabaseException {
        Application.getMetaData(dB);
        return fieldNames;
    }

    public static void getMetaData(DB dB) {
        if (fieldNames != null) {
            return;
        }
        try {
            int n;
            ResultSet resultSet = null;
            Object var2_3 = null;
            Object var3_4 = null;
            DatabaseMetaData databaseMetaData = dB.getMetaData();
            resultSet = dB.getDBType().compareTo("oracle") == 0 || dB.getDBType().compareTo("derby") == 0 || dB.getDBType().compareTo("db2") == 0 ? databaseMetaData.getColumns(null, null, "APPLICATION", "%") : databaseMetaData.getColumns(null, null, "application", "%");
            Vector<String> vector = new Vector<String>();
            Vector<Integer> vector2 = new Vector<Integer>();
            boolean bl = false;
            while (resultSet.next()) {
                n = resultSet.getInt("DATA_TYPE");
                String string = resultSet.getString("COLUMN_NAME");
                String string2 = resultSet.getString("TYPE_NAME");
                if (string.equals("ID")) {
                    if (bl) break;
                    bl = true;
                }
                if (!DBConnector.isReadAbleType(n) || string.toUpperCase().compareTo("ID") == 0 || string.toUpperCase().compareTo("NAME") == 0) continue;
                vector.add(resultSet.getString("COLUMN_NAME"));
                vector2.add(new Integer(n));
            }
            resultSet.close();
            fieldNames = new String[vector.size()];
            fieldTypes = new int[vector2.size()];
            for (n = 0; n < vector2.size(); ++n) {
                Application.fieldNames[n] = (String)vector.get(n);
                Application.fieldTypes[n] = (Integer)vector2.get(n);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public String getFieldName(int n) {
        return fieldNames[n];
    }

    public int getFieldType(int n) {
        return fieldTypes[n];
    }

    public String[] getFieldNames() {
        return fieldNames;
    }

    public int[] getFieldTypes() {
        return fieldTypes;
    }

    public int getID() {
        return this.applicationID;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getField(int n) {
        return this.fields[n];
    }

    public void setField(int n, String string) {
        if (DBConnector.isIntegerType(fieldTypes[n]) && string != null) {
            try {
                int n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        if (DBConnector.isFloatingPointType(fieldTypes[n]) && string != null) {
            try {
                double d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
        this.fields[n] = string;
    }

    public void setID(int n) {
        this.applicationID = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static Vector getApplicationList(DB dB, String string) {
        StringBuffer stringBuffer = null;
        try {
            Application.getMetaData(dB);
            ResultSet resultSet = null;
            Vector<Application> vector = new Vector<Application>();
            stringBuffer = new StringBuffer("select id, name");
            for (int i = 0; i < fieldNames.length; ++i) {
                stringBuffer.append(", " + fieldNames[i]);
            }
            stringBuffer.append(" from " + dB.getSchemaPrefix() + "application");
            stringBuffer.append(string);
            if (dB.getDBType().compareTo("oracle") == 0) {
                stringBuffer.append(" order by dbms_lob.substr(name) asc");
            } else if (dB.getDBType().compareTo("derby") == 0) {
                stringBuffer.append(" order by cast (name as varchar(256)) asc");
            } else if (dB.getDBType().compareTo("db2") == 0) {
                stringBuffer.append(" order by cast (name as varchar(256)) asc");
            } else {
                stringBuffer.append(" order by name asc ");
            }
            resultSet = dB.executeQuery(stringBuffer.toString());
            while (resultSet.next()) {
                Application application = new Application();
                application.setID(resultSet.getInt(1));
                application.setName(resultSet.getString(2));
                String string2 = resultSet.getString(3);
                for (int i = 0; i < fieldNames.length; ++i) {
                    application.setField(i, resultSet.getString(i + 3));
                }
                vector.addElement(application);
            }
            resultSet.close();
            return vector;
        }
        catch (SQLException sQLException) {
            if (stringBuffer != null) {
                System.out.println(stringBuffer.toString());
            }
            throw new DatabaseException("", sQLException);
        }
    }

    public int saveApplication(DB dB) {
        try {
            int n;
            int n2;
            boolean bl = false;
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM " + dB.getSchemaPrefix() + "application WHERE id = ?");
            preparedStatement.setInt(1, this.getID());
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
            preparedStatement.close();
            StringBuffer stringBuffer = new StringBuffer();
            if (bl) {
                stringBuffer.append("UPDATE " + dB.getSchemaPrefix() + "application SET name = ?");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", " + this.getFieldName(n2) + " = ?");
                }
                stringBuffer.append(" WHERE id = ?");
            } else {
                stringBuffer.append("INSERT INTO " + dB.getSchemaPrefix() + "application (name");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", " + this.getFieldName(n2));
                }
                stringBuffer.append(") VALUES (?");
                for (n2 = 0; n2 < this.getNumFields(); ++n2) {
                    if (!DBConnector.isWritableType(this.getFieldType(n2))) continue;
                    stringBuffer.append(", ?");
                }
                stringBuffer.append(")");
            }
            preparedStatement = dB.prepareStatement(stringBuffer.toString());
            n2 = 1;
            preparedStatement.setString(n2++, this.getName());
            for (n = 0; n < this.getNumFields(); ++n) {
                if (!DBConnector.isWritableType(this.getFieldType(n))) continue;
                preparedStatement.setString(n2++, this.getField(n));
            }
            if (bl) {
                preparedStatement.setInt(n2++, this.getID());
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
            n = 0;
            if (bl) {
                n = this.getID();
            } else {
                String string = new String();
                string = dB.getDBType().compareTo("mysql") == 0 ? "select LAST_INSERT_ID();" : (dB.getDBType().compareTo("db2") == 0 ? "select IDENTITY_VAL_LOCAL() FROM application" : (dB.getDBType().compareTo("derby") == 0 ? "select IDENTITY_VAL_LOCAL() FROM application" : (dB.getDBType().compareTo("oracle") == 0 ? "SELECT " + dB.getSchemaPrefix() + "application_id_seq.currval FROM DUAL" : "select currval('application_id_seq');")));
                n = Integer.parseInt(dB.getDataItem(string));
            }
            return n;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return -1;
        }
    }

    private boolean exists(DB dB) {
        boolean bl = false;
        try {
            PreparedStatement preparedStatement = dB.prepareStatement("SELECT name FROM application WHERE id = ?");
            preparedStatement.setInt(1, this.applicationID);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl = true;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while saving the application.");
            sQLException.printStackTrace();
        }
        return bl;
    }

    public static void deleteApplication(DB dB, int n) {
        try {
            PreparedStatement preparedStatement = null;
            preparedStatement = dB.prepareStatement("delete from " + dB.getSchemaPrefix() + "application where id = ?");
            preparedStatement.setInt(1, n);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            System.out.println("An error occurred while deleting the application.");
            sQLException.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (fieldNames == null) {
            fieldNames = (String[])objectInputStream.readObject();
        }
        if (fieldTypes == null) {
            fieldTypes = (int[])objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(fieldNames);
        objectOutputStream.writeObject(fieldTypes);
    }
}

