/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.CallPathUtilFuncs;
import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.DataSourceException;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import edu.uoregon.tau.perfdmf.UserEvent;
import edu.uoregon.tau.perfdmf.UserEventProfile;
import edu.uoregon.tau.perfdmf.UtilFncs;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class DataSource {
    public static int TAUPROFILE = 0;
    public static int PPROF = 1;
    public static int DYNAPROF = 2;
    public static int MPIP = 3;
    public static int HPM = 4;
    public static int GPROF = 5;
    public static int PSRUN = 6;
    public static int PPK = 7;
    public static int CUBE = 8;
    public static int HPCTOOLKIT = 9;
    public static String[] formatTypeStrings = new String[]{"Tau profiles", "Tau pprof.dat", "Dynaprof", "MpiP", "HPMToolkit", "Gprof", "PSRun", "ParaProf Packed Profile", "Cube", "HPCToolkit"};
    private static boolean meanIncludeNulls = true;
    private boolean userEventsPresent = false;
    private boolean callPathDataPresent = false;
    private boolean groupNamesPresent = false;
    private boolean phasesPresent = false;
    private Function topLevelPhase;
    private List metrics = null;
    protected Thread meanData = null;
    protected Thread totalData = null;
    protected Thread stddevData = null;
    private Map nodes = new TreeMap();
    private Map functions = new TreeMap();
    private Map groups = new TreeMap();
    private Map userEvents = new TreeMap();
    private List allThreads;
    private int[] maxNCT = null;
    protected volatile boolean reloading;

    public abstract void load() throws FileNotFoundException, IOException, DataSourceException, SQLException;

    public abstract int getProgress();

    public abstract void cancelLoad();

    public List getFiles() {
        return new ArrayList();
    }

    public boolean isReloading() {
        return this.reloading;
    }

    public boolean reloadData() throws Exception {
        if (this.reloading) {
            return false;
        }
        this.reloading = true;
        this.cleanData();
        this.load();
        this.reloading = false;
        return true;
    }

    protected void cleanData() {
        Iterator iterator = this.getAllThreads().iterator();
        while (iterator.hasNext()) {
            Thread thread = (Thread)iterator.next();
            Iterator iterator2 = thread.getFunctionProfileIterator();
            while (iterator2.hasNext()) {
                FunctionProfile functionProfile = (FunctionProfile)iterator2.next();
                if (functionProfile == null) continue;
                for (int i = 0; i < this.getNumberOfMetrics(); ++i) {
                    functionProfile.setExclusive(i, 0.0);
                    functionProfile.setInclusive(i, 0.0);
                }
                functionProfile.setNumSubr(0.0);
                functionProfile.setNumCalls(0.0);
            }
        }
    }

    public Thread getMeanData() {
        return this.meanData;
    }

    public Thread getStdDevData() {
        return this.stddevData;
    }

    public Thread getTotalData() {
        return this.totalData;
    }

    private void setCallPathDataPresent(boolean bl) {
        this.callPathDataPresent = bl;
    }

    public boolean getCallPathDataPresent() {
        return this.callPathDataPresent;
    }

    protected void setGroupNamesPresent(boolean bl) {
        this.groupNamesPresent = bl;
    }

    public boolean getGroupNamesPresent() {
        return this.groupNamesPresent;
    }

    protected void setUserEventsPresent(boolean bl) {
        this.userEventsPresent = bl;
    }

    public boolean getUserEventsPresent() {
        return this.userEventsPresent;
    }

    public Function addFunction(String string) {
        return this.addFunction(string, this.getNumberOfMetrics());
    }

    public Function addFunction(String string, int n) {
        Object v = this.functions.get(string = string.trim());
        if (v != null) {
            return (Function)v;
        }
        Function function = new Function(string, this.functions.size(), n);
        this.functions.put(string, function);
        return function;
    }

    public Function getFunction(String string) {
        return (Function)this.functions.get(string.trim());
    }

    public int getNumFunctions() {
        return this.functions.size();
    }

    public Iterator getFunctions() {
        return this.functions.values().iterator();
    }

    public UserEvent addUserEvent(String string) {
        Object v = this.userEvents.get(string);
        if (v != null) {
            return (UserEvent)v;
        }
        UserEvent userEvent = new UserEvent(string, this.userEvents.size() + 1);
        this.userEvents.put(string, userEvent);
        return userEvent;
    }

    public UserEvent getUserEvent(String string) {
        return (UserEvent)this.userEvents.get(string);
    }

    public int getNumUserEvents() {
        return this.userEvents.size();
    }

    public Iterator getUserEvents() {
        return this.userEvents.values().iterator();
    }

    public Group getGroup(String string) {
        return (Group)this.groups.get(string);
    }

    public Group addGroup(String string) {
        Object v = this.groups.get(string = string.trim());
        if (v != null) {
            return (Group)v;
        }
        Group group = new Group(string, this.groups.size() + 1);
        this.groups.put(string, group);
        return group;
    }

    public int getNumGroups() {
        return this.groups.size();
    }

    public Iterator getGroups() {
        return this.groups.values().iterator();
    }

    public int[] getMaxNCTNumbers() {
        if (this.maxNCT == null) {
            this.maxNCT = new int[3];
            Iterator iterator = this.getNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (node.getNodeID() > this.maxNCT[0]) {
                    this.maxNCT[0] = node.getNodeID();
                }
                Iterator iterator2 = node.getContexts();
                while (iterator2.hasNext()) {
                    Context context = (Context)iterator2.next();
                    if (context.getContextID() > this.maxNCT[1]) {
                        this.maxNCT[1] = context.getContextID();
                    }
                    Iterator iterator3 = context.getThreads();
                    while (iterator3.hasNext()) {
                        Thread thread = (Thread)iterator3.next();
                        if (thread.getThreadID() <= this.maxNCT[2]) continue;
                        this.maxNCT[2] = thread.getThreadID();
                    }
                }
            }
        }
        return this.maxNCT;
    }

    public int getNumThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    iterator3.next();
                    ++n;
                }
            }
        }
        return n;
    }

    public void setMetrics(List list) {
        this.metrics = list;
    }

    public void addMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new ArrayList();
        }
        metric.setID(this.getNumberOfMetrics());
        this.metrics.add(metric);
    }

    public Metric addMetric(String string) {
        Object object;
        if (this.metrics != null) {
            object = this.metrics.iterator();
            while (object.hasNext()) {
                Metric metric = (Metric)object.next();
                if (!metric.getName().equals(string)) continue;
                return metric;
            }
        }
        object = new Metric();
        ((Metric)object).setName(string);
        this.addMetric((Metric)object);
        return object;
    }

    public List getMetrics() {
        return this.metrics;
    }

    public Metric getMetric(String string) {
        Iterator iterator = this.metrics.iterator();
        while (iterator.hasNext()) {
            Metric metric = (Metric)iterator.next();
            if (!metric.getName().equals(string)) continue;
            return metric;
        }
        return null;
    }

    public Metric getMetric(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return (Metric)this.metrics.get(n);
        }
        return null;
    }

    public String getMetricName(int n) {
        if (this.metrics != null && n < this.metrics.size()) {
            return ((Metric)this.metrics.get(n)).getName();
        }
        return null;
    }

    public int getNumberOfMetrics() {
        if (this.metrics != null) {
            return this.metrics.size();
        }
        return -1;
    }

    private void generateBonusCallPathData() {
        Comparable comparable;
        if (!this.getCallPathDataPresent()) {
            return;
        }
        ArrayList<Function> arrayList = new ArrayList<Function>();
        Iterator iterator = this.getFunctions();
        while (iterator.hasNext()) {
            comparable = (Function)iterator.next();
            arrayList.add((Function)comparable);
        }
        this.initAllThreadsList();
        int n = this.allThreads.size();
        comparable = this.addGroup("TAU_CALLPATH_DERIVED");
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            Function function = (Function)iterator2.next();
            if (!function.isCallPathFunction() || !CallPathUtilFuncs.containsDoublePath(function.getName())) continue;
            String string = function.getName();
            string = string.substring(string.indexOf("=>") + 2);
            while (string.indexOf("=>") != -1) {
                Function function2 = this.getFunction(string);
                if (function2 == null) {
                    function2 = this.addFunction(string);
                    Iterator iterator3 = function.getGroups().iterator();
                    while (iterator3.hasNext()) {
                        function2.addGroup((Group)iterator3.next());
                    }
                }
                function2.addGroup((Group)comparable);
                string = string.substring(string.indexOf("=>") + 2);
                for (int i = 0; i < n; ++i) {
                    Thread thread = (Thread)this.allThreads.get(i);
                    FunctionProfile functionProfile = thread.getFunctionProfile(function);
                    if (functionProfile == null) continue;
                    FunctionProfile functionProfile2 = thread.getFunctionProfile(function2);
                    if (functionProfile2 == null) {
                        functionProfile2 = new FunctionProfile(function2, this.getNumberOfMetrics());
                        thread.addFunctionProfile(functionProfile2);
                    }
                    for (int j = 0; j < this.getNumberOfMetrics(); ++j) {
                        functionProfile2.setExclusive(j, functionProfile2.getExclusive(j) + functionProfile.getExclusive(j));
                        functionProfile2.setInclusive(j, functionProfile2.getInclusive(j) + functionProfile.getInclusive(j));
                    }
                    functionProfile2.setNumCalls(functionProfile2.getNumCalls() + functionProfile.getNumCalls());
                    functionProfile2.setNumSubr(functionProfile2.getNumSubr() + functionProfile.getNumSubr());
                }
            }
        }
    }

    public void generateDerivedData() {
        if (CallPathUtilFuncs.checkCallPathsPresent(this.getFunctions())) {
            this.setCallPathDataPresent(true);
        }
        this.generateBonusCallPathData();
        this.checkForPhases();
        Iterator iterator = this.getAllThreads().iterator();
        while (iterator.hasNext()) {
            ((Thread)iterator.next()).setThreadDataAllMetrics();
        }
        this.generateStatistics(0, this.getNumberOfMetrics() - 1);
        this.meanData.setThreadDataAllMetrics();
        this.totalData.setThreadDataAllMetrics();
        this.stddevData.setThreadDataAllMetrics();
        this.generateUserEventStatistics();
        this.finishPhaseAnalysis();
    }

    private double computeStdDev(double d, double d2, int n) {
        double d3 = 0.0;
        if (n > 1) {
            d3 = Math.sqrt(Math.abs(d / (double)n - d2 * d2));
        }
        return d3;
    }

    private void generateUserEventStatistics() {
        Iterator iterator = this.getUserEvents();
        while (iterator.hasNext()) {
            UserEventProfile userEventProfile;
            UserEventProfile userEventProfile2;
            UserEvent userEvent = (UserEvent)iterator.next();
            UserEventProfile userEventProfile3 = this.meanData.getUserEventProfile(userEvent);
            if (userEventProfile3 == null) {
                userEventProfile3 = new UserEventProfile(userEvent);
                this.meanData.addUserEventProfile(userEventProfile3);
            }
            if ((userEventProfile2 = this.totalData.getUserEventProfile(userEvent)) == null) {
                userEventProfile2 = new UserEventProfile(userEvent);
                this.totalData.addUserEventProfile(userEventProfile2);
            }
            if ((userEventProfile = this.stddevData.getUserEventProfile(userEvent)) == null) {
                userEventProfile = new UserEventProfile(userEvent);
                this.stddevData.addUserEventProfile(userEventProfile);
            }
            int n = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            this.initAllThreadsList();
            int n2 = this.allThreads.size();
            for (int i = 0; i < n2; ++i) {
                Thread thread = (Thread)this.allThreads.get(i);
                UserEventProfile userEventProfile4 = thread.getUserEventProfile(userEvent);
                if (userEventProfile4 == null) continue;
                ++n;
                d += userEventProfile4.getNumSamples();
                d2 += userEventProfile4.getNumSamples() * userEventProfile4.getNumSamples();
                d3 += userEventProfile4.getMaxValue();
                d4 += userEventProfile4.getMaxValue() * userEventProfile4.getMaxValue();
                d5 += userEventProfile4.getMinValue();
                d6 += userEventProfile4.getMinValue() * userEventProfile4.getMinValue();
                d7 += userEventProfile4.getMeanValue();
                d8 += userEventProfile4.getMeanValue() * userEventProfile4.getMeanValue();
                d9 += userEventProfile4.getStdDev();
                d10 += userEventProfile4.getStdDev() * userEventProfile4.getStdDev();
            }
            if (!meanIncludeNulls) {
                n2 = n;
            }
            userEventProfile2.setNumSamples((int)d);
            userEventProfile2.setMaxValue(d3);
            userEventProfile2.setMinValue(d5);
            userEventProfile2.setMeanValue(d3);
            userEventProfile2.setStdDev(d9);
            userEventProfile3.setNumSamples((int)(d / (double)n2));
            userEventProfile3.setMaxValue(d3 / (double)n2);
            userEventProfile3.setMinValue(d5 / (double)n2);
            userEventProfile3.setMeanValue(d7 / (double)n2);
            userEventProfile3.setStdDev(d9 / (double)n2);
            userEventProfile.setNumSamples(this.computeStdDev(d2, userEventProfile3.getNumSamples(), n2));
            userEventProfile.setMaxValue(this.computeStdDev(d4, userEventProfile3.getMaxValue(), n2));
            userEventProfile.setMinValue(this.computeStdDev(d6, userEventProfile3.getMinValue(), n2));
            userEventProfile.setMeanValue(this.computeStdDev(d8, userEventProfile3.getMeanValue(), n2));
            userEventProfile.setStdDev(this.computeStdDev(d10, userEventProfile3.getStdDev(), n2));
        }
    }

    public void generateStatistics(int n, int n2) {
        Comparable comparable;
        Object object;
        int n3 = this.getNumberOfMetrics();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        double[] dArray5 = new double[n3];
        if (this.meanData == null) {
            this.meanData = new Thread(-1, -1, -1, n3);
        }
        if (this.totalData == null) {
            this.totalData = new Thread(-2, -2, -2, n3);
        }
        if (this.stddevData == null) {
            this.stddevData = new Thread(-3, -3, -3, n3);
        }
        this.initAllThreadsList();
        for (int i = 0; i < n3; ++i) {
            object = this.allThreads.iterator();
            while (object.hasNext()) {
                comparable = (Thread)object.next();
                int n4 = i;
                dArray5[n4] = dArray5[n4] + ((Thread)comparable).getMaxInclusive(i);
            }
        }
        Iterator iterator = this.getFunctions();
        while (iterator.hasNext()) {
            int n5;
            int n6;
            object = (Function)iterator.next();
            comparable = this.meanData.getFunctionProfile((Function)object);
            if (comparable == null) {
                comparable = new FunctionProfile((Function)object, n3);
                this.meanData.addFunctionProfile((FunctionProfile)comparable);
            }
            ((Function)object).setMeanProfile((FunctionProfile)comparable);
            FunctionProfile functionProfile = this.totalData.getFunctionProfile((Function)object);
            if (functionProfile == null) {
                functionProfile = new FunctionProfile((Function)object, n3);
                this.totalData.addFunctionProfile(functionProfile);
            }
            ((Function)object).setTotalProfile(functionProfile);
            FunctionProfile functionProfile2 = this.stddevData.getFunctionProfile((Function)object);
            if (functionProfile2 == null) {
                functionProfile2 = new FunctionProfile((Function)object, n3);
                this.stddevData.addFunctionProfile(functionProfile2);
            }
            ((Function)object).setStddevProfile(functionProfile2);
            int n7 = 0;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            for (n6 = 0; n6 < n3; ++n6) {
                dArray[n6] = 0.0;
                dArray2[n6] = 0.0;
                dArray3[n6] = 0.0;
                dArray4[n6] = 0.0;
            }
            n6 = this.allThreads.size();
            for (n5 = 0; n5 < n6; ++n5) {
                Thread thread = (Thread)this.allThreads.get(n5);
                FunctionProfile functionProfile3 = thread.getFunctionProfile((Function)object);
                if (functionProfile3 == null) continue;
                ++n7;
                for (int i = n; i <= n2; ++i) {
                    int n8 = i;
                    dArray[n8] = dArray[n8] + functionProfile3.getExclusive(i);
                    int n9 = i;
                    dArray2[n9] = dArray2[n9] + functionProfile3.getInclusive(i);
                    int n10 = i;
                    dArray3[n10] = dArray3[n10] + functionProfile3.getExclusive(i) * functionProfile3.getExclusive(i);
                    int n11 = i;
                    dArray4[n11] = dArray4[n11] + functionProfile3.getInclusive(i) * functionProfile3.getInclusive(i);
                    if (i != 0) continue;
                    d += functionProfile3.getNumCalls();
                    d2 += functionProfile3.getNumSubr();
                    d3 += functionProfile3.getNumCalls() * functionProfile3.getNumCalls();
                    d4 += functionProfile3.getNumSubr() * functionProfile3.getNumSubr();
                }
            }
            if (!meanIncludeNulls) {
                n6 = n7;
            }
            if (n == 0) {
                functionProfile.setNumCalls(d);
                functionProfile.setNumSubr(d2);
                ((FunctionProfile)comparable).setNumCalls(d / (double)n6);
                ((FunctionProfile)comparable).setNumSubr(d2 / (double)n6);
                double d5 = 0.0;
                if (n6 > 1) {
                    d5 = Math.sqrt(Math.abs(d3 / (double)n6 - ((FunctionProfile)comparable).getNumCalls() * ((FunctionProfile)comparable).getNumCalls()));
                }
                functionProfile2.setNumCalls(d5);
                d5 = 0.0;
                if (n6 > 1) {
                    d5 = Math.sqrt(Math.abs(d4 / (double)n6 - ((FunctionProfile)comparable).getNumSubr() * ((FunctionProfile)comparable).getNumSubr()));
                }
                functionProfile2.setNumSubr(d5);
            }
            for (n5 = n; n5 <= n2; ++n5) {
                functionProfile.setExclusive(n5, dArray[n5]);
                functionProfile.setInclusive(n5, dArray2[n5]);
                ((FunctionProfile)comparable).setExclusive(n5, dArray[n5] / (double)n6);
                ((FunctionProfile)comparable).setInclusive(n5, dArray2[n5] / (double)n6);
                double d6 = 0.0;
                if (n6 > 1) {
                    d6 = Math.sqrt(Math.abs(dArray3[n5] / (double)n6 - ((FunctionProfile)comparable).getExclusive(n5) * ((FunctionProfile)comparable).getExclusive(n5)));
                }
                functionProfile2.setExclusive(n5, d6);
                d6 = 0.0;
                if (n6 > 1) {
                    d6 = Math.sqrt(Math.abs(dArray4[n5] / (double)n6 - ((FunctionProfile)comparable).getInclusive(n5) * ((FunctionProfile)comparable).getInclusive(n5)));
                }
                functionProfile2.setInclusive(n5, d6);
                if (dArray5[n5] == 0.0) continue;
                functionProfile.setInclusivePercent(n5, functionProfile.getInclusive(n5) / dArray5[n5] * 100.0);
                functionProfile.setExclusivePercent(n5, functionProfile.getExclusive(n5) / dArray5[n5] * 100.0);
                ((FunctionProfile)comparable).setInclusivePercent(n5, functionProfile.getInclusivePercent(n5));
                ((FunctionProfile)comparable).setExclusivePercent(n5, functionProfile.getExclusivePercent(n5));
                if (((FunctionProfile)comparable).getInclusive(n5) != 0.0) {
                    functionProfile2.setInclusivePercent(n5, functionProfile2.getInclusive(n5) / ((FunctionProfile)comparable).getInclusive(n5) * 100.0);
                }
                if (((FunctionProfile)comparable).getExclusive(n5) == 0.0) continue;
                functionProfile2.setExclusivePercent(n5, functionProfile2.getExclusive(n5) / ((FunctionProfile)comparable).getExclusive(n5) * 100.0);
            }
        }
    }

    public Node addNode(int n) {
        Object v = this.nodes.get(new Integer(n));
        if (v != null) {
            return (Node)v;
        }
        Node node = new Node(n);
        this.nodes.put(new Integer(n), node);
        return node;
    }

    public Node getNode(int n) {
        return (Node)this.nodes.get(new Integer(n));
    }

    public int getNumberOfNodes() {
        return this.nodes.size();
    }

    public Iterator getNodes() {
        return this.nodes.values().iterator();
    }

    public int getTotalNumberOfContexts() {
        int n = -1;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            n += node.getNumberOfContexts();
        }
        return n;
    }

    public int getNumberOfContexts(int n) {
        return this.getNode(n).getNumberOfContexts();
    }

    public Iterator getContexts(int n) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContexts();
        }
        return null;
    }

    public Context getContext(int n, int n2) {
        Node node = this.getNode(n);
        if (node != null) {
            return node.getContext(n2);
        }
        return null;
    }

    public int getTotalNumberOfThreads() {
        int n = 0;
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                n += context.getNumberOfThreads();
            }
        }
        return n;
    }

    public int getNumberOfThreads(int n, int n2) {
        return this.getContext(n, n2).getNumberOfThreads();
    }

    public List getThreads() {
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    arrayList.add(thread);
                }
            }
        }
        return arrayList;
    }

    public Thread getThread(int n, int n2, int n3) {
        if (n == -1) {
            return this.getMeanData();
        }
        if (n == -3) {
            return this.getStdDevData();
        }
        Context context = this.getContext(n, n2);
        Thread thread = null;
        if (context != null) {
            thread = context.getThread(n3);
        }
        return thread;
    }

    private void initAllThreadsList() {
        this.allThreads = new ArrayList();
        Iterator iterator = this.getNodes();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            Iterator iterator2 = node.getContexts();
            while (iterator2.hasNext()) {
                Context context = (Context)iterator2.next();
                Iterator iterator3 = context.getThreads();
                while (iterator3.hasNext()) {
                    Thread thread = (Thread)iterator3.next();
                    this.allThreads.add(thread);
                }
            }
        }
    }

    public List getAllThreads() {
        if (this.allThreads == null) {
            this.initAllThreadsList();
        }
        return this.allThreads;
    }

    public static void setMeanIncludeNulls(boolean bl) {
        meanIncludeNulls = bl;
    }

    protected void checkForPhases() {
        Group group = this.getGroup("TAU_PHASE");
        if (group != null) {
            Function function;
            this.phasesPresent = true;
            Iterator iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                if (!function.isGroupMember(group)) continue;
                function.setPhase(true);
                function.setActualPhase(function);
            }
            iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                int n = function.getName().indexOf("=>");
                if (n <= 0) continue;
                String string = UtilFncs.getLeftSide(function.getName());
                String string2 = UtilFncs.getRightSide(function.getName());
                Function function2 = this.getFunction(string2);
                if (function2.isPhase()) {
                    function.setPhase(true);
                    function.setActualPhase(function2);
                }
                function.setParentPhase(this.getFunction(string));
            }
        }
    }

    protected void finishPhaseAnalysis() {
        if (this.phasesPresent) {
            Function function;
            Group group = this.getGroup("TAU_PHASE");
            ArrayList<Function> arrayList = new ArrayList<Function>();
            Iterator iterator = this.getFunctions();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                if (!function.isGroupMember(group)) continue;
                arrayList.add(function);
            }
            if (arrayList.size() == 0) {
                throw new RuntimeException("Error: TAU_PHASE found, but no phases!");
            }
            this.topLevelPhase = (Function)arrayList.get(0);
            iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                function = (Function)iterator.next();
                if (!(function.getMeanInclusive(0) > this.topLevelPhase.getMeanInclusive(0))) continue;
                this.topLevelPhase = function;
            }
        }
    }

    public boolean getPhasesPresent() {
        return this.phasesPresent;
    }

    public Function getTopLevelPhase() {
        return this.topLevelPhase;
    }
}

